
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//SV" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="sv" lang="sv">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 10</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter10.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 10<br />
      Imaginary Journeys: The Lojban Space/Time Tense System</h2>

      <!--
      <h6>$Revision: 4.2 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. Introductory</h3>

    <p>This chapter attempts to document and explain the space/time
    tense system of Lojban. It does not attempt to answer all
    questions of the form ``How do I say such-and-such (an English
    tense) in Lojban?'' Instead, it explores the Lojban tense
    system from the inside, attempting to educate the reader into a
    Lojbanic viewpoint. Once the overall system is understood and
    the resources that it makes available are familiar, the reader
    should have some hope of using appropriate tense constructs and
    being correctly understood.</p>

    <p>The system of Lojban tenses presented here may seem really
    complex because of all the pieces and all the options; indeed,
    this chapter is the longest one in this book. But tense is in
    fact complex in every language. In your native language, the
    subtleties of tense are intuitive. In foreign languages, you
    are seldom taught the entire system until you have reached an
    advanced level. Lojban tenses are extremely systematic and
    productive, allowing you to express subtleties based on what
    they mean rather than on how they act similarly to English
    tenses. This chapter concentrates on presenting an intuitive
    approach to the meaning of Lojban tense words and how they may
    be creatively and productively combined.</p>

    <p>What is ``tense''? Historically, ``tense'' is the attribute
    of verbs in English and related languages that expresses the
    time of the action. In English, three tenses are traditionally
    recognized, conventionally called the past, the present, and
    the future. There are also a variety of compound tenses used in
    English. However, there is no simple relationship between the
    form of an English tense and the time actually expressed:</p>

    <dl>
      <dt></dt>

      <dd>I go to London tomorrow. I will go to London tomorrow. I
      am going to London tomorrow.</dd>
    </dl>
    all mean the same thing, even though the first sentence uses
    the present tense; the second, the future tense; and the third,
    a compound tense usually called ``present progressive''.
    Likewise, a newspaper headline says ``JONES DIES'', although it
    is obvious that the time referred to must be in the past. Tense
    is a mandatory category of English: every sentence must be
    marked for tense, even if in a way contrary to logic, because
    every main verb has a tense marker built into to it. By
    contrast, Lojban brivla have no implicit or explicit tense
    marker attached to them. 

    <p>In Lojban, the concept of tense extends to every selbri, not
    merely the verb-like ones. In addition, tense structures
    provide information about location in space as well as in time.
    All tense information is optional in Lojban: a sentence
    like:</p>

    <p></p>
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  mi klama le zarci
    I go-to the market.
</pre>
    can be understood as: 

    <dl>
      <dt></dt>

      <dd>I went to the market. I am going to the market. I have
      gone to the market. I will go to the market. I continually go
      to the market.</dd>
    </dl>
    as well as many other possibilities: context resolves which is
    correct. 

    <p>The placement of a tense construct within a Lojban bridi is
    easy: right before the selbri. It goes immediately after the
    ``cu'', and can in fact always replace the ``cu'' (although in
    very complex sentences the rules for eliding terminators may be
    changed as a result). In the following examples, ``pu'' is the
    tense marker for ``past time'':</p>
<pre>
<a id="e1d2" name="e1d2">1.2)</a>  mi cu pu klama le zarci
    mi pu klama le zarci
    I in-the-past go-to the market.
    I went to the market.
</pre>
    It is also possible to put the tense somewhere else in the
    bridi by adding ``ku'' after it. This ``ku'' is an elidable
    terminator, but it's almost never possible to actually elide it
    except at the end of the bridi: 
<pre>
<a id="e1d3" name="e1d3">1.3)</a>  puku mi klama le zarci
    In-the-past I go-to the market.
    Earlier, I went to the market.

<a id="e1d4" name="e1d4">1.4)</a>   mi klama puku le zarci
    I go-to in-the-past the market.
    I went earlier to the market.

<a id="e1d5" name="e1d5">1.5)</a>   mi klama le zarci pu [ku]
    I go-to the market in-the-past.
    I went to the market earlier.
</pre>
    <a href="#e1d2">Examples 1.2</a> through <a
    href="#e1d5">1.5</a> are different only in emphasis. Abnormal
    order, such as <a href="#e1d3">Examples 1.3</a> through <a
    href="#e1d5">1.5</a> exhibit, adds emphasis to the words that
    have been moved; in this case, the tense cmavo ``pu''. Words at
    either end of the sentence tend to be more noticeable. 

    <h3><a id="s2" name="s2">2. Spatial tenses: FAhA and VA</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   vi  VA  short distance
    va  VA  medium distance
    vu  VA  long distance

    zu'a    FAhA    left
    ri'u    FAhA    right
    ga'u    FAhA    up
    ni'a    FAhA    down
    ca'u    FAhA    front
    ne'i    FAhA    within
    be'a    FAhA    north of
</pre>
    (The complete list of FAhA cmavo can be found in <a
    href="#s27">Section 27</a>.) 

    <p>Why is this section about spatial tenses rather than the
    more familiar time tenses of <a href="#s1">Section 1</a>, asks
    the reader? Because the model to be used in explaining both
    will be easier to grasp for space than for time. The
    explanation of time tenses will resume in <a href="#s4">Section
    4</a>.</p>

    <p>English doesn't have mandatory spatial tenses. Although
    there are plenty of ways in English of showing where an event
    happens, there is absolutely no need to do so. Considering this
    fact may give the reader a feel for what the optional Lojban
    time tenses are like. From the Lojban point of view, space and
    time are interchangeable, although they are not treated
    identically.</p>

    <p>Lojban specifies the spatial tense of a bridi (the place at
    which it occurs) by using words from selma'o FAhA and VA to
    describe an imaginary journey from the speaker to the place
    referred to. FAhA cmavo specify the direction taken in the
    journey, whereas VA cmavo specify the distance gone. For
    example:</p>

    <p></p>
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  le nanmu va batci le gerku
    The man [medium distance] bites the dog.
    Over there the man is biting the dog.
</pre>
    What is at a medium distance? The event referred to by the
    bridi: the man biting the dog. What is this event at a medium
    distance from? The speaker's location. We can understand the
    ``va'' as saying: ``If you want to get from the speaker's
    location to the location of the bridi, journey for a medium
    distance (in some direction unspecified).'' This ``imaginary
    journey'' can be used to understand not only <a
    href="#e2d1">Example 2.1</a>, but also every other spatial
    tense construct. 

    <p>Suppose you specify a direction with a FAhA cmavo, rather
    than a distance with a VA cmavo:</p>

    <p></p>
<pre>
<a id="e2d2" name="e2d2">2.2)</a>  le nanmu zu'a batci le gerku
    The man [left] bites the dog.
</pre>

    <p>Here the imaginary journey is again from the speaker's
    location to the location of the bridi, but it is now performed
    by going to the left (in the speaker's reference frame) for an
    unspecified distance. So a reasonable translation is:</p>

    <dl>
      <dt></dt>

      <dd>To my left, the man bites the dog.</dd>
    </dl>

    <p>The ``my'' does not have an explicit equivalent in the
    Lojban, because the speaker's location is understood as the
    starting point.</p>

    <p>(Etymologically, by the way, ``zu'a'' is derived from
    ``zunle'', the gismu for ``left'', whereas ``vi'', ``va'', and
    ``vu'' are intended to be reminiscent of ``ti'', ``ta'', and
    ``tu'', the demonstrative pronouns ``this-here'',
    ``that-there'', and ``that-yonder''.)</p>

    <p>What about specifying both a direction and a distance? The
    rule here is that the direction must come before the
    distance:</p>
<pre>
<a id="e2d3" name="e2d3">2.3)</a>  le nanmu zu'avi batci le gerku
    The man [left] [short distance] bites the dog.
    Slightly to my left, the man bites the dog.
</pre>

    <p>As explained in <a href="#s1">Section 1</a>, it would be
    perfectly correct to use ``ku'' to move this tense to the
    beginning or the end of the sentence to emphasize it:</p>
<pre>
<a id="e2d4"
name="e2d4">2.4)</a>  zu'aviku le nanmu cu batci le gerku
    [Left] [short distance] the man bites the dog.
    Slightly to my left, the man bites the dog.
</pre>

    <h3><a id="s3" name="s3">3. Compound spatial tenses</h3>

    <p>Humph, says the reader: this talk of ``imaginary journeys''
    is all very well, but what's the point of it? --- ``zu'a''
    means ``on the left'' and ``vi'' means ``nearby'', and there's
    no more to be said. The imaginary-journey model becomes more
    useful when so-called compound tenses are involved. A compound
    tense is exactly like a simple tense, but has several FAhAs run
    together:</p>

    <p></p>
<pre>
<a id="e3d1"
name="e3d1">3.1)</a>  le nanmu ga'u zu'a batci le gerku
    The man [up] [left] bites the dog.
</pre>
    The proper interpretation of <a href="#e3d1">Example 3.1</a> is
    that the imaginary journey has two stages: first move from the
    speaker's location upward, and then to the left. A translation
    might read: 

    <dl>
      <dt></dt>

      <dd>Left of a place above me, the man bites the dog.</dd>
    </dl>
    (Perhaps the speaker is at the bottom of a manhole, and the
    dog-biting is going on at the edge of the street.) 

    <p>In the English translation, the keywords ``left'' and
    ``above'' occur in reverse order to the Lojban order. This
    effect is typical of what happens when we ``unfold'' Lojban
    compound tenses into their English equivalents, and shows why
    it is not very useful to try to memorize a list of Lojban tense
    constructs and their colloquial English equivalents.</p>

    <p>The opposite order also makes sense:</p>
<pre>
<a id="e3d2"
name="e3d2">3.2)</a>  le nanmu zu'a ga'u batci le gerku
    The man [left] [up] bites the dog.
    Above a place to the left of me, the man bites the dog.
</pre>
    In ordinary space, the result of going up and then to the left
    is the same as that of going left and then up, but such a
    simple relationship does not apply in all environments or to
    all directions: going south, then east, then north may return
    one to the starting point, if that point is the North Pole. 

    <p>Each direction can have a distance following:</p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  le nanmu zu'avi ga'uvu
        batci le gerku
    The man [left] [short distance] [up] [long distance]
        bites the dog.
    Far above a place slightly to the left of me,
        the man bites the dog.
</pre>
    A distance can also come at the beginning of the tense
    construct, without any specified direction. (<a
    href="#e2d1">Example 2.1</a>, with VA alone, is really a
    special case of this rule when no directions at all follow.) 
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  le nanmu vi zu'a batci le gerku
    The man [short distance] [left] bites the dog.
    Left of a place near me, the man bites the dog.
</pre>
    Any number of directions may be used in a compound tense, with
    or without specified distances for each: 
<pre>
<a id="e3d5" name="e3d5">3.5)</a>  le nanmu ca'uvi ni'ava
        ri'uvu ne'i
        batci le gerku
    The man [front] [short] [down] [medium]
        [right] [long] [within]
        bites the dog.
    Within a place a long distance to the right
        of a place which is a medium distance downward
        from a place a short distance in front of me,
        the man bites the dog.
</pre>

    <p>Whew! It's a good thing tense constructs are optional:
    having to say all that could certainly be painful. Note,
    however, how much shorter the Lojban version of <a
    href="#e3d5">Example 3.5</a> is than the English version.</p>

    <h3><a id="s4" name="s4">4. Temporal tenses: PU and ZI</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   pu  PU  past
    ca  PU  present
    ba  PU  future

    zi  ZI  short time distance
    za  ZI  medium time distance
    zu  ZI  long time distance
</pre>
    Now that the reader understands spatial tenses, there are only
    two main facts to understand about temporal tenses: they work
    exactly like the spatial tenses, with selma'o PU and ZI
    standing in for FAhA and VA; and when both spatial and temporal
    tense cmavo are given in a single tense construct, the temporal
    tense is expressed first. (If space were expressed before time,
    then certain constructions would be ambiguous.) 
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  le nanmu pu batci le gerku
    The man [past] bites the dog.
    The man bit the dog.
</pre>
    means that to reach the dog-biting, you must take an imaginary
    journey through time, moving towards the past an unspecified
    distance. (Of course, this journey is even more imaginary than
    the ones talked about in the previous sections, since
    time-travel is not an available option.) 

    <p>Lojban recognizes three temporal directions: ``pu'' for the
    past, ``ca'' for the present, and ``ba'' for the future.
    (Etymologically, these derive from the corresponding gismu
    ``purci'', ``cabna'', and ``balvi''. See <a href="#s23">Section
    23</a> for an explanation of the exact relationship between the
    cmavo and the gismu.) There are many more spatial directions,
    since there are FAhA cmavo for both absolute and relative
    directions as well as ``direction-like relationships'' like
    ``surrounding'', ``within'', ``touching'', etc. (See <a
    href="#s27">Section 27</a> for a complete list.) But there are
    really only two directions in time: forward and backward,
    toward the future and toward the past. Why, then, are there
    three cmavo of selma'o PU?</p>

    <p>The reason is that tense is subjective: human beings
    perceive space and time in a way that does not necessarily
    agree with objective measurements. We have a sense of ``now''
    which includes part of the objective past and part of the
    objective future, and so we naturally segment the time line
    into three parts. The Lojban design recognizes this human
    reality by providing a separate time-direction cmavo for the
    ``zero direction'', Similarly, there is a FAhA cmavo for the
    zero space direction: ``bu'u'', which means something like
    ``coinciding''.</p>

    <p>(Technical note for readers conversant with relativity
    theory: The Lojban time tenses reflect time as seen by the
    speaker, who is assumed to be a ``point-like observer'' in the
    relativistic sense: they do not say anything about physical
    relationships of relativistic interval, still less about
    implicit causality. The nature of tense is not only subjective
    but also observer-based.)</p>

    <p>Here are some examples of temporal tenses:</p>
<pre>
<a id="e4d2" name="e4d2">4.2)</a>  le nanmu puzi batci le gerku
    The man [past] [short distance] bites the dog.
    A short time ago, the man bit the dog.

<a id="e4d3" name="e4d3">4.3)</a>   le nanmu pu pu batci le gerku
    The man [past] [past] bites the dog.
    Earlier than an earlier time than now,
        the man bit the dog.
    The man had bitten the dog.
    The man had been biting the dog.

<a id="e4d4" name="e4d4">4.4)</a>   le nanmu ba puzi batci le gerku
    The man [future] [past] [short] bites the dog.
    Shortly earlier than some time later than now,
        the man will bite the dog.
    Soon before then, the man will have bitten the dog.
    The man will have just bitten the dog.
    The man will just have been biting the dog.
</pre>
    What about the analogue of an initial VA without a direction?
    Lojban does allow an initial ZI with or without following PUs: 
<pre>
<a id="e4d5" name="e4d5">4.5)</a>  le nanmu zi pu batci le gerku
    The man [short] [past] bites the dog.
    Before a short time from or before now,
        the man bit or will bite the dog.

<a id="e4d6" name="e4d6">4.6)</a>   le nanmu zu batci le gerku
    The man [long] bites the dog.
    A long time from or before now,
        the man will bite or bit the dog.
</pre>
    <a href="#e4d5">Example 4.5</a> and <a href="#e4d6">Example
    4.6</a> are perfectly legitimate, but may not be very much
    used: ``zi'' by itself signals an event that happens at a time
    close to the present, but without saying whether it is in the
    past or the future. A rough translation might be ``about now,
    but not exactly now''. 

    <p>Because we can move in any direction in space, we are
    comfortable with the idea of events happening in an unspecified
    space direction (``nearby'' or ``far away''), but we live only
    from past to future, and the idea of an event which happens
    ``nearby in time'' is a peculiar one. Lojban provides lots of
    such possibilities that don't seem all that useful to
    English-speakers, even though you can put them together
    productively; this fact may be a limitation of English.</p>

    <p>Finally, here are examples which combine temporal and
    spatial tense:</p>

    <p></p>
<pre>
<a id="e4d7" name="e4d7">4.7)</a>  le nanmu puzu vu batci le gerku
    The man [past] [long time] [long space] bites the dog.
    Long ago and far away, the man bit the dog.
</pre>

    <p>Alternatively,</p>
<pre>
<a id="e4d8" name="e4d8">4.8)</a>  le nanmu batci le gerku puzuvuku
    The man bites the dog [past] [long time] [long space].
    The man bit the dog long ago and far away.
</pre>

    <h3><a id="s5" name="s5">5. Interval sizes: VEhA and ZEhA</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ve'i    VEhA    short space interval
    ve'a    VEhA    medium space interval
    ve'u    VEhA    long space interval

    ze'i    ZEhA    short time interval
    ze'a    ZEhA    medium time interval
    ze'u    ZEhA    long time interval
</pre>
    So far, we have considered only events that are usually thought
    of as happening at a particular point in space and time: a man
    biting a dog at a specified place and time. But Lojbanic events
    may be much more ``spread out'' than that: ``mi vasxu'' (I
    breathe) is something which is true during the whole of my life
    from birth to death, and over the entire part of the earth
    where I spend my life. The cmavo of VEhA (for space) and ZEhA
    (for time) can be added to any of the tense constructs we have
    already studied to specify the size of the space or length of
    the time over which the bridi is claimed to be true. 

    <p></p>
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  le verba ve'i cadzu le bisli
    The child [small space interval] walks-on the ice.
    In a small space, the child walks on the ice.
    The child walks about a small area of the ice.
</pre>
    means that her walking was done in a small area. Like the
    distances, the interval sizes are classified only roughly as
    ``small, medium, large'', and are relative to the context: a
    small part of a room might be a large part of a table in that
    room. 

    <p>Here is an example using a time interval:</p>
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  le verba ze'a cadzu le bisli
    The child [medium time interval] walks-on the ice.
    For a medium time, the child walks/walked/will walk
        on the ice.
</pre>
    Note that with no time direction word, <a href="#e5d2">Example
    5.2</a> does not say when the walking happened: that would be
    determined by context. It is possible to specify both
    directions or distances and an interval, in which case the
    interval always comes afterward: 
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  le verba pu ze'a
        cadzu le bisli
    The child [past] [medium time interval]
        walks-on the ice.
    For a medium time, the child walked on the ice.
    The child walked on the ice for a while.
</pre>
    In <a href="#e5d3">Example 5.3</a>, the relationship of the
    interval to the specified point in time or space is
    indeterminate. Does the interval start at the point, end at the
    point, or is it centered on the point? By adding an additional
    direction cmavo after the interval, this question can be
    conclusively answered: 
<pre>
<a id="e5d4" name="e5d4">5.4)</a>  mi ca ze'ica cusku dei
    I [present] [short time interval -- present]
        express this-utterance.
    I am now saying this sentence.
</pre>
    means that for an interval starting a short time in the past
    and extending to a short time in the future, I am expressing
    the utterance which is <a href="#e5d4">Example 5.4</a>. Of
    course, ``short'' is relative, as always in tenses. Even a long
    sentence takes up only a short part of a whole day; in a
    geological context, the era of Homo sapiens would only be a
    ``ze'i'' interval. 

    <p>By contrast,</p>

    <p></p>
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  mi ca ze'ipu
        cusku dei
    I [present] [short time interval -- past]
        express this-utterance.
    I have just been saying this sentence.
</pre>
    means that for a short time interval extending from the past to
    the present I have been expressing <a href="#e5d5">Example
    5.5</a>. Here the imaginary journey starts at the present, lays
    down one end point of the interval, moves into the past, and
    lays down the other endpoint. Another example: 
<pre>
<a id="e5d6" name="e5d6">5.6)</a>  mi pu ze'aba citka le mi sanmi
    I [past] [medium time interval - future] eat my meal.
    For a medium time afterward, I ate my meal.
    I ate my meal for a while.
</pre>

    <p>With ``ca'' instead of ``ba'', <a href="#e5d6">Example
    5.6</a> becomes <a href="#e5d7">Example 5.7</a>,</p>
<pre>
<a id="e5d7" name="e5d7">5.7)</a>  mi pu ze'aca citka le mi sanmi
    I [past] [medium time interval - present] eat my meal
    For a medium time before and afterward, I ate my meal.
    I ate my meal for a while.
</pre>
    because the interval would then be centered on the past moment
    rather than oriented toward the future of that moment. The
    colloquial English translations are the same --- English is not
    well-suited to representing this distinction. 

    <p>Here are some examples of the use of space intervals with
    and without specified directions:</p>

    <p></p>
<pre>
<a id="e5d8" name="e5d8">5.8)</a>  ta ri'u ve'i finpe
    that-there [right] [short space interval] is-a-fish
    That thing on my right is a fish.
</pre>

    <p>In <a href="#e5d8">Example 5.8</a>, there is no equivalent
    in the colloquial English translation of the ``small interval''
    which the fish occupies. Neither the Lojban nor the English
    expresses the orientation of the fish. Compare <a
    href="#e5d9">Example 5.9</a>:</p>
<pre>
<a id="e5d9" name="e5d9">5.9)</a>  ta ri'u ve'ica'u
        finpe
    that-there [right] [short space interval - front]
        is-a-fish
    That thing on my right extending forwards is a fish.
</pre>

    <p>Here the space interval occupied by the fish extends from a
    point on my right to another point in front of the first
    point.</p>

    <h3><a id="s6" name="s6">6. Vague intervals and non-specific tenses</h3>

    <p>What is the significance of failing to specify an interval
    size of the type discussed in <a href="#s5">Section 5</a>? The
    Lojban rule is that if no interval size is given, the size of
    the space or time interval is left vague by the speaker. For
    example:</p>
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  mi pu klama le zarci
    I [past] go-to the market.
</pre>
    really means: 

    <dl>
      <dt></dt>

      <dd>At a moment in the past, and possibly other moments as
      well, the event ``I went to the market'' was in
      progress.</dd>
    </dl>
    The vague or unspecified interval contains an instant in the
    speaker's past. However, there is no indication whether or not
    the whole interval is in the speaker's past! It is entirely
    possible that the interval during which the going-to-the-market
    is happening stretches into the speaker's present or even
    future. 

    <p><a href="#e6d1">Example 6.1</a> points up a fundamental
    difference between Lojban tenses and English tenses. An English
    past-tense sentence like ``I went to the market'' generally
    signifies that the going-to-the-market is entirely in the past;
    that is, that the event is complete at the time of speaking.
    Lojban ``pu'' has no such implication.</p>

    <p>This property of a past tense is sometimes called
    ``aorist'', in reference to a similar concept in the tense
    system of Classical Greek. All of the Lojban tenses have the
    same property, however:</p>

    <p></p>
<pre>
<a id="e6d3" name="e6d3">6.3)</a>  le tricu ba crino
    the tree [future] is-green
    The tree will be green.
</pre>
    does not imply (as the colloquial English translation does)
    that the tree is not green now. The vague interval throughout
    which the tree is, in fact, green may have already started. 

    <p>This general principle does not mean that Lojban has no way
    of indicating that a tree will be green but is not yet green.
    Indeed, there are several ways of expressing that concept: see
    <a href="#s10">Section 10</a> (event contours) and <a
    href="#s20">Section 20</a> (logical connection between
    tenses).</p>

    <h3><a id="s7" name="s7">7. Dimensionality: VIhA</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   vi'i    VIhA    on a line
    vi'a    VIhA    in an area
    vi'u    VIhA    through a volume
    vi'e    VIhA    throughout a space/time interval
</pre>
    The cmavo of ZEhA are sufficient to express time intervals. One
    fundamental difference between space and time, however, is that
    space is multi-dimensional. Sometimes we want to say not only
    that something moves over a small interval, but also perhaps
    that it moves in a line. Lojban allows for this. I can specify
    that a motion ``in a small space'' is more specifically ``in a
    short line'', ``in a small area'', or ``through a small
    volume''. 

    <p>What about the child walking on the ice in <a
    href="#e5d1">Examples 5.1</a> through <a
    href="#e5d3">5.3</a>? Given the nature of ice, probably the
    area interpretation is most sensible. I can make this
    assumption explicit with the appropriate member of selma'o
    VIhA:</p>

    <p></p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  le verba ve'a vi'a
        cadzu le bisli
    The child [medium space interval] [2-dimensional]
        walks-on the ice.
    In a medium-sized area, the child walks on the ice.
</pre>
    Space intervals can contain either VEhA or VIhA or both, but if
    both, VEhA must come first, as <a href="#e7d1">Example 7.1</a>
    shows. 

    <p>The reader may wish to raise a philosophical point here.
    (Readers who don't wish to, should skip this paragraph.) The
    ice may be two-dimensional, or more accurately its surface may
    be, but since the child is three-dimensional, her walking must
    also be. The subjective nature of Lojban tense comes to the
    rescue here: the action is essentially planar, and the third
    dimension of height is simply irrelevant to walking. Even
    walking on a mountain could be called ``vi'a'', because
    relatively speaking the mountain is associated with an
    essentially two-dimensional surface. Motion which is not
    confined to such a surface (e.g., flying, or walking through a
    three-dimensional network of tunnels, or climbing among
    mountains rather than on a single mountain) would be properly
    described with ``vi'u''. So the cognitive, rather than the
    physical, dimensionality controls the choice of VIhA cmavo.</p>

    <p>VIhA has a member ``vi'e'' which indicates a 4-dimensional
    interval, one that involves both space and time. This allows
    the spatial tenses to invade, to some degree, the temporal
    tenses; it is possible to make statements about space-time
    considered as an Einsteinian whole. (There are presently no
    cmavo of FAhA assigned to ``pastward'' and ``futureward''
    considered as space rather than time directions --- they could
    be added, though, if Lojbanists find space-time expression
    useful.) If a temporal tense cmavo is used in the same tense
    construct with a ``vi'e'' interval, the resulting tense may be
    self-contradictory.</p>

    <h3><a id="s8" name="s8">8. Movement in space: MOhI</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   mo'i    MOhI    movement flag
</pre>
    All the information carried by the tense constructs so far
    presented has been presumed to be static: the bridi is
    occurring somewhere or other in space and time, more or less
    remote from the speaker. Suppose the truth of the bridi itself
    depends on the result of a movement, or represents an action
    being done while the speaker is moving? This too can be
    represented by the tense system, using the cmavo ``mo'i'' (of
    selma'o MOhI) plus a spatial direction and optional distance;
    the direction now refers to a direction of motion rather than a
    static direction from the speaker. 

    <p></p>
<pre>
<a id="e8d1"
name="e8d1">8.1)</a>  le verba mo'i ri'u cadzu le bisli
    The child [movement] [right] walks-on the ice.
    The child walks toward my right on the ice.
</pre>

    <p>This is quite different from:</p>
<pre>
<a id="e8d2" name="e8d2">8.2)</a>  le verba ri'u cadzu le bisli
    The child [right] walks-on the ice.
    To the right of me, the child walks on the ice.
</pre>
    In either case, however, the reference frame for defining
    ``right'' and ``left'' is the speaker's, not the child's. This
    can be changed thus: 

    <p></p>
<pre>
<a id="e8d3"
name="e8d3">8.3)</a>  le verba mo'i ri'u cadzu le bisli
        ma'i vo'a
    The child [movement] [right] walks on the ice
        in-reference-frame the-x1-place.
    The child walks toward her right on the ice.
</pre>
    <a href="#e8d3">Example 8.3</a> is analogous to <a
    href="#e8d1">Example 8.1</a>. The cmavo ``ma'i'' belongs to
    selma'o BAI (explained in <a href="chapter9.html">Chapter 9</a>),
    and allows specifying a reference frame. 

    <p>Both a regular and a ``mo'i''-flagged spatial tense can be
    combined, with the ``mo'i'' construct coming last:</p>
<pre>
<a id="e8d4" name="e8d4">8.4)</a>  le verba zu'avu mo'i ri'uvi
        cadzu le bisli
    The child [left] [long] [movement] [right] [short]
        walks-on the ice.
    Far to the left of me, the child walks a short
        distance toward my right on the ice.
</pre>
    It is not grammatical to use multiple directions like ``zu'a
    ca'u'' after ``mo'i'', but complex movements can be expressed
    in a separate bridi. 

    <p>Here is an example of a movement tense on a bridi not
    inherently involving movement:</p>

    <p></p>
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  mi mo'i ca'uvu citka le mi sanmi
    I [movement] [front] [long] eat my meal.
    While moving a long way forward, I eat my meal.
</pre>
    (Perhaps I am eating in an airplane.) 

    <p>There is no parallel facility in Lojban at present for
    expressing movement in time --- time travel --- but one could
    be added easily if it ever becomes useful.</p>

    <h3><a id="s9" name="s9">9. Interval properties: TAhE and ``roi''</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   di'i    TAhE    regularly
    na'o    TAhE    typically
    ru'i    TAhE    continuously
    ta'e    TAhE    habitually

    di'inai TAhE    irregularly
    na'onai TAhE    atypically
    ru'inai TAhE    intermittently
    ta'enai TAhE    contrary to habit

    roi ROI ``n'' times
    roinai  ROI other than ``n'' times

    ze'e    ZEhA    whole time interval
    ve'e    VEhA    whole space interval    
</pre>
    Consider Lojban bridi which express events taking place in
    time. Whether a very short interval (a point) or a long
    interval of time is involved, the event may not be spread
    consistently throughout that interval. Lojban can use the cmavo
    of selma'o TAhE to express the idea of continuous or
    non-continuous actions. 

    <p></p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  mi puzu ze'u
        velckule
    I [past] [long distance] [long interval]
        am-a-school-attendee (pupil).
    Long ago I attended school for a long time.
</pre>
    probably does not mean that I attended school continuously
    throughout the whole of that long-ago interval. Actually, I
    attended school every day, except for school holidays. More
    explicitly, 

    <p></p>
<pre>
<a id="e9d2" name="e9d2">9.2)</a>  mi puzu ze'u di'i
        velckule
    I [past] [long distance] [long interval] [regularly]
        am-a-pupil.
    Long ago I regularly attended school for a long time.
</pre>
    The four TAhE cmavo are differentiated as follows: ``ru'i''
    covers the entirety of the interval, ``di'i'' covers the parts
    of the interval which are systematically spaced subintervals;
    ``na'o'' covers part of the interval, but exactly which part is
    determined by context; ``ta'e'' covers part of the interval,
    selected with reference to the behavior of the actor (who
    often, but not always, appears in the x1 place of the bridi). 

    <p>Using TAhE does not require being so specific. Either the
    time direction or the time interval or both may be omitted (in
    which case they are vague). For example:</p>
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  mi ba ta'e klama le zarci
    I [future] [habitually] go-to the market.
    I will habitually go to the market.
    I will make a habit of going to the market.
</pre>
    specifies the future, but the duration of the interval is
    indefinite. Similarly, 
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  mi na'o klama le zarci
    I [typically] go-to the market
    I typically go/went/will go to the market
</pre>
    illustrates an interval property in isolation. There are no
    distance or direction cmavo, so the point of time is vague;
    likewise, there is no interval cmavo, so the length of the
    interval during which these goings-to-the-market take place is
    also vague. As always, context will determine these vague
    values. 

    <p>``Intermittently'' is the polar opposite notion to
    ``continuously'', and is expressed not with its own cmavo, but
    by adding the negation suffix ``-nai'' (which belongs to
    selma'o NAI) to ``ru'i''. For example:</p>
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  le verba ru'inai cadzu le bisli
    The child [continuously-not] walks-on the ice.
    The child intermittently walks on the ice.
</pre>
    As shown in the cmavo table above, all the cmavo of TAhE may be
    negated with ``-nai''; ``ru'inai'' and ``di'inai'' are probably
    the most useful. 

    <p>An intermittent event can also be specified by counting the
    number of times during the interval that it takes place. The
    cmavo ``roi'' (which belongs to selma'o ROI) can be appended to
    a number to make a quantified tense. Quantified tenses are
    common in English, but not so commonly named: they are
    exemplified by the adverbs ``never'', ``once'', ``twice'',
    ``thrice'', ... ``always'', and by the related phrases ``many
    times'', ``a few times'', ``too many times'', and so on. All of
    these are handled in Lojban by a number plus ``-roi'':</p>
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  mi paroi klama le zarci
    I [one time] go-to the market.
    I go to the market once.

<a id="e9d7" name="e9d7">9.7)</a>   mi du'eroi klama le zarci
    I [too-many times] go-to the market.
    I go to the market too often.
</pre>
    With the quantified tense alone, we don't know whether the
    past, the present, or the future is intended, but of course the
    quantified tense need not stand alone: 
<pre>
<a id="e9d8" name="e9d8">9.8)</a>  mi pu reroi klama le zarci
    I [past] [two times] go-to the market.
    I went to the market twice.
</pre>
    The English is slightly over-specific here: it entails that
    both goings-to- the-market were in the past, which may or may
    not be true in the Lojban sentence, since the implied interval
    is vague. Therefore, the interval may start in the past but
    extend into the present or even the future. 

    <p>Adding ``-nai'' to ``roi'' is also permitted, and has the
    meaning ``other than (the number specified)'':</p>

    <p></p>
<pre>
<a id="e9d9" name="e9d9">9.9)</a>  le ratcu reroinai citka le cirli
    The rat [twice-not] eats the cheese.
    The rat eats the cheese other than twice
</pre>

    <p>This may mean that the rat eats the cheese fewer times, or
    more times, or not at all.</p>

    <p>It is necessary to be careful with sentences like <a
    href="#e9d6">Example 9.6</a> and <a href="#e9d8">Example
    9.8</a>, where a quantified tense appears without an interval.
    What <a href="#e9d8">Example 9.8</a> really says is that during
    an interval of unspecified size, at least part of which was set
    in the past, the event of my going to the market happened
    twice. The example says nothing about what happened outside
    that vague time interval. This is often less than we mean. If
    we want to nail down that I went to the market once and only
    once, we can use the cmavo ``ze'e'' which represents the
    ``whole time interval'': conceptually, an interval which
    stretches from time's beginning to its end:</p>
<pre>
<a id="e9d10"
name="e9d10">9.10)</a>    mi ze'e paroi klama le zarci
    I [whole interval] [once] go-to the market.
</pre>

    <p>Since specifying no ZEhA leaves the interval vague, <a
    href="#e9d8">Example 9.8</a> might in appropriate context mean
    the same as <a href="#e9d10">Example 9.10</a> after all --- but
    <a href="#e9d10">Example 9.10</a> allows us to be specific when
    specificity is necessary.</p>

    <p>A PU cmavo following ``ze'e'' has a slightly different
    meaning from one that follows another ZEhA cmavo. The compound
    cmavo ``ze'epu'' signifies the interval stretching from the
    infinite past to the reference point (wherever the imaginary
    journey has taken you); ``ze'eba'' is the interval stretching
    from the reference point to the infinite future. The remaining
    form, ``ze'eca'', makes specific the ``whole of time''
    interpretation just given. These compound forms make it
    possible to assert that something has never happened without
    asserting that it never will.</p>
<pre>
<a id="e9d11"
name="e9d11">9.11)</a>    mi ze'epu noroi klama le zarci
    I [whole interval] [past] [never] go-to the market.
    I have never gone to the market.
</pre>
    says nothing about whether I might go in future. 

    <p>The space equivalent of ``ze'e'' is ``ve'e'', and it can be
    used in the same way with a quantified space tense: see <a
    href="#s11">Section 11</a> for an explanation of space interval
    modifiers.</p>

    <h3><a id="s10" name="s10">10. Event contours: ZAhO and ``re'u''</h3>

    <p>The following cmavo are discussed in this section:</p>

    <p></p>
<pre>
   pu'o    ZAhO    inchoative
    ca'o    ZAhO    continuitive
    ba'o    ZAhO    perfective
    co'a    ZAhO    initiative
    co'u    ZAhO    cessitive
    mo'u    ZAhO    completitive
    za'o    ZAhO    superfective
    co'i    ZAhO    achievative
    de'a    ZAhO    pausative
    di'a    ZAhO    resumptive
    re'u    ROI ordinal tense
</pre>
    The cmavo of selma'o ZAhO express the Lojban version of what is
    traditionally called ``aspect''. This is not a notion well
    expressed by English tenses, but many languages (including
    Chinese and Russian among Lojban's six source languages)
    consider it more important than the specification of mere
    position in time. 

    <p>The ``event contours'' of selma'o ZAhO, with their bizarre
    keywords, represent the natural portions of an event considered
    as a process, an occurrence with an internal structure
    including a beginning, a middle, and an end. Since the keywords
    are scarcely self-explanatory, each ZAhO will be explained in
    detail here. Note that from the viewpoint of Lojban syntax,
    ZAhOs are interval modifiers like TAhEs or ROI compounds; if
    both are found in a single tense, the TAhE/ROI comes first and
    the ZAhO afterward. The imaginary journey described by other
    tense cmavo moves us to the portion of the event-as-process
    which the ZAhO specifies.</p>

    <p>It is important to understand that ZAhO cmavo, unlike the
    other tense cmavo, specify characteristic portions of the
    event, and are seen from an essentially timeless perspective.
    The ``beginning'' of an event is the same whether the event is
    in the speaker's present, past, or future. It is especially
    important not to confuse the speaker-relative viewpoint of the
    PU tenses with the event-relative viewpoint of the ZAhO
    tenses.</p>

    <p>The cmavo ``pu'o'', ``ca'o'', and ``ba'o'' (etymologically
    derived from the PU cmavo) refer to an event that has not yet
    begun, that is in progress, or that has ended,
    respectively:</p>

    <p></p>
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    mi pu'o damba
    I [inchoative] fight.
    I'm on the verge of fighting.
</pre>
<pre>
<a id="e10d2" name="e10d2">10.2)</a>    la stiv. ca'o bacru
    Steve [continuitive] utters.
    Steve continues to talk.
</pre>
<pre>
<a id="e10d3"
name="e10d3">10.3)</a>    le verba ba'o cadzu le bisli
    The child [perfective] walks-on the ice.
    The child is finished walking on the ice.
</pre>
    As discussed in <a href="#s6">Section 6</a>, the simple PU
    cmavo make no assumptions about whether the scope of a past,
    present, or future event extends into one of the other tenses
    as well. <a href="#e10d1">Examples 10.1</a> through <a
    href="#e10d3">10.3</a> illustrate that these ZAhO cmavo do make
    such assumptions possible: the event in 10.1 has not yet begun,
    definitively; likewise, the event in 10.3 is definitely over. 

    <p>Note that in <a href="#e10d1">Example 10.1</a> and <a
    href="#e10d3">Example 10.3</a>, ``pu'o'' and ``ba'o'' may
    appear to be reversed: ``pu'o'', although etymologically
    connected with ``pu'', is referring to a future event; whereas
    ``ba'o'', connected with ``ba'', is referring to a past event.
    This is the natural result of the event-centered view of ZAhO
    cmavo. The inchoative, or ``pu'o'', part of an event, is in the
    ``pastward'' portion of that event, when seen from the
    perspective of the event itself. It is only by inference that
    we suppose that <a href="#e10d1">Example 10.1</a> refers to the
    speaker's future: in fact, no PU tense is given, so the
    inchoative part of the event need not be coincident with the
    speaker's present: ``pu'o'' is not necessarily, though in fact
    often is, the same as ``ca pu'o''.</p>

    <p>The cmavo in <a href="#e10d1">Examples 10.1</a> through <a
    href="#e10d3">10.3</a> refer to spans of time. There are also
    two points of time that can be usefully associated with an
    event: the beginning, marked by ``co'a'', and the end, marked
    by ``co'u''. Specifically, ``co'a'' marks the boundary between
    the ``pu'o'' and ``ca'o'' parts of an event, and ``co'u'' marks
    the boundary between the ``ca'o'' and ``ba'o'' parts:</p>
<pre>
<a id="e10d4"
name="e10d4">10.4)</a>    mi ba co'a citka le mi sanmi
    I [future] [initiative] eat my meal.
    I will begin to eat my meal.

<a id="e10d5" name="e10d5">10.5)</a> mi pu co'u citka le mi sanmi
    I [past] [cessitive] eat my meal.
    I ceased eating my meal.
</pre>

    <p>Compare <a href="#e10d4">Example 10.4</a> with:</p>
<pre>
<a id="e10d6" name="e10d6">10.6)</a>    mi ba di'i co'a bajra
    I [future] [regularly] [initiative] run.
    I will regularly begin to run.
</pre>
    which illustrates the combination of a TAhE with a ZAhO. 

    <p>A process can have two end points, one reflecting the
    ``natural end'' (when the process is complete) and the other
    reflecting the ``actual stopping point'' (whether complete or
    not). <a href="#e10d5">Example 10.5</a> may be contrasted
    with:</p>
<pre>
<a id="e10d7"
name="e10d7">10.7)</a>    mi pu mo'u citka le mi sanmi
    I [past] [completitive] eat my meal.
    I finished eating my meal.
</pre>

    <p>In <a href="#e10d7">Example 10.7</a>, the meal has reached
    its natural end; in <a href="#e10d5">Example 10.5</a>, the meal
    has merely ceased, without necessarily reaching its natural
    end.</p>

    <p>A process such as eating a meal does not necessarily proceed
    uninterrupted. If it is interrupted, there are two more
    relevant point events: the point just before the interruption,
    marked by ``de'a'', and the point just after the interruption,
    marked by ``di'a''. Some examples:</p>
<pre>
<a id="e10d8"
name="e10d8">10.8)</a>    mi pu de'a citka le mi sanmi
    I [past] [pausative] eat my meal.
    I stopped eating my meal
        (with the intention of resuming).

<a id="e10d9" name="e10d9">10.9)</a> mi ba di'a citka le mi sanmi
    I [future] [resumptive] eat my meal.
    I will resume eating my meal.
</pre>
    In addition, it is possible for a process to continue beyond
    its natural end. The span of time between the natural and the
    actual end points is represented by ``za'o'': 

    <p></p>
<pre>
<a id="e10d10" name="e10d10">10.10)</a>  le xirma ca za'o
        jivna bajra
    The horse [present] [superfective]
        compete-type-of runs.
    The horse keeps on running a race too long.
</pre>
    which means that it ran past the finish line (after the race
    was over --- in most races, the runners do not stop right at
    the finish line). 

    <p>An entire event can be treated as a single moment using the
    cmavo ``co'i'':</p>
<pre>
<a id="e10d11"
name="e10d11">10.11)</a>  la djan. pu co'i catra la djim
    John [past] [achievative] kills Jim.
    John was at the point in time where he killed Jim.
</pre>
    Finally, since an activity is cyclical, an individual cycle can
    be referred to using a number followed by ``re'u'', which is
    the other cmavo of selma'o ROI: 
<pre>
<a id="e10d12" name="e10d12">10.12)</a>  mi pare'u klama le zarci
    I [first time] go-to the store.
    I go to the store for the first time
        (within a vague interval).
</pre>

    <p>Note the difference between:</p>
<pre>
<a id="e10d13"
name="e10d13">10.13)</a>  mi pare'u paroi klama le zarci
    I [first time] [one time] go-to the store.
    For the first time, I go to the store once.
</pre>
    and 
<pre>
<a id="e10d14"
name="e10d14">10.14)</a>  mi paroi pare'u klama le zarci
    I [one time] [first time] go-to the store.
    There is one occasion on which I go to
        the store for the first time.
</pre>

    <h3><a id="s11" name="s11">11. Space interval modifiers: FEhE</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
       fe'e    FEhE    space interval modifier flag
</pre>
    Like time intervals, space intervals can also be continuous,
    discontinuous, or repetitive. Rather than having a whole
    separate set of selma'o for space interval properties, we
    instead prefix the flag ``fe'e'' to the cmavo used for time
    interval properties. A space interval property would be placed
    just after the space interval size and/or dimensionality cmavo:
    

    <p></p>
<pre>
<a id="e11d1" name="e11d1">11.1)</a>    ko vi'i fe'e di'i
        sombo le gurni
    You-imperative [1-dimensional] [space:] [regularly]
        sow the grain.
    Sow the grain in a line and evenly!
</pre>
<pre>
<a id="e11d2" name="e11d2">11.2)</a>    mi fe'e ciroi
        tervecnu lo selsalta
    I [space:] [three places]
        buy those-which-are salad-ingredients.
    I buy salad ingredients in three locations.
</pre>
<pre>
<a id="e11d3" name="e11d3">11.3)</a>    ze'e roroi ve'e
        fe'e roroi ku
        li re su'i re du li vo
    [whole time] [all times] [whole space]
        [space:] [all places]
        The-number 2 + 2 = the-number 4.
    Always and everywhere, two plus two is four.
</pre>

    <p>As shown in <a href="#e11d3">Example 11.3</a>, when a tense
    comes first in a bridi, rather than in its normal position
    before the selbri (in this case ``du''), it is emphasized.</p>

    <p>The ``fe'e'' marker can also be used for the same purpose
    before members of ZAhO. (The cmavo ``be'a'' belongs to selma'o
    FAhA; it is the space direction meaning ``north of''.)</p>

    <p></p>
<pre>
<a id="e11d4" name="e11d4">11.4)</a>    tu ve'abe'a
        fe'e co'a rokci
    that-yonder [medium space interval - north]
        [space] [initiative] is-a-rock.
    That is the beginning of a rock extending to my north.
    That is the south face of a rock.
</pre>
    Here the notion of a ``beginning point'' represented by the
    cmavo ``co'a'' is transferred from ``beginning in time'' to
    ``beginning in space'' under the influence of the ``fe'e''
    flag. Space is not inherently oriented, unlike time, which
    flows from past to future: therefore, some indication of
    orientation is necessary, and the ``ve'abe'a'' provides an
    orientation in which the south face is the ``beginning'' and
    the north face is the ``end'', since the rock extends from
    south (near me) to north (away from me). 

    <p>Many natural languages represent time by a space-based
    metaphor: in English, what is past is said to be ``behind us''.
    In other languages, the metaphor is reversed. Here, Lojban is
    representing space (or space interval modifiers) by a
    time-based metaphor: the choice of a FAhA cmavo following a
    VEhA cmavo indicates which direction is mapped onto the future.
    (The choice of future rather than past is arbitrary, but
    convenient for English-speakers.)</p>

    <p>If both a TAhE (or ROI) and a ZAhO are present as space
    interval modifiers, the ``fe'e'' flag must be prefixed to
    each.</p>

    <h3><a id="s12" name="s12">12. Tenses as sumti tcita</h3>

    <p>So far, we have seen tenses only just before the selbri, or
    (equivalently in meaning) floating about the bridi with ``ku''.
    There is another major use for tenses in Lojban: as sumti
    tcita, or argument tags. A tense may be used to add spatial or
    temporal information to a bridi as, in effect, an additional
    place:</p>
<pre>
<a id="e12d1" name="e12d1">12.1)</a>    mi klama le zarci ca le nu
        do klama le zdani
    I go-to the market [present] the event-of
        you go-to the house.
    I go to the market when you go to the house.
</pre>
    Here ``ca'' does not appear before the selbri, nor with ``ku'';
    instead, it governs the following sumti, the ``le nu''
    construct. What <a href="#e12d1">Example 12.1</a> asserts is
    that the action of the main bridi is happening at the same time
    as the event mentioned by that sumti. So ``ca'', which means
    ``now'' when used with a selbri, means ``simultaneously-with''
    when used with a sumti. Consider another example: 

    <p></p>
<pre>
<a id="e12d2" name="e12d2">12.2)</a>    mi klama le zarci pu le nu
        do pu klama le zdani
    I go-to the market [past] the event-of
        you [past] go-to the house.
</pre>

    <p>The second ``pu'' is simply the past tense marker for the
    event of your going to the house, and says that this event is
    in the speaker's past. How are we to understand the first
    ``pu'', the sumti tcita?</p>

    <p>All of our imaginary journeys so far have started at the
    speaker's location in space and time. Now we are specifying an
    imaginary journey that starts at a different location, namely
    at the event of your going to the house. <a
    href="#e12d2">Example 12.2</a> then says that my going to the
    market is in the past, relative not to the speaker's present
    moment, but instead relative to the moment when you went to the
    house. <a href="#e12d2">Example 12.2</a> can therefore be
    translated:</p>

    <dl>
      <dt></dt>

      <dd>I had gone to the market before you went to the
      house.</dd>
    </dl>
    (Other translations are possible, depending on the ever-present
    context.) Spatial direction and distance sumti tcita are
    exactly analogous: 

    <p></p>
<pre>
<a id="e12d3"
name="e12d3">12.3)</a>    le ratcu cu citka le cirla vi le panka
    The rat eats the cheese [short distance] the park.
    The rat eats the cheese near the park.

<a id="e12d4" name="e12d4">12.4)</a> le ratcu cu citka le cirla
        vi le vu panka
    The rat eats the cheese
        [short distance] the [long distance] park
    The rat eats the cheese near the faraway park.

<a id="e12d5" name="e12d5">12.5)</a> le ratcu cu citka le cirla
        vu le vi panka
    The rat eats the cheese
        [long distance] the [short distance] park
    The rat eats the cheese far away from the nearby park.
</pre>
    The event contours of selma'o ZAhO (and their space
    equivalents, prefixed with ``fe'e'') are also useful as sumti
    tcita. The interpretation of ZAhO tcita differs from that of
    FAhA, VA, PU, and ZI tcita, however. The event described in the
    sumti is viewed as a process, and the action of the main bridi
    occurs at the phase of the process which the ZAhO specifies, or
    at least some part of that phase. The action of the main bridi
    itself is seen as a point event, so that there is no issue
    about which phase of the main bridi is intended. For example: 

    <p></p>
<pre>
<a id="e12d6"
name="e12d6">12.6)</a>    mi morsi ba'o le nu mi jmive
    I am-dead [perfective] the event-of I live.
    I die in the aftermath of my living.
</pre>

    <p>Here the (point-)event of my being dead is the portion of my
    living-process which occurs after the process is complete.
    Contrast <a href="#e12d6">Example 12.6</a> with:</p>
<pre>
<a id="e12d7" name="e12d7">12.7)</a>    mi morsi ba le nu mi jmive
    I am-dead [future] the event-of I live.
</pre>

    <p>As explained in <a href="#s6">Section 6</a>, <a
    href="#e12d7">Example 12.7</a> does not exclude the possibility
    that I died before I ceased to live!</p>

    <p>Likewise, we might say:</p>
<pre>
<a id="e12d8"
name="e12d8">12.8)</a>    mi klama le zarci pu'o le nu mi citka
    I go-to the store [inchoative] the event-of I eat
</pre>
    which indicates that before my eating begins, I go to the
    store, whereas 
<pre>
<a id="e12d9"
name="e12d9">12.9)</a>    mi klama le zarci ba'o le nu mi citka
    I go-to the store [perfective] the event-of I eat
</pre>
    would indicate that I go to the store after I am finished
    eating. 

    <p>Here is an example which mixes temporal ZAhO (as a tense)
    and spatial ZAhO (as a sumti tcita):</p>

    <p></p>
<pre>
<a id="e12d10" name="e12d10">12.10)</a>  le bloti pu za'o xelklama
        fe'e ba'o le lalxu
    the boat [past] [superfective]
        is-a-transport-mechanism
        [space] [perfective] the lake.
    The boat sailed for too long and beyond the lake.
</pre>

    <p>Probably it sailed up onto the dock. One point of
    clarification: although ``xelklama'' appears to mean simply
    ``is-a-mode-of-transport'', it does not -- the bridi of <a
    href="#e12d10">Example 12.10</a> has four omitted arguments,
    and thus has the (physical) journey which goes on too long as
    part of its meaning.</p>

    <p>The remaining tense cmavo, which have to do with interval
    size, dimension, and continuousness (or lack thereof) are
    interpreted to let the sumti specify the particular interval
    over which the main bridi operates:</p>

    <p></p>
<pre>
<a id="e12d11"
name="e12d11">12.11)</a>  mi klama le zarci reroi le ca djedi
    I go-to the market [twice] the [present] day
    I go/went/will go to the market twice today.
</pre>
    Be careful not to confuse a tense used as a sumti tcita with a
    tense used within a seltcita sumti: 

    <p></p>
<pre>
<a id="e12d12" name="e12d12">12.12)</a>  loi snime cu carvi
        ze'u le ca dunra
    some-of-the-mass-of snow rains
        [long time interval] the [present] winter.
    Snow falls during this winter.
</pre>
    claims that the interval specified by ``this winter'' is long,
    as events of snowfall go, whereas 
<pre>
<a id="e12d13" name="e12d13">12.13)</a>  loi snime cu carvi
        ca le ze'u dunra
    some-of-the-mass-of snow rains
        [present] the [long time] winter.
    Snow falls in the long winter.
</pre>
    claims that during some part of the winter, which is long as
    winters go, snow falls. 

    <h3><a id="s13" name="s13">13. Sticky and multiple tenses: KI</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   ki  KI  sticky tense set/reset
</pre>
    So far we have only considered tenses in isolated bridi. Lojban
    provides several ways for a tense to continue in effect over
    more than a single bridi. This property is known as
    ``stickiness'': the tense gets ``stuck'' and remains in effect
    until explicitly ``unstuck''. In the metaphor of the imaginary
    journey, the place and time set by a sticky tense may be
    thought of as a campsite or way-station: it provides a
    permanent origin with respect to which other tenses are
    understood. Later imaginary journeys start from that point
    rather than from the speaker. 

    <p>To make a tense sticky, suffix ``ki'' to it:</p>
<pre>
<a id="e13d1" name="e13d1">13.1)</a>    mi puki klama le zarci
        .i le nanmu cu batci le gerku
    I [past] [sticky] go-to the market.
         The man bites the dog.
    I went to the market.  The man bit the dog.
</pre>

    <p>Here the use of ``puki'' rather than just ``pu'' ensures
    that the tense will affect the next sentence as well.
    Otherwise, since the second sentence is tenseless, there would
    be no way of determining its tense; the event of the second
    sentence might happen before, after, or simultaneously with
    that of the first sentence.</p>

    <p>(The last statement does not apply when the two sentences
    form part of a narrative. See <a href="#s14">Section 14</a> for
    an explanation of ``story time'', which employs a different set
    of conventions.)</p>

    <p>What if the second sentence has a tense anyway?</p>

    <p></p>
<pre>
<a id="e13d2" name="e13d2">13.2)</a>    mi puki klama le zarci
        .i le nanmu pu batci le gerku
    I [past] sticky go-to the market.
         The man [past] bites the dog.
</pre>

    <p>Here the second ``pu'' does not replace the sticky tense,
    but adds to it, in the sense that the starting point of its
    imaginary journey is taken to be the previously set sticky
    time. So the translation of <a href="#e13d2">Example 13.2</a>
    is:</p>
<pre>
<a id="e13d3" name="e13d3">13.3)</a>    I went to the market.
        The man had earlier bitten the dog.
</pre>
    and it is equivalent in meaning (when considered in isolation
    from any other sentences) to: 
<pre>
<a id="e13d4" name="e13d4">13.4)</a>    mi pu klama le zarci
        .i le nanmu pupu batci le gerku
    I [past] go-to the market.
        The man [past] [past] bites the dog.
</pre>
    The point has not been discussed so far, but it is perfectly
    grammatical to have more than one tense construct in a
    sentence: 
<pre>
<a id="e13d5" name="e13d5">13.5)</a>    puku mi ba klama le zarci
    [past] I [future] go-to the market.
    Earlier, I was going to go to the market.
</pre>

    <p>Here there are two tenses in the same bridi, the first
    floating free and specified by ``puku'', the second in the
    usual place and specified by ``ba''. They are considered
    cumulative in the same way as the two tenses in separate
    sentences of <a href="#e13d4">Example 13.4</a>. <a
    href="#e13d5">Example 13.5</a> is therefore equivalent in
    meaning, except for emphasis, to:</p>
<pre>
<a id="e13d6" name="e13d6">13.6)</a>    mi puba klama le zarci
    I [past] [future] go-to the market.
    I was going to go to the market.
</pre>
    Compare <a href="#e13d7">Example 13.7</a> and <a
    href="#e13d8">Example 13.8</a>, which have a different meaning
    from <a href="#e13d5">Example 13.5</a> and <a
    href="#e13d6">Example 13.6</a>: 
<pre>
<a id="e13d7" name="e13d7">13.7)</a>    mi ba klama le zarci puku
    I [future] go-to the market [past].
    I will have gone to the market earlier.

<a id="e13d8" name="e13d8">13.8)</a> mi bapu klama le zarci
    I [future] [past] go-to the market.
    I will have gone to the market.
</pre>

    <p>So when multiple tense constructs in a single bridi are
    involved, order counts --- the tenses cannot be shifted around
    as freely as if there were only one tense to worry about.</p>

    <p>But why bother to allow multiple tense constructs at all?
    They specify separate portions of the imaginary journey, and
    can be useful in order to make part of a tense sticky. Consider
    <a href="#e13d9">Example 13.9</a>, which adds a second bridi
    and a ``ki'' to <a href="#e13d5">Example 13.5</a>:</p>

    <dl>
      <dt>13.9</dt>

      <dd>pukiku mi ba klama le zarci .i le nanmu cu batci le gerku
      [past] [sticky] I [future] go-to the market. The man bites
      the dog.</dd>
    </dl>

    <p>What is the implied tense of the second sentence? Not
    ``puba'', but only ``pu'', since only ``pu'' was made sticky
    with ``ki''. So the translation is:</p>

    <dl>
      <dt></dt>

      <dd>I was going to go to the market. The man bit the
      dog.</dd>
    </dl>
    Lojban has several ways of embedding a bridi within another
    bridi: descriptions, abstractors, relative clauses.
    (Technically, descriptions contain selbri rather than bridi.)
    Any of the selbri of these subordinate bridi may have tenses
    attached. These tenses are interpreted relative to the tense of
    the main bridi: 

    <p></p>
<pre>
<a id="e13d10" name="e13d10">13.10)</a>  mi pu klama le ba'o zarci
    I [past] go-to the [perfective] market
    I went to the former market.
</pre>

    <p>The significance of the ``ba'o'' in <a
    href="#e13d10">Example 13.10</a> is that the speaker's
    destination is described as being ``in the aftermath of being a
    market''; that is, it is a market no longer. In particular, the
    time at which it was no longer a market is in the speaker's
    past, because the ``ba'o'' is interpreted relative to the
    ``pu'' tense of the main bridi.</p>

    <p>Here is an example involving an abstraction bridi:</p>
<pre>
<a id="e13d11"
name="e13d11">13.11)</a>  mi ca jinvi le du'u mi ba morsi
    I now opine the fact-that I will-be dead.
    I now believe that I will be dead.
</pre>

    <p>Here the event of being dead is said to be in the future
    with respect to the opinion, which is in the present.</p>

    <p>``ki'' may also be used as a tense by itself. This cancels
    all stickiness and returns the bridi and all following bridi to
    the speaker's location in both space and time:</p>
<pre>
<a id="e13d12" name="e13d12">13.12)</a>  mi ki cusku dei
    I [here and now] express this-utterance.
    I say this sentence now.
</pre>
    In complex descriptions, multiple tenses may be saved and then
    used by adding a subscript to ``ki''. A time made sticky with
    ``kixipa'' (ki-sub-1) can be returned to by specifying
    ``kixipa'' as a tense by itself. In the case of written
    expression, the writer's here-and-now is often different from
    the reader's, and a pair of subscripted ``ki'' tenses could be
    used to distinguish the two. 

    <h3><a id="s14" name="s14">14. Story time</h3>

    <p>Making strict use of the conventions explained in <a
    href="#s13">Section 13</a> would be intolerably awkward when a
    story is being told. The time at which a story is told by the
    narrator is usually unimportant to the story. What matters is
    the flow of time within the story itself. The term ``story'' in
    this section refers to any series of statements related in
    more-or-less time-sequential order, not just a fictional
    one.</p>

    <p>Lojban speakers use a different set of conventions, commonly
    called ``story time'', for inferring tense within a story. It
    is presumed that the event described by each sentence takes
    place some time more or less after the previous ones.
    Therefore, tenseless sentences are implicitly tensed as ``what
    happens next''. In particular, any sticky time setting is
    advanced by each sentence.</p>

    <p>The following mini-story illustrates the important features
    of story time. A sentence-by-sentence explication follows:</p>

    <p></p>
<pre>
<a id="e14d1" name="e14d1">14.1)</a>    puzuki ku ne'iki le kevna
        le ninmu goi ko'a zutse le rokci
    [past] [long] [sticky] [,] [inside] [sticky] the cave,
        the woman defined-as she-1 sat-on the rock
    Long ago, in a cave, a woman sat on a rock.

<a id="e14d2" name="e14d2">14.2)</a> .i ko'a citka loi kanba rectu
    She-1 [tenseless] eat some-of-the-mass-of goat flesh.
    She was eating goat's meat.

<a id="e14d3"
name="e14d3">14.3)</a> .i ko'a pu jukpa ri le mudyfagri
    She [past] cook the-last-mentioned
        by-method the wood-fire.
    She had cooked the meat over a wood fire.

<a id="e14d4" name="e14d4">14.4)</a> .i lei rectu cu zanglare
    The-mass-of flesh is-(favorable)-warm.
    The meat was pleasantly warm.

<a id="e14d5" name="e14d5">14.5)</a> .i le labno goi ko'e bazaki
        nenri klama le kevna
    The wolf defined-as it-2 [future] [medium] [sticky]
        within-came to-the cave.
    A while later, a wolf came into the cave.

<a id="e14d6" name="e14d6">14.6)</a> .i ko'e lebna lei rectu ko'a
    It-2 [tenseless] takes the-mass-of flesh from-her-1.
    It took the meat from her.

<a id="e14d7" name="e14d7">14.7)</a> .i ko'e bartu klama
    It-2 out ran
    It ran out.
</pre>
    <a href="#e14d1">Example 14.1</a> sets both the time (long ago)
    and the place (in a cave) using ``ki'', just like the sentence
    sequences in <a href="#s13">Section 13</a>. No further space
    cmavo are used in the rest of the story, so the place is
    assumed to remain unchanged. The English translation of <a
    href="#e14d1">Example 14.1</a> is marked for past tense also,
    as the conventions of English storytelling require:
    consequently, all other English translation sentences are also
    in the past tense. (We don't notice how strange this is; even
    stories about the future are written in past tense!) This
    conventional use of past tense is not used in Lojban
    narratives. 

    <p><a href="#e14d2">Example 14.2</a> is tenseless. Outside
    story time, it would be assumed that its event happens
    simultaneously with that of <a href="#e14d1">Example 14.1</a>,
    since a sticky tense is in effect; the rules of story time,
    however, imply that the event occurs afterwards, and that the
    story time has advanced (changing the sticky time set in <a
    href="#e14d1">Example 14.1</a>).</p>

    <p><a href="#e14d3">Example 14.3</a> has an explicit tense.
    This is taken relative to the latest setting of the sticky
    time; therefore, the event of <a href="#e14d3">Example 14.3</a>
    happens before that of <a href="#e14d2">Example 14.2</a>. It
    cannot be determined if <a href="#e14d3">Example 14.3</a>
    happens before or after <a href="#e14d1">Example 14.1</a>.</p>

    <p><a href="#e14d4">Example 14.4</a> is again tenseless. Story
    time was not changed by the flashback in <a
    href="#e14d3">Example 14.3</a>, so <a href="#e14d4">Example
    14.4</a> happens after <a href="#e14d2">Example 14.2</a>.</p>

    <p><a href="#e14d5">Example 14.5</a> specifies the future
    (relative to <a href="#e14d4">Example 14.4</a>) and makes it
    sticky. So all further events happen after <a
    href="#e14d5">Example 14.5</a>.</p>

    <p><a href="#e14d6">Example 14.6</a> and <a
    href="#e14d7">Example 14.7</a> are again tenseless, and so
    happen after <a href="#e14d5">Example 14.5</a>. (Story time is
    changed.)</p>

    <p>So the overall order is 14.1 - 14.3 - 14.2 - 14.4 - (medium
    interval) - 14.5 - 14.6 - 14.7. It is also possible that 14.3
    happens before 14.1.</p>

    <p>If no sticky time (or space) is set initially, the story is
    set at an unspecified time (or space): the effect is like that
    of choosing an arbitrary reference point and making it sticky.
    This style is common in stories that are jokes. The same
    convention may be used if the context specifies the sticky time
    sufficiently.</p>

    <h3><a id="s15" name="s15">15. Tenses in subordinate bridi</h3>

    <p>English has a set of rules, formally known as ``sequence of
    tense rules'', for determining what tense should be used in a
    subordinate clause, depending on the tense used in the main
    sentence. Here are some examples:</p>
<pre>
<a id="e15d1"
name="e15d1">15.1)</a>    John says that George is going to the market.

<a id="e15d2"
name="e15d2">15.2)</a> John says that George went to the market.

<a id="e15d3"
name="e15d3">15.3)</a> John said that George went to the market.

<a id="e15d4"
name="e15d4">15.4)</a> John said that George had gone to the market.
</pre>

    <p>In <a href="#e15d1">Example 15.1</a> and <a
    href="#e15d2">Example 15.2</a>, the tense of the main sentence
    is the present: ``says''. If George goes when John speaks, we
    get the present tense ``is going'' (``goes'' would be
    unidiomatic); if George goes before John speaks, we get the
    past tense ``went''. But if the tense of the main sentence is
    the past, with ``said'', then the tense required in the
    subordinate clause is different. If George goes when John
    speaks, we get the past tense ``went''; if George goes before
    John speaks, we get the past-perfect tense ``had gone''.</p>

    <p>The rule of English, therefore, is that both the tense of
    the main sentence and the tense of the subordinate clause are
    understood relative to the speaker (not John, but the person
    who speaks <a href="#e15d1">Examples 15.1</a> through <a
    href="#e15d4">15.4</a>).</p>

    <p>Lojban, like Russian and Esperanto, uses a different
    convention. A tense in a subordinate bridi is understood to be
    relative to the tense already set in the main bridi. Thus <a
    href="#e15d1">Examples 15.1</a> through <a
    href="#e15d4">15.4</a> can be expressed in Lojban respectively
    thus:</p>

    <p></p>
<pre>
<a id="e15d5"
name="e15d5">15.5)</a>    la djan. ca cusku le se du'u
        la djordj. ca klama le zarci
    John [present] says the statement-that
        George [present] goes-to the market.

<a id="e15d6" name="e15d6">15.6)</a> la djan. ca cusku le se du'u
        la djordj. pu klama le zarci
    John [present] says the statement-that
        George [past] goes-to the market.

<a id="e15d7" name="e15d7">15.7)</a> la djan. pu cusku le se du'u
        la djordj. ca klama le zarci
    John [past] says the statement-that
        George [present] goes-to the market.

<a id="e15d8" name="e15d8">15.8)</a> la djan. pu cusku le se du'u
        la djordj. pu klama le zarci
    John [past] says the statement-that
        George [past] goes-to the market.
</pre>

    <p>Probably the most counterintuitive of the Lojban examples is
    <a href="#e15d7">Example 15.7</a>. The ``ca'' looks quite odd,
    as if George were going to the market right now, rather than
    back when John spoke. But this ``ca'' is really a ``ca'' with
    respect to a reference point specified by the outer ``pu''.
    This behavior is the same as the additive behavior of multiple
    tenses in the same bridi, as explained in <a
    href="#s13">Section 13</a>.</p>

    <p>There is a special cmavo ``nau'' (of selma'o CUhE) which can
    be used to override these rules and get to the speaker's
    current reference point. (Yes, it sounds like English ``now''.)
    It is not grammatical to combine ``nau'' with any other cmavo
    in a tense, except by way of a logical or non-logical
    connection (see <a href="#s20">Section 20</a>). Here is a
    convoluted sentence with several nested bridi which uses
    ``nau'' at the lowest level:</p>
<pre>
<a id="e15d9"
name="e15d9">15.9)</a>    la djan. pu cusku le se du'u
        la .alis pu cusku le se du'u
            la djordj. pu cusku le se du'u
                la maris. nau klama le zarci
    John [past] says the statement-that
        Alice [past] says the statement-that
            George [past] says the statement that
                Mary [now] goes-to the market.
    John said that Alice had said that George had earlier
        said that Mary is now going to the market.
</pre>
    The use of ``nau'' does not affect sticky tenses. 

    <h3><a id="s16" name="s16">16. Tense relations between sentences</h3>

    <p>The sumti tcita method, explained in <a href="#s12">Section
    12</a>, of asserting a tense relationship between two events
    suffers from asymmetry. Specifically,</p>
<pre>
<a id="e16d1" name="e16d1">16.1)</a>    le verba cu cadzu le bisli
        zu'a le nu le nanmu cu batci le gerku
    The child walks-on the ice
        [left] the event-of the man bites the dog.
    The child walks on the ice to the left of where
        the man bites the dog.
</pre>
    which specifies an imaginary journey leftward from the man
    biting the dog to the child walking on the ice, claims only
    that the child walks on the ice. By the nature of ``le nu'',
    the man's biting the dog is merely referred to without being
    claimed. If it seems desirable to claim both, each event can be
    expressed as a main sentence bridi, with a special form of
    ``.i'' connecting them: 
<pre>
<a id="e16d2" name="e16d2">16.2)</a>    le nanmu cu batci le gerku
        .izu'abo le verba cu cadzu le bisli
    The man bites the dog.
        [Left] the child walks-on the ice.
    The  man bites the dog.  To the left, the child
        walks on the ice.
</pre>
    ``.izu'abo'' is a compound cmavo: the ``.i'' separates the
    sentences and the ``zu'a'' is the tense. The ``bo'' is required
    to prevent the ``zu'a'' from gobbling up the following sumti,
    namely ``le verba''. 

    <p>Note that the bridi in <a href="#e16d2">Example 16.2</a>
    appear in the reverse order from their appearance in <a
    href="#e16d1">Example 16.1</a>. With ``.izu'abo'' (and all
    other afterthought tense connectives) the sentence specifying
    the origin of the journey comes first. This is a natural order
    for sentences, but requires some care when converting between
    this form and the sumti tcita form.</p>

    <p><a href="#e16d2">Example 16.2</a> means the same thing
    as:</p>
<pre>
<a id="e16d3" name="e16d3">16.3)</a>    le nanmu cu batci le gerku
        .i zu'a la'edi'u
        le verba cu cadzu le bisli
    The man bites the dog.
        [Left] the-referent-of-the-last-sentence
        the child walks-on the ice.
    The man bites the dog.
        Left of what I just mentioned,
        the child walks on the ice.
</pre>
    If the ``bo'' is omitted, the meaning changes: 
<pre>
<a id="e16d4" name="e16d4">16.4)</a>    le nanmu cu batci le gerku
        .i zu'a le verba cu cadzu le bisli
    The man bites the dog.
         [Left] the child [something] walks-on the ice.
    The man bites the dog. To the left of the child,
        something walks on the ice.
</pre>

    <p>Here the first place of the second sentence is unspecified,
    because ``zu'a'' has absorbed the sumti ``le verba''.</p>

    <p>Do not confuse either <a href="#e16d2">Example 16.2</a> or
    <a href="#e16d4">Example 16.4</a> with the following:</p>

    <p></p>
<pre>
<a id="e16d5" name="e16d5">16.5)</a>    le nanmu cu batci le gerku
        .i zu'aku le verba cu cadzu le bisli
    The man bites the dog.
        [Left] the child walks-on the ice.
    The man bites the dog.  Left of me, the child walks
        on the ice.
</pre>

    <p>In <a href="#e16d5">Example 16.5</a>, the origin point is
    the speaker, as is usual with ``zu'aku''. <a
    href="#e16d2">Example 16.2</a> makes the origin point of the
    tense the event described by the first sentence.</p>

    <p>Two sentences may also be connected in forethought by a
    tense relationship. Just like afterthought tense connection,
    forethought tense connection claims both sentences, and in
    addition claims that the time or space relationship specified
    by the tense holds between the events the two sentences
    describe.</p>

    <p>The origin sentence is placed first, preceded by a tense
    plus ``gi''. Another ``gi'' is used to separate the
    sentences:</p>
<pre>
<a id="e16d6"
name="e16d6">16.6)</a>    pugi mi klama le zarci gi mi klama le zdani
    [past] I go-to the market [,] I go-to the house.
    Before I go to the market, I go to the house.
</pre>

    <p>A parallel construction can be used to express a tense
    relationship between sumti:</p>

    <p></p>
<pre>
<a id="e16d7"
name="e16d7">16.7)</a>    mi klama pugi le zarci gi le zdani
    I go-to [past] the market [,] the house.
</pre>

    <p>Because English does not have any direct way of expressing a
    tense-like relationship between nouns, <a href="#e16d7">Example
    16.7</a> cannot be expressed in English without paraphrasing it
    either into <a href="#e16d6">Example 16.6</a> or else into ``I
    go to the house before the market'', which is ambiguous --- is
    the market going?</p>

    <p>Finally, a third forethought construction expresses a tense
    relationship between bridi-tails rather than whole bridi. (The
    construct known as a ``bridi-tail'' is explained fully in <a
    href="chapter14.html">Chapter 14</a>; roughly speaking, it is a
    selbri with any following sumti.) <a href="#e16d8">Example
    16.8</a> is equivalent in meaning to <a href="#e16d6">Example
    16.6</a> and <a href="#e16d7">Example 16.7</a>:</p>
<pre>
<a id="e16d8"
name="e16d8">16.8)</a>    mi pugi klama le zarci gi klama le zdani
    I [past] go-to the market [,] go-to the house.
    I, before going to the market, go to the house.
</pre>
    In both <a href="#e16d7">Example 16.7</a> and <a
    href="#e16d8">Example 16.8</a>, the underlying sentences ``mi
    klama le zarci'' and ``mi klama le zdani'' are not claimed;
    only the relationship in time between them is claimed. 

    <p>Both the forethought and the afterthought forms are
    appropriate with PU, ZI, FAhA, VA, and ZAhO tenses. In all
    cases, the equivalent forms are (where X and Y stand for
    sentences, and TENSE for a tense cmavo):</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>subordinate: X TENSE le nu Y afterthought coordinate: Y
      .i+TENSE+bo X forethought coordinate: TENSE+gi X gi Y</dd>
    </dl>

    <h3><a id="s17" name="s17">17. Tensed logical connectives</h3>

    <p>The Lojban tense system interacts with the Lojban logical
    connective system. That system is a separate topic, explained
    in <a href="chapter14.html">Chapter 14</a> and touched on only in
    summary here. By the rules of the logical connective system, <a
    href="#e17d1">Example 17.1</a> through 17.3 are equivalent in
    meaning:</p>
<pre>
<a id="e17d1" name="e17d1">17.1)</a>    la teris. satre le mlatu
        .ije la teris. satre le ractu
    Terry strokes the cat.
        And Terry strokes the rabbit.

<a id="e17d2"
name="e17d2">17.2)</a> la teris. satre le mlatu gi'e satre le ractu
    Terry strokes the cat and strokes the rabbit.

<a id="e17d3"
name="e17d3">17.3)</a> la teris. satre le mlatu .e le ractu
    Terry strokes the cat and the rabbit.
</pre>
    Suppose we wish to add a tense relationship to the logical
    connective ``and''? To say that Terry strokes the cat and later
    strokes the rabbit, we can combine a logical connective with a
    tense connective by placing the logical connective first, then
    the tense, and then the cmavo ``bo'', thus: 

    <p></p>
<pre>
<a id="e17d4" name="e17d4">17.4)</a>    la teris. satre le mlatu
        .ijebabo la teris. satre le ractu
    Terry strokes the cat.
        And then Terry strokes the rabbit.
</pre>
<pre>
<a id="e17d5"
name="e17d5">17.5)</a>    la teris. satre le mlatu gi'ebabo satre le ractu
    Terry strokes the cat, and then strokes the rabbit.
</pre>
<pre>
<a id="e17d6"
name="e17d6">17.6)</a>    la teris. satre le mlatu .ebabo le ractu
    Terry strokes the cat and then the rabbit.
</pre>
    <a href="#e17d4">Example 17.4</a> through 17.6 are equivalent
    in meaning. They are also analogous to <a
    href="#e17d1">Examples 17.1</a> through <a
    href="#e17d3">17.3</a> respectively. The ``bo'' is required for
    the same reason as in <a href="#e16d2">Example 16.2</a>: to
    prevent the ``ba'' from functioning as a sumti tcita for the
    following sumti (or, in <a href="#e17d5">Example 17.5</a>, from
    being attached to the following selbri). 

    <p>In addition to the ``bo'' construction of <a
    href="#e17d4">Examples 17.4</a> through <a href="#e17d6">17.6</a>,
    there is also a form of tensed logical connective with ``ke ...
    ke'e'' (``tu'e... tu'u'' for sentences). The logical connective
    system makes <a href="#e17d7">Examples 17.7</a> through <a
    href="#e17d9">17.9</a> equivalent in meaning:</p>
    
<pre>
<a id="e17d7" name="e17d7">17.7)</a>    mi bevri le dakli
        .ije tu'e mi bevri le gerku
            .ija mi bevri le mlatu tu'u
    I carry the sack.
        And (I carry the dog.
            And/or I carry the cat).
    I carry the sack. And I carry the dog, or I carry
        the cat, or I carry both.

<a id="e17d8" name="e17d8">17.8)</a> mi bevri le dakli
        gi'eke bevri le gerku gi'a bevri le mlatu
    I carry the sack
        and (carry the dog and/or carry the cat).
    I carry the sack, and also carry the dog
        or carry the cat or carry both.

<a id="e17d9"
name="e17d9">17.9)</a> mi bevri le dakli .eke le gerku .a le mlatu
    I carry the sack and (the dog or the cat)
    I carry the sack and also the dog or the cat or both.
</pre>

    <p>Note the uniformity of the Lojban, as contrasted with the
    variety of ways in which the English provides for the correct
    grouping. In all cases, the meaning is that I carry the sack in
    any case, and either the cat or the dog or both.</p>

    <p>To express that I carry the sack first (earlier in time),
    and then the dog or the cat or both simultaneously, I can
    insert tenses to form <a href="#e17d10">Examples 17.10</a>
    through <a href="#e17d12">17.12</a>:</p>

    <p></p>
<pre>
<a id="e17d10" name="e17d10">17.10)</a>  mi bevri le dakli
        .ije ba tu'e mi bevri le gerku
            .ijacabo mi bevri le mlatu tu'u
    I carry the sack.
        And [future] (I carry the dog.
            And/or [present] I carry the cat.)
    I carry the sack. And then I will carry the dog
        or I will carry the cat or I will carry both
        at once.
</pre>
<pre>
<a id="e17d11" name="e17d11">17.11)</a>  mi bevri le dakli
        gi'ebake bevri le gerku
            gi'acabo bevri le mlatu
    I carry the sack
        and [future] (carry the dog
            and/or [present] carry the cat).
    I carry the sack and then will carry the dog
        or carry the cat or carry both at once.
</pre>
<pre>
<a id="e17d12" name="e17d12">17.12)</a>  mi bevri le dakli
        .ebake bevri le gerku .acabo le mlatu
    I carry the sack and
        [future] (the cat and/or [present] the dog).
    I carry the sack, and then the cat or the dog
        or both at once.
</pre>
    <a href="#e17d10">Examples 17.10</a> through <a
    href="#e17d12">17.12</a> are equivalent in meaning to each
    other, and correspond to the tenseless <a
    href="#e17d7">Examples 17.7</a> through <a
    href="#e17d9">17.9</a> respectively. 

    <h3><a id="s18" name="s18">18. Tense negation</h3>

    <p>Any bridi which involves tenses of selma'o PU, FAhA, or ZAhO
    can be contradicted by a ``-nai'' suffixed to the tense cmavo.
    Some examples:</p>
<pre>
<a id="e18d1" name="e18d1">18.1)</a>    mi punai klama le zarci
    I [past] [not] go-to the market.
    I didn't go to the market.
</pre>
    As a contradictory negation, <a href="#e18d1">Example 18.1</a>
    implies that the bridi as a whole is false without saying
    anything about what is true. When the negated tense is a sumti
    tcita, ``-nai'' negation indicates that the stated relationship
    does not hold: 
<pre>
<a id="e18d2"
name="e18d2">18.2)</a>    mi klama le zarci canai le nu
        do klama le zdani
    I go-to the market [present] [not] the event-of
        you go-to the house.
    It is not true that I went to the market at the same
        time that you went to the house.

<a id="e18d3"
name="e18d3">18.3)</a> le nanmu batci le gerku ne'inai le kumfa
    The man bites the dog [within] [not] the room.
    The man didn't bite the dog inside the room.

<a id="e18d4"
name="e18d4">18.4)</a> mi morsi ca'onai le nu mi jmive
    I am-dead [continuitive - negated] the event-of I live.
    It is false that I am dead during my life.
</pre>
    It is also possible to perform scalar negation of whole tense
    constructs by placing a member of NAhE before them. Unlike
    contradictory negation, scalar negation asserts a truth: that
    the bridi is true with some tense other than that specified.
    The following examples are scalar negation analogues of <a
    href="#e18d1">Examples 18.1</a> to <a href="#e18d3">18.3</a>:
    
<pre>
<a id="e18d5" name="e18d5">18.5)</a>    mi na'e pu klama le zarci
    I [non-] [past] go-to the market.
    I go to the market other than in the past.

<a id="e18d6"
name="e18d6">18.6)</a> le nanmu batci le gerku to'e ne'i le kumfa
    The man bites the dog [opposite-of] [within] the room.
    The man bites the dog outside the room.

<a id="e18d7"
name="e18d7">18.7)</a> mi klama le zarci na'e ca le nu
        do klama le zdani
    I go-to the market [non-] [present] the event-of
        you go-to the house.
    I went to the market at a time other than the time at
        which you went to the house.

<a id="e18d8"
name="e18d8">18.8)</a> mi morsi na'e ca'o le nu mi jmive
    I am-dead [non-] [continuitive] the event-of I live.
    I am dead other than during my life.
</pre>
    Unlike ``-nai'' contradictory negation, scalar negation of
    tenses is not limited to PU and FAhA: 
<pre>
<a id="e18d9"
name="e18d9">18.9)</a>    le verba na'e ri'u cadzu le bisli
    The child [non-] [right] walks-on the ice
    The child walks on the ice other than to my right.
</pre>
    The use of ``-nai'' on cmavo of TAhE and ROI has already been
    discussed in <a href="#s9">Section 9</a>; this use is also a
    scalar negation. 

    <h3><a id="s19" name="s19">19. Actuality, potentiality, capability: CAhA</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ca'a    CAhA    actually is
    ka'e    CAhA    is innately capable of
    nu'o    CAhA    can but has not
    pu'i    CAhA    can and has
</pre>
    Lojban bridi without tense markers may not necessarily refer to
    actual events: they may also refer to capabilities or potential
    events. For example: 

    <p></p>
<pre>
<a id="e19d1" name="e19d1">19.1)</a>    ro datka cu flulimna
    all ducks are-float-swimmers
    All ducks swim by floating.
</pre>
    is a Lojban truth, even though the colloquial English
    translation is false or at best ambiguous. This is because the
    tenseless Lojban bridi doesn't necessarily claim that every
    duck is swimming or floating now or even at a specific time or
    place. Even if we add a tense marker to <a
    href="#e19d1">Example 19.1</a>, 
<pre>
<a id="e19d2" name="e19d2">19.2)</a>    ro datka ca flulimna
    all ducks [present] are-float-swimmers.
    All ducks are now swimming by floating.
</pre>
    the resulting <a href="#e19d2">Example 19.2</a> might still be
    considered a truth, even though the colloquial English seems
    even more likely to be false. All ducks have the potential of
    swimming even if they are not exercising that potential at
    present. To get the full flavor of ``All ducks are now
    swimming'', we must append a marker from selma'o CAhA to the
    tense, and say: 

    <p></p>
<pre>
<a id="e19d3" name="e19d3">19.3)</a>    ro datka ca ca'a flulimna
    all ducks [present] [actual] are-float-swimmers
    All ducks are now actually swimming by floating.
</pre>
    A CAhA cmavo is always placed after any other tense cmavo,
    whether for time or for space. However, a CAhA cmavo comes
    before ``ki'', so that a CAhA condition can be made sticky. 

    <p><a href="#e19d3">Example 19.3</a> is false in both Lojban
    and English, since it claims that the swimming is an actual,
    present fact, true of every duck that exists, whereas in fact
    there is at least one duck that is not swimming now.</p>

    <p>Furthermore, some ducks are dead (and therefore sink); some
    ducks have just hatched (and do not know how to swim yet), and
    some ducks have been eaten by predators (and have ceased to
    exist as separate objects at all). Nevertheless, all these
    ducks have the innate capability of swimming --- it is part of
    the nature of duckhood. The cmavo ``ka'e'' expresses this
    notion of innate capability:</p>
<pre>
<a id="e19d4" name="e19d4">19.4)</a>    ro datka ka'e flulimna
    all ducks [capable] are-float-swimmers.
    All ducks are innately capable of swimming.
</pre>
    Under some epistemologies, innate capability can be extended in
    order to apply the innate properties of a mass to which certain
    individuals belong to the individuals themselves, even if those
    individuals are themselves not capable of fulfilling the claim
    of the bridi. For example: 

    <p></p>
<pre>
<a id="e19d5" name="e19d5">19.5)</a>    la djan. ka'e viska
    John [capable] sees.
    John is innately capable of seeing.
    John can see.
</pre>
    might be true about a human being named John, even though he
    has been blind since birth, because the ability to see is
    innately built into his nature as a human being. It is
    theoretically possible that conditions might occur that would
    enable John to see (a great medical discovery). On the other
    hand, 
<pre>
<a id="e19d6" name="e19d6">19.6)</a>    le cukta ka'e viska
    The book [capable] sees.
    The book can see.
</pre>
    is not true in most epistemologies, since the ability to see is
    not part of the innate nature of a book. 

    <p>Consider once again the newly hatched ducks mentioned
    earlier. They have the potential of swimming, but have not yet
    demonstrated that potential. This may be expressed using
    ``nu'o'', the cmavo of CAhA for undemonstrated potential:</p>

    <p></p>
<pre>
<a id="e19d7" name="e19d7">19.7)</a>    ro cifydatka nu'o flulimna
    all infant-ducks [can but has not] are-float-swimmers.
    All infant ducks have an undemonstrated potential
        for swimming by floating.
    Baby ducks can swim but haven't yet.
</pre>
    Contrariwise, if Frank is not blind from birth, then ``pu'i''
    is appropriate: 

    <p></p>
<pre>
<a id="e19d8" name="e19d8">19.8)</a>    la frank. pu'i viska
    Frank [can and has] sees.
    Frank has demonstrated a potential for seeing.
    Frank can see and has seen.
</pre>
    Note that the glosses given at the beginning of this section
    for ``ca'a'', ``nu'o'', and ``pu'i'' incorporate ``ca'' into
    their meaning, and are really correct for ``ca ca'a'', ``ca
    nu'o'', and ``ca pu'i''. However, the CAhA cmavo are perfectly
    meaningful with other tenses than the present: 
<pre>
<a id="e19d9" name="e19d9">19.9)</a>    mi pu ca'a klama le zarci
    I [past] [actual] go-to the store.
    I actually went to the store.

<a id="e19d10"
name="e19d10">19.10)</a>   la frank. pu nu'o klama le zdani
    Frank [past] [can but has not] goes-to the store.
    Frank could have, but will not have, gone to the
        store (at some understood moment in the
        future).
</pre>
    As always in Lojban tenses, a missing CAhA can have an
    indeterminate meaning, or the context can be enough to
    disambiguate it. Saying 
<pre>
<a id="e19d11" name="e19d11">19.11)</a>  ta jelca
    That burns/is-burning/might-burn/will-burn.
</pre>
    with no CAhA specified can translate the two very different
    English sentences ``That is on fire'' and ``That is
    inflammable.'' The first demands immediate action (usually),
    whereas the second merely demands caution. The two cases can be
    disambiguated with: 
<pre>
<a id="e19d12" name="e19d12">19.12)</a>  ta ca ca'a jelca
    That [present] [actual] burns.
    That is on fire.
</pre>
    and 
<pre>
<a id="e19d13" name="e19d13">19.13)</a>  ta ka'e jelca
    That [capable] burns.
    That is capable of burning.
    That is inflammable.
</pre>
    When no indication is given, as in the simple observative 
<pre>
<a id="e19d14" name="e19d14">19.14)</a>  fagri
    fire
</pre>
    the prudent Lojbanist will assume the meaning ``Fire!'' 

    <h3><a id="s20" name="s20">20. Logical and non-logical connections between tenses</h3>

    <p>Like many things in Lojban, tenses may be logically
    connected; logical connection is explained in more detail in <a
    href="chapter14.html">Chapter 14</a>. Some of the terminology in
    this section will be clear only if you already understand
    logical connectives.</p>

    <p>The appropriate logical connectives belong to selma'o JA. A
    logical connective between tenses can always be expanded to one
    between sentences:</p>
<pre>
<a id="e20d1" name="e20d1">20.1)</a>    mi pu je ba klama le zarci
    I [past] and [future] go-to the market.
    I went and will go to the market.
</pre>
    means the same as: 
<pre>
<a id="e20d2" name="e20d2">20.2)</a>    mi pu klama le zarci
        .ije mi ba klama le zarci
    I [past] go-to the market.
        And I [future] go-to the market.
    I went to the market, and I will go to the market.
</pre>
    Tense connection and tense negation are combined in: 
<pre>
<a id="e20d3" name="e20d3">20.3)</a>    mi punai je canai je ba
        klama le zarci
    I [past] [not] and [present] [not] and [future]
        go-to the market.
    I haven't yet gone to the market, but I will in future.
</pre>
    <a href="#e20d3">Example 20.3</a> is far more specific than 
<pre>
<a id="e20d4" name="e20d4">20.4)</a>    mi ba klama le zarci
    I [future] go-to the market.
</pre>
    which only says that I will go, without claiming anything about
    my past or present. ``ba'' does not imply ``punai'' or
    ``canai''; to compel that interpretation, either a logical
    connection or a ZAhO is needed. 

    <p>Tense negation can often be removed in favor of negation in
    the logical connective itself. The following examples are
    equivalent in meaning:</p>
<pre>
<a id="e20d5"
name="e20d5">20.5)</a>    mi mo'izu'anai je mo'iri'u cadzu
    I [motion] [left-not] and [motion] [right] walk.
    I walk not leftward but rightward.

<a id="e20d6"
name="e20d6">20.6)</a> mi mo'izu'a naje mo'iri'u cadzu
    I [motion] [left] not-and [motion] [right] walk.
    I walk not leftward but rightward.  
</pre>
    There are no forethought logical connections between tenses
    allowed by the grammar, to keep tenses simpler. Nor is there
    any way to override simple left-grouping of the connectives,
    the Lojban default. 

    <p>The non-logical connectives of selma'o JOI, BIhI, and GAhO
    are also permitted between tenses. One application is to
    specify intervals not by size, but by their end-points
    (``bi'o'' belongs to selma'o BIhI, and connects the end-points
    of an ordered interval, like English ``from ... to''):</p>
<pre>
<a id="e20d7" name="e20d7">20.7)</a>    mi puza bi'o bazu vasxu
    I [past] [medium] from ... to [future] [long] breathe.
    I breathe from a medium time ago till a long time
        to come.
</pre>
    (It is to be hoped that I have a long life ahead of me.) 

    <p>One additional use of non-logical connectives within tenses
    is discussed in <a href="#s21">Section 21</a>. Other uses will
    probably be identified in future.</p>

    <h3><a id="s21" name="s21">21. Sub-events</h3>

    <p>Another application of non-logical tense connection is to
    talk about sub-events of events. Consider a six-shooter: a gun
    which can fire six bullets in succession before reloading. If I
    fire off the entire magazine twice, I can express the fact in
    Lojban thus:</p>

    <p></p>
<pre>
<a id="e21d1" name="e21d1">21.1)</a>    mi reroi pi'u xaroi
        cecla le seldanti
    I [twice] [cross-product] [six times]
        shoot the projectile-launcher.
    On two occasions, I fire the gun six times.
</pre>
    It would be confusing, though grammatical, to run the ``reroi''
    and the ``xaroi'' directly together. However, the non-logical
    connective ``pi'u'' expresses a Cartesian product (also known
    as a cross product) of two sets. In this case, there is a set
    of two firings each of which is represented by a set of six
    shots, for twelve shots in all (hence the name ``product'': the
    product of 2 and 6 is 12). Its use specifies very precisely
    what occurs. 

    <p>In fact, you can specify strings of interval properties and
    event contours within a single tense without the use of a
    logical or non-logical connective cmavo. This allows tenses of
    the type:</p>
<pre>
<a id="e21d2" name="e21d2">21.2)</a>    la djordj. ca'o co'a ciska
    George [continuitive] [initiative] writes.
    George continues to start to write.

<a id="e21d3"
name="e21d3">21.3)</a> mi reroi ca'o xaroi darxi le damri
    I [twice] [continuitive] [six times] hit the drum.
    On two occasions, I continue to beat the drum six times.
</pre>

    <h3><a id="s22" name="s22">22. Conversion of sumti tcita: JAI</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   jai JAI tense conversion
    fai FA  indefinite place
</pre>
    Conversion is the regular Lojban process of moving around the
    places of a place structure. The cmavo of selma'o SE serve this
    purpose, exchanging the first place with one of the others: 
<pre>
<a id="e22d1" name="e22d1">22.1)</a>    mi cu klama le zarci
    I go-to the market.

<a id="e22d2" name="e22d2">22.2)</a> le zarci cu se klama mi
    The market is-gone-to by-me.
</pre>
    It is also possible to bring a place that is specified by a
    sumti tcita (for the purposes of this chapter, a tense sumti
    tcita) to the front, by using ``jai'' plus the tense as the
    grammatical equivalent of SE: 

    <p></p>
<pre>
<a id="e22d3"
name="e22d3">22.3)</a>    le ratcu cu citka le cirla vi le panka
    The rat eats the cheese [short distance] the park.
    The rat eats the cheese in the park.

<a id="e22d4"
name="e22d4">22.4)</a> le panka cu jai vi citka le cirla fai le ratcu
    The park is-the-place-of eating the cheese by-the rat.
    The park is where the rat eats the cheese.
</pre>
    In <a href="#e22d4">Example 22.4</a>, the construction
    JAI+tense converts the location sumti into the first place. The
    previous first place has nowhere to go, since the location
    sumti is not a numbered place; however, it can be inserted back
    into the bridi with ``fai'', the indefinite member of selma'o
    FA. 

    <p>(The other members of FA are used to mark the first, second,
    etc. places of a bridi explicitly:</p>
<pre>
<a id="e22d5" name="e22d5">22.5)</a>    fa mi cu klama fe le zarci
</pre>
    means the same as 
<pre>
<a id="e22d6" name="e22d6">22.6)</a>    fe le zarci cu klama fa mi
</pre>
    as well as the simple 
<pre>
<a id="e22d7" name="e22d7">22.7)</a>    mi cu klama le zarci
</pre>
    in which the place structure is determined by position.) 

    <p>Like SE conversion, JAI+tense conversion is especially
    useful in descriptions with LE selma'o:</p>

    <p></p>
<pre>
<a id="e22d8"
name="e22d8">22.8)</a>    mi viska le jai vi citka be le cirla
    I saw the place-of eating the cheese.
</pre>

    <p>Here the eater of the cheese is elided, so no ``fai''
    appears.</p>

    <p>Of course, temporal tenses are also usable with JAI:</p>

    <p></p>
<pre>
<a id="e22d9" name="e22d9">22.9)</a>    mi djuno fi le jai ca morsi
        be fai la djan.
    I know about the [present] is-dead
        of-the-one-called ``John''
    I know the time of John's death.
    I know when John died.
</pre>

    <h3><a id="s23" name="s23">23. Tenses versus modals</h3>

    <p>Grammatically, every use of tenses seen so far is exactly
    paralleled by some use of modals as explained in <a
    href="chapter9.html">Chapter 9</a>. Modals and tenses alike can be
    followed by sumti, can appear before the selbri, can be used in
    pure and mixed connections, can participate in JAI conversions.
    The parallelism is perfect. However, there is a deep difference
    in the semantics of tense constructs and modal constructs,
    grounded in historical differences between the two forms.
    Originally, modals and tenses were utterly different things in
    earlier versions of Loglan; only in Lojban have they become
    grammatically interchangeable. And even now, differences in
    semantics continue to be maintained.</p>

    <p>The core distinction is that whereas the modal bridi</p>
<pre>
<a id="e23d1"
name="e23d1">23.1)</a>    mi nelci do mu'i le nu do nelci mi
    I like you with-motivation the event-of you like me.
    I like you because you like me.
</pre>
    places the ``le nu'' sumti in the x1 place of the gismu
    ``mukti'' (which underlies the modal ``mu'i''), namely the
    motivating event, the tensed bridi 

    <p></p>
<pre>
<a id="e23d2"
name="e23d2">23.2)</a>    mi nelci do ba le nu do nelci mi
    I like you after the event-of you like me.
    I like you after you like me.
</pre>
    places the ``le nu'' sumti in the x2 place of the gismu
    ``balvi'' (which underlies the tense ``ba''), namely the point
    of reference for the future tense. Paraphrases of <a
    href="#e23d1">Example 23.1</a> and <a href="#e23d2">Example
    23.2</a>, employing the brivla ``mukti'' and ``balvi''
    explicitly, would be: 
<pre>
<a id="e23d3"
name="e23d3">23.3)</a>    le nu do nelci mi cu mukti le nu mi nelci do
    The event-of you like me motivates the event-of I like you
    Your liking me is the motive for my liking you.
</pre>
    and 
<pre>
<a id="e23d4"
name="e23d4">23.4)</a>    le nu mi nelci do cu balvi le nu do nelci mi
    The event-of I like you is after the event of you like me.
    My liking you follows (in time) your liking me.
</pre>
    (Note that the paraphrase is not perfect due to the difference
    in what is claimed; <a href="#e23d3">Example 23.3</a> and <a
    href="#e23d4">Example 23.4</a> claim only the causal and
    temporal relationships between the events, not the existence of
    the events themselves.) 

    <p>As a result, the afterthought sentence-connective forms of
    <a href="#e23d1">Example 23.1</a> and <a href="#e23d2">Example
    23.2</a> are, respectively:</p>
<pre>
<a id="e23d5"
name="e23d5">23.5)</a>    mi nelci do .imu'ibo do nelci mi
    I like you.  [That is] Because you like me.

<a id="e23d6" name="e23d6">23.6)</a> do nelci mi .ibabo mi nelci do
    You like me.  Afterward, I like you.
</pre>

    <p>In <a href="#e23d5">Example 23.5</a>, the order of the two
    bridi ``mi nelci do'' and ``do nelci mi'' is the same as in <a
    href="#e23d1">Example 23.1</a>. In <a href="#e23d6">Example
    23.6</a>, however, the order is reversed: the origin point ``do
    nelci mi'' physically appears before the future-time event ``mi
    nelci do''. In both cases, the bridi characterizing the event
    in the x2 place appears before the bridi characterizing the
    event in the x1 place of ``mukti'' or ``balvi''.</p>

    <p>In forethought connections, however, the asymmetry between
    modals and tenses is not found. The forethought equivalents of
    <a href="#e23d5">Example 23.5</a> and <a href="#e23d6">Example
    23.6</a> are</p>
<pre>
<a id="e23d7"
name="e23d7">23.7)</a>    mu'igi do nelci mi gi mi nelci do
    Because you like me, I like you.
</pre>
    and 
<pre>
<a id="e23d8"
name="e23d8">23.8)</a>    bagi do nelci mi gi mi nelci do
    After you like me, I like you.
</pre>
    respectively. 

    <p>The following modal sentence schemata (where X and Y
    represent sentences) all have the same meaning:</p>

    <dl>
      <dt></dt>

      <dd>X .i BAI bo Y BAI gi Y gi X X BAI le nu Y</dd>
    </dl>
    whereas the following tensed sentence schemata also have the
    same meaning: 

    <dl>
      <dt></dt>

      <dd>X .i TENSE bo Y TENSE gi X gi Y Y TENSE le nu X</dd>
    </dl>
    neglecting the question of what is claimed. In the modal
    sentence schemata, the modal tag is always followed by Y, the
    sentence representing the event in the x1 place of the gismu
    that underlies the BAI. In the tensed sentences, no such simple
    rule exists. 

    <h3><a id="s24" name="s24">24. Tense questions: ``cu'e''</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   cu'e    CUhE    tense question
</pre>
    There are two main ways to ask questions about tense. The main
    English tense question words are ``When?'' and ``Where?''.
    These may be paraphrased respectively as ``At what time?'' and
    ``At what place?'' In these forms, their Lojban equivalents
    simply involve a tense plus ``ma'', the Lojban sumti question: 

    <p></p>
<pre>
<a id="e24d1" name="e24d1">24.1)</a>    do klama le zdani ca ma
    you go-to the house [present] [what sumti?].
    You go to the house at what time?
    When do you go to the house?
</pre>
<pre>
<a id="e24d2" name="e24d2">24.2)</a>    le verba vi ma pu
        cadzu le bisli
    The child [short space] [what sumti?] [past]
        walks-on the ice.
    The child at/near what place walked on the ice?
    Where did the child walk on the ice?
</pre>
    There is also a non-specific tense and modal question,
    ``cu'e'', belonging to selma'o CUhE. This can be used wherever
    a tense or modal construct can be used. 

    <p></p>
<pre>
<a id="e24d3"
name="e24d3">24.3)</a>    le nanmu cu'e batci le gerku
    The man [what tense?] bites the dog.
    When/Where/How does the man bite the dog?
</pre>
    Possible answers to <a href="#e24d3">Example 24.3</a> might be:
    
<pre>
<a id="e24d4" name="e24d4">24.4)</a>    va
    [medium space].
    Some ways from here.

<a id="e24d5" name="e24d5">24.5)</a> puzu
    [past] [long time].
    A long time ago.

<a id="e24d6" name="e24d6">24.6)</a> vi le lunra
    [short space] The moon.
    On the moon.

<a id="e24d7" name="e24d7">24.7)</a> pu'o
    [inchoative]
    He hasn't yet done so.
</pre>
    or even the modal reply (from selma'o BAI; see <a
    href="chapter9.html">Chapter 9</a>): 
<pre>
<a id="e24d8" name="e24d8">24.8)</a>    bai la djan.
    Under John's compulsion.
</pre>
    The only way to combine ``cu'e'' with other tense cmavo is
    through logical connection, which makes a question that
    pre-specifies some information: 

    <p></p>
<pre>
<a id="e24d9"
name="e24d9">24.9)</a>    do puzi je cu'e sombo le gurni
    You [past] [short] and [when?] sow the grain?
    You sowed the grain a little while ago;
        when else do you sow it?
</pre>

    <p>Additionally, the logical connective itself can be replaced
    by a question word:</p>

    <p></p>
<pre>
<a id="e24d10"
name="e24d10">24.10)</a>  la .artr. pu je'i ba nolraitru
    Arthur [past] [which?] [future] is-a-king
    Was Arthur a king or will he be?
</pre>

    <p>Answers to <a href="#e24d10">Example 24.10</a> would be
    logical connectives such as ``je'', meaning ``both'', ``naje''
    meaning ``the latter'', or ``jenai'' meaning ``the
    former''.</p>

    <p></p>

    <h3><a id="s25" name="s25">25. Explicit magnitudes</h3>

    <p>It is a limitation of the VA and ZI system of specifying
    magnitudes that they can only prescribe vague magnitudes:
    small, medium, or large. In order to express both an origin
    point and an exact distance, the Lojban construction called a
    ``termset'' is employed. (Termsets are explained further in <a
    href="chapter14.html">Chapter 14</a> and <a
    href="chapter16.html">Chapter 16</a>.) It is grammatical for a
    termset to be placed after a tense or modal tag rather than a
    sumti, which allows both the origin of the imaginary journey
    and its distance to be specified. Here is an example:</p>
<pre>
<a id="e25d1"
name="e25d1">25.1)</a>    la frank. sanli zu'a nu'i la djordj.
        lu'a lo mitre
            be li mu [nu'u]
    Frank stands [left] [start termset] George
        [quantity] a thing-measuring-in-meters
            the-number 5 [end termset].
    Frank is standing five meters to the left of George.
</pre>

    <p>Here the termset extends from the ``nu'i'' to the implicit
    ``nu'u'' at the end of the sentence, and includes the terms
    ``la djordj.'', which is the unmarked origin point, and the
    tagged sumti ``lo mitre be li mu'', which the cmavo ``la'u''
    (of selma'o BAI, and meaning ``with quantity''; see <a
    href="chapter9.html">Chapter 9</a>) marks as a quantity. Both
    terms are governed by the tag ``zu'a''</p>

    <p>It is not necessary to have both an origin point and an
    explicit magnitude: a termset may have only a single term in
    it. A less precise version of <a href="#e25d1">Example 25.1</a>
    is:</p>
<pre>
<a id="e25d2"
name="e25d2">25.2)</a>    la frank. sanli zu'a nu'i lu'a
        lo mitre be li mu
    Frank stands [left] [termset] [quantity]
        a thing-measuring-in-meters the-number 5.
    Frank stands five meters to the left.
</pre>

    <h3><a id="s26" name="s26">26. Finally (an exercise for the much-tried reader)</h3>
<pre>
<a id="e26d1"
name="e26d1">26.1)</a>    a'o do pu seju ba roroi ca'o fe'e su'oroi jimpe
        fi le lojbo temci selsku ciste
</pre>

    <h3><a id="s27" name="s27">27. Summary of tense selma'o</h3>

    <p></p>

    <dl>
      <dt>PU</dt>

      <dd>temporal direction pu = past, ca = present, ba = future
      ZI temporal distance zi = short, za = medium, zu = long ZEhA
      temporal interval ze'i = short, ze'a = medium, ze'u = long,
      ze'e = infinite ROI objective quantified tense flag noroi =
      never, paroi = once, ..., roroi = always, etc. TAhE
      subjective quantified tense di'i = regularly, na'o =
      typically, ru'i = continuously, ta'e = habitually ZAhO event
      contours see <a href="#s10">Section 10</a></dd>

      <dt>FAhA</dt>

      <dd>spatial direction see <a href="#s27">Section 27</a> VA
      spatial distance vi = short, va = medium, vu = long VEhA
      spatial interval ve'i = short, ve'a = medium, ve'u = long,
      ve'e = infinite VIhA spatial dimensionality vi'i = line, vi'a
      = plane, vi'u = space, vi'e = space-time FEhE spatial
      interval modifier flag fe'enoroi = nowhere, fe'eroroi =
      everywhere, fe'eba'o = beyond, etc. MOhI spatial movement
      flag mo'i = motion; see <a href="#s27">Section 27</a></dd>

      <dt>KI</dt>

      <dd>set or reset sticky tense tense+``ki'' = set, ``ki''
      alone = reset CUhE tense question, reference point cu'e =
      asks for a tense or aspect nau = use speaker's reference
      point JAI tense conversion jaica = the time of, jaivi = the
      place of, etc.</dd>
    </dl>

    <h3><a id="s28" name="s28">28. List of spatial directions and direction-like
    relations</h3>

    <p>The following list of FAhA cmavo gives rough English glosses
    for the cmavo, first when used without ``mo'i'' to express a
    direction, and then when used with ``mo'i'' to express movement
    in the direction. When possible, the gismu from which the cmavo
    is derived is also listed.</p>
<pre>
cmavo  gismu   without mo'i        with mo'i
-----   -----   ------------        ---------
ca'u    crane   in front (of)       forward
ti'a    trixe   behind          backward
zu'a    zunle   on the left (of)    leftward
ri'u    pritu   on the right (of)   rightward
ga'u    gapru   above           upward(ly)
ni'a    cnita   below           downward(ly)
ne'i    nenri   within          into
ru'u    sruri   surrounding     orbiting
pa'o    pagre   transfixing     passing through
ne'a        next to         moving while next to        
te'e        bordering       moving along the border (of)
re'o        adjacent (to)       along
fa'a    farna   towards         arriving at
to'o        away from               departing from
zo'i        inward (from)       approaching
ze'o        outward (from)      receding from
zo'a        tangential (to)     passing (by)
bu'u        coincident (with)   moving to coincide with
be'a    berti   north (of)      northward(ly)
ne'u    snanu   south (of)      southward(ly)
du'a    stuna   east (of)       eastward(ly)
vu'a        west (of)       westward(ly)
</pre>
    Special note on ``fa'a'', ``to'o'', ``zo'i'', and ``ze'o'': 

    <p>``zo'i'' and ``ze'o'' refer to direction towards or away
    from the speaker's location, or whatever the origin is.</p>

    <p>``fa'a'' and ``to'o'' refer to direction towards or away
    from some other point.</p>

    <hr />
    
    <p>Senast modifierad: Mon Jun 27 23:12:51 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
