
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//FR" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 11</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter11.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 11<br />
      Events, Qualities, Quantities, And Other Vague Words: On
      Lojban Abstraction</h2>

      <!--
      <h6>$Revision: 4.2 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <p></p>

    <h3><a id="s1" name="s1">1. The syntax of abstraction</h3>

    <p>The purpose of the feature of Lojban known as
    ``abstraction'' is to provide a means for taking whole bridi
    and packaging them up, as it were, into simple selbri.
    Syntactically, abstractions are very simple and uniform;
    semantically, they are rich and complex, with few features in
    common between one variety of abstraction and another. We will
    begin by discussing syntax without regard to semantics; as a
    result, the notion of abstraction may seem unmotivated at
    first. Bear with this difficulty until <a href="#s2">Section
    2</a>.</p>

    <p>An abstraction selbri is formed by taking a full bridi and
    preceding it by any cmavo of selma'o NU. There are twelve such
    cmavo; they are known as ``abstractors''. The bridi is closed
    by the elidable terminator ``kei'', of selma'o KEI. Thus, to
    change the bridi</p>
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  mi klama le zarci
    I go-to the store
</pre>
    into an abstraction using ``nu'', one of the members of selma'o
    NU, we change it into 

    <p></p>
<pre>
<a id="e1d2" name="e1d2">1.2)</a>  nu mi klama le zarci [kei]
    an-event-of my going-to the store
</pre>
    The bridi may be a simple selbri, or it may have associated
    sumti, as here. It is important to beware of eliding ``kei''
    improperly, as many of the common uses of abstraction selbri
    involve following them with words that would appear to be part
    of the abstraction if ``kei'' had been elided. 

    <p>(Technically, ``kei'' is never necessary, because the
    elidable terminator ``vau'' that closes every bridi can
    substitute for it; however, ``kei'' is specific to
    abstractions, and using it is almost always clearer.)</p>

    <p>The grammatical uses of an abstraction selbri are exactly
    the same as those of a simple brivla. In particular,
    abstraction selbri may be used as observatives, as in <a
    href="#e1d2">Example 1.2</a>, or used in tanru:</p>

    <p></p>
<pre>
<a id="e1d3" name="e1d3">1.3)</a>  la djan. cu nu sonci kei djica
    John is-an-(event-of being-a-soldier) type-of desirer.
    John wants to be a soldier.
</pre>
    Abstraction selbri may also be used in descriptions, preceded
    by ``le'' (or any other member of selma'o LE): 
<pre>
<a id="e1d4"
name="e1d4">1.4)</a>  la djan. cu djica le nu sonci [kei]
    John desires the event-of being-a-soldier.
</pre>

    <p>We will most often use descriptions containing abstraction
    either at the end of a bridi, or just before the main selbri
    with its ``cu''; in either of these circumstances, ``kei'' can
    normally be elided.</p>

    <p>The place structure of an abstraction selbri depends on the
    particular abstractor, and will be explained individually in
    the following sections.</p>

    <p>Note: In glosses of bridi within abstractions, the
    grammatical form used in the English changes. Thus, in the
    gloss of <a href="#e1d2">Example 1.2</a> we see ``my going-to
    the store'' rather than ``I go-to the store''; likewise, in the
    glosses of <a href="#e1d3">Example 1.3</a> and <a
    href="#e1d4">Example 1.4</a> we see ``being-a-soldier'' rather
    than ``is-a-soldier''. This procedure reflects the desire for
    more understandable glosses, and does not indicate any change
    in the Lojban form. A bridi is a bridi, and undergoes no change
    when it is used as part of an abstraction selbri.</p>

    <p></p>

    <h3><a id="s2" name="s2">2. Event abstraction</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   nu  NU  event abstractor
</pre>
    The examples in <a href="#s1">Section 1</a> made use of ``nu''
    as the abstractor, and it is certainly the most common
    abstractor in Lojban text. Its purpose is to capture the event
    or state of the bridi considered as a whole. Do not confuse the
    ``le'' description built on a ``nu'' abstraction with ordinary
    descriptions based on ``le'' alone. The following sumti are
    quite distinct: 
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  le klama
    the comer, that which comes

<a id="e2d2" name="e2d2">2.2)</a>   le se klama
    the destination

<a id="e2d3" name="e2d3">2.3)</a>   le te klama
    the origin

<a id="e2d4" name="e2d4">2.4)</a>   le ve klama
    the route

<a id="e2d5" name="e2d5">2.5)</a>   le xe klama
    the means of transportation

<a id="e2d6" name="e2d6">2.6)</a>   le nu klama
    the event of someone coming to somewhere
        from somewhere by some route using some means
</pre>
    <a href="#e2d1">Examples 2.1</a> through <a
    href="#e2d5">2.5</a> are descriptions that isolate the five
    individual sumti places of the selbri ``klama''. <a
    href="#e2d6">Example 2.6</a> describes something associated
    with the bridi as a whole: the event of it. 

    <p>In Lojban, the term ``event'' is divorced from its ordinary
    English sense of something that happens over a short period of
    time. The description:</p>
<pre>
<a id="e2d7" name="e2d7">2.7)</a>  le nu mi vasxu
    the event-of my breathing
</pre>
    is an event which lasts for the whole of my life (under normal
    circumstances). On the other hand, 

    <p></p>
<pre>
<a id="e2d8" name="e2d8">2.8)</a>  le nu la djan. cinba la djein.
    the event-of John kissing Jane
</pre>
    is relatively brief by comparison (again, under normal
    circumstances). 

    <p>We can see from <a href="#e2d6">Examples 2.6</a> through
    <a href="#e2d8">2.8</a> that ellipsis of sumti is valid in the
    bridi of abstraction selbri, just as in the main bridi of a
    sentence. Any sumti may be ellipsized if the listener will be
    able to figure out from context what the proper value of it is,
    or else to recognize that the proper value is unimportant. It
    is extremely common for ``nu'' abstractions in descriptions to
    have the x1 place ellipsized:</p>
<pre>
<a id="e2d9" name="e2d9">2.9)</a>  mi nelci le nu limna
    I like the event-of swimming.
    I like swimming.
</pre>
    is elliptical, and most probably means: 
<pre>
<a id="e2d10" name="e2d10">2.10)</a>    mi nelci le nu mi limna
    I like the event-of I swim.
</pre>

    <p>In the proper context, of course, <a href="#e2d9">Example
    2.9</a> could refer to the event of somebody else swimming. Its
    English equivalent, ``I like swimming'', can't be interpreted
    as ``I like Frank's swimming''; this is a fundamental
    distinction between English and Lojban. In Lojban, an omitted
    sumti can mean whatever the context indicates that it should
    mean.</p>

    <p>Note that the lack of an explicit NU cmavo in a sumti can
    sometimes hide an implicit abstraction. In the context of <a
    href="#e2d10">Example 2.10</a>, the appearance of ``le se
    nelci'' (``that which is liked'') is in effect an
    abstraction:</p>
<pre>
<a id="e2d11" name="e2d11">2.11)</a>    le se nelci cu cafne
    The liked-thing is-frequent.
    The thing which I like happens often.
</pre>
    which in this context means 

    <dl>
      <dt></dt>

      <dd>My swimming happens often.</dd>
    </dl>

    <p>Event descriptions with ``le nu'' are commonly used to fill
    the ``under conditions...'' places, among others, of gismu and
    lujvo place structures:</p>

    <p></p>
<pre>
<a id="e2d12" name="e2d12">2.12)</a>    la lojban. cu frili mi
        le nu mi tadni [kei]
    Lojban is-easy for-me
        under-conditions-the event-of I study
    Lojban is easy for me when I study.
</pre>
    (The ``when'' of the English would also be appropriate for a
    construction involving a Lojban tense, but the Lojban sentence
    says more than that the studying is concurrent with the ease.) 

    <p>The place structure of a ``nu'' abstraction selbri is
    simply:</p>

    <dl>
      <dt></dt>

      <dd>x1 is an event of (the bridi)</dd>
    </dl>

    <h3><a id="s3" name="s3">3. Types of event abstractions</h3>

    <p>The following cmavo are discussed in this section:</p>

    <p></p>
<pre>
   mu'e    NU  point-event abstractor
    pu'u    NU  process abstractor
    zu'o    NU  activity abstractor
    za'i    NU  state abstractor
</pre>

    <p>Event abstractions with ``nu'' suffice to express all kinds
    of events, whether long, short, unique, repetitive, or
    whatever. Lojban also has more finely discriminating machinery
    for talking about events, however. There are four other
    abstractors of selma'o NU for talking about four specific types
    of events, or four ways of looking at the same event.</p>

    <p>An event considered as a point in time is called a
    ``point-event'', or sometimes an ``achievement''. (This latter
    word should be divorced, in this context, from all connotations
    of success or triumph.) A point-event can be extended in
    duration, but it is still a point-event if it is thought of as
    unitary, having no internal structure. The abstractor ``mu'e''
    means ``point-event-of'':</p>

    <p></p>
<pre>
<a id="e3d1"
name="e3d1">3.1)</a>  le mu'e la djan. catra la djim. cu zekri
    the point-event-of (John kills Jim) is-a-crime
    John's killing Jim (considered as a point in time)
        is a crime.
</pre>
    An event considered as extended in time, and structured with a
    beginning, a middle containing one or more stages, and an end,
    is called a ``process''. The abstractor ``pu'u'' means
    ``process-of'': 

    <p></p>
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  ca'o le pu'u le latmo balje'a
        cu porpi kei
        so'i je'atru cu selcatra
    [continuitive] the process-of( the Latin great-state
        breaking-up )
        many state-rulers were-killed
    During the fall of the Roman Empire,
        many Emperors were killed.
</pre>
    An event considered as extended in time and cyclic or
    repetitive is called an ``activity''. The abstractor ``zu'o''
    means ``activity-of'': 
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  mi tatpi ri'a le zu'o mi plipe
    I am-tired because-of the activity-of (I jump)
    I am tired because I jump.
</pre>
    An event considered as something that is either happening or
    not happening, with sharp boundaries, is called a ``state''.
    The abstractor ``za'i'' means ``state-of'': 

    <p></p>
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  le za'i mi jmive cu ckape do
    the state-of (I am-alive) is-dangerous-to you
    My being alive is dangerous to you.
</pre>
    The abstractors in <a href="#e3d1">Examples 3.1</a> through
    <a href="#e3d4">3.4</a> could all have been replaced by ``nu'',
    with some loss of precision. Note that Lojban allows every sort
    of event to be viewed in any of these four ways: 

    <p></p>

    <dl>
      <dt></dt>

      <dd>the ``state of running'' begins when the runner starts
      and ends when the runner stops;</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>the ``activity of running'' consists of the cycle ``lift
      leg, step forward, drop leg, lift other leg...'' (each such
      cycle is a process, but the activity consists in the
      repetition of the cycle);</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>the ``process of running'' puts emphasis on the initial
      sprint, the steady speed, and the final slowdown;</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>the ``achievement of running'' is most alien to English,
      but sees the event of running as a single indivisible thing,
      like ``Pheidippides' run from Marathon to Athens'' (the
      original marathon).</dd>
    </dl>

    <p>Further information on types of events can be found in <a
    href="#s12">Section 12</a>.</p>

    <p>The four event type abstractors have the following place
    structures:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>``mu'e'': x1 is a point event of (the bridi) ``pu'u'': x1
      is a process of (the bridi) with stages x2 ``za'i'': x1 is a
      continuous state of (the bridi) being true ``zu'o'': x1 is an
      activity of (the bridi) consisting of repeated actions
      x2</dd>
    </dl>

    <h3><a id="s4" name="s4">4. Property abstractions</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ka  NU  property abstractor
    ce'u    KOhA    
</pre>

    <p>The things described by ``le nu'' descriptions (or, to put
    it another way, the things of which ``nu'' selbri may correctly
    be predicated) are only moderately ``abstract''. They are still
    closely tied to happenings in space and time. Properties,
    however, are much more ethereal. What is ``the property of
    being blue'', or ``the property of being a go-er''? They are
    what logicians call ``intensions''. If John has a heart, then
    ``the property of having a heart'' is an abstract object which,
    when applied to John, is true. In fact,</p>

    <p></p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  la djan. cu se risna zo'e
    John has-as-heart something-unspecified.
    John has a heart.
</pre>
    has the same truth conditions as 
<pre>
<a id="e4d2" name="e4d2">4.2)</a>  la djan. cu ckaji
        le ka se risna [zo'e] [kei]
    John has-the-property
        the property-of having-as-heart something.
    John has the property of having a heart.
</pre>
    (The English word ``have'' frequently appears in any discussion
    of Lojban properties: things are said to ``have'' properties,
    but this is not the same sense of ``have'' as in ``I have
    money'', which is possession.) 

    <p>Property descriptions, like event descriptions, are often
    wanted to fill places in brivla place structures:</p>
<pre>
<a id="e4d3" name="e4d3">4.3)</a>  do cnino mi
        le ka xunre [kei]
    You are-new to-me
        in-the-quality-of-the property-of being-red.
    You are new to me in redness.
</pre>
    (The English suffix ``-ness'' often signals a property
    abstraction, as does the suffix ``-ity''.) 

    <p>We can also move the property description to the x1 place of
    <a href="#e4d3">Example 4.3</a>, producing:</p>
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  le ka do xunre [kei] cu cnino mi
    The property-of your being-red is-new to me.
    Your redness is new to me.
</pre>
    It would be suitable to use <a href="#e4d3">Examples 4.3</a>
    and <a href="#e4d4">4.4</a> to someone who has returned from
    the beach with a sunburn. 

    <p>There are several different properties that can be extracted
    from a bridi, depending on which place of the bridi is
    ``understood'' as being specified externally. Thus:</p>

    <p></p>
<pre>
<a id="e4d5" name="e4d5">4.5)</a>  ka mi prami [zo'e] [kei]
    a-property-of me loving something-unspecified
</pre>
    is quite different from 
<pre>
<a id="e4d6" name="e4d6">4.6)</a>  ka [zo'e] prami mi [kei]
    a-property-of something-unspecified loving me
</pre>

    <p>In particular, sentences like <a href="#e4d7">Example
    4.7</a> and <a href="#e4d8">Example 4.8</a> are quite different
    in meaning:</p>

    <p></p>
<pre>
<a id="e4d7"
name="e4d7">4.7)</a>  la djan. cu zmadu la djordj. le ka mi prami
    John exceeds George in-the property-of (I love X)
    I love John more than I love George.

<a id="e4d8"
name="e4d8">4.8)</a>   la djan. cu zmadu la djordj. le ka prami mi
    John exceeds George in the property of (X loves me).
    John loves me more than George loves me.
</pre>

    <p>The ``X'' used in the glosses of <a href="#e4d7">Examples
    4.7</a> through <a href="#e4d8">4.8</a> as a place-holder
    cannot be represented only by ellipsis in Lojban, because
    ellipsis means that there must be a specific value that can
    fill the ellipsis, as mentioned in <a href="#s2">Section 2</a>.
    Instead, the cmavo ``ce'u'' of selma'o KOhA is employed when an
    explicit sumti is wanted. (The form ``X'' will be used in
    literal translations.)</p>

    <p>Therefore, an explicit equivalent of <a href="#e4d7">Example
    4.7</a>, with no ellipsis, is:</p>
<pre>
<a id="e4d9"
name="e4d9">4.9)</a>  la djan. cu zmadu la djordj. le ka mi prami ce'u
    John exceeds George in-the property-of (I love X).
</pre>
    and of <a href="#e4d8">Example 4.8</a> is: 
<pre>
<a id="e4d10"
name="e4d10">4.10)</a>    la djan. cu zmadu la djordj. le ka ce'u prami mi
    John exceeds George in-the property-of (X loves me).
</pre>

    <p>This convention allows disambiguation of cases like:</p>

    <p></p>
<pre>
<a id="e4d11"
name="e4d11">4.11)</a>    le ka [zo'e] dunda le xirma [zo'e] [kei]
    the property-of giving the horse
</pre>
    into 
<pre>
<a id="e4d12" name="e4d12">4.12)</a>    le ka ce'u dunda le xirma
        [zo'e] [kei]
    the property-of (X is-a-giver of-the horse
        to someone-unspecified)
    the property of being a giver of the horse
</pre>
    which is the most natural interpretation of <a
    href="#e4d11">Example 4.11</a>, versus 
<pre>
<a id="e4d13" name="e4d13">4.13)</a>    le ka [zo'e] dunda
        le xirma ce'u [kei]
    the property-of (someone-unspecified
        is-a-giver of-the horse to X)
    the property of being one to whom the horse is given
</pre>
    which is also a possible interpretation. 

    <p>It is also possible to have more than one ``ce'u'' in a
    ``ka'' abstraction, which transforms it from a property
    abstraction into a relationship abstraction, a resource of the
    language that has not yet been explored.</p>

    <p>The place structure of ``ka'' abstraction selbri is
    simply:</p>

    <dl>
      <dt></dt>

      <dd>x1 is a property of (the bridi)</dd>
    </dl>

    <h3><a id="s5" name="s5">5. Amount abstractions</h3>

    <p>The following cmavo is discussed in this section:</p>

    <p></p>
<pre>
   ni  NU  amount abstraction
</pre>

    <p>Amount abstractions are far more limited than event or
    property abstractions. They really make sense only if the
    selbri of the abstracted bridi is subject to measurement of
    some sort. Thus we can speak of:</p>

    <p></p>
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  le ni le pixra cu blanu [kei]
    the amount-of (the picture being-blue)
    the amount of blueness in the picture
</pre>
    because ``blueness'' could be measured with a colorimeter or a
    similar device. However, 
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  le ni la djein. cu mamta [kei]
    the amount-of (Jane being-a-mother)
    the amount of Jane's mother-ness (?)
    the amount of mother-ness in Jane (?)
</pre>
    makes very little sense in either Lojban or English. We simply
    do not have any sort of measurement scale for being a mother. 

    <p>Semantically, a sumti with ``le ni'' is a number; however,
    it cannot be treated grammatically as a quantifier in Lojban
    unless prefixed by the mathematical cmavo ``mo'e'':</p>
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  li pa vu'u mo'e
        le ni le pixra cu blanu [kei]
    the-number 1 minus the-operand
        the amount-of (the picture being-blue)
    1 - B, where B = blueness of the picture
</pre>

    <p>Mathematical Lojban is beyond the scope of this chapter, and
    is explained more fully in <a href="chapter18.html">Chapter
    18</a>.</p>

    <p>There are contexts where either property or amount
    abstractions make sense, and in such constructions, amount
    abstractions can make use of ``ce'u'' just like property
    abstractors. Thus,</p>

    <p></p>
<pre>
<a id="e5d4"
name="e5d4">5.4)</a>  le pixra cu cenba le ka ce'u blanu [kei]
    the picture varies in-the property-of (X is blue)
    The picture varies in being blue.
    The picture varies in blueness.
</pre>
    is not the same as 
<pre>
<a id="e5d5"
name="e5d5">5.5)</a>  le pixra cu cenba le ni ce'u blanu [kei]
    the picture varies in-the amount-of (X is blue)
    The picture varies in how blue it is.
    The picture varies in blueness.
</pre>
    <a href="#e5d4">Example 5.4</a> conveys that the blueness comes
    and goes, whereas <a href="#e5d5">Example 5.5</a> conveys that
    its quantity changes over time. 

    <p>Whenever we talk of measurement of an amount, there is some
    sort of scale, and so the place structure of ``ni'' abstraction
    selbri is:</p>

    <dl>
      <dt></dt>

      <dd>x1 is the amount of (the bridi) on scale x2</dd>
    </dl>
    Note: the best way to express the x2 places of abstract sumti
    is to use something like ``le ni ... kei be''. See <a
    href="#e9d5">Example 9.5</a> for the use of this construction. 

    <p></p>

    <h3><a id="s6" name="s6">6. Truth-value abstraction: ``jei''</h3>

    <p>The ``blueness of the picture'' discussed in <a
    href="#s5">Section 5</a> refers to the measurable amount of
    blue pigment (or other source of blueness), not to the degree
    of truth of the claim that blueness is present. That
    abstraction is expressed in Lojban using ``jei'', which is
    closely related semantically to ``ni''. In the simplest cases,
    ``le jei'' produces not a number but a truth value:</p>

    <p></p>
<pre>
<a id="e6d1"
name="e6d1">6.1)</a>  le jei li re su'i re du li vo [kei]
    the truth-value-of the-number 2 + 2 = the-number 4
    the truth of 2 + 2 being 4
</pre>
    is equivalent to ``truth'', and 
<pre>
<a id="e6d2"
name="e6d2">6.2)</a>  le jei li re su'i re du li mu [kei]
    the truth-value-of the-number 2 + 2 = the-number 5
    the truth of 2 + 2 being 5
</pre>
    is equivalent to ``falsehood''. 

    <p>However, not everything in life (or even in Lojban) is
    simply true or false. There are shades of gray even in truth
    value, and ``jei'' is Lojban's mechanism for indicating the
    shade of grey intended:</p>

    <p></p>
<pre>
<a id="e6d3" name="e6d3">6.3)</a>  mi ba jdice le jei
        la djordj. cu zekri gasnu [kei]
    I [future] decide the truth-value of
        (George being-a-(crime doer)).
    I will decide whether George is a criminal.
</pre>
    <a href="#e6d3">Example 6.3</a> does not imply that George is,
    or is not, definitely a criminal. Depending on the legal system
    I am using, I may make some intermediate decision. As a result,
    ``jei'' requires an x2 place analogous to that of ``ni'': 

    <dl>
      <dt></dt>

      <dd>x1 is the truth value of (the bridi) under epistemology
      x2</dd>
    </dl>
    Abstractions using ``jei'' are the mechanism for fuzzy logic in
    Lojban; the ``jei'' abstraction refers to a number between 0
    and 1 inclusive (as distinct from ``ni'' abstractions, which
    are often on open-ended scales). The detailed conventions for
    using ``jei'' in fuzzy-logic contexts have not yet been
    established. 

    <p></p>

    <h3><a id="s7" name="s7">7. Predication/sentence abstraction</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   du'u    NU  predication abstraction
</pre>
    There are some selbri which demand an entire predication as a
    sumti; they make claims about some predication considered as a
    whole. Logicians call these the ``propositional attitudes'',
    and they include (in English) things like knowing, believing,
    learning, seeing, hearing, and the like. Consider the English
    sentence: 

    <p></p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  I know that Frank is a fool.
</pre>

    <p>How's that in Lojban? Let us try:</p>
<pre>
<a id="e7d2"
name="e7d2">7.2)</a>  mi djuno le nu la frank. cu bebna [kei]
    I know the event of Frank being a fool.
</pre>
    Not quite right. Events are actually or potentially physical,
    and can't be contained inside one's mind, except for events of
    thinking, feeling, and the like; <a href="#e7d2">Example
    7.2</a> comes close to claiming that Frank's being-a-fool is
    purely a mental activity on the part of the speaker. (In fact,
    <a href="#e7d2">Example 7.2</a> is an instance of improperly
    marked ``sumti raising'', a concept discussed further in <a
    href="#s10">Section 10</a>). 

    <p>Try again:</p>
<pre>
<a id="e7d3"
name="e7d3">7.3)</a>  mi djuno le jei la frank. cu bebna [kei]
    I know the truth-value of Frank being a fool.
</pre>

    <p>Closer. <a href="#e7d3">Example 7.3</a> says that I know
    whether or not Frank is a fool, but doesn't say that he is one,
    as <a href="#e7d1">Example 7.1</a> does. To catch that nuance,
    we must say:</p>

    <p></p>
<pre>
<a id="e7d4"
name="e7d4">7.4)</a>  mi djuno le du'u la frank. cu bebna [kei]
    I know the predication that Frank is a fool.
</pre>

    <p>Now we have it. Note that the implied assertion ``Frank is a
    fool'' is not a property of ``le du'u'' abstraction, but of
    ``djuno''; we can only know what is in fact true. (As a result,
    ``djuno'' like ``jei'' has a place for epistemology, which
    specifies how we know.) <a href="#e7d5">Example 7.5</a> has no
    such implied assertion:</p>

    <p></p>
<pre>
<a id="e7d5"
name="e7d5">7.5)</a>  mi kucli le du'u la frank. cu bebna [kei]
    I am curious about whether Frank is a fool.
</pre>
    and here ``du'u'' could probably be replaced by ``jei'' without
    much change in meaning: 

    <p></p>
<pre>
<a id="e7d6"
name="e7d6">7.6)</a>  mi kucli le jei la frank. cu bebna [kei]
    I am curious about how true it is
        that Frank is a fool.
</pre>
    As a matter of convenience rather than logical necessity,
    ``du'u'' has been given an x2 place, which is a sentence (piece
    of language) expressing the bridi: 

    <dl>
      <dt></dt>

      <dd>x1 is the predication (the bridi), expressed in sentence
      x2</dd>
    </dl>
    and ``le se du'u ...'' is very useful in filling places of
    selbri which refer to speaking, writing, or other linguistic
    behavior regarding bridi: 

    <p></p>
<pre>
<a id="e7d6.5" name="e7d6.5">7.6.5)</a>  la djan. cusku
        le se du'u
            la djordj. klama le zarci [kei]
    John expresses
        the sentence-expressing-that
            George goes-to the store
    John says that George goes to the store.
</pre>
    <a href="#e7d6">Example 7.6</a> differs from 
<pre>
<a id="e7d7" name="e7d7">7.7)</a>  la djan cusku
        lu la djordj. klama le zarci li'u
    John expresses,
        quote, George goes to the store, unquote.
    John says ``George goes to the store''.
</pre>
    because <a href="#e7d7">Example 7.7</a> claims that John
    actually said the quoted words, whereas <a href="#e7d6">Example
    7.6</a> claims only that he said some words or other which were
    to the same purpose. 

    <p>``le se du'u'' is much the same as ``lu'e le du'u'', a
    symbol for the predication, but ``se du'u'' can be used as a
    selbri, whereas ``lu'e'' is ungrammatical in a selbri. (See <a
    href="chapter5.html">Chapter 5</a> for a discussion of
    ``lu'e''.)</p>

    <p></p>

    <h3><a id="s8" name="s8">8. Indirect questions</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   kau UI  indirect question marker
</pre>
    There is an alternative type of sentence involving ``du'u'' and
    a selbri expressing a propositional attitude. In addition to
    sentences like 
<pre>
<a id="e8d1"
name="e8d1">8.1)</a>  I know that John went to the store.
</pre>
    we can also say things like 

    <p></p>
<pre>
<a id="e8d2" name="e8d2">8.2)</a>  I know who went to the store.
</pre>
    This form is called an ``indirect question'' in English because
    the embedded English sentence is a question: ``Who went to the
    store?'' A person who says <a href="#e8d2">Example 8.2</a> is
    claiming to know the answer to this question. Indirect
    questions can occur with many other English verbs as well: I
    can wonder, or doubt, or see, or hear, as well as know who went
    to the store. 

    <p>To express indirect questions in Lojban, we use a ``le
    du'u'' abstraction, but rather than using a question word like
    ``who'' (``ma'' in Lojban), we use any word that will fit
    grammatically and mark it with the suffix particle ``kau''.
    This cmavo belongs to selma'o UI, so grammatically it can
    appear anywhere. The simplest Lojban translation of <a
    href="#e8d2">Example 8.2</a> is therefore:</p>
<pre>
<a id="e8d3" name="e8d3">8.3)</a>  mi djuno le du'u
        makau pu klama le zarci
    I know the predication-of
        X [indirect question] [past] going to the store.
</pre>
    In <a href="#e8d3">Example 8.3</a>, we have chosen to use
    ``ma'' as the word marked by ``kau''. In fact, any other sumti
    would have done as well: ``zo'e'' or ``da'' or even ``la
    djan.''. Using ``la djan.'' would suggest that it was John who
    I knew had gone to the store, however: 
<pre>
<a id="e8d4" name="e8d4">8.4)</a>  mi djuno le du'u
        la djan. kau pu
            klama le zarci
    I know the predication-of/fact-that
        John [indirect question] [past]
            going to the store.
    I know who went to the store, namely John.
    I know that it was John who went to the store.
</pre>

    <p>Using one of the indefinite pro-sumti such as ``ma'',
    ``zo'e'', or ``da'' does not suggest any particular value.</p>

    <p>Why does Lojban require the ``kau'' marker, rather than
    using ``ma'' as English and Chinese and many other languages
    do? Because ``ma'' always signals a direct question, and so</p>
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  mi djuno le du'u
        ma pu klama le zarci
    I know the predication-of
        [what sumti?] [past] goes-to the store
</pre>
    means 
<pre>
<a id="e8d6"
name="e8d6">8.6)</a>  Who is it that I know goes to the store?
</pre>
    It is actually not necessary to use ``le du'u'' and ``kau'' at
    all if the indirect question involves a sumti; there is
    generally a paraphrase of the type: 
<pre>
<a id="e8d7"
name="e8d7">8.7)</a>  mi djuno fi le pu klama be le zarci
    I know about the [past] goer to-the store.
    I know something about the one who went to the store
        (namely, his identity).
</pre>
    because the x3 place of ``djuno'' is the subject of knowledge,
    as opposed to the fact that is known. But when the questioned
    point is not a sumti, but (say) a logical connection, then
    there is no good alternative to ``kau'': 
<pre>
<a id="e8d8" name="e8d8">8.8)</a>  mi ba zgana le du'u
        la djan. jikau la djordj.
            cu zvati le panka
    I [future] observe the predication-of/fact-that
        John [connective indirect question] George
            is-at the park.
    I will see whether John or George (or both)
        is at the park.
</pre>

    <p>In addition, <a href="#e8d7">Example 8.7</a> is only a loose
    paraphrase of <a href="#e8d3">Example 8.3</a>, because it is
    left to the listener's insight to realize that what is known
    about the goer-to-the-store is his identity rather than some
    other of his attributes.</p>

    <p></p>

    <h3><a id="s9" name="s9">9. Minor abstraction types</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   li'i    NU  experience abstractor
    si'o    NU  concept abstractor
    su'u    NU  general abstractor
</pre>
    There are three more abstractors in Lojban, all of them little
    used so far. The abstractor ``li'i'' expresses experience: 
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  mi morji le li'i mi verba
    I remember the experience-of (my being-a-child)
</pre>
    The abstractor ``si'o'' expresses a mental image, a concept, an
    idea: 
<pre>
<a id="e9d2"
name="e9d2">9.2)</a>  mi nelci le si'o la lojban. cu mulno
    I enjoy the concept-of Lojban being-complete.
</pre>
    Finally, the abstractor ``su'u'' is a vague abstractor, whose
    meaning must be grasped from context: 

    <p></p>
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  ko zgana le su'u
        le ci smacu cu bajra
    you [imperative] observe the abstract-nature-of
        the three mice running
    See how the three mice run!
</pre>
    All three of these abstractors have an x2 place. An experience
    requires an experiencer, so the place structure of ``li'i'' is:
    

    <dl>
      <dt></dt>

      <dd>x1 is the experience of (the bridi) as experienced by
      x2</dd>
    </dl>
    Similarly, an idea requires a mind to hold it, so the place
    structure of ``si'o'' is: 

    <dl>
      <dt></dt>

      <dd>x1 is the idea/concept of (the bridi) in the mind of
      x2</dd>
    </dl>
    Finally, there needs to be some way of specifying just what
    sort of abstraction ``su'u'' is representing, so its place
    structure is: 

    <dl>
      <dt></dt>

      <dd>x1 is an abstract nature of (the bridi) of type x2</dd>
    </dl>
    The x2 place of ``su'u'' allows it to serve as a substitute for
    any of the other abstractors, or as a template for creating new
    ones. For example, 
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  le nu mi klama
    the event-of my going
</pre>
    can be paraphrased as 
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  le su'u mi klama kei be lo fasnu
    the abstract-nature-of (my going) of-type an event
</pre>
    and there is a book whose title might be rendered in Lojban as:
    

    <p></p>
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  le su'u la .iecuas. kuctra
        selcatra kei
        be lo sao'rdzifa'a
        ke nalmatma'e sutyterjvi
    the abstract-nature-of (Jesus is-an-intersect-shape
        type-of-killed-one)
        of-type a slope-low-direction
        type-of non-motor-vehicle speed-competition
    The Crucifixion of Jesus Considered As A
        Downhill Bicycle Race
</pre>

    <p>Note the importance of using ``kei'' after ``su'u'' when the
    x2 of ``su'u'' (or any other abstractor) is being specified;
    otherwise, the ``be lo'' ends up inside the abstraction
    bridi.</p>

    <p></p>

    <h3><a id="s10" name="s10">10. Lojban sumti raising</h3>

    <p>The following cmavo are discussed in this section:</p>

    <p></p>
<pre>
   tu'a    LAhE    an abstraction involving
    jai JAI abstraction conversion
</pre>
    It is sometimes inconvenient, in a situation where an abstract
    description is logically required, to express the abstraction.
    In English we can say: 
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    I try to open the door.
</pre>
    which in Lojban is: 
<pre>
<a id="e10d2" name="e10d2">10.2)</a>    mi troci le nu
        [mi] gasnu le nu
            le vorme cu karbi'o
    I try the event-of
        (I am-agent-in the event-of
            (the door open-becomes)).
</pre>
    which has an abstract description within an abstract
    description, quite a complex structure. In English (but not in
    all other languages), we may also say: 

    <p></p>
<pre>
<a id="e10d3" name="e10d3">10.3)</a>    I try the door.
</pre>
    where it is understood that what I try is actually not the door
    itself, but the act of opening it. The same simplification can
    be done in Lojban, but it must be marked explicitly using a
    cmavo. The relevant cmavo is ``tu'a'', which belongs to selma'o
    LAhE. The Lojban equivalent of <a href="#e10d3">Example
    10.3</a> is: 
<pre>
<a id="e10d4" name="e10d4">10.4)</a>    mi troci tu'a le vorme
    I try some-action-to-do-with the door.
</pre>
    The term ``sumti-raising'', as in the title of this section,
    signifies that a sumti which logically belongs within an
    abstraction (or even within an abstraction which is itself
    inside an intermediate abstraction) is ``raised'' to the main
    bridi level. This transformation from <a href="#e10d2">Example
    10.2</a> to <a href="#e10d4">Example 10.4</a> loses
    information: nothing except convention tells us what the
    abstraction was. 

    <p>Using ``tu'a'' is a kind of laziness: it makes speaking
    easier at the possible expense of clarity for the listener. The
    speaker must be prepared for the listener to respond something
    like:</p>

    <p></p>
<pre>
<a id="e10d5" name="e10d5">10.5)</a>    tu'a le vorme lu'u ki'a
    something-to-do-with the door [terminator] [confusion!]
</pre>
    which indicates that ``tu'a le vorme'' cannot be understood.
    (The terminator for ``tu'a'' is ``lu'u'', and is used in <a
    href="#e10d5">Example 10.5</a> to make clear just what is being
    questioned: the sumti-raising, rather than the word ``vorme''
    as such.) An example of a confusing raised sumti might be: 
<pre>
<a id="e10d6" name="e10d6">10.6)</a>    tu'a la djan. cu cafne
    something-to-do-with John frequently-occurs
</pre>

    <p>This must mean that something which John does, or which
    happens to John, occurs frequently: but without more context
    there is no way to figure out what. Note that without the
    ``tu'a'', <a href="#e10d6">Example 10.6</a> would mean that
    John considered as an event frequently occurs --- in other
    words, that John has some sort of on-and-off existence!
    Normally we do not think of people as events in English, but
    the x1 place of ``cafne'' is an event, and if something that
    does not seem to be an event is put there, the Lojbanic
    listener will attempt to construe it as one. (Of course, this
    analysis assumes that ``djan.'' is the name of a person, and
    not the name of some event.)</p>

    <p>Logically, a counterpart of some sort is needed to ``tu'a''
    which transposes an abstract sumti into a concrete one. This is
    achieved at the selbri level by the cmavo ``jai'' (of selma'o
    JAI). This cmavo has more than one function, discussed in <a
    href="chapter9.html">Chapter 9</a> and <a
    href="chapter11.html">Chapter 11</a>; for the purposes of this
    chapter, it operates as a conversion of selbri, similarly to
    the cmavo of selma'o SE. This conversion changes</p>

    <p></p>
<pre>
<a id="e10d7" name="e10d7">10.7)</a>    tu'a mi rinka
        le nu do morsi
    something-to-do-with me causes
        the event-of you are-dead
    My action causes your death.
</pre>
    into 
<pre>
<a id="e10d8" name="e10d8">10.8)</a>    mi jai rinka le nu do morsi
    I am-associated-with causing the event-of your death.
    I cause your death.
</pre>

    <p>In English, the subject of ``cause'' can either be the
    actual cause (an event), or else the agent of the cause (a
    person, typically); not so in Lojban, where the x1 of ``rinka''
    is always an event. <a href="#e10d7">Example 10.7</a> and <a
    href="#e10d8">Example 10.8</a> look equally convenient (or
    inconvenient), but in making descriptions, <a
    href="#e10d8">Example 10.8</a> can be altered to:</p>
<pre>
<a id="e10d9" name="e10d9">10.9)</a>    le jai rinka
        be le nu do morsi
    that-which-is associated-with causing
        (the event-of your death)
    the one who caused your death
</pre>
    because ``jai'' modifies the selbri and can be incorporated
    into the description --- not so for ``tu'a''. 

    <p>The weakness of ``jai'' used in descriptions in this way is
    that it does not specify which argument of the implicit
    abstraction is being raised into the x1 place of the
    description selbri. One can be more specific by using the modal
    form of ``jai'' explained in <a href="chapter9.html">Chapter
    9</a>:</p>
<pre>
<a id="e10d10" name="e10d10">10.10)</a>  le jai gau rinka
        be le nu do morsi
    that-which-is agent-in causing
        (the event-of your death)
</pre>

    <h3><a id="s11" name="s11">12. Event-type abstractors and event contour tenses</h3>

    <p>This section is a logical continuation of <a
    href="#s3">Section 3</a>.</p>

    <p>There exists a relationship between the four types of events
    explained in <a href="#s3">Section 3</a> and the event contour
    tense cmavo of selma'o ZAhO. The specific cmavo of NU and of
    ZAhO are mutually interdefining; the ZAhO contours were chosen
    to fit the needs of the NU event types and vice versa. Event
    contours are explained in full in <a href="chapter10.html">Chapter
    10</a>, and only summarized here.</p>

    <p>The purpose of ZAhO cmavo is to represent the natural
    portions of an event, such as the beginning, the middle, and
    the end. They fall into several groups:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>The cmavo ``pu'o'', ``ca'o'', and ``ba'o'' represent
      spans of time: before an event begins, while it is going on,
      and after it is over, respectively.</dd>

      <dt></dt>

      <dd>The cmavo ``co'a'', ``de'a'', ``di'a'', and ``co'u''
      represent points of time: the start of an event, the
      temporary stopping of an event, the resumption of an event
      after a stop, and the end of an event, respectively. Not all
      events can have breaks in them, in which case ``de'a'' and
      ``di'a'' do not apply.</dd>

      <dt></dt>

      <dd>The cmavo ``mo'u'' and ``za'o'' correspond to ``co'u''
      and ``ba'o'' respectively, in the case of those events which
      have a natural ending point that may not be the same as the
      actual ending point: ``mo'u'' refers to the natural ending
      point, and ``za'o'' to the time between the natural ending
      point and the actual ending point (the ``excessive'' or
      ``superfective'' part of the event).</dd>

      <dt></dt>

      <dd>The cmavo ``co'i'' represents an entire event considered
      as a point-event or achievement.</dd>
    </dl>
    All these cmavo are applicable to events seen as processes and
    abstracted with ``pu'u''. Only processes have enough internal
    structure to make all these points and spans of time
    meaningful. 

    <p>For events seen as states and abstracted with ``za'i'', the
    meaningful event contours are the spans ``pu'o'', ``ca'o'', and
    ``ba'o''; the starting and ending points ``co'a'' and ``co'u'',
    and the achievement contour ``co'i''. States do not have
    natural endings distinct from their actual ending. (It is an
    open question whether states can be stopped and resumed.)</p>

    <p>For events seen as activities and abstracted with ``zu'o'',
    the meaningful event contours are the spans ``pu'o'', ``ca'o'',
    and ``ba'o'', and the achievement contour ``co'i''. Because
    activities are inherently cyclic and repetitive, the beginning
    and ending points are not well-defined: you do not know whether
    an activity has truly begun until it begins to repeat.</p>

    <p>For events seen as point-events and abstracted with
    ``mu'e'', the meaningful event contours are the spans ``pu'o''
    and ``ba'o'' but not ``ca'o'' (a point-event has no duration),
    and the achievement contour ``co'i''.</p>

    <p>Note that the parts of events are themselves events, and may
    be treated as such. The points in time may be seen as ``mu'e''
    point-events; the spans of time may constitute processes or
    activities. Therefore, Lojban allows us to express processes
    within processes, activities within states, and many other
    complicated abstract things.</p>

    <p></p>

    <h3><a id="s12" name="s12">13. Abstractor connection</h3>

    <p>An abstractor may be replaced by two or more abstractors
    joined by logical or non-logical connectives. Connectives are
    explained in detail in <a href="chapter14.html">Chapter 14</a>.
    The connection can be expanded to one between two bridi which
    differ only in abstraction marker. <a href="#e13d1">Example
    13.1</a> and <a href="#e13d2">Example 13.2</a> are equivalent
    in meaning:</p>
<pre>
<a id="e13d1"
name="e13d1">13.1)</a>    le ka la frank. ciska cu xlali
        .ije le ni la frank. ciska cu xlali
    The quality-of Frank's writing is bad,
        and the quantity of Frank's writing is bad.

<a id="e13d2"
name="e13d2">13.2)</a> le ka je ni la frank. ciska cu xlali
    The quality and quantity of Frank's writing is bad.
</pre>

    <p>This feature of Lojban has hardly ever been used, and nobody
    knows what uses it may eventually have.</p>

    <p></p>

    <h3><a id="s13" name="s13">14. Table of abstractors</h3>

    <p>The following table gives each abstractor, an English gloss
    for it, a Lojban gismu which is connected with it (more or less
    remotely: the associations between abstractors and gismu are
    meant more as memory hooks than for any kind of inference), the
    rafsi associated with it, and (on the following line) its place
    structure.</p>
<pre>
nu event of    fasnu       nun
        x1 is an event of (the bridi)
ka  property of ckaji       kam
        x1 is a property of (the bridi)
ni  amount of   klani       nil
        x1 is an amount of (the bridi)
            measured on scale x2
jei truth-value of  jetnu       jez
        x1 is a truth-value of (the bridi)
            under epistemology x2
li'i    experience of   lifri       liz
        x1 is an experience of (the bridi)
            to experiencer x2
si'o    idea of     sidbo       siz
        x1 is an idea/concept of (the bridi)
            in the mind of x2
du'u    predication of  -----       dum
        x1 is the bridi (the bridi)
            expressed by sentence x2
su'u    abstraction of  sucta       sus
        x1 is an abstract nature of (the bridi)
za'i    state of    zasti       zam
        x1 is a state of (the bridi)
zu'o    activity of zukte       zum
        x1 is an activity of (the bridi)
pu'u    process of  pruce       pup
        x1 is a process of (the bridi)
mu'e    point-event of  mulno       mub
        x1 is a point-event/achievement
            of (the bridi)
</pre>

    <hr />
    
    <p>Derni&egrave;res modifications&nbsp;: Mon Jun 27 23:12:04 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
