
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//SV" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="sv" lang="sv">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 12</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter12.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 12<br />
      Dog House And White House: Determining lujvo Place
      Structures</h2>

      <!--
      <h6>$Revision: 4.2 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. Why have lujvo?</h3>

    <p>The Lojban vocabulary is founded on its list of 1350-plus
    gismu, made up by combining word lists from various sources.
    These gismu are not intended to be either a complete vocabulary
    for the language nor a minimal list of semantic primitives.
    Instead, the gismu list serves as a basis for the creation of
    compound words, or lujvo. The intention is that (except in
    certain semantically broad but shallow fields such as cultures,
    nations, foods, plants, and animals) suitable lujvo can be
    devised to cover the ten million or so concepts expressible in
    all the world's languages taken together. Grammatically, lujvo
    behave just like gismu: they have place structures and function
    as selbri.</p>

    <p>There is a close relationship between lujvo and tanru. In
    fact, lujvo are condensed forms of tanru:</p>
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  ti fagri festi
    That is-fire waste.
</pre>
    contains a tanru which can be reduced to the lujvo in: 
<pre>
<a id="e1d2" name="e1d2">1.2)</a>  ti fagyfesti
    That is-fire-waste.
    That is-ashes.
</pre>

    <p>Although the lujvo ``fagyfesti'' is derived from the tanru
    ``fagri festi'', it is not equivalent in meaning to it. In
    particular, ``fagyfesti'' has a distinct place structure of its
    own, not the same as that of ``festi''. (In contrast, the tanru
    does have the same place structure as ``festi''.) The lujvo
    needs to take account of the places of ``fagri'' as well. When
    a tanru is made into a lujvo, there is no equivalent of ``be
    ... bei ... be'o'' (described in <a href="chapter5.html">Chapter
    5</a>) to incorporate sumti into the middle of the lujvo.</p>

    <p>So why have lujvo? Primarily to reduce semantic ambiguity.
    On hearing a tanru, there is a burden on the listener to figure
    out what the tanru might mean. Adding further terms to the
    tanru reduces ambiguity in one sense, by providing more
    information; but it increases ambiguity in another sense,
    because there are more and more tanru joints, each with an
    ambiguous significance. Since lujvo, like other brivla, have a
    fixed place structure and a single meaning, encapsulating a
    commonly-used tanru into a lujvo relieves the listener of the
    burden of creative understanding. In addition, lujvo are
    typically shorter than the corresponding tanru.</p>

    <p>There are no absolute laws fixing the place structure of a
    newly created lujvo. The maker must consider the place
    structures of all the components of the tanru and then decide
    which are still relevant and which can be removed. What is said
    in this chapter represents guidelines, presented as one
    possible standard, not necessarily complete, and not the only
    possible standard. There may well be lujvo that are built
    without regard for these guidelines, or in accordance with
    entirely different guidelines, should such alternative
    guidelines someday be developed. The reason for presenting any
    guidelines at all is so that Lojbanists have a starting point
    for deciding on a likely place structure --- one that others
    seeing the same word can also arrive at by similar
    consideration.</p>

    <p>If the tanru includes connective cmavo such as ``bo'',
    ``ke'', ``ke'e'', or ``je'', or conversion or abstraction cmavo
    such as ``se'' or ``nu'', there are ways of incorporating them
    into the lujvo as well. Sometimes this makes the lujvo
    excessively long; if so, the cmavo may be dropped. This leads
    to the possibility that more than one tanru could produce the
    same lujvo. Typically, however, only one of the possible tanru
    is useful enough to justify making a lujvo for it.</p>

    <p>The exact workings of the lujvo-making algorithm, which
    takes a tanru built from gismu (and possibly cmavo) and
    produces a lujvo from it, are described in <a
    href="chapter4.html">Chapter 4</a>.</p>

    <p></p>

    <h3><a id="s2" name="s2">2. The meaning of tanru: a necessary detour</h3>

    <p>The meaning of a lujvo is controlled by --- but is not the
    same as --- the meaning of the tanru from which the lujvo was
    constructed. The tanru corresponding to a lujvo is called its
    ``veljvo'' in Lojban, and since there is no concise English
    equivalent, that term will be used in this chapter.
    Furthermore, the left (modifier) part of a tanru will be called
    the ``seltau'', and the right (modified) part the ``tertau'',
    following the usage of <a href="chapter5.html">Chapter 5</a>. For
    brevity, we will speak of the seltau or tertau of a lujvo,
    meaning of course the seltau or tertau of the veljvo of that
    lujvo. (If this terminology is confusing, substituting
    ``modifier'' for ``seltau'' and ``modified'' for ``tertau'' may
    help.)</p>

    <p>The place structure of a tanru is always the same as the
    place structure of its tertau. As a result, the meaning of the
    tanru is a modified version of the meaning of the tertau; the
    tanru will typically, but not always, refer to a subset of the
    things referred to by the tertau.</p>

    <p>The purpose of a tanru is to join concepts together without
    necessarily focusing on the exact meaning of the seltau. For
    example, in the <cite>Iliad</cite>, the poet talks about ``the
    wine-dark sea'', in which ``wine'' is a seltau relative to
    ``dark'', and the pair of words is a seltau relative to
    ``sea''. We're talking about the sea, not about wine or color.
    The other words are there to paint a scene in the listener's
    mind, in which the real action will occur, and to evoke
    relations to other sagas of the time similarly describing the
    sea. Logical inferences about wine or color will be rejected as
    irrelevant.</p>

    <p>As a simple example, consider the rather non-obvious tanru
    ``klama zdani'', or ``goer-house''. The gismu ``zdani'' has two
    places:</p>
<pre>
<a id="e2d1"
name="e2d1">2.1)</a>  x1 is a nest/house/lair/den for inhabitant x2
</pre>
    (but in this chapter we will use simply ``house'', for
    brevity), and the gismu ``klama'' has five: 
<pre>
<a id="e2d2"
name="e2d2">2.2)</a>  x1 goes to destination x2 from origin point x3
        via route x4 using means x5
</pre>

    <p>The tanru ``klama zdani'' will also have two places, namely
    those of ``zdani''. Since a ``klama zdani'' is a type of
    ``zdani'', we can assume that all goer-houses --- whatever they
    may be --- are also houses.</p>

    <p>But is knowing the places of the tertau everything that is
    needed to understand the meaning of a tanru? No. To see why,
    let us switch to a less unlikely tanru: ``gerku zdani'',
    literally ``dog house''. A tanru expresses a very loose
    relation: a ``gerku zdani'' is a house that has something to do
    with some dog or dogs. What the precise relation might be is
    left unstated. Thus, the meaning of ``lo gerku zdani'' can
    include all of the following: houses occupied by dogs, houses
    shaped by dogs, dogs which are also houses (e.g. houses for
    fleas), houses named after dogs, and so on. All that is
    essential is that the place structure of ``zdani'' continues to
    apply.</p>

    <p>For something (call it z1) to qualify as a ``gerku zdani''
    in Lojban, it's got to be a house, first of all. For it to be a
    house, it's got to house someone (call that z2). Furthermore,
    there's got to be a dog somewhere (called g1). For g1 to count
    as a dog in Lojban, it's got to belong to some breed as well
    (called g2). And finally, for z1 to be in the first place of
    ``gerku zdani'', as opposed to just ``zdani'', there's got to
    be some relationship (called r) between some place of ``zdani''
    and some place of ``gerku''. It doesn't matter which places,
    because if there's a relationship between some place of
    ``zdani'' and any place of ``gerku'', then that relationship
    can be compounded with the relationship between the places of
    ``gerku'' --- namely, ``gerku'' itself --- to reach any of the
    other ``gerku'' places. Thus, if the relationship turns out to
    be between z2 and g2, we can still state r in terms of z1 and
    g1: ``the relationship involves the dog g1, whose breed has to
    do with the occupant of the house z1''.</p>

    <p>Doubtless to the relief of the reader, here's an
    illustration. We want to find out whether the White House (the
    one in which the U. S. President lives, that is) counts as a
    ``gerku zdani''. We go through the five variables. The White
    House is the z1. It houses Bill Clinton as z2, as of this
    writing, so it counts as a ``zdani''. Let's take a dog --- say,
    Spot (g1). Spot has to have a breed; let's say it's a Saint
    Bernard (g2). Now, the White House counts as a ``gerku zdani''
    if there is any relationship (r) at all between the White House
    and Spot. (We'll choose the g1 and z1 places to relate by r; we
    could have chosen any other pair of places, and simply gotten a
    different relationship.)</p>

    <p>The sky is the limit for r; it can be as complicated as
    ``The other day, g1 (Spot) chased Socks, who is owned by
    Chelsea Clinton, who is the daughter of Bill Clinton, who lives
    in z1 (the White House)'' or even worse. If no such r can be
    found, well, you take another dog, and keep going until no more
    dogs can be found. Only then can we say that the White House
    cannot fit into the first place of ``gerku zdani''.</p>

    <p>As we have seen, no less than five elements are involved in
    the definition of ``gerku zdani'': the house, the house
    dweller, the dog, the dog breed (everywhere a dog goes in
    Lojban, a dog breed follows), and the relationship between the
    house and the dog. Since tanru are explicitly ambiguous in
    Lojban, the relationship r cannot be expressed within a tanru
    (if it could, it wouldn't be a tanru any more!) All the other
    places, however, can be expressed --- thus:</p>
<pre>
<a id="e2d3"
name="e2d3">2.3)</a>  la blabi zdani cu gerku be fa la spot.
        bei la sankt. berNARD. be'o
        zdani la bil. klinton.
    The White House is-a-dog (namely Spot
        of-breed Saint Bernard)
        type-of-house-for Bill Clinton.
</pre>
    Not the most elegant sentence ever written in either Lojban or
    English. Yet if there is any relation at all between Spot and
    the White House, <a href="#e2d4">Example 2.4</a> is arguably
    true. If we concentrate on just one type of relation in
    interpreting the tanru ``gerku zdani'', then the meaning of
    ``gerku zdani'' changes. So if we understand ``gerku zdani'' as
    having the same meaning as the English word ``doghouse'', the
    White House would no longer be a ``gerku zdani'' with respect
    to Spot, because as far as we know Spot does not actually live
    in the White House, and the White House is not a doghouse
    (derogatory terms for incumbents notwithstanding). 

    <h3><a id="s3" name="s3">3. The meaning of lujvo</h3>

    <p>This is a fairly long way to go to try and work out how to
    say ``doghouse''! The reader can take heart; we're nearly
    there. Recall that one of the components involved in fixing the
    meaning of a tanru --- the one left deliberately vague --- is
    the precise relation between the tertau and the seltau. Indeed,
    fixing this relation is tantamount to giving an interpretation
    to the ambiguous tanru.</p>

    <p>A lujvo is defined by a single disambiguated instance of a
    tanru. That is to say, when we try to design the place
    structure of a lujvo, we don't need to try to discover the
    relation between the tertau and the seltau. We already know
    what kind of relation we're looking for; it's given by the
    specific need we wish to express, and it determines the place
    structure of the lujvo itself.</p>

    <p>Therefore, it is generally not appropriate to simply devise
    lujvo and decide on place structures for them without
    considering one or more specific usages for the coinage. If one
    does not consider specifics, one will be likely to make
    erroneous generalizations on the relationship r.</p>

    <p>The insight driving the rest of this chapter is this: while
    the relation expressed by a tanru can be very distant (e.g.
    Spot chasing Socks, above), the relationship singled out for
    disambiguation in a lujvo should be quite close. This is
    because lujvo-making, paralleling natural language compounding,
    picks out the most salient relationship r between a tertau
    place and a seltau place to be expressed in a single word. The
    relationship ``dog chases cat owned by daughter of person
    living in house'' is too distant, and too incidental, to be
    likely to need expression as a single short word; the
    relationship ``dog lives in house'' is not. From all the
    various interpretations of ``gerku zdani'', the person creating
    ``gerzda'' should pick the most useful value of r. The most
    useful one is usually going to be the most obvious one, and the
    most obvious one is usually the closest one.</p>

    <p>In fact, the relationship will almost always be so close
    that the predicate expressing r will be either the seltau or
    the tertau predicate itself. This should come as no surprise,
    given that a word like ``zdani'' in Lojban is a predicate.
    Predicates express relations; so when you're looking for a
    relation to tie together ``le zdani'' and ``le gerku'', the
    most obvious relation to pick is the very relation named by the
    tertau, ``zdani'': the relation between a home and its dweller.
    As a result, the object which fills the first place of
    ``gerku'' (the dog) also fills the second place of ``zdani''
    (the house-dweller).</p>

    <p>The seltau-tertau relationship in the veljvo is expressed by
    the seltau or tertau predicate itself. Therefore, at least one
    of the seltau places is going to be equivalent to a tertau
    place. This place is thus redundant, and can be dropped from
    the place structure of the lujvo. As a corollary, the precise
    relationship between the veljvo components can be implicitly
    determined by finding one or more places to overlap in this
    way.</p>

    <p>So what is the place structure of ``gerzda''? We're left
    with three places, since the dweller, the ``se zdani'', turned
    out to be identical to the dog, the ``gerku''. We can proceed
    as follows:</p>

    <p>(The notation introduced casually in <a href="#s2">Section
    2</a> will be useful in the rest of this chapter. Rather than
    using the regular x1, x2, etc. to represent places, we'll use
    the first letter of the relevant gismu in place of the ``x'',
    or more than one letter where necessary to resolve ambiguities.
    Thus, z1 is the first place of ``zdani'', and g2 is the second
    place of ``gerku''.)</p>

    <p>The place structure of ``zdani'' is given as <a
    href="#e2d1">Example 2.1</a>, but is repeated here using the
    new notation:</p>

    <p></p>
<pre>
<a id="e3d1"
name="e3d1">3.1)</a>  z1 is a nest/house/lair/den of z2
</pre>

    <p>The place structure of ``gerku'' is:</p>
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  g1 is a dog of breed g2
</pre>

    <p>But z2 is the same as g1; therefore, the tentative place
    structure for ``gerzda'' now becomes:</p>
<pre>
<a id="e3d3"
name="e3d3">3.3)</a>  z1 is a house for dweller z2 of breed g2
</pre>
    which can also be written 
<pre>
<a id="e3d4"
name="e3d4">3.4)</a>  z1 is a house for dog g1 of breed g2
</pre>
    or more concisely 
<pre>
<a id="e3d5"
name="e3d5">3.5)</a>  z1 is a house for dweller/dog z2=g1 of breed g2
</pre>

    <p>Despite the apparently conclusive nature of <a
    href="#e3d5">Example 3.5</a>, our task is not yet done: we
    still need to decide whether any of the remaining places should
    also be eliminated, and what order the lujvo places should
    appear in. These concerns will be addressed in the remainder of
    the chapter; but we are now equipped with the terminology
    needed for those discussions.</p>

    <h3><a id="s4" name="s4">4. Selecting places</h3>

    <p>The set of places of an ordinary lujvo are selected from the
    places of its component gismu. More precisely, the places of
    such a lujvo are derived from the set of places of the
    component gismu by eliminating unnecessary places, until just
    enough places remain to give an appropriate meaning to the
    lujvo. In general, including a place makes the concept
    expressed by a lujvo more general; excluding a place makes the
    concept more specific, because omitting the place requires
    assuming a standard value or range of values for it.</p>

    <p>It would be possible to design the place structure of a
    lujvo from scratch, treating it as if it were a gismu, and
    working out what arguments contribute to the notion to be
    expressed by the lujvo. There are two reasons arguing against
    doing so and in favor of the procedure detailed in this
    chapter.</p>

    <p>The first is that it might be very difficult for a hearer or
    reader, who has no preconceived idea of what concept the lujvo
    is intended to convey, to work out what the place structure
    actually is. Instead, he or she would have to make use of a
    lujvo dictionary every time a lujvo is encountered in order to
    work out what a ``se jbopli'' or a ``te klagau'' is. But this
    would mean that, rather than having to learn just the 1300-odd
    gismu place structures, a Lojbanist would also have to learn
    myriads of lujvo place structures with little or no apparent
    pattern or regularity to them. The purpose of the guidelines
    documented in this chapter is to apply regularity and to make
    it conventional wherever possible.</p>

    <p>The second reason is related to the first: if the veljvo of
    the lujvo has not been properly selected, and the places for
    the lujvo are formulated from scratch, then there is a risk
    that some of the places formulated may not correspond to any of
    the places of the gismu used in the veljvo of the lujvo. If
    that is the case --- that is to say, if the lujvo places are
    not a subset of the veljvo gismu places --- then it will be
    very difficult for the hearer or reader to understand what a
    particular place means, and what it is doing in that particular
    lujvo. This is a topic that will be further discussed in <a
    href="#s14">Section 14</a>.</p>

    <p>However, second-guessing the place structure of the lujvo is
    useful in guiding the process of subsequently eliminating
    places from the veljvo. If the Lojbanist has an idea of what
    the final place structure should look like, he or she should be
    able to pick an appropriate veljvo to begin with, in order to
    express the idea, and then to decide which places are relevant
    or not relevant to expressing that idea.</p>

    <h3><a id="s5" name="s5">5. Symmetrical and asymmetrical lujvo</h3>

    <p>A common pattern, perhaps the most common pattern, of
    lujvo-making creates what is called a ``symmetrical lujvo''. A
    symmetrical lujvo is one based on a tanru interpretation such
    that the first place of the seltau is equivalent to the first
    place of the tertau: each component of the tanru characterizes
    the same object. As an illustration of this, consider the lujvo
    ``balsoi'': it is intended to mean ``both great and a soldier''
    --- that is, ``great soldier'', which is the interpretation we
    would tend to give its veljvo, ``banli sonci''. The underlying
    gismu place structures are:</p>
<pre>
<a id="e5d1"
name="e5d1">5.1)</a>  ``banli'': b1 is great in property b2 by standard b3
    ``sonci'': s1 is a soldier of army s2
</pre>

    <p>In this case the s1 place of ``sonci'' is redundant, since
    it is equivalent to the b1 place of ``banli''. Therefore the
    place structure of ``balsoi'' need not include places for both
    s1 and b1, as they refer to the same thing. So the place
    structure of ``balsoi'' is at most</p>
<pre>
<a id="e5d2"
name="e5d2">5.2)</a>  b1=s1 is a great soldier of army s2
        in property b2 by standard b3
</pre>
    Some symmetrical veljvo have further equivalent places in
    addition to the respective first places. Consider the lujvo
    ``tinju'i'', ``to listen'' (``to hear attentively, to hear and
    pay attention''). The place structures of the gismu ``tirna''
    and ``jundi'' are: 

    <p></p>
<pre>
<a id="e5d3"
name="e5d3">5.3)</a>  ``tirna'': t1 listens to t2 against background noise t3
    ``jundi'': j1 pays attention to j2
</pre>
    and the place structure of the lujvo is: 
<pre>
<a id="e5d4"
name="e5d4">5.4)</a>  j1=t1 listens to j2=t2 against background noise t3
</pre>

    <p>Why so? Because not only is the j1 place (the one who pays
    attention) equivalent to the t1 place (the hearer), but the j2
    place (the thing paid attention to) is equivalent to the t2
    place (the thing heard).</p>

    <p>A substantial minority of lujvo have the property that the
    first place of the seltau (``gerku'' in this case) is
    equivalent to a place other than the first place of the tertau;
    such lujvo are said to be ``asymmetrical''. (There is a
    deliberate parallel here with the terms ``asymmetrical tanru''
    and ``symmetrical tanru'' used in <a href="chapter5.html">Chapter
    5</a>.)</p>

    <p>In principle any asymmetrical lujvo could be expressed as a
    symmetrical lujvo. Consider ``gerzda'', discussed in <a
    href="#s3">Section 3</a>, where we learned that the g1 place
    was equivalent to the z2 place. In order to get the places
    aligned, we could convert ``zdani'' to ``se zdani'' (or
    ``selzda'' when expressed as a lujvo). The place structure of
    ``selzda'' is</p>
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  s1 is housed by nest s2
</pre>
    and so the three-part lujvo ``gerselzda'' would have the place
    structure 
<pre>
<a id="e5d6"
name="e5d6">5.6)</a>  s1=g1 is a dog housed in nest s2 of dog breed g2
</pre>

    <p>However, although ``gerselzda'' is a valid lujvo, it doesn't
    translate ``doghouse''; its first place is the dog, not the
    doghouse. Furthermore, it is more complicated than necessary;
    ``gerzda'' is simpler than ``gerselzda''.</p>

    <p>From the reader's or listener's point of view, it may not
    always be obvious whether a newly met lujvo is symmetrical or
    asymmetrical, and if the latter, what kind of asymmetrical
    lujvo. If the place structure of the lujvo isn't given in a
    dictionary or elsewhere, then plausibility must be applied,
    just as in interpreting tanru.</p>

    <p>The lujvo ``karcykla'', for example, is based on ``karce
    klama'', or ``car goer''. The place structure of ``karce''
    is:</p>
<pre>
<a id="e5d7"
name="e5d7">5.7)</a>  ka1 is a car carrying ka2 propelled by ka3
</pre>

    <p>A asymmetrical interpretation of ``karcykla'' that is
    strictly analogous to the place structure of ``gerzda'',
    equating the kl2 (destination) and ka1 (car) places, would lead
    to the place structure</p>
<pre>
<a id="e5d8"
name="e5d8">5.8)</a>  kl1 goes to car kl2=ka1 which carries ka2
        propelled by ka3 from origin kl3
        via route kl4 by means of kl5
</pre>

    <p>But in general we go about in cars, rather than going to
    cars, so a far more likely place structure treats the ka1 place
    as equivalent to the kl5 place, leading to</p>
<pre>
<a id="e5d9"
name="e5d9">5.9)</a>  kl1 goes to destination kl2 from origin kl3
        via route kl4 by means of car kl5=ka1
        carrying ka2 propelled by ka3.
</pre>
    instead. 

    <h3><a id="s6" name="s6">6. Dependent places</h3>

    <p>In order to understand which places, if any, should be
    completely removed from a lujvo place structure, we need to
    understand the concept of dependent places. One place of a
    brivla is said to be dependent on another if its value can be
    predicted from the values of one or more of the other places.
    For example, the g2 place of ``gerku'' is dependent on the g1
    place. Why? Because when we know what fits in the g1 place
    (Spot, let us say, a well-known dog), then we know what fits in
    the g2 place (``St. Bernard'', let us say). In other words,
    when the value of the g1 place has been specified, the value of
    the g2 place is determined by it. Conversely, since each dog
    has only one breed, but each breed contains many dogs, the g1
    place is not dependent on the g2 place; if we know only that
    some dog is a St. Bernard, we cannot tell by that fact alone
    which dog is meant.</p>

    <p>For ``zdani'', on the other hand, there is no dependency
    between the places. When we know the identity of a
    house-dweller, we have not determined the house, because a
    dweller may dwell in more than one house. By the same token,
    when we know the identity of a house, we do not know the
    identity of its dweller, for a house may contain more than one
    dweller.</p>

    <p>The rule for eliminating places from a lujvo is that
    dependent places provided by the seltau are eliminated.
    Therefore, in ``gerzda'' the dependent g2 place is removed from
    the tentative place structure given in <a href="#e3d5">Example
    3.5</a>, leaving the place structure:</p>
<pre>
<a id="e6d1"
name="e6d1">6.1)</a>  z1 is the house dwelt in by dog z2=g1
</pre>

    <p>Informally put, the reason this has happened --- and it
    happens a lot with seltau places --- is that the third place
    was describing not the doghouse, but the dog who lives in it.
    The sentence</p>

    <p></p>
<pre>
<a id="e6d2" name="e6d2">6.2)</a>  la mon. rePOS. gerzda la spat.
    Mon Repos is a doghouse of Spot.
</pre>
    really means 
<pre>
<a id="e6d3"
name="e6d3">6.3)</a>  la mon. rePOS. zdani la spat. noi gerku
    Mon Repos is a house of Spot, who is a dog.
</pre>
    since that is the interpretation we have given ``gerzda''. But
    that in turn means 

    <p></p>
<pre>
<a id="e6d4"
name="e6d4">6.4)</a>  la mon. rePOS. zdani la spat noi ke'a gerku zo'e
    Mon Repos is a house of Spot, who is a dog
        of unspecified breed.
</pre>

    <p>Specifically,</p>
<pre>
<a id="e6d5" name="e6d5">6.5)</a>  la mon. rePOS. zdani la spat.
        noi ke'a gerku la sankt. berNARD.
    Mon Repos is a house of Spot,
        who is a dog of breed St. Bernard.
</pre>
    and in that case, it makes little sense to say 
<pre>
<a id="e6d6" name="e6d6">6.6)</a>  la mon. rePOS. gerzda la spat.
        noi ke'a gerku la sankt. berNARD. ku'o
        la sankt. berNARD.
    Mon Repos is a doghouse of Spot,
        who is a dog of breed St. Bernard,
        of breed St. Bernard.
</pre>
    employing the over-ample place structure of <a
    href="#e3d5">Example 3.5</a>. The dog breed is redundantly
    given both in the main selbri and in the relative clause, and
    (intuitively speaking) is repeated in the wrong place, since
    the dog breed is supplementary information about the dog, and
    not about the doghouse. 

    <p>As a further example, take ``cakcinki'', the lujvo for
    ``beetle'', based on the tanru ``calku cinki'', or
    ``shell-insect''. The gismu place structures are:</p>

    <p></p>
<pre>
<a id="e6d7"
name="e6d7">6.7)</a>  ``calku'': ca1 is a shell/husk around ca2 made of ca3
    ``cinki'': ci1 is an insect/arthropod of species ci2
</pre>
    This example illustrates a cross-dependency between a place of
    one gismu and a place of the other. The ca3 place is dependent
    on ci1, because all insects (which fit into ci1) have shells
    made of chitin (which fits into ca3). Furthermore, ca1 is
    dependent on ci1 as well, because each insect has only a single
    shell. And since ca2 (the thing with the shell) is equivalent
    to ci1 (the insect), the place structure is 
<pre>
<a id="e6d8"
name="e6d8">6.8)</a>  ci1=ca2 is a beetle of species ci2
</pre>
    with not a single place of ``calku'' surviving independently! 

    <p>(Note that there is nothing in this explanation that tells
    us just why ``cakcinki'' means ``beetle'' (member of
    Coleoptera), since all insects in their adult forms have chitin
    shells of some sort. The answer, which is in no way
    predictable, is that the shell is a prominent, highly
    noticeable feature of beetles in particular.)</p>

    <p>What about the dependency of ci2 on ci1? After all, no
    beetle belongs to more than one species, so it would seem that
    the ci2 place of ``cakcinki'' could be eliminated on the same
    reasoning that allowed us to eliminate the g2 place of
    ``gerzda'' above. However, it is a rule that dependent places
    are not eliminated from a lujvo when they are derived from the
    tertau of its veljvo. This rule is imposed to keep the place
    structures of lujvo from drifting too far from the tertau place
    structure; if a place is necessary in the tertau, it's treated
    as necessary in the lujvo as well.</p>

    <p>In general, the desire to remove places coming from the
    tertau is a sign that the veljvo selected is simply wrong.
    Different place structures imply different concepts, and the
    lujvo maker may be trying to shoehorn the wrong concept into
    the place structure of his or her choosing. This is obvious
    when someone tries to shoe-horn a ``klama'' tertau into a
    ``litru'' or ``cliva'' concept, for example: these gismu differ
    in their number of arguments, and suppressing places of
    ``klama'' in a lujvo doesn't make any sense if the resulting
    modified place structure is that of ``litru'' or ``cliva''.</p>

    <p>Sometimes the dependency is between a single place of the
    tertau and the whole event described by the seltau. Such cases
    are discussed further in <a href="#s13">Section 13</a>.</p>

    <p>Unfortunately, not all dependent places in the seltau can be
    safely removed: some of them are necessary to interpreting the
    lujvo's meaning in context. It doesn't matter much to a
    doghouse what breed of dog inhabits it, but it can make quite a
    lot of difference to the construction of a school building what
    kind of school is in it! Music schools need auditoriums and
    recital rooms, elementary schools need playgrounds, and so on:
    therefore, the place structure of ``kuldi'u'' (from ``ckule
    dinju'', and meaning ``school building'') needs to be</p>
<pre>
<a id="e6d9"
name="e6d9">6.9)</a>  d1 is a building housing school c1
        teaching subject c3 to audience c4
</pre>
    even though c3 and c4 are plainly dependent on c1. The other
    places of ``ckule'', the location (c2) and operators (c5),
    don't seem to be necessary to the concept ``school building'',
    and are dependent on c1 to boot, so they are omitted. Again,
    the need for case-by-case consideration of place structures is
    demonstrated. 

    <h3><a id="s7" name="s7">7. Ordering lujvo places.</h3>

    <p>So far, we have concentrated on selecting the places to go
    into the place structure of a lujvo. However, this is only half
    the story. In using selbri in Lojban, it is important to
    remember the right order of the sumti. With lujvo, the need to
    attend to the order of sumti becomes critical: the set of
    places selected should be ordered in such a way that a reader
    unfamiliar with the lujvo should be able to tell which place is
    which.</p>

    <p>If we aim to make understandable lujvo, then, we should make
    the order of places in the place structure follow some
    conventions. If this does not occur, very real ambiguities can
    turn up. Take for example the lujvo ``jdaselsku'', meaning
    ``prayer''. In the sentence</p>

    <p></p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  di'e jdaselsku la dong.
    This-utterance is-a-prayer somehow-related-to-Dong.
</pre>
    we must be able to know if Dong is the person making the
    prayer, giving the meaning 
<pre>
<a id="e7d2" name="e7d2">7.2)</a>  This is a prayer by Dong
</pre>
    or is the entity being prayed to, resulting in 
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  This is a prayer to Dong
</pre>

    <p>We could resolve such problems on a case-by-case basis for
    each lujvo (<a href="#s14">Section 14</a> discusses when this
    is actually necessary), but case-by-case resolution for
    run-of-the-mill lujvo makes the task of learning lujvo place
    structures unmanageable. People need consistent patterns to
    make sense of what they learn. Such patterns can be found
    across gismu place structures (see <a href="#s16">Section
    16</a>), and are even more necessary in lujvo place structures.
    Case-by-case consideration is still necessary; lujvo creation
    is a subtle art, after all. But it is helpful to take advantage
    of any available regularities.</p>

    <p>We use two different ordering rules: one for symmetrical
    lujvo and one for asymmetrical ones. A symmetrical lujvo like
    ``balsoi'' (from <a href="#s5">Section 5</a>) has the places of
    its tertau followed by whatever places of the seltau survive
    the elimination process. For ``balsoi'', the surviving places
    of ``banli'' are b2 and b3, leading to the place structure:</p>
<pre>
<a id="e7d4"
name="e7d4">7.4)</a>  b1=s1 is a great soldier of army s2
        in property b2 by standard b3
</pre>
    just what appears in <a href="#e5d1">Example 5.1</a>. In fact,
    all place structures shown until now have been in the correct
    order by the conventions of this section, though the fact has
    been left tacit until now. 

    <p>The motivation for this rule is the parallelism between the
    lujvo bridi-schema</p>
<pre>
<a id="e7d5" name="e7d5">7.5)</a>  b1 bansoi s2 b2 b3
    b1 is-a-great-soldier of-army-s2
        in-property-b2 by-standard-b3
</pre>
    and the more or less equivalent bridi-schema 
<pre>
<a id="e7d6" name="e7d6">7.6)</a>  b1 sonci s2 gi'e banli b2 b3
    b1 is-a-soldier of-army-s2 and
        is-great in-property-b2
        by-standard-b3
</pre>
    where ``gi'e'' is the Lojban word for ``and'' when placed
    between two partial bridi, as explained in <a
    href="chapter14.html">Chapter 14</a>. 

    <p>Asymmetrical lujvo like ``gerzda'', on the other hand,
    employ a different rule. The seltau places are inserted not at
    the end of the place structure, but rather immediately after
    the tertau place which is equivalent to the first place of the
    seltau. Consider ``dalmikce'', meaning ``veterinarian'': its
    veljvo is ``danlu mikce'', or ``animal doctor''. The place
    structures for those gismu are:</p>

    <p></p>
<pre>
<a id="e7d7"
name="e7d7">7.7)</a>  ``danlu'': d1 is an animal of species d2
    ``mikce'': m1 is a doctor to patient m2 for ailment m3
        using treatment m4
</pre>
    and the lujvo place structure is: 
<pre>
<a id="e7d8"
name="e7d8">7.8)</a>  m1 is a doctor for animal m2=d1 of species d2
        for ailment m3 using treatment m4
</pre>
    Since the shared place is m2=d1, the animal patient, the
    remaining seltau place d2 is inserted immediately after the
    shared place; then the remaining tertau places form the last
    two places of the lujvo. 

    <h3><a id="s8" name="s8">8. lujvo with more than two parts.</h3>

    <p>The theory we have outlined so far is an account of lujvo
    with two parts. But often lujvo are made containing more than
    two parts. An example is ``bavlamdei'', ``tomorrow'': it is
    composed of the rafsi for ``future'', ``adjacent'', and
    ``day''. How does the account we have given apply to lujvo like
    this?</p>

    <p>The best way to approach such lujvo is to continue to
    classify them as based on binary tanru, the only difference
    being that the seltau or the tertau or both is itself a lujvo.
    So it is easiest to make sense of ``bavlamdei'' as having two
    components: ``bavla'i'', ``next'', and ``djedi''. If we know or
    invent the lujvo place structure for the components, we can
    compose the new lujvo place structure in the usual way.</p>

    <p>In this case, ``bavla'i'' is given the place structure</p>
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  b1=l1 is next after b2=l2
</pre>
    making it a symmetrical lujvo. We combine this with ``djedi'',
    which has the place structure: 
<pre>
<a id="e8d2"
name="e8d2">8.2)</a>  duration d1 is d2 days long (default 1)
        by standard d3
</pre>
    While symmetrical lujvo normally put any trailing tertau places
    before any seltau places, the day standard is a much less
    important concept than the day the tomorrow follows, in the
    definition of ``bavlamdei''. This is an example of how the
    guidelines presented for selecting and ordering lujvo places
    are just that, not laws that must be rigidly adhered to. In
    this case, we choose to rank places in order of relative
    importance. The resulting place structure is: 
<pre>
<a id="e8d3"
name="e8d3">8.3)</a>  d1=b1=l1 is a day following b2=l2,
        d2 days later (default 1) by standard d3
</pre>
    Here is another example of a multi-part lujvo: ``cladakyxa'i'',
    meaning ``long-sword'', a specific type of medieval weapon. The
    gismu place structures are: 
<pre>
<a id="e8d4"
name="e8d4">8.4)</a>  ``clani'': c1 is long in direction c2 by standard c3
    ``dakfu'': d1 is a knife for cutting d2
        with blade made of d3
    ``xarci'': xa1 is a weapon for use against xa2
        by wielder xa3
</pre>
    Since ``cladakyxa'i'' is a symmetrical lujvo based on
    ``cladakfu xarci'', and ``cladakfu'' is itself a symmetrical
    lujvo, we can do the necessary analyses all at once. Plainly c1
    (the long thing), d1 (the knife), and xa1 (the weapon) are all
    the same. Likewise, the d2 place (the thing cut) is the same as
    the xa2 place (the target of the weapon), given that swords are
    used to cut victims. Finally, the c2 place (direction of
    length) is always along the sword blade in a longsword, by
    definition, and so is dependent on c1=d1=xa1. Adding on the
    places of the remaining gismu in right-to-left order we get: 
<pre>
<a id="e8d5"
name="e8d5">8.5)</a>  xa1=d1=c1 is a long-sword for use against xa2=d2
        by wielder xa3, with a blade made of d3,
        long measured by standard c3.
</pre>

    <p>If the last place sounds unimportant to you, notice that
    what counts legally as a ``sword'', rather than just a
    ``knife'', depends on the length of the blade (the cutoff point
    varies in different jurisdictions). This fifth place of
    ``cladakyxa'i'' may not often be explicitly filled, but it is
    still useful on occasion. Because it is so seldom important, it
    is best that it be last.</p>

    <h3><a id="s9" name="s9">9. Eliding SE rafsi from seltau</h3>

    <p>It is common to form lujvo that omit the rafsi based on
    cmavo of selma'o SE, as well as other cmavo rafsi. Doing so
    makes lujvo construction for common or useful constructions
    shorter. Since it puts more strain on the listener who has not
    heard the lujvo before, the shortness of the word should not
    necessarily outweigh ease in understanding, especially if the
    lujvo refers to a rare or unusual concept.</p>

    <p>Consider as an example the lujvo ``ti'ifla'', from the
    veljvo ``stidi flalu'', and meaning ``bill, proposed law''. The
    gismu place structures are:</p>
<pre>
<a id="e9d1"
name="e9d1">9.1)</a>  ``stidi'': agent st1 suggests idea/action st2
        to audience st3
    ``flalu'': f1 is a law specifying f2 for community f3
        under conditions f4 by lawgiver f5
</pre>
    This lujvo does not fit any of our existing molds: it is the
    second seltau place, st2, that is equivalent to one of the
    tertau places, namely f1. However, if we understand ``ti'ifla''
    as an abbreviation for the lujvo ``selti'ifla'', then we get
    the first places of seltau and tertau lined up. The place
    structure of ``selti'i'' is: 

    <dl>
      <dt></dt>

      <dd><a id="e9d2" name="e9d2">9.2)</a> ``selti'i'':
      idea/action se1 is suggested by agent se2 to audience
      se3</dd>
    </dl>

    <p>Here we can see that se1 (what is suggested) is equivalent
    to f1 (the law), and we get a normal symmetrical lujvo. The
    final place structure is:</p>
<pre>
<a id="e9d3"
name="e9d3">9.3)</a>  f1=se1 is a bill specifying f2 for community f3
        under conditions f4 by suggester se2
        to audience/lawgivers f5=se3
</pre>
    or, relabeling the places, 
<pre>
<a id="e9d4"
name="e9d4">9.4)</a>  f1=st2 is a bill specifying f2 for community f3
        under conditions f4 by suggester st1
        to audience/lawgivers f5=st3
</pre>
    where the last place (st3) is probably some sort of
    legislature. 

    <p>Abbreviated lujvo like ``ti'ifla'' are more intuitive (for
    the lujvo-maker) than their more explicit counterparts like
    ``selti'ifla'' (as well as shorter). They don't require the
    coiner to sit down and work out the precise relation between
    the seltau and the tertau: he or she can just rattle off a
    rafsi pair. But should the lujvo get to the stage where a place
    structure needs to be worked out, then the precise relation
    does need to be specified. And in that case, such abbreviated
    lujvo form a trap in lujvo place ordering, since they obscure
    the most straightforward relation between the seltau and
    tertau. To give our lujvo-making guidelines as wide an
    application as possible, and to encourage analyzing the
    seltau-tertau relation in lujvo, lujvo like ``ti'ifla'' are
    given the place structure they would have with the appropriate
    SE added to the seltau.</p>

    <p>Note that, with these lujvo, an interpretation requiring SE
    insertion is safe only if the alternatives are either
    implausible or unlikely to be needed as a lujvo. This may not
    always be the case, and Lojbanists should be aware of the risk
    of ambiguity.</p>

    <h3><a id="s10" name="s10">10. Eliding SE rafsi from tertau</h3>

    <p>Eliding SE rafsi from tertau gets us into much more trouble.
    To understand why, recall that lujvo, following their veljvo,
    describe some type of whatever their tertau describe. Thus,
    ``posydji'' describes a type of ``djica'', ``gerzda'' describes
    a type of ``zdani'', and so on. What is certain is that
    ``gerzda'' does not describe a ``se zdani'' --- it is not a
    word that could be used to describe an inhabitant such as a
    dog.</p>

    <p>Now consider how we would translate the word ``blue-eyed''.
    Let's tentatively translate this word as ``blakanla'' (from
    ``blanu kanla'', meaning ``blue eye''). But immediately we are
    in trouble: we cannot say</p>
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    la djak. cu blakanla
    Jack is-a-blue-eye
</pre>
    because Jack is not an eye, ``kanla'', but someone with an eye,
    ``se kanla''. At best we can say 
<pre>
<a id="e10d2" name="e10d2">10.2)</a>    la djak. cu se blakanla
    Jack is-the-bearer-of-blue-eyes
</pre>

    <p>But look now at the place structure of ``blakanla'': it is a
    symmetrical lujvo, so the place structure is:</p>
<pre>
<a id="e10d3"
name="e10d3">10.3)</a>    xe1=s1 is a blue eye of xe2=s2
</pre>

    <p>We end up being most interested in talking about the second
    place, not the first (we talk much more of people than of their
    eyes), so ``se'' would almost always be required.</p>

    <p>What is happening here is that we are translating the tertau
    wrongly, under the influence of English. The English suffix
    ``-eyed'' does not mean ``eye'', but someone with an eye, which
    is ``selkanla''.</p>

    <p>Because we've got the wrong tertau (eliding a ``se'' that
    really should be there), any attempt to accommodate the
    resulting lujvo into our guidelines for place structure is
    fitting a square peg in a round hole. Since they can be so
    misleading, lujvo with SE rafsi elided from the tertau should
    be avoided in favor of their more explicit counterparts: in
    this case, ``blaselkanla''.</p>

    <h3><a id="s11" name="s11">11. Eliding KE and KEhE rafsi from lujvo</h3>

    <p>People constructing lujvo usually want them to be as short
    as possible. To that end, they will discard any cmavo they
    regard as niceties. The first such cmavo to get thrown out are
    usually ``ke'' and ``ke'e'', the cmavo used to structure and
    group tanru. We can usually get away with this, because the
    interpretation of the tertau with ``ke'' and ``ke'e'' missing
    is less plausible than that with the cmavo inserted, or because
    the distinction isn't really important.</p>

    <p>For example, in ``bakrecpa'o'', meaning ``beefsteak'', the
    veljvo is</p>

    <p></p>
<pre>
<a id="e11d1"
name="e11d1">11.1)</a>    [ke] bakni rectu [ke'e] panlo
    ( bovine meat ) slice
</pre>
    because of the usual Lojban left-grouping rule. But there
    doesn't seem to be much difference between that veljvo and 

    <p></p>
<pre>
<a id="e11d2" name="e11d2">11.2)</a>    bakni ke rectu panlo [ke'e]
    bovine ( meat slice )
</pre>
    On the other hand, the lujvo ``zernerkla'', meaning ``to sneak
    in'', almost certainly was formed from the veljvo 
<pre>
<a id="e11d3" name="e11d3">11.3)</a>    zekri ke nenri klama [ke'e]
    crime ( inside go )
    to go within, criminally
</pre>
    because the alternative, 
<pre>
<a id="e11d4"
name="e11d4">11.4)</a>    [ke] zekri nenri [ke'e] klama
    (crime inside) go
</pre>
    doesn't make much sense. (To go to the inside of a crime? To go
    into a place where it is criminal to be inside --- an
    interpretation almost identical with <a href="#e11d3">Example
    11.3</a> anyway?) 

    <p>There are cases, however, where omitting a KE or KEhE rafsi
    can produce another lujvo, equally useful. For example,
    ``xaskemcakcurnu'' means ``oceanic shellfish'', and has the
    veljvo</p>

    <p></p>
<pre>
<a id="e11d5" name="e11d5">11.5)</a>    xamsi ke calku curnu
    ocean type-of (shell worm)
</pre>
    (``worm'' in Lojban refers to any invertebrate), but
    ``xascakcurnu'' has the veljvo 

    <p></p>
<pre>
<a id="e11d6"
name="e11d6">11.6)</a>    [ke] xamsi calku [ke'e] curnu
    (ocean shell) type-of worm
</pre>
    and might refer to the parasitic worms that infest clamshells. 

    <p>Such misinterpretation is more likely than not in a lujvo
    starting with ``sel-'' (from ``se''), ``nal-'' (from ``na'e'')
    or ``tol-'' (from ``to'e''): the scope of the rafsi will
    likeliest be presumed to be as narrow as possible, since all of
    these cmavo normally bind only to the following brivla or ``ke
    ... ke'e'' group. For that reason, if we want to modify an
    entire lujvo by putting ``se'', ``na'e'' or ``to'e'' before it,
    it's better to leave the result as two words, or else to insert
    ``ke'', than to just stick the SE or NAhE rafsi on.</p>

    <p>It is all right to replace the phrase ``se klama'' with
    ``selkla'', and the places of ``selkla'' are exactly those of
    ``se klama''. But consider the related lujvo ``dzukla'',
    meaning ``to walk to somewhere''. It is a symmmetrical lujvo,
    derived from the veljvo ``cadzu klama'' as follows:</p>
<pre>
<a id="e11d7"
name="e11d7">11.7)</a>    ``cadzu'': c1 walks on surface c2 using limbs c3
    ``klama'': k1 goes to k2 from k3 via route k4 using k5
    ``dzukla'': c1=k1 walks to k2 from k3 via route k4
        using limbs k5=c3 on surface c2
</pre>

    <p>We can swap the k1 and k2 places using ``se dzukla'', but we
    cannot directly make ``se dzukla'' into ``seldzukla'', which
    would represent the veljvo ``selcadzu klama'' and plausibly
    mean something like ``to go to a walking surface''. Instead, we
    would need ``selkemdzukla'', with an explicit rafsi for ``ke''.
    Similarly, ``nalbrablo'' (from ``na'e barda bloti'') means
    ``non-big boat'', whereas ``na'e brablo'' means ``other than a
    big boat''.</p>

    <p>If the lujvo we want to modify with SE has a seltau already
    starting with a SE rafsi, we can take a shortcut. For instance,
    ``gekmau'' means ``happier than'', while ``selgekmau'' means
    ``making people happier than, more enjoyable than, more of a
    'se gleki' than''. If something is less enjoyable than
    something else, we can say it is ``se selgekmau''.</p>

    <p>But we can also say it is ``selselgekmau''. Two ``se'' cmavo
    in a row cancel each other (``se se gleki'' means the same as
    just ``gleki''), so there would be no good reason to have
    ``selsel'' in a lujvo with that meaning. Instead, we can feel
    free to interpret ``selsel-'' as ``selkemsel-''. The rafsi
    combinations ``terter-'', ``velvel-'' and ``xelxel-'' work in
    the same way.</p>

    <p>Other SE combinations like ``selter-'', although they might
    conceivably mean ``se te'', more than likely should be
    interpreted in the same way, namely as ``se ke te'', since
    there is no need to re-order places in the way that ``se te''
    provides. (See <a href="chapter9.html">Chapter 9</a>.)</p>

    <h3><a id="s12" name="s12">12. Abstract lujvo</h3>

    <p>The cmavo of NU can participate in the construction of lujvo
    of a particularly simple and well-patterned kind. Consider that
    old standard example, ``klama'':</p>
<pre>
<a id="e12d1"
name="e12d1">12.1)</a>    k1 comes/goes to k2 from k3 via route k4 by means k5.
</pre>

    <p>The selbri ``nu klama [kei]'' has only one place, the
    event-of-going, but the full five places exist implicitly
    between ``nu'' and ``kei'', since a full bridi with all sumti
    may be placed there. In a lujvo, there is no room for such
    inside places, and consequently the lujvo ``nunkla'' (``nun-''
    is the rafsi for ``nu''), needs to have six places:</p>
<pre>
<a id="e12d2"
name="e12d2">12.2)</a>    nu1 is the event of k1's coming/going to k2 from k3
        via route k4 by means k5.
</pre>

    <p>Here the first place of ``nunklama'' is the first and only
    place of ``nu'', and the other five places have been pushed
    down by one to occupy the second through the sixth places. Full
    information on ``nu'', as well as the other abstractors
    mentioned in this section, is given in <a
    href="chapter11.html">Chapter 11</a>.</p>

    <p>For those abstractors which have a second place as well, the
    standard convention is to place this place after, rather than
    before, the places of the brivla being abstracted. The place
    structure of ``nilkla'', the lujvo derived from ``ni klama'',
    is the imposing:</p>
<pre>
<a id="e12d3"
name="e12d3">12.3)</a>    ni1 is the amount of k1's coming/going to k2 from k3
        via route k4 by means k5, measured on scale ni2.
</pre>

    <p>It is not uncommon for abstractors to participate in the
    making of more complex lujvo as well. For example,
    ``nunsoidji'', from the veljvo</p>
<pre>
<a id="e12d4" name="e12d4">12.4)</a>    nu sonci kei djica
    event-of being-a-soldier desirer
</pre>
    has the place structure 
<pre>
<a id="e12d5"
name="e12d5">12.5)</a>    d1 desires the event of (s1 being a soldier of army s2)
        for purpose d3
</pre>
    where the d2 place has disappeared altogether, being replaced
    by the places of the seltau. As shown in <a
    href="#e12d5">Example 12.5</a>, the ordering follows this idea
    of replacement: the seltau places are inserted at the point
    where the omitted abstraction place exists in the tertau. 

    <p>The lujvo ``nunsoidji'' is quite different from the ordinary
    asymmetric lujvo ``soidji'', a ``soldier desirer'', whose place
    structure is just</p>
<pre>
<a id="e12d6"
name="e12d6">12.6)</a>    d1 desires (a soldier of army s2) for purpose d3
</pre>

    <p>A ``nunsoidji'' might be someone who is about to enlist,
    whereas a ``soidji'' might be a camp-follower.</p>

    <p>One use of abstract lujvo is to eliminate the need for
    explicit ``kei'' in tanru: ``nunkalri gasnu'' means much the
    same as ``nu kalri kei gasnu'', but is shorter. In addition,
    many English words ending in ``-hood'' are represented with
    ``nun-'' lujvo, and other words ending in ``-ness'' or ``-dom''
    are often representable with ``kam-'' lujvo (``kam-'' is the
    rafsi for ``ka''); ``kambla'' is ``blueness''.</p>

    <p>Even though the cmavo of NU are long-scope in nature,
    governing the whole following bridi, the NU rafsi should
    generally be used as short-scope modifiers, like the SE and
    NAhE rafsi discussed in <a href="#s9">Section 9</a>.</p>

    <p>There is also a rafsi for the cmavo ``jai'', namely ``jax'',
    which allows sentences like</p>

    <p></p>
<pre>
<a id="e12d7" name="e12d7">12.7)</a>    mi jai rinka le nu do morsi
    I am-associated-with causing the event-of your death.
    I cause your death.
</pre>
    explained in <a href="chapter11.html">Chapter 11</a>, to be
    rendered with lujvo: 
<pre>
<a id="e12d8" name="e12d8">12.8)</a>    mi jaxri'a le nu do morsi
    I am-part-of-the-cause-of the event-of your dying.
</pre>
    In making a lujvo that contains ``jax-'' for a selbri that
    contains ``jai'', the rule is to leave the ``fai'' place as a
    ``fai'' place of the lujvo; it does not participate in the
    regular lujvo place structure. (The use of ``fai'' is also
    explained in <a href="chapter11.html">Chapter 11</a>.) 

    <h3><a id="s13" name="s13">13. Implicit-abstraction lujvo</h3>

    <p>Eliding NU rafsi involves the same restrictions as eliding
    SE rafsi, plus additional ones. In general, NU rafsi should not
    be elided from the tertau, since that changes the kind of thing
    the lujvo is talking about from an abstraction to a concrete
    sumti. However, they may be elided from the seltau if no
    reasonable ambiguity would result.</p>

    <p>A major difference, however, between SE elision and NU
    elision is that the former is a rather sparse process,
    providing a few convenient shortenings. Eliding ``nu'',
    however, is extremely important in producing a class of lujvo
    called ``implicit-abstraction lujvo''.</p>

    <p>Let us make a detailed analysis of the lujvo
    ``nunctikezgau'', meaning ``to feed''. (If you think this lujvo
    is excessively longwinded, be patient.) The veljvo of
    ``nunctikezgau'' is ``nu citka kei gasnu''. The relevant place
    structures are:</p>
<pre>
<a id="e13d1" name="e13d1">13.1)</a>    ``nu'': n1 is an event
    ``citka'': c1 eats c2
    ``gasnu'': g1 does action/is the agent of event g2
</pre>

    <p>In accordance with the procedure for analyzing three-part
    lujvo given in <a href="#s8">Section 8</a>, we will first
    create an intermediate lujvo, ``nuncti'', whose veljvo is ``nu
    citka [kei]''. By the rules given in <a href="#s12">Section
    12</a>, ``nuncti'' has the place structure</p>
<pre>
<a id="e13d2"
name="e13d2">13.2)</a>    n1 is the event of c1 eating c2
</pre>
    Now we can transform the veljvo of ``nunctikezgau'' into
    ``nuncti gasnu''. The g2 place (what is brought about by the
    actor g1) obviously denotes the same thing as n1 (the event of
    eating). So we can eliminate g2 as redundant, leaving us with a
    tentative place structure of 
<pre>
<a id="e13d3"
name="e13d3">13.3)</a>    g1 is the actor in the event n1=g2 of c1 eating c2
</pre>

    <p>But it is also possible to omit the n1 place itself! The n1
    place describes the event brought about; an event in Lojban is
    described as a bridi, by a selbri and its sumti; the selbri is
    already known (it's the seltau), and the sumti are also already
    known (they're in the lujvo place structure). So n1 would not
    give us any information we didn't already know. In fact, the
    n1=g2 place is dependent on c1 and c2 jointly --- it does not
    depend on either c1 or c2 by itself. Being dependent and
    derived from the seltau, it is omissible. So the final place
    structure of ``nunctikezgau'' is:</p>
<pre>
<a id="e13d4"
name="e13d4">13.4)</a>    g1 is the actor in the event of c1 eating c2
</pre>
    There is one further step that can be taken. As we have already
    seen with ``balsoi'' in <a href="#s5">Section 5</a>, the
    interpretation of lujvo is constrained by the semantics of
    gismu and of their sumti places. Now, any asymmetrical lujvo
    with ``gasnu'' as its tertau will involve an event abstraction
    either implicitly or explicitly, since that is how the g2 place
    of ``gasnu'' is defined. 

    <p>Therefore, if we assume that ``nu'' is the type of
    abstraction one would expect to be a ``se gasnu'', then the
    rafsi ``nun'' and ``kez'' in ``nunctikezgau'' are only telling
    us what we would already have guessed --- that the seltau of a
    ``gasnu'' lujvo is an event. If we drop these rafsi out, and
    use instead the shorter lujvo ``ctigau'', rejecting its
    symmetrical interpretation (``someone who both does and eats'';
    ``an eating doer''), we can still deduce that the seltau refers
    to an event.</p>

    <p>(You can't ``do an eater''/``gasnu lo citka'', with the
    meaning of ``do'' as ``bring about an event''; so the seltau
    must refer to an event, ``nu citka''. The English slang
    meanings of ``do someone'', namely ``socialize with someone''
    and ``have sex with someone'', are not relevant to
    ``gasnu''.)</p>

    <p>So we can simply use ``ctigau'' with the same place
    structure as ``nunctikezgau'':</p>
<pre>
<a id="e13d5"
name="e13d5">13.5)</a>    agent g1 causes c1 to eat c2
    g1 feeds c2 to c1.
</pre>
    This particular kind of asymmetrical lujvo, in which the seltau
    serves as the selbri of an abstraction which is a place of the
    tertau, is called an implicit-abstraction lujvo, because one
    deduces the presence of an abstraction which is unexpressed
    (implicit). 

    <p>To give another example: the gismu ``basti'', whose place
    structure is</p>
<pre>
<a id="e13d6"
name="e13d6">13.6)</a>    b1 replaces b2 in circumstances b3
</pre>
    can form the lujvo ``basygau'', with the place structure: 
<pre>
<a id="e13d7"
name="e13d7">13.7)</a>    g1 (agent) replaces b1 with b2 in circumstances b3
</pre>
    where both ``basti'' and ``basygau'' are translated ``replace''
    in English, but represent different relations: ``basti'' may be
    used with no mention of any agent doing the replacing. 

    <p>In addition, ``gasnu''-based lujvo can be built from what we
    would consider nouns or adjectives in English. In Lojban,
    everything is a predicate, so adjectives, nouns and verbs are
    all treated in the same way. This is consistent with the use of
    similar causative affixes in other languages. For example, the
    gismu ``litki'', meaning ``liquid'', with the place
    structure</p>

    <p></p>
<pre>
<a id="e13d8"
name="e13d8">13.8)</a>    l1 is a quantity of liquid of composition l2
        under conditions l3
</pre>
    can give ``likygau'', meaning ``to liquefy'': 
<pre>
<a id="e13d9"
name="e13d9">13.9)</a>    g1 (agent) causes l1 to be a quantity of liquid
        of composition l2 under conditions l3.
</pre>

    <p>While ``likygau'' correctly represents ``causes to be a
    liquid'', a different lujvo based on ``galfi'' (meaning
    ``modify'') may be more appropriate for ``causes to become a
    liquid''. On the other hand, ``fetsygau'' is unsafe, because it
    could mean ``agent in the event of something becoming female''
    (the implicit-abstraction interpretation) or simply ``female
    agent'' (the parallel interpretation), so using
    implicit-abstraction lujvo is always accompanied with some risk
    of being misunderstood.</p>

    <p>Many other Lojban gismu have places for event abstractions,
    and therefore are good candidates for the tertau of an
    implicit-abstraction lujvo. For example, lujvo based on
    ``rinka'', with its place structure</p>
<pre>
<a id="e13d10"
name="e13d10">13.10)</a>  event r1 causes event r2 to occur
</pre>
    are closely related to those based on ``gasnu''. However,
    ``rinka'' is less generally useful than ``gasnu'', because its
    r1 place is another event rather than a person: ``lo rinka'' is
    a cause, not a causer. Thus the place structure of
    ``likyri'a'', a lujvo analogous to ``likygau'', is 
<pre>
<a id="e13d11"
name="e13d11">13.11)</a>  event r1 causes l1 to be a quantity of liquid
        of composition l2 under conditions l3
</pre>
    and would be useful in translating sentences like ``The heat of
    the sun liquefied the block of ice.'' 

    <p>Implicit-abstraction lujvo are a powerful means in the
    language of rendering quite verbose bridi into succinct and
    manageable concepts, and increasing the expressive power of the
    language.</p>

    <h3><a id="s14" name="s14">14. Anomalous lujvo</h3>

    <p>Some lujvo that have been coined and actually employed in
    Lojban writing do not follow the guidelines expressed above,
    either because the places that are equivalent in the seltau and
    the tertau are in an unusual position, or because the seltau
    and tertau are related in a complex way, or both. An example of
    the first kind is ``jdaselsku'', meaning ``prayer'', which was
    mentioned in <a href="#s7">Section 7</a>. The gismu places
    are:</p>

    <p></p>
<pre>
<a id="e14d1"
name="e14d1">14.1)</a>    ``lijda'': l1 is a religion with believers l2
        and beliefs l3
    ``cusku'': c1 expresses text c2 to audience c3
        in medium c4
</pre>
    and ``selsku'', the tertau of ``jdaselsku'', has the place
    structure 
<pre>
<a id="e14d2"
name="e14d2">14.2)</a>    s1 is a text expressed by s2 to audience s3
        in medium s4
    
Now it is easy to see that the l2 and s2 places are equivalent:  the
believer in the religion (l2) is the one who expresses the prayer (s2).
This is not one of the cases for which a place ordering rule has been
given in <a href="#s7">Section 7</a> or <a
href="#s13">Section 13</a>; therefore, for lack of a better rule,
we put the tertau places first and the remaining seltau places after them,
leading to the place structure:

<a id="e14d3"
name="e14d3">14.3)</a> s1 is a prayer expressed by s2=l2 to audience s3
        in medium s4 pertaining to religion l1
</pre>

    <p>The l3 place (the beliefs of the religion) is dependent on
    the l1 place (the religion) and so is omitted.</p>

    <p>We could make this lujvo less messy by replacing it with
    ``se seljdasku'', where ``seljdasku'' is a normal symmetrical
    lujvo with place structure:</p>
<pre>
<a id="e14d4" name="e14d4">14.4)</a>    c1=l2 religiously expresses
        prayer c2 to audience c3
        in medium s4 pertaining to religion l1
</pre>
    which, according to the rule expressed in <a href="#s9">Section
    9</a>, can be further expressed as ``selseljdasku''. However,
    there is no need for the ugly ``selsel-'' prefix just to get
    the rules right: ``jdaselsku'' is a reasonable, if anomalous,
    lujvo. 

    <p>However, there is a further problem with ``jdaselsku'', not
    resolvable by using ``seljdasku''. No veljvo involving just the
    two gismu ``lijda'' and ``cusku'' can fully express the
    relationship implicit in prayer. A prayer is not just anything
    said by the adherents of a religion; nor is it even anything
    said by them acting as adherents of that religion. Rather, it
    is what they say under the authority of that religion, or using
    the religion as a medium, or following the rules associated
    with the religion, or something of the kind. So the veljvo is
    somewhat elliptical.</p>

    <p>As a result, both ``seljdasku'' and ``jdaselsku'' belong to
    the second class of anomalous lujvo: the veljvo doesn't really
    supply all that the lujvo requires.</p>

    <p>Another example of this kind of anomalous lujvo, drawn from
    the tanru lists in <a href="chapter5.html">Chapter 5</a>, is
    ``lange'u'', meaning ``sheepdog''. Clearly a sheepdog is not a
    dog which is a sheep (the symmetrical interpretation is wrong),
    nor a dog of the sheep breed (the asymmetrical interpretation
    is wrong). Indeed, there is simply no overlap in the places of
    ``lanme'' and ``gerku'' at all. Rather, the lujvo refers to a
    dog which controls sheep flocks, a ``terlanme jitro gerku'',
    the lujvo from which is ``terlantroge'u'' with place
    structure:</p>

    <p></p>
<pre>
<a id="e14d5"
name="e14d5">14.5)</a>    g1=j1 is a dog that controls sheep flock l3=j2
        made up of sheep l1 in activity j3 of dog breed g2
</pre>
    based on the gismu place structures 
<pre>
<a id="e14d6"
name="e14d6">14.6)</a>    ``lanme'': l1 is a sheep of breed l2 belonging to flock l3
    ``gerku'': g1 is a dog of breed g2
    ``jitro'': j1 controls j2 in activity j3
</pre>

    <p>Note that this lujvo is symmetrical between ``lantro''
    (sheep-controller) and ``gerku'', but ``lantro'' is itself an
    asymmetrical lujvo. The l2 place, the breed of sheep, is
    removed as dependent on l1. However, the lujvo ``lange'u'' is
    both shorter than ``terlantroge'u'' and sufficiently clear to
    warrant its use: its place structure, however, should be the
    same as that of the longer lujvo, for which ``lange'u'' can be
    understood as an abbreviation.</p>

    <p>Another example is ``xanmi'e'', ``to command by hand, to
    beckon''. The component place structures are:</p>
<pre>
<a id="e14d7"
name="e14d7">14.7)</a>    ``xance'': xa1 is the hand of xa2
    ``minde'': m1 gives commands to m2 to cause m3 to happen
</pre>

    <p>The relation between the seltau and tertau is close enough
    for there to be an overlap: xa2 (the person with the hand) is
    the same as m1 (the one who commands). But interpreting
    ``xanmi'e'' as a symmetrical lujvo with an elided ``sel-'' in
    the seltau, as if from ``se xance mindu'', misses the point:
    the real relation expressed by the lujvo is not just ``one who
    commands and has a hand'', but ``to command using the hand''.
    The concept of ``using'' suggests in the gismu ``pilno'', with
    place structure</p>
<pre>
<a id="e14d8"
name="e14d8">14.8)</a>    p1 uses tool p2 for purpose p3
</pre>

    <p>Some possible three-part veljvo are (depending on how
    strictly you want to constrain the veljvo)</p>
<pre>
<a id="e14d9"
name="e14d9">14.9)</a>    [ke] xance pilno [ke'e] minde
    (hand user) type-of commander

<a id="e14d10"
name="e14d10">14.10)</a>   [ke] minde xance [ke'e] pilno
    (commander hand) type-of user
</pre>
    or even 
<pre>
<a id="e14d11"
name="e14d11">14.11)</a>  minde ke xance pilno [ke'e]
    commander type-of (hand user)
</pre>
    which lead to the three different lujvo ``xanplimi'e'',
    ``mi'erxanpli'', and ``minkemxanpli'' respectively. 

    <p>Does this make ``xanmi'e'' wrong? By no means. But it does
    mean that there is a latent component to the meaning of
    ``xanmi'e'', the gismu ``pilno'', which is not explicit in the
    veljvo. And it also means that, for a place structure
    derivation that actually makes sense, rather than being ad-hoc,
    the Lojbanist should probably go through a derivation for
    ``xancypliminde'' or one of the other possibilities that is
    analogous to the analysis of ``terlantroge'u'' above, even if
    he or she decides to stick with a shorter, more convenient form
    like ``xanmi'e''. In addition, of course, the possibilities of
    elliptical lujvo increase their potential ambiguity enormously
    --- an unavoidable fact which should be borne in mind.</p>

    <h3><a id="s15" name="s15">15. Comparatives and superlatives</h3>

    <p>English has the concepts of ``comparative adjectives'' and
    ``superlative adjectives'' which can be formed from other
    adjectives, either by adding the suffixes ``-er'' and ``-est''
    or by using the words ``more'' and ``most'', respectively. The
    Lojbanic equivalents, which can be made from any brivla, are
    lujvo with the tertau ``zmadu'', ``mleca'', ``zenba'',
    ``jdika'', and ``traji''. In order to make these lujvo regular
    and easy to make, certain special guidelines are imposed.</p>

    <p>We will begin with lujvo based on ``zmadu'' and ``mleca'',
    whose place structures are:</p>
<pre>
<a id="e15d1"
name="e15d1">15.1)</a>    ``zmadu'': z1 is more than z2 in property z3
        in quantity z4
    ``mleca'': m1 is less than m2 in property m3
        in quantity m4
</pre>

    <p>For example, the concept ``young'' is expressed by the gismu
    ``citno'', with place structure</p>
<pre>
<a id="e15d2" name="e15d2">15.2)</a>    ``citno'':  c1 is young
</pre>
    The comparative concept ``younger'' can be expressed by the
    lujvo ``citmau'' (based on the veljvo ``citno zmadu'', meaning
    ``young more-than''). 
<pre>
<a id="e15d3"
name="e15d3">15.3)</a>    mi citmau do lo nanca be li xa
    I am-younger-than you by-years the-number six.
    I am six years younger than you.
</pre>

    <p>The place structure for ``citmau'' is</p>
<pre>
<a id="e15d4"
name="e15d4">15.4)</a>    z1=c1 is younger than z2=c1 by amount z4
</pre>

    <p>Similarly, in Lojban you can say:</p>
<pre>
<a id="e15d5"
name="e15d5">15.5)</a>    do citme'a mi lo nanca be li xa
    You are-less-young-than me by-years the-number six.
    You are six years less young than me.
</pre>

    <p>In English, ``more'' comparatives are easier to make and use
    than ``less'' comparatives, but in Lojban the two forms are
    equally easy.</p>

    <p>Because of their much simpler place structure, lujvo ending
    in ``-mau'' and ``-me'a'' are in fact used much more frequently
    than ``zmadu'' and ``mleca'' themselves as selbri. It is highly
    unlikely for such lujvo to be construed as anything other than
    implicit-abstraction lujvo. But there is another type of
    ambiguity relevant to these lujvo, and which has to do with
    what is being compared.</p>

    <p>For example, does ``nelcymau'' mean ``X likes Y more than X
    likes Z'', or ``X likes Y more than Z likes Y''? Does
    ``klamau'' mean: ``X goes to Y more than to Z'', ``X goes to Y
    more than Z does'', ``X goes to Y from Z more than from W'', or
    what?</p>

    <p>We answer this concern by putting regularity above any
    considerations of concept usefulness: by convention, the two
    things being compared always fit into the first place of the
    seltau. In that way, each of the different possible
    interpretations can be expressed by SE-converting the seltau,
    and making the required place the new first place. As a result,
    we get the following comparative lujvo place structures:</p>
<pre>
<a id="e15d6"
name="e15d6">15.6)</a>    ``nelcymau'': z1, more than z2, likes n2
        by amount z4
    ``selnelcymau'': z1, more than z2, is liked by n1
        in amount z4
    ``klamau'': z1, more than z2, goes to k2 from k3
        via k4 by means of k5
    ``selklamau'': z1, more than z2, is gone to by k1
        from k3 via k4 by means of k5
    ``terklamau'': z1, more than z2, is an origin point
        from destination k2 for k1's going via k4
        by means of k5
</pre>
    (See <a href="chapter11.html">Chapter 11</a> for the way in which
    this problem is resolved when lujvo aren't used.) 

    <p>The ordering rule places the things being compared first,
    and the other seltau places following. Unfortunately the z4
    place, which expresses by how much one entity exceeds the
    other, is displaced into a lujvo place whose number is
    different for each lujvo. For example, while ``nelcymau'' has
    z4 as its fourth place, ``klamau'' has it as its sixth place.
    In any sentence where a difficulty arises, this amount-place
    can be redundantly tagged with ``vemau'' (for ``zmadu'') or
    ``veme'a'' (for ``mleca'') to help make the speaker's intention
    clear.</p>

    <p>It is important to realize that such comparative lujvo do
    not presuppose their seltau. Just as in English, saying someone
    is younger than someone else doesn't imply that they're young
    in the first place: an octogenarian, after all, is still
    younger than a nonagenarian. Rather, the 80-year-old has a
    greater ``ni citno'' than the 90-year-old. Similarly, a
    5-year-old is older than a 1-year-old, but is not considered
    ``old'' by most standards.</p>

    <p>There are some comparative concepts which are in which the
    ``se zmadu'' is difficult to specify. Typically, these involve
    comparisons implicitly made with a former state of affairs,
    where stating a z2 place explicitly would be problematic.</p>

    <p>In such cases, it is best not to use ``zmadu'' and leave the
    comparison hanging, but to use instead the gismu ``zenba'',
    meaning ``increase'' (and ``jdika'', meaning ``decrease'', in
    place of ``mleca''). The gismu ``zenba'' was included in the
    language precisely in order to capture those notions of
    increase which ``zmadu'' can't quite cope with; in addition, we
    don't have to waste a place in lujvo or tanru on something that
    we'd never fill in with a value anyway. So we can translate
    ``I'm stronger now'' not as</p>
<pre>
<a id="e15d7" name="e15d7">15.7)</a>    mi ca tsamau
    I now am-stronger.
</pre>
    which implies that I'm stronger than somebody else (the elided
    occupant of the second or z2 place), but as 
<pre>
<a id="e15d8" name="e15d8">15.8)</a>    mi ca tsaze'a
    I increase in strength.
</pre>

    <p>Finally, lujvo with a tertau of ``traji'' are used to build
    superlatives. The place structure of ``traji'' is</p>
<pre>
<a id="e15d9"
name="e15d9">15.9)</a>    t1 is superlative in property t2, being
        the t3 extremum (largest by default) of set t4
</pre>

    <p>Consider the gismu ``xamgu'', whose place structure is:</p>
<pre>
<a id="e15d10"
name="e15d10">15.10)</a>  xa1 is good for xa2 by standard xa3
</pre>
    The comparative form is ``xagmau'', corresponding to English
    ``better'', with a place structure (by the rules given above)
    of 
<pre>
<a id="e15d11"
name="e15d11">15.11)</a>  z1 is better than z2 for xa2 by standard xa3
        in amount z4
</pre>
    We would expect the place structure of ``xagrai'', the
    superlative form, to somehow mirror that, given that
    comparatives and superlatives are comparable concepts,
    resulting in: 
<pre>
<a id="e15d12"
name="e15d12">15.12)</a>  xa1=t1 is the best of the set t4 for xa2
        by standard xa3.
</pre>

    <p>The t2 place in ``traji'', normally filled by a property
    abstraction, is replaced by the seltau places, and the t3 place
    specifying the extremum of ``traji'' (whether the most or the
    least, that is) is presumed by default to be ``the most''.</p>

    <p>But the set against which the t1 place of ``traji'' is
    compared is not the t2 place (which would make the place
    structure of ``traji'' fully parallel to that of ``zmadu''),
    but rather the t4 place. Nevertheless, by a special exception
    to the rules of place ordering, the t4 place of ``traji''-based
    lujvo becomes the second place of the lujvo. Some examples:</p>

    <p></p>
<pre>
<a id="e15d12.5"
name="e15d12.5">15.12.5)</a>  la djudis. cu citrai lo'i lobypli
    Judy is the youngest of all Lojbanists.
</pre>
<pre>
<a id="e15d13"
name="e15d13">15.13)</a>  la ajnctain. cu balrai lo'i skegunka
    Einstein was the greatest of all scientists.
</pre>

    <h3><a id="s16" name="s16">16. Notes on gismu place structures</h3>

    <p>Unlike the place structures of lujvo, the place structures
    of gismu were assigned in a far less systematic way through a
    detailed case-by-case analysis and repeated reviews with
    associated changes. (The gismu list is now baselined, so no
    further changes are contemplated.) Nevertheless, certain
    regularities were imposed both in the choice of places and in
    the ordering of places which may be helpful to the learner and
    the lujvo-maker, and which are therefore discussed here.</p>

    <p>The choice of gismu places results from the varying outcome
    of four different pressures: brevity, convenience, metaphysical
    necessity, and regularity. (These are also to some extent the
    underlying factors in the lujvo place structures generated by
    the methods of this chapter.) The implications of each are
    roughly as follows:</p>

    <dl>
      <dt></dt>

      <dd>Brevity tends to remove places: the fewer places a gismu
      has, the easier it is to learn, and the less specific it is.
      As mentioned in <a href="#s4">Section 4</a>, a brivla with
      fewer place structures is less specific, and generality is a
      virtue in gismu, because they must thoroughly blanket all of
      semantic space.</dd>

      <dt></dt>

      <dd>Convenience tends to increase the number of places: if a
      concept can be expressed as a place of some existing gismu,
      there is no need to make another gismu, a lujvo or a fu'ivla
      for it.</dd>

      <dt></dt>

      <dd>Metaphysical necessity can either increase or decrease
      places: it is a pressure tending to provide the ``right
      number'' of places. If something is part of the essential
      nature of a concept, then a place must be made for it; on the
      other hand, if instances of the concept need not have some
      property, then this pressure will tend to remove the
      place.</dd>

      <dt></dt>

      <dd>Regularity is a pressure which can also either increase
      or decrease places. If a gismu has a given place, then gismu
      which are semantically related to it are likely to have the
      place also.</dd>
    </dl>

    <p>Here are some examples of gismu place structures, with a
    discussion of the pressures operating on them:</p>
<pre>
<a id="e16d1" name="e16d1">16.1)</a>    ``xekri'':  xe1 is black
</pre>
    Brevity was the most important goal here, reinforced by one
    interpretation of metaphysical necessity. There is no mention
    of color standards here, as many people have pointed out; like
    all color gismu, ``xekri'' is explicitly subjective. Objective
    color standards can be brought in by an appropriate BAI tag
    such as ``ci'u'' (``in system''; see <a
    href="chapter9.html">Chapter 9</a>) or by making a lujvo. 
<pre>
<a id="e16d2"
name="e16d2">16.2)</a>    ``jbena'': j1 is born to j2 at time j3 and location j4
</pre>

    <p>The gismu ``jbena'' contains places for time and location,
    which few other gismu have: normally, the time and place at
    which something is done is supplied by a tense tag (see <a
    href="chapter10.html">Chapter 10</a>). However, providing these
    places makes ``le te jbena'' a simple term for ``birthday'' and
    ``le ve jbena'' for ``birthplace'', so these places were
    provided despite their lack of metaphysical necessity.</p>
<pre>
<a id="e16d3"
name="e16d3">16.3)</a>    ``rinka'': event r1 is the cause of event r2
</pre>
    The place structure of ``rinka'' does not have a place for the
    agent, the one who causes, as a result of the pressure toward
    metaphysical necessity. A cause-effect relationship does not
    have to include an agent: an event (such as snow melting in the
    mountains) may cause another event (such as the flooding of the
    Nile) without any human intervention or even knowledge. 

    <p>Indeed, there is a general tendency to omit agent places
    from most gismu except for a few such as ``gasnu'' and
    ``zukte'' which are then used as tertau in order to restore the
    agent place when needed: see <a href="#s13">Section 13</a>.</p>
<pre>
<a id="e16d4"
name="e16d4">16.4)</a>    ``cinfo'': c1 is a lion of species/breed c2
</pre>
    The c2 place of ``cinfo'' is provided as a result of the
    pressure toward regularity. All animal and plant gismu have
    such an c2 place; although there is in fact only one species of
    lion, and breeds of lion, though they exist, aren't all that
    important in talking about lions. The species/breed place must
    exist for such diversified species as dogs, and for general
    terms like ``cinki'' (insect), and are provided for all other
    animals and plants as a matter of regularity. 

    <p>Less can be said about gismu place structure ordering, but
    some regularities are apparent. The places tend to appear in
    decreasing order of psychological saliency or importance. There
    is an implication within the place structure of ``klama'', for
    example, that ``lo klama'' (the one going) will be talked about
    more often, and is thus more important, than ``lo se klama''
    (the destination), which is in turn more important than ``lo xe
    klama'' (the means of transport).</p>

    <p>Some specific tendencies (not really rules) can also be
    observed. For example, when there is an agent place, it tends
    to be the first place. Similarly, when a destination and an
    origin point are mentioned, the destination is always placed
    just before the origin point. Places such as ``under
    conditions'' and ``by standard'', which often go unfilled, are
    moved to near the end of the place structure.</p>

    <hr />
    
    <p>Senast modifierad: Mon Jun 27 23:10:54 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
