
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//FR" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 15</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter15.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 15<br />
      ``No'' Problems: On Lojban Negation</h2>

      <!--
      <h6>$Revision: 4.1 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. Introductory</h3>

    <p>The grammatical expression of negation is a critical part of
    Lojban's claim to being logical. The problem of negation,
    simply put, is to come up with a complete definition of the
    word ``not''. For Lojban's unambiguous grammar, this means
    further that meanings of ``not'' with different grammatical
    effect must be different words, and even different grammatical
    structures.</p>

    <p>Logical assertions are implicitly required in a logical
    language; thus, an apparatus for expressing them is built into
    Lojban's logical connectives and other structures.</p>

    <p>In natural languages, especially those of Indo-European
    grammar, we have sentences composed of two parts which are
    typically called ``subject'' and ``predicate''. In the
    statement</p>
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  John goes to the store
</pre>
    ``John'' is the subject, and ``goes to the store'' is the
    predicate. Negating <a href="#e1d1">Example 1.1</a> to produce 
<pre>
<a id="e1d2" name="e1d2">1.2)</a>  John doesn't go to the store.
</pre>
    has the effect of declaring that the predicate does not hold
    for the subject. <a href="#e1d2">Example 1.2</a> says nothing
    about whether John goes somewhere else, or whether someone else
    besides John goes to the store. 

    <p>We will call this kind of negation ``natural language
    negation''. This kind of negation is difficult to manipulate by
    the tools of logic, because it doesn't always follow the rules
    of logic. Logical negation is bi-polar: either a statement is
    true, or it is false. If a statement is false, then its
    negation must be true. Such negation is termed contradictory
    negation.</p>

    <p>Let's look at some examples of how natural language negation
    can violate the rules of contradictory negation.</p>
<pre>
<a id="e1d3" name="e1d3">1.3)</a>  Some animals are not white.

<a id="e1d4" name="e1d4">1.4)</a>   Some animals are white.
</pre>

    <p>Both of these statements are true; yet one is apparently the
    negation of the other. Another example:</p>
<pre>
<a id="e1d5" name="e1d5">1.5)</a>  I mustn't go to the dance.

<a id="e1d6" name="e1d6">1.6)</a>   I must go to the dance.
</pre>

    <p>At first thought, <a href="#e1d5">Example 1.5</a> negates <a
    href="#e1d6">Example 1.6</a>. Thinking further, we realize that
    there is an intermediate state wherein I am permitted to go to
    the dance, but not obligated to do so. Thus, it is possible
    that both statements are false.</p>

    <p>Sometimes order is significant:</p>
<pre>
<a id="e1d7"
name="e1d7">1.7)</a>  The falling rock didn't kill Sam.

<a id="e1d8"
name="e1d8">1.8)</a>   Sam wasn't killed by the falling rock.
</pre>

    <p>Our minds play tricks on us with this one. Because <a
    href="#e1d7">Example 1.7</a> is written in what is called the
    ``active voice'', we immediately get confused about whether
    ``the falling rock'' is a suitable subject for the predicate
    ``did kill Sam''. ``Kill'' implies volition to us, and rocks do
    not have volition. This confusion is employed by opponents of
    gun control who use the argument ``Guns don't kill people;
    people kill people.''</p>

    <p>Somehow, we don't have the same problem with <a
    href="#e1d8">Example 1.8</a>. The subject is Sam, and we
    determine the truth or falsity of the statement by whether he
    was or wasn't killed by the falling rock.</p>

    <p><a href="#e1d8">Example 1.8</a> also helps us focus on the
    fact that there are at least two questionable facts implicit in
    this sentence: whether Sam was killed, and if so, whether the
    falling rock killed him. If Sam wasn't killed, the question of
    what killed him is moot.</p>

    <p>This type of problem becomes more evident when the subject
    of the sentence turns out not to exist:</p>
<pre>
<a id="e1d9"
name="e1d9">1.9)</a>  The King of Mexico didn't come to dinner.

<a id="e1d10"
name="e1d10">1.10)</a> The King of Mexico did come to dinner.
</pre>

    <p>In the natural languages, we would be inclined to say that
    both of these statements are false, since there is no King of
    Mexico.</p>

    <p>The rest of this chapter is designed to explain the Lojban
    model of negation.</p>

    <h3><a id="s2" name="s2">2. bridi negation</h3>

    <p>In discussing Lojban negation, we will call the form of
    logical negation that simply denies the truth of a statement
    ``bridi negation''. Using bridi negation, we can say the
    equivalent of ``I haven't stopped beating my wife'' without
    implying that I ever started, nor even that I have a wife,
    meaning simply ``It isn't true that I have stopped beating my
    wife.'' Since Lojban uses bridi as smaller components of
    complex sentences, bridi negation is permitted in these
    components as well at the sentence level.</p>

    <p>For the bridi negation of a sentence to be true, the
    sentence being negated must be false. A major use of bridi
    negation is in making a negative response to a yes/no question;
    such responses are usually contradictory, denying the truth of
    the entire sentence. A negative answer to</p>
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  Did you go to the store?
</pre>
    is taken as a negation of the entire sentence, equivalent to 
<pre>
<a id="e2d2" name="e2d2">2.2)</a>  No, I didn't go to the store.
</pre>

    <p>The most important rule about bridi negation is that if a
    bridi is true, its negation is false, and vice versa.</p>

    <p>The simplest way to express a bridi negation is to use the
    cmavo ``na'' of selma'o NA before the selbri of the affirmative
    form of the bridi (but after the ``cu'', if there is one):</p>
<pre>
<a id="e2d3" name="e2d3">2.3)</a>  mi klama le zarci
    I go-to the store.
</pre>
    when negated becomes: 
<pre>
<a id="e2d4" name="e2d4">2.4)</a>  mi na klama le zarci
    I [false] go-to the store.
</pre>

    <p>Note that we have used a special convention to show in the
    English that a bridi negation is present. We would like to use
    the word ``not'', because this highlights the naturalness of
    putting the negation marker just before the selbri, and makes
    the form easier to learn. But there is a major difference
    between Lojban's bridi negation with ``na'' and natural
    language negation with ``not''. In English, the word ``not''
    can apply to a single word, to a phrase, to an English
    predicate, or to the entire sentence. In addition, ``not'' may
    indicate either contradictory negation or another form of
    negation, depending on the sentence. Lojban's internal bridi
    negation, on the other hand, always applies to an entire bridi,
    and is always a contradictory negation; that is, it contradicts
    the claim of the whole bridi.</p>

    <p>Because of the ambiguity of English ``not'', we will use
    ``[false]'' in the translation of Lojban examples to remind the
    reader that we are expressing a contradictory negation. Here
    are more examples of bridi negation:</p>
<pre>
<a id="e2d5" name="e2d5">2.5)</a>  mi [cu] na ca klama le zarci
    I [false] now am-a-go-er to the market.
    I am not going to the market now.

<a id="e2d6" name="e2d6">2.6)</a>   lo ca nolraitru
        be le fasygu'e cu na krecau
    The-actual present noblest-governor
        of the French country [false] is-hair-without.
    The current king of France isn't bald.

<a id="e2d7" name="e2d7">2.7)</a>   ti na barda prenu co melbi mi
    This [false] is a big-person of-type (beautiful to me).
    This isn't a big person who is beautiful to me.
</pre>

    <p>Although there is this fundamental difference between
    Lojban's internal bridi negation and English negation, we note
    that in many cases, especially when there are no existential or
    quantified variables (the cmavo ``da'', ``de'', and ``di'' of
    selma'o KOhA, explained in <a href="chapter16.html">Chapter
    16</a>) in the bridi, you can indeed translate Lojban ``na'' as
    ``not'' (or ``isn't'' or ``doesn't'', as appropriate).</p>

    <p>The most important rule about bridi negation is that if a
    bridi is true, its negation is false, and vice versa.</p>

    <p>In Lojban, there are several structures that implicitly
    contain bridi, so that Lojban sentences may contain more than
    one occurrence of ``na''. For example:</p>
<pre>
<a id="e2d8" name="e2d8">2.8)</a>  mi na gleki le nu
        na klama le nu dansu
    I [false] am-happy-about the event-of(
        [false] going-to the event-of dancing).
    It is not the case that I am happy about it not being
        the case that I am going to the dance.
    I am not happy about not going to the dance.
In the previous example, we used internal negations in abstraction
bridi; bridi negation may also be found in descriptions within
sumti.  For example:

<a id="e2d9" name="e2d9">2.9)</a>   mi nelci le na melbi
    I am fond of the-one-described-as ([false] beautiful)
    I am fond of the one who isn't beautiful.
</pre>

    <p>A more extreme (and more indefinite) example is:</p>
<pre>
<a id="e2d10" name="e2d10">2.10)</a>    mi nelci lo na ca nolraitru
        be le frasygu'e
    I am-fond-of one-who-is ([false] the current king
        of the French-country).
    I am fond of one who isn't the current king of France.
</pre>

    <p>The claim of <a href="#e2d10">Example 2.10</a> could apply
    to anyone except a person who is fond of no one at all, since
    the relation within the description is false for everyone. You
    cannot readily express these situations in colloquial
    English.</p>

    <p>Negation with ``na'' applies to an entire bridi, and not to
    just part of a selbri. Therefore, you won't likely have reason
    to put ``na'' inside a tanru. In fact, the grammar currently
    does not allow you to do so (except in a lujvo and in elaborate
    constructs involving GUhA, the forethought connector for
    selbri). Any situation where you might want to do so can be
    expressed in a less-compressed non-tanru form. This grammatical
    restriction helps ensure that bridi negation is kept separate
    from other forms of negation.</p>

    <p>The grammar of ``na'' allows multiple adjacent negations,
    which cancel out, as in normal logic:</p>
<pre>
<a id="e2d11" name="e2d11">2.11)</a>    ti na na barda prenu co
        melbi mi
    This [false] [false] is-a-big person
        that is (beautiful to me).
</pre>
    which is the same as: 
<pre>
<a id="e2d12" name="e2d12">2.12)</a>    ti barda prenu co melbi mi
    This is a big-person that is (beautiful to me).
</pre>

    <p>When a selbri is tagged with a tense or a modal, negation
    with ``na'' is permitted in two positions: before or after the
    tag. No semantic difference between these forms has yet been
    defined, but this is not finally determined, since the
    interactions between tenses/modals and bridi negation have not
    been fully explored. In particular, it remains to be seen
    whether sentences using less familiar tenses, such as:</p>
<pre>
<a id="e2d13" name="e2d13">2.13)</a>    mi [cu] ta'e klama le zarci
    I habitually go to the market.
</pre>
    mean the same thing with ``na'' before the ``ta'e'', as when
    the negation occurs afterwards; we'll let future,
    Lojban-speaking, logicians decide on how they relate to each
    other. 

    <p>A final caution on translating English negations into
    Lojban: if you translate the English literally, you'll get the
    wrong one. With English causal statements, and other statements
    with auxiliary clauses, this problem is more likely.</p>

    <p>Thus, if you translate the English:</p>
<pre>
<a id="e2d14"
name="e2d14">2.14)</a>    I do not go to the market because the car is broken.
</pre>
    as: 
<pre>
<a id="e2d15"
name="e2d15">2.15)</a>    mi na klama le zarci ki'u lenu le karce cu spofu
    I [false] go-to the market because the car is broken.
    It is false that: ``I go to the market because the car
        is broken.''
</pre>
    you end up negating too much. 

    <p>Such mistranslations result from the ambiguity of English
    compounded by the messiness of natural language negation. A
    correct translation of the normal interpretation of <a
    href="#e2d14">Example 2.14</a> is:</p>
<pre>
<a id="e2d16" name="e2d16">2.16)</a>    lenu mi na klama le zarci
        cu se krinu
            lenu le karce cu spofu
    The event-of (my [false] going-to the market)
        is justified by
            the event-of (the car being broken).
    My not going to the market is because the car is broken.
</pre>

    <p>In <a href="#e2d16">Example 2.16</a>, the negation is
    clearly confined to the event abstraction in the x1 sumti, and
    does not extend to the whole sentence. The English could also
    have been expressed by two separate sentences joined by a
    causal connective (which we'll not go into here).</p>

    <p>The problem is not confined to obvious causals. In the
    English:</p>
<pre>
<a id="e2d17"
name="e2d17">2.17)</a>    I was not conscripted into the Army with the help of
        my uncle the Senator.
</pre>
    we do not intend the uncle's help to be part of the negation.
    We must thus move the negation into an event clause or use two
    separate sentences. The event-clause version would look like: 
<pre>
<a id="e2d18"
name="e2d18">2.18)</a>    The event-of (my [false] being-conscripted-into
        the Army) was aided by my uncle the Senator.
</pre>

    <p>It is possible that someone will want to incorporate bridi
    negations into lujvo. For this reason, the rafsi ``-nar-'' has
    been reserved for ``na''. However, before using this rafsi,
    make sure that you intend the contradictory bridi negation, and
    not the scalar negation described in <a href="#s3">Section
    3</a>, which will be much more common in tanru and lujvo.</p>

    <h3><a id="s3" name="s3">3. Scalar Negation</h3>

    <p>Let us now consider some other types of negation. For
    example, when we say:</p>
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  The chair is not brown.
</pre>
    we make a positive inference --- that the chair is some other
    color. Thus, it is legitimate to respond: 
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  It is green.
</pre>

    <p>Whether we agree that the chair is brown or not, the fact
    that the statement refers to color has significant effect on
    how we interpret some responses. If we hear the following
    exchange:</p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  The chair is not brown.
    Correct.  The chair is wooden.
</pre>
    we immediately start to wonder about the unusual wood that
    isn't brown. If we hear the exchange: 
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  Is the chair green?
    No, it is in the kitchen.
</pre>
    we are unsettled because the response seems to be a
    non-sequitur. But since it might be true and it is a statement
    about the chair, one can't say it is entirely irrelevant! 

    <p>What is going on in these statements is something called
    ``scalar negation''. As the name suggests, scalar negation
    presumes an implied scale. A negation of this type not only
    states that one scalar value is false, but implies that another
    value on the scale must be true. This can easily lead to
    complications. The following exchange seems reasonably natural
    (a little suspension of disbelief in such inane conversation
    will help):</p>
<pre>
<a id="e3d5" name="e3d5">3.5)</a>  That isn't a blue house.
    Right! That is a green house.
</pre>

    <p>We have acknowledged a scalar negation by providing a
    correct value which is another color in the set of colors
    permissible for houses. While a little less likely, the
    following exchange is also natural:</p>
<pre>
<a id="e3d6" name="e3d6">3.6)</a>  That isn't a blue house.
    Right! That is a blue car.
</pre>

    <p>Again, we have acknowledged a scalar negation, and
    substituted a different object in the universe of discourse of
    things that can be blue.</p>

    <p>Now, if the following exchange occurs:</p>
<pre>
<a id="e3d7" name="e3d7">3.7)</a>  That isn't a blue house.
    Right! That is a green car.
</pre>
    we find the result unsettling. This is because it seems that
    two corrections have been applied when there is only one
    negation. Yet out of context, ``blue house'' and ``green car''
    seem to be reasonably equivalent units that should be mutually
    replaceable in a sentence. It's just that we don't have a clear
    way in English to say: 
<pre>
<a id="e3d8" name="e3d8">3.8)</a>  That isn't a ``blue-house''.
</pre>
    aloud so as to clearly imply that the scalar negation is
    affecting the pair of words as a single unit. 

    <p>Another even more confusing example of scalar negation is to
    the sentence:</p>
<pre>
<a id="e3d9"
name="e3d9">3.9)</a>  John didn't go to Paris from Rome.
</pre>

    <p>Might <a href="#e3d9">Example 3.9</a> imply that John went
    to Paris from somewhere else? Or did he go somewhere else from
    Rome? Or perhaps he didn't go anywhere at all: maybe someone
    else did, or maybe there was no event of going whatsoever. One
    can devise circumstances where any one, two or all three of
    these statements might be inferred by a listener.</p>

    <p>In English, we have a clear way of distinguishing scalar
    negation from predicate negation that can be used in many
    situations. We can use the partial word ``non-'' as a prefix.
    But this is not always considered good usage, even though it
    would render many statements much clearer. For example, we can
    clearly distinguish</p>
<pre>
<a id="e3d10" name="e3d10">3.10)</a>    That is a non-blue house.
</pre>
    from the related sentence 
<pre>
<a id="e3d11" name="e3d11">3.11)</a>    That is a blue non-house.
</pre>
    <a href="#e3d10">Example 3.10</a> and <a href="#e3d11">Example
    3.11</a> have the advantage that, while they contain a negative
    indication, they are in fact positive assertions. They say what
    is true by excluding the false; they do not say what is false. 

    <p>We can't always use ``non-'' though, because of the
    peculiarities of English's grammar. It would sound strange to
    say:</p>
<pre>
<a id="e3d12"
name="e3d12">3.12)</a>    John went to non-Paris from Rome.
</pre>
    or 
<pre>
<a id="e3d13"
name="e3d13">3.13)</a>    John went to Paris from non-Rome.
</pre>
    although these would clarify the vague negation. Another
    circumlocution for English scalar negation is ``other than'',
    which works where ``non-'' does not, but is wordier. 

    <p>Finally, we have natural language negations that are called
    polar negations, or opposites:</p>
<pre>
<a id="e3d14" name="e3d14">3.14)</a>    John is moral

<a id="e3d15" name="e3d15">3.15)</a> John is immoral
</pre>

    <p>To be immoral is much more than to just be not moral: it
    implies the opposite condition. Statements like <a
    href="#e3d15">Example 3.15</a> are strong negations which not
    only deny the truth of a statement, but assert its opposite.
    Since, ``opposite'' implies a scale, polar negations are a
    special variety of scalar negations.</p>

    <p>To examine this concept more closely, let us draw a linear
    scale, showing two examples of how the scale is used:</p>
<pre>
   Affirmations (positive)      Negations (negative)
    |-----------|-----------|-----------|-----------|
    All       Most        Some         Few       None
    Excellent Good        Fair         Poor     Awful
</pre>

    <p>Some scales are more binary than the examples we diagrammed.
    Thus we have ``not necessary'' or ``unnecessary'' being the
    polar opposite of necessary. Another scale, especially relevant
    to Lojban, is interpreted based on situations modified by one's
    philosophy: ``not true'' may be equated with ``false'' in a
    bi-valued truth-functional logic, while in tri-valued logic an
    intermediate between ``true'' and ``false'' is permitted, and
    in fuzzy logic a continuous scale exists from true to false.
    The meaning of ``not true'' requires a knowledge of which
    variety of truth scale is being considered.</p>

    <p>We will define the most general form of scalar negation as
    indicating only that the particular point or value in the scale
    or range is not valid and that some other (unspecified) point
    on the scale is correct. This is the intent expressed in most
    contexts by ``not mild''.</p>

    <p>Using this paradigm, contradictory negation is less
    restrictive than scalar negation --- it says that the point or
    value stated is incorrect (false), and makes no statement about
    the truth of any other point or value, whether or not on the
    scale.</p>

    <p>In English, scalar negation semantically includes phrases
    such as ``other than'', ``reverse of'', or ``opposite from''
    expressions and their equivalents. More commonly, scalar
    negation is expressed in English by the prefixes ``non-'',
    ``un-'', ``il-'', and ``im-''. Just which form and permissible
    values are implied by a scalar negation is dependent on the
    semantics of the word or concept which is being negated, and on
    the context. Much confusion in English results from the
    uncontrolled variations in meaning of these phrases and
    prefixes.</p>

    <p>In the examples of <a href="#s4">Section 4</a>, we will
    translate the general case of scalar negation using the general
    formula ``other than'' when a phrase is scalar-negated, and
    ``non-'' when a single word is scalar-negated.</p>

    <h3><a id="s4" name="s4">4. selbri and tanru negation</h3>

    <p>All the scalar negations illustrated in <a
    href="#s3">Section 3</a> are expressed in Lojban using the
    cmavo ``na'e'' (of selma'o NAhE). The most common use of
    ``na'e'' is as a prefix to the selbri:</p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  mi klama le zarci
    I go to the market.

<a id="e4d2" name="e4d2">4.2)</a>   mi na'e klama le zarci
    I non-go to the market.
</pre>

    <p>Comparing these two, we see that the negation operator being
    used in <a href="#e4d2">Example 4.2</a> is ``na'e''. But what
    exactly does ``na'e'' negate? Does the negation include only
    the gismu ``klama'', which is the entire selbri in this case,
    or does it include the ``le zarci'' as well? In Lojban, the
    answer is unambiguously ``only the gismu''. The cmavo ``na'e''
    always applies only to what follows it.</p>

    <p><a href="#e4d2">Example 4.2</a> looks as if it were parallel
    to:</p>
<pre>
<a id="e4d3" name="e4d3">4.3)</a>  mi na klama le zarci
    I [false] go-to the market.
</pre>
    but in fact there is no real parallelism at all. A negation
    using ``na'' denies the truth of a relationship, but a selbri
    negation with ``na'e'' asserts that a relationship exists other
    than that stated, one which specifically involves the sumti
    identified in the statement. The grammar allotted to ``na'e''
    allows us to unambiguously express scalar negations in terms of
    scope, scale, and range within the scale. Before we explain the
    scalar aspects, let us show how the scope of ``na'e'' is
    determined. 

    <p>In tanru, we may wish to negate an individual element before
    combining it with another to form the tanru. We in effect need
    a shorter-than-selbri-scope negation, for which we can use
    ``na'e'' as well. The positive sentence</p>
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  mi cadzu klama le zarci
    I walking-ly go to the market.
</pre>
    can be subjected to selbri negation in several ways. Two are: 
<pre>
<a id="e4d5" name="e4d5">4.5)</a>  mi na'e cadzu klama le zarci
    I (other-than-walkingly)-go-to the market.

<a id="e4d6" name="e4d6">4.6)</a>   mi cadzu na'e klama le zarci
    I walkingly-(other-than-go-to) the market.
</pre>

    <p>These negations show the default scope of ``na'e'' is
    close-binding on an individual brivla in a tanru. <a
    href="#e4d5">Example 4.5</a> says that I am going to the
    market, but in some kind of a non-walking manner. (As with most
    tanru, there are a few other possible interpretations, but
    we'll assume this one --- see <a href="chapter5.html">Chapter
    5</a> for a discussion of tanru meaning).</p>

    <p>In neither <a href="#e4d5">Example 4.5</a> nor <a
    href="#e4d6">Example 4.6</a> does the ``na'e'' negate the
    entire selbri. While both sentences contain negations that deny
    a particular relationship between the sumti, they also have a
    component which makes a positive claim about such a
    relationship. This is clearer in <a href="#e4d5">Example
    4.5</a>, which says that I am going, but in a non-walking
    manner. In <a href="#e4d6">Example 4.6</a>, we have claimed
    that the relationship between me and the market in some way
    involves walking, but is not one of ``going to'' (perhaps we
    are walking around the market, or walking-in-place while at the
    market).</p>

    <p>The ``scale'', or actually the ``set'', implied in Lojban
    tanru negations is anything which plausibly can be substituted
    into the tanru. (Plausibility here is interpreted in the same
    way that answers to a ``mo'' question must be plausible --- the
    result must not only have the right number of places and have
    sumti values appropriate to the place structure, it must also
    be appropriate or relevant to the context.) This minimal
    condition allows a speaker to be intentionally vague, while
    still communicating meaningful information. The speaker who
    uses selbri negation is denying one relationship, while
    minimally asserting a different relationship.</p>

    <p>We also need a scalar negation form that has a scope longer
    than a single brivla. There exists such a longer-scope selbri
    negation form, as exemplified by (each Lojban sentence in the
    next several examples is given twice, with parentheses in the
    second copy showing the scope of the ``na'e''):</p>
<pre>
<a id="e4d7"
name="e4d7">4.7)</a>  mi na'eke cadzu klama [ke'e] le zarci
    mi na'e (ke cadzu klama [ke'e]) le zarci
    I other-than-(walkingly-go-to) the market.
</pre>

    <p>This negation uses the same ``ke'' and ``ke'e'' delimiters
    (the ``ke'e'' is always elidable at the end of a selbri) that
    are used in tanru. The sentence clearly negates the entire
    selbri. The ``ke'e'', whether elided or not, reminds us that
    the negation does not include the trailing sumti. While the
    trailing-sumti place-structure is defined as that of the final
    brivla, the trailing sumti themselves are not part of the
    selbri and are thus not negated by ``na'e''.</p>

    <p>Negations of just part of the selbri are also permitted:</p>
<pre>
<a id="e4d8"
name="e4d8">4.8)</a>  mi na'eke sutra cadzu ke'e klama le zarci
    mi na'e (ke sutra cadzu ke'e) klama le zarci
    I other-than-(quickly-walkingly) go-to the market.
</pre>

    <p>In <a href="#e4d8">Example 4.8</a>, only the ``sutra cadzu''
    tanru is negated, so the speaker is indeed going to the market,
    but not by walking quickly.</p>

    <p>Negations made with ``na'e'' or ``na'eke'' also include
    within their scope any sumti attached to the brivla or tanru
    with ``be'' or ``bei''. Such attached sumti are considered part
    of the brivla or tanru:</p>
<pre>
<a id="e4d9"
name="e4d9">4.9)</a>  mi na'e ke sutra cadzu be le mi birka ke'e
        klama le zarci
    I other-than-(quickly walking-on-my-arms-ly)
        go-to the market.
</pre>

    <p>Note that <a href="#e4d10">Example 4.10</a> and <a
    href="#e4d11">Example 4.11</a> do not express the same
    thing:</p>
<pre>
<a id="e4d10"
name="e4d10">4.10)</a>    mi na'eke sutra cadzu [ke'e] lemi birka
    mi na'e (ke sutra cadzu [ke'e]) lemi birka
    I other-than-(quickly-walk-on) my-arms.

<a id="e4d11"
name="e4d11">4.11)</a> mi na'eke sutra cadzu be lemi birka [ke'e]
    mi na'e (ke sutra cadzu be lemi birka [ke'e])
    I other-than-(quickly-walk-on my-arms).
</pre>

    <p>The translations show that the negation in <a
    href="#e4d10">Example 4.10</a> is more restricted in scope;
    i.e. less of the sentence is negated with respect to x1
    (``mi'').</p>

    <p>Logical scope being an important factor in Lojban's claims
    to be unambiguous, let us indicate the relative precedence of
    ``na'e'' as an operator. Grouping with ``ke'' and ``ke'e'', of
    course, has an overt scope, which is its advantage. ``na'e'' is
    very close binding to its brivla. Internal binding of tanru,
    with ``bo'', is not as tightly bound as ``na'e''. ``co'', the
    tanru inversion operator has a scope that is longer than all
    other tanru constructs.</p>

    <p>In short, ``na'e'' and ``na'eke'' define a type of negation,
    which is shorter in scope than bridi negation, and which
    affects all or part of a selbri. The result of ``na'e''
    negation remains an assertion of some specific truth and not
    merely a denial of another claim.</p>

    <p>The similarity becomes striking when it is noticed that the
    rafsi ``-nal-'', representing ``na'e'' when a tanru is
    condensed into a lujvo, forms an exact parallel to the English
    usage of ``non-''. Turning a series of related negations into
    lujvo gives:</p>
<pre>
<a id="e4d12" name="e4d12">4.12)</a>    na'e klama becomes nalkla
    na'e cadzu klama becomes naldzukla
    na'e sutra cadzu klama becomes nalsu'adzukla
    nake sutra cadzu ke'e klama becomes nalsu'adzuke'ekla
</pre>

    <p>Note: ``-kem-'' is the rafsi for ``ke'', but it is omitted
    in the final lujvo as superfluous --- ``ke'e'' is its own
    rafsi, and its inclusion in the lujvo implies a ``ke'' after
    the ``-nal-'', since it needs to close something; only a ``ke''
    immediately after the negation would make the ``ke'e''
    meaningful in the tanru expressed in this lujvo.</p>

    <p>In a lujvo, it is probably clearest to translate ``-nal-''
    as ``non-'', to match the English combining forms, except when
    the ``na'e'' has single word scope and English uses ``un-'' or
    ``im-'' to negate that single word. Translation style should
    determine the use of ``other than'', ``non-'', or another
    negator for ``na'e'' in tanru; the translator must render the
    Lojban into English so it is clear in context. Let's go back to
    our simplest example:</p>
<pre>
<a id="e4d13" name="e4d13">4.13)</a>    mi na'e klama le zarci
    I am other-than-(going-to) the market.
    ?I am not going-to the market.

<a id="e4d14" name="e4d14">4.14)</a> mi nalkla le zarci
    I am-a-non-go-er-to the market.
</pre>

    <p>Note that to compare with the English translation form using
    ``non-'', we've translated the Lojban as if the selbri were a
    noun. Since Lojban ``klama'' is indifferently a noun, verb, or
    adjective, the difference is purely a translation change, not a
    true change in meaning. The English difference seems
    significant, though, due to the strongly different English
    grammatical forms and the ambiguity of English negation.</p>

    <p>Consider the following highly problematic sentence:</p>
<pre>
<a id="e4d15" name="e4d15">4.15)</a>    lo ca nolraitru
        be le fasygu'e
        cu krecau
    An-actual currently noblest-governor
        of the French country
        is-hair-without.
    The current King of France is bald.
</pre>

    <p>The selbri ``krecau'' negates with ``na'e'' as:</p>
<pre>
<a id="e4d16" name="e4d16">4.16)</a>    lo ca nolraitru
        be le fasygu'e
        cu na'e krecau
    An-actual currently noblest-governor
        of the French country
        is-other-than hair-without.
    The current King of France is other-than-bald.
</pre>
    or, as a lujvo: 
<pre>
<a id="e4d17" name="e4d17">4.17)</a>    lo ca nolraitru
        be le fasygu'e
        cu nalkrecau
    An-actual currently noblest-governor
        of the French country
        is-non-hair-without.
    The current King of France is a non-bald-one.
</pre>
    <a href="#e4d16">Example 4.16</a> and <a href="#e4d17">Example
    4.17</a> express the predicate negation forms using a negation
    word (``na'e'') or rafsi (``-nal-''); yet they make positive
    assertions about the current King of France; ie., that he is
    other-than-bald or non-bald. This follows from the close
    binding of ``na'e'' to the brivla. The lujvo form makes this
    overt by absorbing the negative marker into the word. 

    <p>Since there is no current King of France, it is false to say
    that he is bald, or non-bald, or to make any other affirmative
    claim about him. Any sentence about the current King of France
    containing only a selbri negation is as false as the sentence
    without the negation. No amount of selbri negations have any
    effect on the truth value of the sentence, which is invariably
    ``false'', since no affirmative statement about the current
    King of France can be true. On the other hand, bridi negation
    does produce a truth:</p>
<pre>
<a id="e4d18" name="e4d18">4.18)</a>    lo ca nolraitru
        be le fasygu'e
        cu na krecau
    An-actual current noblest-governor
        of the French Country
        [false] is-hair-without.
    It is false that the current King of France is bald.
</pre>

    <p>Note: ``lo'' is used in these sentences because negation
    relates to truth conditions. To meaningfully talk about truth
    conditions in sentences carrying a description, it must be
    clear that the description actually applies to the referent. A
    sentence using ``le'' instead of ``lo'' can be true even if
    there is no current king of France, as long as the speaker and
    the listener agree to describe something as the current king of
    France. (See the explanations of ``le'' in <a
    href="chapter6.html">Chapter 6</a>.)</p>

    <h3><a id="s5" name="s5">5. Expressing scales in selbri negation</h3>

    <p>In expressing a scalar negation, we must provide some
    indication of the scale, range, frame-of-reference, or universe
    of discourse that is being dealt with in an assertion. As
    stated in <a href="#s4">Section 4</a>, the default is the set
    of plausible alternatives. Thus if we say:</p>
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  le stizu cu na'e xunre
    The chair is a non-(red-thing).
</pre>
    the pragmatic interpretation is that we mean a different color
    and not 
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  le stizu cu dzukla be le zarci
    The chair walkingly-goes-to-the-market.
</pre>

    <p>However, if we have reason to be more explicit (an obtuse or
    contrary listener, or simply an overt logical analysis), we can
    clarify that we are referring to a color by saying:</p>
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  le stizu cu na'e xunre skari
    The chair is of a non-(red)-color
        (as perceived by something under some conditions).
</pre>

    <p>We might also have reduced the pragmatic ambiguity by making
    the two trailing sumti values explicit (the ``as perceived by''
    and ``under conditions'' places have been added to the place
    structure of ``xunre''). But assume we have a really stubborn
    listener (an artificially semi-intelligent computer?) who will
    find a way to misinterpret <a href="#e5d3">Example 5.3</a> even
    with three specific sumti provided.</p>

    <p>In this case, we use a sumti tagged with the sumti tcita
    ``ci'u'', which translates roughly as ``on a scale of X'',
    where ``X'' is the sumti. For maximal clarity, the tagged sumti
    can be bound into the negated selbri with ``be''. To clarify <a
    href="#e5d3">Example 5.3</a>, we might say:</p>
<pre>
<a id="e5d4"
name="e5d4">5.4)</a>  le stizu cu na'e xunre be ci'u loka skari
    The chair is a non-(red on-a-scale-of-colorness)-thing.
</pre>

    <p>We can alternately use the sumti tcita ``teci'e'', based on
    ``ciste'', which translates roughly as ``of a system of
    components X'', for universes of discourse; in this case, we
    would express <a href="#e5d3">Example 5.3</a> as:</p>
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  le stizu cu na'e xunre
        be teci'e le skari
    The chair is a non-(red
        of-a-system-with-components-the-colors)-thing.
</pre>

    <p>Other places of ``ciste'' can be brought out using the
    grammar of selma'o BAI modals, allowing slightly different
    forms of expression, thus:</p>
<pre>
<a id="e5d6" name="e5d6">5.6)</a>  le stizu cu na'e xunre
        be ci'e lo'i skari
    The chair is a non-(red
        of-a-system-which-is-the-set-of-colors)-thing.
</pre>

    <p>The cmavo ``le'a'', also in selma'o BAI, can be used to
    specify a category:</p>
<pre>
<a id="e5d7" name="e5d7">5.7)</a>  le stizu cu na'e xunre
        be le'a lo'i skari
    The chair is a non-(red
        of-a-category-which-is-the-set-of-colors)-thing.
</pre>
    which is minimally different in meaning from <a
    href="#e5d6">Example 5.6</a>. 

    <p>The cmavo ``na'e'' is not the only member of selma'o NAhE.
    If we want to express a scalar negation which is a polar
    opposite, we use the cmavo ``to'e'', which is grammatically
    equivalent to ``na'e'':</p>
<pre>
<a id="e5d8" name="e5d8">5.8)</a>  le stizu cu to'e xunre
        be ci'u loka skari
    The chair is a (opposite-of red)
        on-scale a-property-of color-ness.
</pre>

    <p>Likewise, the midpoint of a scale can be expressed with the
    cmavo ``no'e'', also grammatically equivalent to ``na'e''. Here
    are some parallel examples of ``na'e'', ``no'e'', and
    ``to'e'':</p>
<pre>
<a id="e5d9" name="e5d9">5.9)</a>  ta melbi
    That is-beautiful.

<a id="e5d10" name="e5d10">5.10)</a> ta na'e melbi
    That is-non-beautiful.
    That is other than beautiful.
    That is ugly [in one sense].

<a id="e5d11" name="e5d11">5.11)</a> ta no'e melbi
    That is-neutrally beautiful.
    That is plain/ordinary-looking
        (neither ugly nor beautiful).

<a id="e5d12" name="e5d12">5.12)</a> ta to'e melbi
    That is-opposite-of beautiful.
    That is ugly/very ugly/repulsive.
</pre>

    <p>The cmavo ``to'e'' has the assigned rafsi ``-tol-'' and
    ``-to'e-''; the cmavo ``no'e'' has the assigned rafsi ``-nor-''
    and ``-no'e-''. The selbri in <a href="#e5d10">Example 5.10</a>
    through <a href="#e5d12">Example 5.12</a> could be replaced by
    the lujvo ``nalmle'', ``normle'', and ``tolmle''
    respectively.</p>

    <p>This large variety of scalar negations is provided because
    different scales have different properties. Some scales are
    open-ended in both directions: there is no ``ultimately ugly''
    or ``ultimately beautiful''. Other scales, like temperature,
    are open at one end and closed at the other: there is a minimum
    temperature (so-called ``absolute zero'') but no maximum
    temperature. Still other scales are closed at both ends.</p>

    <p>Correspondingly, some selbri have no obvious ``to'e'' ---
    what is the opposite of a dog? --- while others have more than
    one, and need ``ci'u'' to specify which opposite is meant.</p>

    <h3><a id="s6" name="s6">6. sumti negation</h3>

    <p>There are two ways of negating sumti in Lojban. We have the
    choice of quantifying the sumti with zero, or of applying the
    sumti-negator ``na'ebo'' before the sumti. It turns out that a
    zero quantification serves for contradictory negation. As the
    cmavo we use implies, ``na'ebo'' forms a scalar negation.</p>

    <p>Let us show examples of each.</p>
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  no lo ca nolraitru
        be le fasygu'e cu krecau
    Zero of those who are currently noblest-governors
        of the French country are-hair-without.
    No current king of France is bald.
</pre>

    <p>Is <a href="#e6d1">Example 6.1</a> true? Yes, because it
    merely claims that of the current Kings of France, however many
    there may be, none are bald, which is plainly true, since there
    are no such current Kings of France.</p>

    <p>Now let us look at the same sentence using ``na'ebo''
    negation:</p>
<pre>
<a id="e6d2" name="e6d2">6.2)</a>  na'ebo lo ca nolraitru
        be le fasygu'e cu krecau
    [Something] other-than-(the-current-noblest-governor
        of the French country) is-hair-without.
    Something other than the current King of France is bald.
</pre>
    <a href="#e6d2">Example 6.2</a> is true provided that something
    reasonably describable as ``other than a current King of
    France'', such as the King of Saudi Arabia, or a former King of
    France, is in fact bald. 

    <p>In place of ``na'ebo'', you may also use ``no'ebo'' and
    ``to'ebo'', to be more specific about the sumti which would be
    appropriate in place of the stated sumti. Good examples are
    hard to come by, but here's a valiant try:</p>
<pre>
<a id="e6d3" name="e6d3">6.3)</a>  mi klama to'ebo la bastn.
    I go to the-opposite-of Boston.
    I go to Perth.
</pre>
    (Boston and Perth are nearly, but not quite, antipodal cities.
    In a purely United States context, San Francisco might be a
    better ``opposite''.) Coming up with good examples is
    difficult, because attaching ``to'ebo'' to a description sumti
    is usually the same as attaching ``to'e'' to the selbri of the
    description. 

    <p>It is not possible to transform sumti negations of either
    type into bridi negations or scalar selbri negations. Negations
    of sumti will be used in Lojban conversation. The inability to
    manipulate these negations logically will, it is hoped, prevent
    the logical errors that result when natural languages attempt
    corresponding manipulations.</p>

    <h3><a id="s7" name="s7">7. Negation of minor grammatical constructs</h3>

    <p>We have a few other constructs that can be negated, all of
    them based on negating individual words. For such negation, we
    use the suffix-combining negator, which is ``nai''. ``nai'', by
    the way, is almost always written as a compound into the
    previous word that it is negating, although it is a regular
    separate-word cmavo and the sole member of selma'o NAI.</p>

    <p>Most of these negation forms are straightforward, and should
    be discussed and interpreted in connection with an analysis of
    the particular construct being negated. Thus, we will not go
    into much detail here.</p>

    <p>The following are places where ``nai'' is used:</p>

    <p>When attached to tenses and modals (see <a
    href="chapter10.html">Chapter 10</a>), the ``nai'' suffix usually
    indicates a contradictory negation of the tagged bridi. Thus
    ``punai'' as a tense inflection means ``not-in-the-past'', or
    ``not-previously'', without making any implication about any
    other time period unless explicitly stated. As a result,</p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  mi na pu klama le zarci
    I [false] [past] go-to the store.
    I didn't go to the store.
</pre>
    and 
<pre>
<a id="e7d2" name="e7d2">7.2)</a>  mi punai klama le zarci
    I [past-not] go-to the store.
    I didn't go to the store.
</pre>
    mean exactly the same thing, although there may be a difference
    of emphasis. 

    <p>Tenses and modals can be logically connected, with the
    logical connectives containing contradictory negations; this
    allows negated tenses and modals to be expressed positively
    using logical connectives. Thus ``punai je ca'' means the same
    thing as ``pu naje ca''.</p>

    <p>As a special case, a ``-nai'' attached to the interval
    modifiers of selma'o TAhE, ROI, or ZAhO (explained in <a
    href="chapter10.html">Chapter 10</a>) signals a scalar
    negation:</p>
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  mi paroinai dansu le bisli
    I [once] [not] dance-on the ice
</pre>
    means that I dance on the ice either zero or else two or more
    times within the relevant time interval described by the bridi.
    <a href="#e7d3">Example 7.3</a> is very different from the
    English use of ``not once'', which is an emphatic way of saying
    ``never'' --- that is, exactly zero times. 

    <p>In indicators and attitudinals of selma'o UI or CAI, ``nai''
    denotes a polar negation. As discussed in <a
    href="chapter13.html">Chapter 13</a>, most indicators have an
    implicit scale, and ``nai'' changes the indicator to refer to
    the opposite end of the scale. Thus ``.uinai'' expresses
    unhappiness, and ``.ienai'' expresses disagreement (not
    ambivalence, which is expressed with the neutral or undecided
    intensity as ``.iecu'i'').</p>

    <p>Vocative cmavo of selma'o COI are considered a kind of
    indicator, but one which identifies the listener. Semantically,
    we could dispense with about half of the COI selma'o words
    based on the scalar paradigm. For example, ``co'o'' could be
    expressed as ``coinai''. However, this is not generally
    done.</p>

    <p>Most of the COI cmavo are used in what are commonly called
    protocol situations. These protocols are used, for example, in
    radio conversations, which often take place in a noisy
    environment. The negatives of protocol words tend to convey
    diametrically opposite communications situations (as might be
    expected). Therefore, only one protocol vocative is dependent
    on ``nai'': negative acknowledgement, which is ``je'enai'' (``I
    didn't get that'').</p>

    <p>Unlike the attitudinal indicators, which tend to be
    unimportant in noisy situations, the protocol vocatives become
    more important. So if, in a noisy environment, a protocol
    listener makes out only ``nai'', he or she can presume it is a
    negative acknowledgement and repeat transmission or otherwise
    respond accordingly. <a href="chapter13.html">Chapter 13</a>
    provides more detail on this topic.</p>

    <p>The abstractors of selma'o NU follow the pattern of the
    tenses and modals. NU allows negative abstractions, especially
    in compound abstractions connected by logical connectives:
    ``su'ujeninai'', which corresponds to ``su'u jenai ni'' just as
    ``punai je ca'' corresponds to ``pu naje ca''. It is not clear
    how much use logically connected abstractors will be: see <a
    href="chapter13.html">Chapter 13</a>.</p>

    <p>A ``nai'' attached to a non-logical connective (of selma'o
    JOI or BIhI) is a scalar negation, and says that the bridi is
    false under the specified mixture, but that another connective
    is applicable. Non-logical connectives are discussed in <a
    href="chapter14.html">Chapter 14</a>.</p>

    <h3><a id="s8" name="s8">8. Truth questions</h3>

    <p>One application of negation is in answer to truth questions
    (those which expect the answers ``Yes'' or ``No''). The truth
    question cmavo ``xu'' is in selma'o UI; placed at the beginning
    of a sentence, it asks whether the sentence as a whole is true
    or false.</p>
<pre>
<a id="e8d1"
name="e8d1">8.1)</a>  xu la djan. pu klama la paris. .e la rom.
    Is it true that:
        (John previously went-to [both] Paris and Rome.)
</pre>

    <p>You can now use each of the several kinds of negation we've
    discussed in answer to this (presuming the same question and
    context for each answer).</p>

    <p>The straightforward negative answer is grammatically
    equivalent to the expanded sentence with the ``na'' immediately
    after the ``cu'' (and before any tense/modal):</p>
<pre>
<a id="e8d2" name="e8d2">8.2)</a>  na go'i
    [false] [repeat previous]
    No.
</pre>
    which means 
<pre>
<a id="e8d3"
name="e8d3">8.3)</a>  la djan. [cu] na pu klama la paris. .e la rom.
    John [false] previously went-to [both] Paris and Rome.
    It's not true that John went to Paris and Rome.
</pre>

    <p>The respondent can change the tense, putting the ``na'' in
    either before or after the new tense:</p>
<pre>
<a id="e8d4" name="e8d4">8.4)</a>  na ba go'i
    [false] [future] [repeat previous]
</pre>
    meaning 
<pre>
<a id="e8d5"
name="e8d5">8.5)</a>  la djan. [cu] na ba klama la paris. .e la rom.
    John [false] later-will-go-to [both] Paris and Rome.
    It is false that John will go to Paris and Rome.
</pre>
    or alternatively 
<pre>
<a id="e8d6" name="e8d6">8.6)</a>  ba na go'i
    [false] [future] [repeat previous]
</pre>
    meaning 
<pre>
<a id="e8d7"
name="e8d7">8.7)</a>  la djan. [cu] ba na klama la paris. .e la rom.
    John later-will [false] go-to [both] Paris and Rome.
</pre>

    <p>We stated in <a href="#s3">Section 3</a> that sentences like
    <a href="#e8d5">Example 8.5</a> and <a href="#e8d7">Example
    8.7</a> appear to be semantically identical, but that subtle
    semantic distinctions may eventually be found.</p>

    <p>You can also use a scalar negation with ``na'e'', in which
    case, it is equivalent to putting a ``na'eke'' immediately
    after any tense:</p>
<pre>
<a id="e8d8" name="e8d8">8.8)</a>  na'e go'i
    other-than [repeat previous]
</pre>
    which means 
<pre>
<a id="e8d9" name="e8d9">8.9)</a>  la djan. [cu] pu na'eke klama
        [ke'e] la paris. .e la rom.
    John previously other-than(went-to)
        [both] Paris and Rome.
</pre>

    <p>He might have telephoned the two cities instead of going
    there. The unnecessary ``ke'' and ``ke'e'' would have been
    essential if the selbri had been a tanru.</p>

    <h3><a id="s9" name="s9">9. Affirmations</h3>

    <p>There is an explicit positive form for both selma'o NA
    (``ja'a'') and selma'o NAhE (``je'a''), each of which would
    supplant the corresponding negator in the grammatical position
    used, allowing one to assert the positive in response to a
    negative question or statement without confusion. Assuming the
    same context as in <a href="#s8">Section 8</a>:</p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  xu na go'i
    Is-it-true-that [false] [repeat previous]?
</pre>
    or equivalently 
<pre>
<a id="e9d2" name="e9d2">9.2)</a>  xu la djan. [cu] na pu klama
        la paris. .e la rom.
    Is it true that: John [false] previously-went-to
        [both] Paris and Rome.]
</pre>

    <p>The obvious, but incorrect, positive response to this
    negative question is:</p>
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  go'i
    [repeat previous]
</pre>

    <p>A plain ``go'i'' does not mean ``Yes it is''; it merely
    abbreviates repeating the previous statement unmodified,
    including any negators present; and <a href="#e9d3">Example
    9.3</a> actually states that it is false that John went to both
    Paris and Rome.</p>

    <p>When considering:</p>
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  na go'i
    [false] [repeat previous]
</pre>
    as a response to a negative question like <a
    href="#e9d2">Example 9.2</a>, Lojban designers had to choose
    between two equally plausible interpretations with opposite
    effects. Does <a href="#e9d4">Example 9.4</a> create a double
    negative in the sentence by adding a new ``na'' to the one
    already there (forming a double negative and hence a positive
    statement), or does the ``na'' replace the previous one,
    leaving the sentence unchanged? 

    <p>It was decided that substitution, the latter alternative, is
    the preferable choice, since it is then clear whether we intend
    a positive or a negativ sentence without performing any
    manipulations. This is the way English usually works, but not
    all languages work this way --- Russian, Japanese, and Navajo
    all interpret a negative reply to a negative question as
    positive.</p>

    <p>The positive assertion cmavo of selma'o NA can also replace
    the ``na'' in the context, giving:</p>
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  ja'a go'i
    (John truly-(previously went-to) [both] Paris and Rome.)
</pre>
    ``ja'a'' can replace ``na'' in a similar manner wherever the
    latter is used: 
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  ja'a go'i
    John indeed previously went-to [both] Paris and Rome.
</pre>
    ``je'a'' can replace ``na'e'' in exactly the same way, stating
    that scalar negation does not apply, and that the relation
    indeed holds as stated. In the absence of a negation context,
    it emphasizes the positive: 
<pre>
<a id="e9d7" name="e9d7">9.7)</a>  ta je'a melbi
    that is-indeed beautiful.
</pre>

    <h3><a id="s10" name="s10">10. Metalinguistic negation forms</h3>

    <p>The question of truth or falsity is not entirely synonymous
    with negation. Consider the English sentence</p>
<pre>
<a id="e10d1"
name="e10d1">10.1)</a>    I have not stopped beating my wife.
</pre>

    <p>If I never started such a heinous activity, then this
    sentence is neither true nor false. Such a negation simply says
    that something is wrong with the non-negated statement.
    Generally, we then use either tone of voice or else a
    correction to express a preferred true claim: ``I never have
    beaten my wife.''</p>

    <p>Negations which follow such a pattern are called
    ``metalinguistic negations''. In natural languages, the mark of
    metalinguistic negation is that an indication of a correct
    statement always, or almost always, follows the negation. Tone
    of voice or emphasis may be further used to clarify the
    error.</p>

    <p>Negations of every sort must be expressible in Lojban;
    errors are inherent to human thought, and are not excluded from
    the language. When such negations are metalinguistic, we must
    separate them from logical claims about the truth or falsity of
    the statement, as well as from scalar negations which may not
    easily express (or imply) the preferred claim. Because Lojban
    allows concepts to be so freely combined in tanru, limits on
    what is plausible or not plausible tend to be harder to
    determine.</p>

    <p>Mimicking the muddled nature of natural language negation
    would destroy this separation. Since Lojban does not use tone
    of voice, we need other means to metalinguistically indicate
    what is wrong with a statement. When the statement is entirely
    inappropriate, we need to be able to express metalinguistic
    negation in a more non-specific fashion.</p>

    <p>Here is a list of some different kinds of metalinguistic
    negation with English-language examples:</p>
<pre>
<a id="e10d2"
name="e10d2">10.2)</a>    I have not <i>stopped</i> beating my wife
    (I never started --- failure of presupposition).

<a id="e10d3" name="e10d3">10.3)</a> 5 is not blue
    (color does not apply to abstract concepts --
    failure of category).

<a id="e10d4"
name="e10d4">10.4)</a> The current King of France is not bald.
    (there is no current King of France ---
    existential failure)

<a id="e10d5" name="e10d5">10.5)</a> I do not have THREE children.
    (I have two --- simple undue quantity)

<a id="e10d6"
name="e10d6">10.6)</a> I have not held THREE jobs previously, but four.
    (inaccurate quantity; the difference from the previous
    example is that someone who has held four jobs has also
    held three jobs)

<a id="e10d7" name="e10d7">10.7)</a> It is not good, but bad.
    (undue quantity negation indicating that the value on a
    scale for measuring the predicate is incorrect)

<a id="e10d8"
name="e10d8">10.8)</a> She is not PRETTY; she is beautiful
    (undue quantity transferred to a non-numeric scale)

<a id="e10d9"
name="e10d9">10.9)</a> The house is not blue, but green.
    (the scale/category being used is incorrect, but a
    related category applies)

<a id="e10d10"
name="e10d10">10.10)</a>   The house is not blue, but is colored.
    (the scale/category being used is incorrect, but a
    broader category applies)

<a id="e10d11"
name="e10d11">10.11)</a>   The cat is not blue, but long-haired.
    (the scale/category being used is incorrect, but an
    unrelated category applies)

<a id="e10d12" name="e10d12">10.12)</a>   A: He ain't coming today.
    B: ``Ain't'' ain't a word.
    (solecism, or improper grammatical action)

<a id="e10d13"
name="e10d13">10.13)</a>   I haven't STOOPED beating my wife; I've STOPPED.
    (spelling or mispronunciation error)

<a id="e10d14"
name="e10d14">10.14)</a>   Not only was it a sheep, it was a black sheep.
    (non-contradictory correction)
</pre>

    <p>The set of possible metalinguistic errors is open-ended.</p>

    <p>Many of these forms have a counterpart in the various
    examples that we've discussed under logical negation.
    Metalinguistic negation doesn't claim that the sentence is
    false or true, though. Rather, it claims that, due to some
    error in the statement, ``true'' and ``false'' don't really
    apply.</p>

    <p>Because one can metalinguistically negate a true statement
    intending a non-contradictory correction (say, a spelling
    error); we need a way (or ways) to metalinguistically negate a
    statement which is independent of our logical negation schemes
    using ``na'', ``na'e'' and kin. The cmavo ``na'i'' is assigned
    this function. If it is present in a statement, it indicates
    metalinguistically that something in the statement is
    incorrect. This metalinguistic negation must override any
    evaluation of the logic of the statement. It is equally allowed
    in both positive and negative statements.</p>

    <p>Since ``na'i'' is not a logical operator, multiple
    occurrences of ``na'i'' need not be assumed to cancel each
    other. Indeed, we can use the position of ``na'i'' to indicate
    metalinguistically what is incorrect, preparatory to correcting
    it in a later sentence; for this reason, we give ``na'i'' the
    grammar of UI. The inclusion of ``na'i'' anywhere in a sentence
    makes it a non-assertion, and suggests one or more pitfalls in
    assigning a truth value.</p>

    <p>Let us briefly indicate how the above-mentioned
    metalinguistic errors can be identified. Other metalinguistic
    problems can then be marked by devising analogies to these
    examples:</p>

    <p>Existential failure can be marked by attaching ``na'i'' to
    the descriptor ``lo'' or the ``poi'' in a ``da poi''-form
    sumti. (See Chapter 6 and <a href="chapter16.html">Chapter 16</a>
    for details on these constructions.) Remember that if a ``le''
    sumti seems to refer to a non-existent referent, you may not
    understand what the speaker has in mind --- the appropriate
    response is then ``ki'a'', asking for clarification.</p>

    <p>Presupposition failure can be marked directly if the
    presupposition is overt; if not, one can insert a ``mock
    presupposition'' to question with the sumti tcita (selma'o BAI)
    word ``ji'u''; ``ji'uku'' thus explicitly refers to an
    unexpressed assumption, and ``ji'una'iku'' metalinguistically
    says that something is wrong with that assumption. (See <a
    href="chapter10.html">Chapter 10</a>.)</p>

    <p>Scale errors and category errors can be similarly expressed
    with selma'o BAI. ``le'a'' has meaning ``of category/class/type
    X'', ``ci'u'' has meaning ``on scale X'', and ``ci'e'', based
    on ``ciste'', can be used to talk about universes of discourse
    defined either as systems or sets of components, as shown in <a
    href="#s8">Section 8</a>. ``kai'' and ``la'u'' also exist in
    BAI for discussing other quality and quantity errors.</p>

    <p>We have to make particular note of potential problems in the
    areas of undue quantity and incorrect scale/category.
    Assertions about the relationships between gismu are among the
    basic substance of the language. It is thus invalid to
    logically require that if something is blue, that it is
    colored, or if it is not-blue, then it is some other color. In
    Lojban, ``blanu'' (``blue'') is not explicitly defined as a
    ``skari'' (``color''). Similarly, it is not implicit that the
    opposite of ``good'' is ``bad''.</p>

    <p>This mutual independence of gismu is only an ideal.
    Pragmatically, people will categorize things based on their
    world-views. We will write dictionary definitions that will
    relate gismu, unfortunately including some of these world-view
    assumptions. Lojbanists should try to minimize these
    assumptions, but this seems a likely area where logical rules
    will break down (or where Sapir-Whorf effects will be made
    evident). In terms of negation, however, it is vital that we
    clearly preserve the capability of denying a presumably obvious
    scale or category assumption.</p>

    <p>Solecisms, grammatical and spelling errors will be marked by
    marking the offending word or phrase with ``na'i'' (in the
    manner of any selma'o UI cmavo). In this sense, ``na'i''
    becomes equivalent to the English metalinguistic marker
    ``[sic]''. Purists may choose to use ZOI or LOhU/LEhU quotes or
    ``sa'a''-marked corrections to avoid repeating a truly
    unparsable passage, especially if a computer is to analyze the
    speech/text. See <a href="chapter19.html">Chapter 19</a> for
    explanations of these usages.</p>

    <p>In summary, metalinguistic negation will typically take the
    form of referring to a previous statement and marking it with
    one or more ``na'i'' to indicate what metalinguistic errors
    have been made, and then repeating the statement with
    corrections. References to previous statements may be full
    repetitions, or may use members of selma'o GOhA. ``na'i'' at
    the beginning of a statement merely says that something is
    inappropriate about the statement, without specificity.</p>

    <p>In normal use, metalinguistic negation requires that a
    corrected statement follow the negated statement. In Lojban,
    however, it is possible to completely and unambiguously specify
    metalinguistic errors without correcting them. It will
    eventually be seen whether an uncorrected metalinguistic
    negation remains an acceptable form in Lojban. In such a
    statement, metalinguistic expression would involve an ellipsis
    not unlike that of tenseless expression.</p>

    <p>Note that metalinguistic negation gives us another kind of
    legitimate negative answer to a ``xu'' question (see <a
    href="#s8">Section 8</a>). ``na'i'' will be used when something
    about the questioned statement is inappropriate, such as in
    questions like ``Have you stopped beating your wife?'':</p>
<pre>
<a id="e10d15"
name="e10d15">10.15)</a>  xu do sisti lezu'o do rapydarxi
        ledo fetspe
    Have you ceased the activity of repeat-hitting
        your female-spouse?
</pre>

    <p>Responses could include:</p>
<pre>
<a id="e10d16" name="e10d16">10.16)</a>  na'i go'i
    The bridi as a whole is inappropriate in some way.

<a id="e10d17" name="e10d17">10.17)</a>   go'i na'i
    The selbri (sisti) is inappropriate in some way.
</pre>

    <p>One can also specifically qualify the metalinguistic
    negation, by explicitly repeating the erroneous portion of the
    bridi to be metalinguistically negated, or adding on of the
    selma'o BAI qualifiers mentioned above:</p>
<pre>
<a id="e10d18" name="e10d18">10.18)</a>  go'i ji'una'iku
    Some presupposition is wrong with the previous bridi.
</pre>

    <p>Finally, one may metalinguistically affirm a bridi with
    ``jo'a'', another cmavo of selma'o UI. A common use for
    ``jo'a'' might be to affirm that a particular construction,
    though unusual or counterintuitive, is in fact correct; another
    usage would be to disagree with --- by overriding --- a
    respondent's metalinguistic negation.</p>

    <h3><a id="s11" name="s11">11. Summary --- Are All Possible Questions About Negation
    Now Answered?</h3>
<pre>
<a id="e11d1"
name="e11d1">11.1)</a>    na go'i  .ije na'e go'i  .ije na'i go'i
</pre>

    <hr />
    
    <p>Derni&egrave;res modifications&nbsp;: Mon Jun 27 23:10:57 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
