
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//ES" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 17</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter17.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 17<br />
      As Easy As A-B-C? The Lojban Letteral System And Its
      Uses</h2>

      <!--
      <h6>$Revision: 4.1 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. What's a letteral, anyway?</h3>

    <p>James Cooke Brown, the founder of the Loglan Project, coined
    the word ``letteral'' (by analogy with ``numeral'') to mean a
    letter of the alphabet, such as ``f'' or ``z''. A typical
    example of its use might be</p>

    <p></p>
<pre>
<a id="e1d1"
name="e1d1">1.1)</a>  There are fourteen occurrences of the letteral
        ``e'' in this sentence.
</pre>
    (Don't forget the one within quotation marks.) Using the word
    ``letteral'' avoids confusion with ``letter'', the kind you
    write to someone. Not surprisingly, there is a Lojban gismu for
    ``letteral'', namely ``lerfu'', and this word will be used in
    the rest of this chapter. 

    <p>Lojban uses the Latin alphabet, just as English does, right?
    Then why is there a need for a chapter like this? After all,
    everyone who can read it already knows the alphabet. The answer
    is twofold:</p>

    <p>First, in English there are a set of words that correspond
    to and represent the English lerfu. These words are rarely
    written down in English and have no standard spellings, but if
    you pronounce the English alphabet to yourself you will hear
    them: ay, bee, cee, dee ... . They are used in spelling out
    words and in pronouncing most acronyms. The Lojban equivalents
    of these words are standardized and must be documented
    somehow.</p>

    <p>Second, English has names only for the lerfu used in writing
    English. (There are also English names for Greek and Hebrew
    lerfu: English-speakers usually refer to the Greek lerfu
    conventionally spelled ``phi'' as ``fye'', whereas ``fee''
    would more nearly represent the name used by Greek-speakers.
    Still, not all English-speakers know these English names.)
    Lojban, in order to be culturally neutral, needs a more
    comprehensive system that can handle, at least potentially, all
    of the world's alphabets and other writing systems.</p>

    <p>Letterals have several uses in Lojban: in forming acronyms
    and abbreviations, as mathematical symbols, and as pro-sumti
    --- the equivalent of English pronouns.</p>

    <p>In earlier writings about Lojban, there has been a tendency
    to use the word ``lerfu'' for both the letterals themselves and
    for the Lojban words which represent them. In this chapter,
    that tendency will be ruthlessly suppressed, and the term
    ``lerfu word'' will invariably be used for the latter. The
    Lojban equivalent would be ``lerfu valsi'' or ``lervla''.</p>

    <h3><a id="s2" name="s2">2. A to Z in Lojban, plus one</h3>

    <p>The first requirement of a system of lerfu words for any
    language is that they must represent the lerfu used to write
    the language. The lerfu words for English are a motley crew:
    the relationship between ``doubleyou'' and ``w'' is strictly
    historical in nature; ``aitch'' represents ``h'' but has no
    clear relationship to it at all; and ``z'' has two distinct
    lerfu words, ``zee'' and ``zed'', depending on the dialect of
    English in question.</p>

    <p>All of Lojban's basic lerfu words are made by one of three
    rules:</p>

    <dl>
      <dt></dt>

      <dd>to get a lerfu word for a vowel, add ``bu''; to get a
      lerfu word for a consonant, add ``y''; the lerfu word for
      ``''' is ``.y'y''.</dd>
    </dl>
    Therefore, the following table represents the basic Lojban
    alphabet: 
<pre>
   '   a   b   c   d   e
    .y'y.   .abu    by. cy. dy. .ebu

    f   g   i   j   k   l
    fy. gy. .ibu    jy. ky. ly.

    m   n   o   p   r   s
    my. ny. .obu    py. ry. sy.

    t   u   v   x   y   z
    ty. .ubu    vy. xy. .ybu    zy.
</pre>
    There are several things to note about this table. The
    consonant lerfu words are a single syllable, whereas the vowel
    and ``''' lerfu words are two syllables and must be preceded by
    pause (since they all begin with a vowel). Another fact, not
    evident from the table but important nonetheless, is that
    ``by'' and its like are single cmavo of selma'o BY, as is
    ``.y'y''. The vowel lerfu words, on the other hand, are
    compound cmavo, made from a single vowel cmavo plus the cmavo
    ``bu'' (which belongs to its own selma'o, BU). All of the vowel
    cmavo have other meanings in Lojban (logical connectives,
    sentence separator, hesitation noise), but those meanings are
    irrelevant when ``bu'' follows. 

    <p>Here are some illustrations of common Lojban words spelled
    out using the alphabet above:</p>
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  ty. .abu ny. ry. .ubu
    ``t'' ``a'' ``n'' ``r'' ``u''

<a id="e2d2" name="e2d2">2.2)</a>   ky. .obu .y'y. .abu
    ``k'' ``o'' ``''' ``a''
</pre>
    Spelling out words is less useful in Lojban than in English,
    for two reasons: Lojban spelling is phonemic, so there can be
    no real dispute about how a word is spelled; and the Lojban
    lerfu words sound more alike than the English ones do, since
    they are made up systematically. The English words ``fail'' and
    ``vale'' sound similar, but just hearing the first lerfu word
    of either, namely ``eff'' or ``vee'', is enough to discriminate
    easily between them --- and even if the first lerfu word were
    somehow confused, neither ``vail'' nor ``fale'' is a word of
    ordinary English, so the rest of the spelling determines which
    word is meant. Still, the capability of spelling out words does
    exist in Lojban. 

    <p>Note that the lerfu words ending in ``y'' were written (in
    <a href="#e2d1">Example 2.1</a> and <a href="#e2d2">Example
    2.2</a>) with pauses after them. It is not strictly necessary
    to pause after such lerfu words, but failure to do so can in
    some cases lead to ambiguities:</p>
<pre>
<a id="e2d3" name="e2d3">2.3)</a>  mi cy. claxu
    I lerfu-``c'' without
    I am without (whatever is referred to by)
        the letter ``c''.
</pre>
    without a pause after ``cy'' would be interpreted as: 
<pre>
<a id="e2d4" name="e2d4">2.4)</a>  micyclaxu
    (Observative:) doctor-without
    Something unspecified is without a doctor.
</pre>

    <p>A safe guideline is to pause after any cmavo ending in ``y''
    unless the next word is also a cmavo ending in ``y''. The
    safest and easiest guideline is to pause after all of them.</p>

    <h3><a id="s3" name="s3">3. Upper and lower cases</h3>

    <p>Lojban doesn't use lower-case (small) letters and upper-case
    (capital) letters in the same way that English does; sentences
    do not begin with an upper-case letter, nor do names. However,
    upper-case letters are used in Lojban to mark irregular stress
    within names, thus:</p>
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  .iVAN.
    the name ``Ivan'' in Russian/Slavic pronunciation.
</pre>
    It would require far too many cmavo to assign one for each
    upper-case and one for each lower-case lerfu, so instead we
    have two special cmavo ``ga'e'' and ``to'a'' representing upper
    case and lower case respectively. They belong to the same
    selma'o as the basic lerfu words, namely BY, and they may be
    freely interspersed with them. 

    <p>The effect of ``ga'e'' is to change the interpretation of
    all lerfu words following it to be the upper-case version of
    the lerfu. An occurrence of ``to'a'' causes the interpretation
    to revert to lower case. Thus, ``ga'e .abu'' means not ``a''
    but ``A'', and Ivan's name may be spelled out thus:</p>
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  .ibu ga'e vy. .abu ny. to'a
    i [upper] V A N [lower]
</pre>
    The cmavo and compound cmavo of this type will be called
    ``shift words''. 

    <p>How long does a shift word last? Theoretically, until the
    next shift word that contradicts it or until the end of text.
    In practice, it is common to presume that a shift word is only
    in effect until the next word other than a lerfu word is
    found.</p>

    <p>It is often convenient to shift just a single letter to
    upper case. The cmavo ``tau'', of selma'o LAU, is useful for
    the purpose. A LAU cmavo must always be immediately followed by
    a BY cmavo or its equivalent: the combination is grammatically
    equivalent to a single BY. (See <a href="#s14">Section 14</a>
    for details.)</p>

    <p>A likely use of ``tau'' is in the internationally
    standardized symbols for the chemical elements. Each element is
    represented using either a single upper-case lerfu or one
    upper-case lerfu followed by one lower-case lerfu:</p>

    <p></p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  tau sy.
    [single shift] S
    S (chemical symbol for sulfur)
</pre>
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  tau sy. .ibu
    [single shift] S i
    Si (chemical symbol for silicon)
</pre>
    If a shift to upper-case is in effect when ``tau'' appears, it
    shifts the next lerfu word only to lower case, reversing its
    usual effect. 

    <h3><a id="s4" name="s4">4. The universal ``bu''</h3>

    <p>So far we have seen ``bu'' only as a suffix to vowel cmavo
    to produce vowel lerfu words. Originally, this was the only use
    of ``bu''. In developing the lerfu word system, however, it
    proved to be useful to allow ``bu'' to be attached to any word
    whatsoever, in order to allow arbitrary extensions of the basic
    lerfu word set.</p>

    <p>Formally, ``bu'' may be attached to any single Lojban word.
    Compound cmavo do not count as words for this purpose. The
    special cmavo ``ba'e'', ``za'e'', ``zei'', ``zo'', ``zoi'',
    ``la'o'', ``lo'u'', ``si'', ``sa'', ``su'', and ``fa'o'' may
    not have ``bu'' attached, because they are interpreted before
    ``bu'' detection is done; in particular,</p>

    <p></p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  zo bu
    the word ``bu''
</pre>
    is needed when discussing ``bu'' in Lojban. It is also illegal
    to attach ``bu'' to itself, but more than one ``bu'' may be
    attached to a word; thus ``.abubu'' is legal, if ugly. (Its
    meaning is not defined, but it is presumably different from
    ``.abu''.) It does not matter if the word is a cmavo, a cmene,
    or a brivla. All such words suffixed by ``bu'' are treated
    grammatically as if they were cmavo belonging to selma'o BY.
    However, if the word is a cmene it is always necessary to
    precede and follow it by a pause, because otherwise the cmene
    may absorb preceding or following words. 

    <p>The ability to attach ``bu'' to words has been used
    primarily to make names for various logograms and other unusual
    characters. For example, the Lojban name for the ``happy face''
    is ``.uibu'', based on the attitudinal ``.ui'' that means
    ``happiness''. Likewise, the ``smiley face'', written ``:-)''
    and used on computer networks to indicate humor, is called
    ``zo'obu'' The existence of these names does not mean that you
    should insert ``.uibu'' into running Lojban text to indicate
    that you are happy, or ``zo'obu'' when something is funny;
    instead, use the appropriate attitudinal directly.</p>

    <p>Likewise, ``joibu'' represents the ampersand character,
    ``&amp;'', based on the cmavo ``joi'' meaning ``mixed and''.
    Many more such lerfu words will probably be invented in
    future.</p>

    <p>The ``.'' and ``,'' characters used in Lojbanic writing to
    represent pause and syllable break respectively have been
    assigned the lerfu words ``denpa bu'' (literally, ``pause bu'')
    and ``slaka bu'' (literally, ``syllable bu''). The written
    space is mandatory here, because ``denpa'' and ``slaka'' are
    normal gismu with normal stress: ``denpabu'' would be a fu'ivla
    (word borrowed from another language into Lojban) stressed
    ``denPAbu''. No pause is required between ``denpa'' (or
    ``slaka'') and ``bu'', though.</p>

    <h3><a id="s5" name="s5">5. Alien alphabets</h3>

    <p>As stated in <a href="#s1">Section 1</a>, Lojban's goal of
    cultural neutrality demands a standard set of lerfu words for
    the lerfu of as many other writing systems as possible. When we
    meet these lerfu in written text (particularly, though not
    exclusively, mathematical text), we need a standard Lojbanic
    way to pronounce them.</p>

    <p>There are certainly hundreds of alphabets and other writing
    systems in use around the world, and it is probably an
    unachievable goal to create a single system which can express
    all of them, but if perfection is not demanded, a usable system
    can be created from the raw material which Lojban provides.</p>

    <p>One possibility would be to use the lerfu word associated
    with the language itself, Lojbanized and with ``bu'' added.
    Indeed, an isolated Greek ``alpha'' in running Lojban text is
    probably most easily handled by calling it ``.alfas. bu''. Here
    the Greek lerfu word has been made into a Lojbanized name by
    adding ``s'' and then into a Lojban lerfu word by adding
    ``bu''. Note that the pause after ``.alfas.'' is still
    needed.</p>

    <p>Likewise, the easiest way to handle the Latin letters ``h'',
    ``q'', and ``w'' that are not used in Lojban is by a consonant
    lerfu word with ``bu'' attached. The following assignments have
    been made:</p>
<pre>
       .y'y.bu     h
        ky.bu       q
        vy.bu       w
</pre>
    As an example, the English word ``quack'' would be spelled in
    Lojban thus: 
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  ky.bu .ubu .abu cy. ky.
    ``q'' ``u'' ``a'' ``c'' ``k''
</pre>
    Note that the fact that the letter ``c'' in this word has
    nothing to do with the sound of the Lojban letter ``c'' is
    irrelevant; we are spelling an English word and English rules
    control the choice of letters, but we are speaking Lojban and
    Lojban rules control the pronunciations of those letters. 

    <p>A few more possibilities for Latin-alphabet letters used in
    languages other than English:</p>
<pre>
       ty.bu       &thorn; (thorn)
        dy.bu       &amp;edh; (edh)
        

However, this system is not ideal for all purposes.  For one thing, it is
verbose.  The native lerfu words are often quite long, and with ``bu'' added
they become even longer: the worst-case Greek lerfu word would be
``.Omikron. bu'', with four syllables and two mandatory pauses.  In addition,
alphabets that are used by many languages have separate sets of lerfu words
for each language, and which set is Lojban to choose?
</pre>
    The alternative plan, therefore, is to use a shift word similar
    to those introduced in <a href="#s3">Section 3</a>. After the
    appearance of such a shift word, the regular lerfu words are
    re-interpreted to represent the lerfu of the alphabet now in
    use. After a shift to the Greek alphabet, for example, the
    lerfu word ``ty'' would represent not Latin ``t'' but Greek
    ``tau''. Why ``tau''? Because it is, in some sense, the closest
    counterpart of ``t'' within the Greek lerfu system. In
    principle it would be all right to map ``ty.'' to ``phi'' or
    even ``omega'', but such an arbitrary relationship would be
    extremely hard to remember. 

    <p>Where no obvious closest counterpart exists, some more or
    less arbitrary choice must be made. Some alien lerfu may simply
    not have any shifted equivalent, forcing the speaker to fall
    back on a ``bu'' form. Since a ``bu'' form may mean different
    things in different alphabets, it is safest to employ a shift
    word even when ``bu'' forms are in use.</p>

    <p>Shifts for several alphabets have been assigned cmavo of
    selma'o BY:</p>

    <p></p>
<pre>
   lo'a    Latin/Roman/Lojban alphabet
    ge'o    Greek alphabet
    je'o    Hebrew alphabet
    jo'o    Arabic alphabet
    ru'o    Cyrillic alphabet
</pre>
    The cmavo ``zai'' (of selma'o LAU) is used to create shift
    words to still other alphabets. The BY word which must follow
    any LAU cmavo would typically be a name representing the
    alphabet with ``bu'' suffixed: 

    <p></p>
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  zai .devanagar. bu
    Devanagari (Hindi) alphabet
</pre>
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  zai .katakan. bu
    Japanese katakana syllabary
</pre>
<pre>
<a id="e5d4" name="e5d4">5.4)</a>  zai .xiragan. bu
    Japanese hiragana syllabary
</pre>
    Unlike the cmavo above, these shift words have not been
    standardized and probably will not be until someone actually
    has a need for them. (Note the ``.'' characters marking leading
    and following pauses.) 

    <p>In addition, there may be multiple visible representations
    within a single alphabet for a given letter: roman vs. italics,
    handwriting vs. print, Bodoni vs. Helvetica. These traditional
    ``font and face'' distinctions are also represented by shift
    words, indicated with the cmavo ``ce'a'' (of selma'o LAU) and a
    following BY word:</p>

    <p></p>
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  ce'a .xelveticas. bu
    Helvetica font
</pre>
<pre>
<a id="e5d6" name="e5d6">5.6)</a>  ce'a .xancisk. bu
    handwriting
</pre>
<pre>
<a id="e5d7" name="e5d7">5.7)</a>  ce'a .pavrel. bu
    12-point font size
</pre>
    The cmavo ``na'a'' (of selma'o BY) is a universal shift-word
    cancel: it returns the interpretation of lerfu words to the
    default of lower-case Lojban with no specific font. It is more
    general than ``lo'a'', which changes the alphabet only,
    potentially leaving font and case shifts in place. 

    <p>Several sections at the end of this chapter contain tables
    of proposed lerfu word assignments for various languages.</p>

    <h3><a id="s6" name="s6">6. Accent marks and compound lerfu words</h3>

    <p>Many languages that make use of the Latin alphabet add
    special marks to some of the lerfu they use. French, for
    example, uses three accent marks above vowels, called (in
    English) ``acute'', ``grave'', and ``circumflex''. Likewise,
    German uses a mark called ``umlaut''; a mark which looks the
    same is also used in French, but with a different name and
    meaning.</p>

    <p>These marks may be considered lerfu, and each has a
    corresponding lerfu word in Lojban. So far, no problem. But the
    marks appear over lerfu, whereas the words must be spoken (or
    written) either before or after the lerfu word representing the
    basic lerfu. Typewriters (for mechanical reasons) and the
    computer programs that emulate them usually require their users
    to type the accent mark before the basic lerfu, whereas in
    speech the accent mark is often pronounced afterwards (for
    example, in German ``a umlaut'' is preferred to ``umlaut
    a'').</p>

    <p> Lojban cannot settle this question by fiat. Either it must be
    left up to default interpretation depending on the language in
    question, or the lerfu-word compounding cmavo ``tei'' (of selma'o
    TEI) and ``foi'' (of selma'o FOI) must be used. These cmavo are
    always used in pairs; any number of lerfu words may appear between
    them, and the whole is treated as a single compound lerfu word. The
    French word ``&eacute;t&eacute;'', with acute accent marks on both
    ``e'' lerfu, could be spelled as:</p>

    <p></p>
<pre>
<a id="e6d1"
name="e6d1">6.1)</a>  tei .ebu .akut. bu foi ty. tei .akut. bu .ebu foi
    ( ``e'' acute ) ``t'' ( acute ``e'' )
</pre>
    and it does not matter whether ``akut. bu''
    appears before or after ``.ebu''; the ``tei ... foi'' grouping
    guarantees that the acute accent is associated with the correct
    lerfu. Of course, the level of precision represented by <a
    href="#e6d1">Example 6.1</a> would rarely be required: it might
    be needed by a Lojban-speaker when spelling out a French word
    for exact transcription by another Lojban-speaker who did not
    know French. 

    <p>This system breaks down in languages which use more than one
    accent mark on a single lerfu; some other convention must be
    used for showing which accent marks are written where in that
    case. The obvious convention is to represent the mark nearest
    the basic lerfu by the lerfu word closest to the word
    representing the basic lerfu. Any remaining ambiguities must be
    resolved by further conventions not yet established.</p>

    <p>Some languages, like Swedish and Finnish, consider certain
    accented lerfu to be completely distinct from their unaccented
    equivalents, but Lojban does not make a formal distinction,
    since the printed characters look the same whether they are
    reckoned as separate letters or not. In addition, some
    languages consider certain 2-letter combinations (like ``ll''
    and ``ch'' in Spanish) to be letters; this may be represented
    by enclosing the combination in ``tei ... foi''.</p>

    <p>In addition, when discussing a specific language, it is
    permissible to make up new lerfu words, as long as they are
    either explained locally or well understood from context: thus
    Spanish ``ll'' or Croatian ``lj'' could be called ``libu'', but
    that usage would not necessarily be universally understood.</p>

    <p><a href="#s19">Section 19</a> contains a table of proposed
    lerfu words for some common accent marks.</p>

    <h3><a id="s7" name="s7">7. Punctuation marks</h3>

    <p>Lojban does not have punctuation marks as such: the denpa bu
    and the slaka bu are really a part of the alphabet. Other
    languages, however, use punctuation marks extensively. As yet,
    Lojban does not have any words for these punctuation marks, but
    a mechanism exists for devising them: the cmavo ``lau'' of
    selma'o LAU. ``lau'' must always be followed by a BY word; the
    interpretation of the BY word is changed from a lerfu to a
    punctuation mark. Typically, this BY word would be a name or
    brivla with a ``bu'' suffix.</p>

    <p>Why is ``lau'' necessary at all? Why not just use a
    ``bu''-marked word and announce that it is always to be
    interpreted as a punctuation mark? Primarily to avoid
    ambiguity. The ``bu'' mechanism is extremely open-ended, and it
    is easy for Lojban users to make up ``bu'' words without
    bothering to explain what they mean. Using the ``lau'' cmavo
    flags at least the most important of such nonce lerfu words as
    having a special function: punctuation. (Exactly the same
    argument applies to the use of ``zai'' to signal an alphabet
    shift or ``ce'a'' to signal a font shift.)</p>

    <p>Since different alphabets require different punctuation
    marks, the interpretation of a ``lau''-marked lerfu word is
    affected by the current alphabet shift and the current font
    shift.</p>

    <h3><a id="s8" name="s8">8. What about Chinese characters?</h3>

    <p>Chinese characters (``han<sup>4</sup>zi<sup>4</sup>'' in
    Chinese, ``kanji'' in Japanese) represent an entirely different
    approach to writing from alphabets or syllabaries. (A
    syllabary, such as Japanese hiragana or Amharic writing, has
    one lerfu for each syllable of the spoken language.) Very
    roughly, Chinese characters represent single elements of
    meaning; also very roughly, they represent single syllables of
    spoken Chinese. There is in principle no limit to the number of
    Chinese characters that can exist, and many thousands are in
    regular use.</p>

    <p>It is hopeless for Lojban, with its limited lerfu and shift
    words, to create an alphabet which will match this diversity.
    However, there are various possible ways around the
    problem.</p>

    <p>First, both Chinese and Japanese have standard
    Latin-alphabet representations, known as ``pinyin'' for Chinese
    and ``romaji'' for Japanese, and these can be used. Thus, the
    word ``han<sup>4</sup>zi<sup>4</sup>'' is conventionally
    written with two characters, but it may be spelled out as:</p>

    <p></p>
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  .y'y.bu .abu ny. vo zy. .ibu vo
    ``h'' ``a'' ``n'' 4 ``z'' ``i'' 4
</pre>
    The cmavo ``vo'' is the Lojban digit ``4''. It is grammatical
    to intersperse digits (of selma'o PA) into a string of lerfu
    words; as long as the first cmavo is a lerfu word, the whole
    will be interpreted as a string of lerfu words. In Chinese, the
    digits can be used to represent tones. Pinyin is more usually
    written using accent marks, the mechanism for which was
    explained in <a href="#s6">Section 6</a>. 

    <p>The Japanese company named ``Mitsubishi'' in English is
    spelled the same way in romaji, and could be spelled out in
    Lojban thus:</p>

    <p></p>
<pre>
<a id="e8d2"
name="e8d2">8.2)</a>  my. .ibu ty. sy. .ubu by. .ibu sy. .y'y.bu .ibu
    ``m'' ``i'' ``t'' ``s'' ``u'' ``b'' ``i'' ``s'' ``h'' ``i''
</pre>
    Alternatively, a really ambitious Lojbanist could assign lerfu
    words to the individual strokes used to write Chinese
    characters (there are about seven or eight of them if you are a
    flexible human being, or about 40 if you are a rigid computer
    program), and then represent each character with a ``tei'', the
    stroke lerfu words in the order of writing (which is
    standardized for each character), and a ``foi''. No one has as
    yet attempted this project. 

    <h3><a id="s9" name="s9">9. lerfu words as pro-sumti</h3>

    <p>So far, lerfu words have only appeared in Lojban text when
    spelling out words. There are several other grammatical uses of
    lerfu words within Lojban. In each case, a single lerfu word or
    more than one may be used. Therefore, the term ``lerfu string''
    is introduced: it is short for ``sequence of one or more lerfu
    words''.</p>

    <p>A lerfu string may be used as a pro-sumti (a sumti which
    refers to some previous sumti), just like the pro-sumti
    ``ko'a'', ``ko'e'', and so on:</p>

    <p></p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  .abu prami by.
    A loves B
</pre>

    <p>In <a href="#e9d1">Example 9.1</a>, ``.abu'' and ``by.''
    represent specific sumti, but which sumti they represent must
    be inferred from context.</p>

    <p>Alternatively, lerfu strings may be assigned by ``goi'', the
    regular pro-sumti assignment cmavo:</p>
<pre>
<a id="e9d2"
name="e9d2">9.2)</a>  le gerku goi gy. cu xekri .i gy. klama le zdani
    The dog, or G, is black.  G goes to the house.
</pre>
    There is a special rule that sometimes makes lerfu strings more
    advantageous than the regular pro-sumti cmavo. If no assignment
    can be found for a lerfu string (especially a single lerfu
    word), it can be assumed to refer to the most recent sumti
    whose name or description begins in Lojban with that lerfu. So
    <a href="#e9d2">Example 9.2</a> can be rephrased: 
<pre>
<a id="e9d3"
name="e9d3">9.3)</a>  le gerku cu xekri. .i gy. klama le zdani
    The dog is black.  G goes to the house.
</pre>
    (A less literal English translation would use ``D'' for ``dog''
    instead.) 

    <p>Here is an example using two names and longer lerfu
    strings:</p>

    <p></p>
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  la stivn. mark. djonz. merko
        .i la .aleksandr. paliitc. kuzNIETsyf. rusko
        .i symyjy. tavla .abupyky. bau la lojban.
    Steven Mark Jones is-American.
        Alexander Pavlovitch Kuznetsov is-Russian.
        SMJ talks-to APK in Lojban.
</pre>

    <p>Perhaps Alexander's name should be given as ``ru'o.abupyky''
    instead.</p>

    <p>What about</p>

    <p></p>
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  .abu dunda by. cy.
    A gives B C
</pre>
    Does this mean that A gives B to C? No. ``by. cy.'' is a single
    lerfu string, although written as two words, and represents a
    single pro-sumti. The true interpretation is that A gives BC to
    someone unspecified. To solve this problem, we need to
    introduce the elidable terminator ``boi'' (of selma'o BOI).
    This cmavo is used to terminate lerfu strings and also strings
    of numerals; it is required when two of these appear in a row,
    as here. (The other reason to use ``boi'' is to attach a free
    modifier --- subscript, parenthesis, or what have you --- to a
    lerfu string.) The correct version is: 

    <p></p>
<pre>
<a id="e9d6"
name="e9d6">9.6)</a>  .abu [boi] dunda by. boi cy. [boi]
    A gives B to C
</pre>
    where the two occurrences of ``boi'' in brackets are elidable,
    but the remaining occurrence is not. Likewise: 
<pre>
<a id="e9d7" name="e9d7">9.7)</a>  xy. boi ro [boi] prenu cu prami
    X all persons loves.
    X loves everybody.
</pre>
    requires the first ``boi'' to separate the lerfu string ``xy.''
    from the digit string ``ro''. 

    <h3><a id="s10" name="s10">10. References to lerfu</h3>

    <p>The rules of <a href="#s9">Section 9</a> make it impossible
    to use unmarked lerfu words to refer to lerfu themselves. In
    the sentence:</p>
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    .abu. cu lerfu
    A is-a-letteral.
</pre>
    the hearer would try to find what previous sumti ``.abu''
    refers to. The solution to this problem makes use of the cmavo
    ``me'o'' of selma'o LI, which makes a lerfu string into a sumti
    representing that very string of lerfu. This use of ``me'o'' is
    a special case of its mathematical use, which is to introduce a
    mathematical expression used literally rather than for its
    value. 

    <p></p>
<pre>
<a id="e10d2" name="e10d2">10.2)</a>    me'o .abu cu lerfu
    the-expression ``a'' is-a-letteral.
</pre>

    <p>Now we can translate <a href="#e1d1">Example 1.1</a> into
    Lojban:</p>

    <p></p>
<pre>
<a id="e10d4" name="e10d4">10.4)</a>    dei vasru vo lerfu
        po'u me'o .ebu
    this-sentence contains four letterals
        which-are the-expression ``e''.
    This sentence contains four ``e''s.
</pre>

    <p>Since the Lojban sentence has only four ``e'' lerfu rather
    than fourteen, the translation is not a literal one --- but <a
    href="#e10d4">Example 10.4</a> is a Lojban truth just as <a
    href="#e1d1">Example 1.1</a> is an English truth.
    Coincidentally, the colloquial English translation of <a
    href="#e10d4">Example 10.4</a> is also true!</p>

    <p> The reader might be tempted to use quotation with ``lu ...
    li'u'' instead of ``me'o'', producing:</p>
<pre>
<a id="e10d4.5" name="e10d4.5">10.4.5)</a>    lu .abu li'u cu lerfu
    [quote] .abu [unquote] is-a-letteral.
</pre>
    (The single-word quote ``zo'' cannot be used, because ``.abu''
    is a compound cmavo.) But <a href="#e10d4">Example 10.4</a> is
    false, because it says: 

    <p></p>
<pre>
<a id="e10d5"
name="e10d5">10.5)</a>    The word ``.abu'' is a letteral
</pre>
    which is not the case; rather, the thing symbolized by the word
    ``.abu'' is a letteral. In Lojban, that would be: 
<pre>
<a id="e10d6" name="e10d6">10.6)</a>    la'e lu .abu li'u cu lerfu
    The-referent-of [quote] .abu [unquote] is-a-letteral.
</pre>
    which is correct. 

    <h3><a id="s11" name="s11">11. Mathematical uses of lerfu strings</h3>

    <p>This chapter is not about Lojban mathematics, which is
    explained in <a href="chapter18.html">Chapter 18</a>, so the
    mathematical uses of lerfu strings will be listed and
    exemplified but not explained.</p>

    <p>A lerfu string as mathematical variable:</p>
<pre>
<a id="e11d1" name="e11d1">11.1)</a>    li .abu du li by. su'i cy.
    the-number a equals the-number b plus c
    a = b + c
</pre>
    A lerfu string as function name (preceded by ``ma'o'' of
    selma'o MAhO): 

    <p></p>
<pre>
<a id="e11d2"
name="e11d2">11.2)</a>    li .y.bu du li ma'o fy. boi xy.
    the-number y equals the number the-function f of x
    y = f(x)
</pre>

    <p>Note the ``boi'' here to separate the lerfu strings ``fy''
    and ``xy''.</p>

    <p>A lerfu string as selbri (followed by a cmavo of selma'o
    MOI):</p>

    <p></p>
<pre>
<a id="e11d3"
name="e11d3">11.3)</a>    le vi ratcu ny.moi le'i mi ratcu
    the here rat is-nth-of the-set-of my rats
    This rat is my Nth rat.
</pre>
    A lerfu string as utterance ordinal (followed by a cmavo of
    selma'o MAI): 

    <p></p>
<pre>
<a id="e11d4" name="e11d4">11.4)</a>    ny.mai
    Nthly
</pre>
    A lerfu string as subscript (preceded by ``xi'' of selma'o XI):
    

    <p></p>
<pre>
<a id="e11d5" name="e11d5">11.5)</a>    xy. xi ky.
    x sub k
</pre>
    A lerfu string as quantifier (enclosed in ``vei ... ve'o''
    parentheses): 

    <p></p>
<pre>
<a id="e11d6" name="e11d6">11.6)</a>    vei ny. [ve'o] lo prenu
    ( ``n'' ) persons
</pre>
    The parentheses are required because ``ny. lo prenu'' would be
    two separate sumti, ``ny.'' and ``lo prenu''. In general, any
    mathematical expression other than a simple number must be in
    parentheses when used as a quantifier; the right parenthesis
    mark, the cmavo ``ve'o'', can usually be elided. 

    <p>All the examples above have exhibited single lerfu words
    rather than lerfu strings, in accordance with the conventions
    of ordinary mathematics. A longer lerfu string would still be
    treated as a single variable or function name: in Lojban,
    ``.abu by. cy.'' is not the multiplication ``a x b x c'' but is
    the variable ``abc''. (Of course, a local convention could
    exist that made the value of a variable like ``abc'', with a
    multi-lerfu-word name, equal to the values of the variables
    ``a'', ``b'', and ``c'' multiplied together.)</p>

    <p>There is a special rule about shift words in mathematical
    text: shifts within mathematical expressions do not affect
    lerfu words appearing outside</p>

    <dl>
      <dt>mathematical expressions, and vice versa.</dt>
    </dl>

    <h3><a id="s12" name="s12">12. Acronyms</h3>

    <p>An acronym is a name constructed of lerfu. English examples
    are ``DNA'', ``NATO'', ``CIA''. In English, some of these are
    spelled out (like ``DNA'' and ``CIA'') and others are
    pronounced more or less as if they were ordinary English words
    (like ``NATO''). Some acronyms fluctuate between the two
    pronunciations: ``SQL'' may be ``ess cue ell'' or
    ``sequel''.</p>

    <p>In Lojban, a name can be almost any sequence of sounds that
    ends in a consonant and is followed by a pause. The easiest way
    to Lojbanize acronym names is to glue the lerfu words together,
    using ``''' wherever two vowels would come together (pauses are
    illegal in names) and adding a final consonant:</p>

    <p></p>
<pre>
<a id="e12d1"
name="e12d1">12.1)</a>    la dyny'abub. .i la ny'abuty'obub.
    .i la cy'ibu'abub. .i la sykybulyl.
    .i la .ibubymym. .i la ny'ybucyc.
    DNA. NATO.
    CIA. SQL.
    IBM. NYC.
</pre>
    There is no fixed convention for assigning the final consonant.
    In <a href="#e12d1">Example 12.1</a>, the last consonant of the
    lerfu string has been replicated into final position. 

    <p>Some compression can be done by leaving out ``bu'' after
    vowel lerfu words (except for ``.y.bu'', wherein the ``bu''
    cannot be omitted without ambiguity). Compression is moderately
    important because it's hard to say long names without
    introducing an involuntary (and illegal) pause:</p>
<pre>
<a id="e12d2"
name="e12d2">12.2)</a>    la dyny'am. .i la ny'aty'om.
    .i la cy'i'am. .i la sykybulym.
    .i la .ibymym. .i la ny'ybucym.
    DNA. NATO.
    CIA. SQL.
    IBM. NYC.
</pre>

    <p>In <a href="#e12d2">Example 12.2</a>, the final consonant
    ``m'' stands for ``merko'', indicating the source culture of
    these acronyms.</p>

    <p>Another approach, which some may find easier to say and
    which is compatible with older versions of the language that
    did not have a ``''' character, is to use the consonant ``z''
    instead of ``''':</p>
<pre>
<a id="e12d3"
name="e12d3">12.3)</a>    la dynyzaz. .i la nyzatyzoz.
    .i la cyzizaz. .i la sykybulyz.
    .i la .ibymyz. .i la nyzybucyz.
    DNA. NATO.
    CIA. SQL.
    IBM. NYC.
</pre>
    One more alternative to these lengthy names is to use the lerfu
    string itself prefixed with ``me'', the cmavo that makes sumti
    into selbri: 
<pre>
<a id="e12d4" name="e12d4">12.4)</a>    la me dy ny. .abu
    that-named what-pertains-to ``d'' ``n'' ``a''
</pre>

    <p>This works because ``la'', the cmavo that normally
    introduces names used as sumti, may also be used before a
    predicate to indicate that the predicate is a (meaningful)
    name:</p>
<pre>
<a id="e12d5" name="e12d5">12.5)</a>    la cribe cu ciska
    that-named ``Bear'' writes
    Bear is a writer
</pre>
    <a href="#e12d5">Example 12.5</a> does not of course refer to a
    bear (``le cribe'' or ``lo cribe'') but to something else,
    probably a person, named ``Bear''. Similarly, ``me dy ny.
    .abu'' is a predicate which can be used as a name, producing a
    kind of acronym which can have pauses between the individual
    lerfu words. 

    <h3><a id="s13" name="s13">13. Computerized character codes</h3>

    <p>Since the first application of computers to non-numerical
    information, character sets have existed, mapping numbers
    (called ``character codes'') into selected lerfu, digits, and
    punctuation marks (collectively called ``characters'').
    Historically, these character sets have only covered the
    English alphabet and a few selected punctuation marks.
    International efforts are now underway to create a unified
    character set that can represent essentially all the characters
    in essentially all the world's writing systems. Lojban can take
    advantage of these encoding schemes by using the cmavo ``se'e''
    (of selma'o BY). This cmavo is conventionally followed by digit
    cmavo of selma'o PA representing the character code, and the
    whole string indicates a single character in some computerized
    character set:</p>

    <p></p>
<pre>
<a id="e13d1" name="e13d1">13.1)</a>    me'o se'ecixa cu lerfu
        la .asycy'i'is. loi merko rupnu
    the-expression [code] 36 is-a-letteral
        in-set ASCII
        for-the-mass-of American currency-units.
    The character code 36 in ASCII represents
        American dollars.
    ``&amp;dollar;'' represents American dollars.
</pre>
    Understanding <a href="#e13d1">Example 13.1</a> depends on
    knowing the value in the ASCII character set (one of the
    simplest and oldest) of the ``&amp;dollar;'' character.
    Therefore, the ``se'e'' convention is only intelligible to
    those who know the underlying character set. For precisely
    specifying a particular character, however, it has the
    advantages of unambiguity and (relative) cultural neutrality,
    and therefore Lojban provides a means for those with access to
    descriptions of such character sets to take advantage of them. 

    <p>As another example, the Unicode character set (also known as
    ISO 10646) represents the international symbol of peace, an
    inverted trident in a circle, using the base-16 value 262E. In
    a suitable context, a Lojbanist may say:</p>
<pre>
<a id="e13d2"
name="e13d2">13.2)</a>    me'o se'erexarerei sinxa le ka panpi
    the-expression [code] 262E is-a-sign-of
        the quality-of being-at-peace
</pre>
    When a ``se'e'' string appears in running discourse, some
    metalinguistic convention must specify whether the number is
    base 10 (as above) or some other base, and which character set
    is in use. 

    <h3><a id="s14" name="s14">14. List of all auxiliary lerfu-word cmavo</h3>

    <p></p>
<pre>
   cmavo   selma'o     meaning

    bu  BU      makes previous word into
                    a lerfu word
    ga'e    BY      upper case shift
    to'a    BY      lower case shift
    tau LAU     case-shift next lerfu word only
    lo'a    BY      Latin/Lojban alphabet shift
    ge'o    BY      Greek alphabet shift
    je'o    BY      Hebrew alphabet shift
    jo'o    BY      Arabic alphabet shift
    ru'o    BY      Cyrillic alphabet shift
    se'e    BY      following digits are
                    a character code
    na'a    BY      cancel all shifts
    zai LAU     following lerfu word
                    specifies alphabet
    ce'a    LAU     following lerfu word
                    specifies font
    lau LAU     following lerfu word
                    is punctuation
    tei TEI     start compound lerfu word
    foi FOI     end compound lerfu word
</pre>
    Note that LAU cmavo must be followed by a BY cmavo or the
    equivalent, where ``equivalent'' means: either any Lojban word
    followed by ``bu'', another LAU cmavo (and its required
    sequel), or a ``tei ... foi'' compound cmavo. 

    <h3><a id="s15" name="s15">15. Proposed lerfu words --- introduction</h3>

    <p>The following sections contain tables of proposed lerfu
    words for some of the standard alphabets supported by the
    Lojban lerfu system. The first column of each list is the lerfu
    (actually, a Latin-alphabet name sufficient to identify it).
    The second column is the proposed name-based lerfu word, and
    the third column is the proposed lerfu word in the system based
    on using the cmavo of selma'o BY with a shift word.</p>

    <p>These tables are not meant to be authoritative (several
    authorities within the Lojban community have niggled over them
    extensively, disagreeing with each other and sometimes with
    themselves). They provide a working basis until actual usage is
    available, rather than a final resolution of lerfu word
    problems. Probably the system presented here will evolve
    somewhat before settling down into a final, conventional
    form.</p>

    <p>For Latin-alphabet lerfu words, see <a href="#s2">Section
    2</a> (for Lojban) and <a href="#s5">Section 5</a> (for
    non-Lojban Latin-alphabet lerfu).</p>

    <h3><a id="s16" name="s16">16. Proposed lerfu words for the Greek alphabet</h3>

    <p></p>
<pre>
   alpha       .alfas. bu      .abu
    beta        .betas. bu      by
    gamma       .gamas. bu      gy
    delta       .deltas. bu     dy
    epsilon     .Epsilon. bu        .ebu
    zeta        .zetas. bu      zy
    eta     .etas. bu       .e'ebu
    theta       .tetas. bu      ty. bu
    iota        .iotas. bu      .ibu
    kappa       .kapas. bu      ky
    lambda      .lymdas. bu     ly
    mu      .mus. bu        my
    nu      .nus. bu        ny
    xi      .ksis. bu       ksis. bu
    omicron     .Omikron. bu        .obu
    pi      .pis. bu        py
    rho     .ros. bu        ry
    sigma       .sigmas. bu     sy
    tau     .taus. bu       ty
    upsilon     .Upsilon. bu        .ubu
    phi     .fis. bu        py. bu
    chi     .xis. bu        ky. bu
    psi     .psis. bu       psis. bu
    omega       .omegas. bu     .o'obu
    rough       .dasei,as. bu       .y'y
    smooth      .psiles. bu     xutla bu
</pre>

    <h3><a id="s17" name="s17">17. Proposed lerfu words for the Cyrillic alphabet</h3>

    <p>The second column in this listing is based on the historical
    names of the letters in Old Church Slavonic. Only those letters
    used in Russian are shown; other languages require more letters
    which can be devised as needed.</p>
<pre>
   a       .azys. bu       .abu
    b       .bukys. bu      by
    v       .vedis. bu      vy
    g       .glagolis. bu       gy
    d       .dobros. bu     dy
    e       .iestys. bu     .ebu
    zh      .jivet. bu      jy
    z       .zemlias. bu        zy
    i       .ije,is. bu     .ibu
    short i                 .itord. bu
    k       .kakos. bu      ky
    l       .liudi,ies. bu      ly
    m       .myslites. bu       my
    n       .naciys. bu     ny
    o       .onys. bu       .obu
    p       .pokois. bu     py
    r       .riytsis. bu        ry
    s       .slovos. bu     sy
    t       .tvriydos. bu       ty
    u       .ukys. bu       .ubu
    f       .friytys. bu        fy
    kh      .xerys. bu      xy
    ts      .tsis. bu       tsys. bu
    ch      .tcriyviys. bu      tcys. bu
    sh      .cas. bu        cy
    shch        .ctas. bu       ctcys. bu
    hard sign   .ier. bu        jdari bu
    yeri        .ierys. bu      .y.bu
    soft sign   .ieriys. bu     ranti bu
    reversed e              .ecarn. bu
    yu      .ius. bu        .iubu
    ya      .ias. bu        .iabu
</pre>

    <h3><a id="s18" name="s18">18. Proposed lerfu words for the Hebrew alphabet</h3>

    <p></p>
<pre>
   aleph       .alef. bu       .alef. bu
    bet     .bet. bu        by
    gimel       .gimel. bu      gy
    daled       .daled. bu      dy
    he      .xex. bu        .y'y
    vav     .vav. bu        vy
    zayin       .zai,in. bu     zy
    khet        .xet. bu        xy. bu
    tet     .tet. bu        ty. bu
    yud     .iud. bu        .iud. bu
    kaf     .kaf. bu        ky
    lamed       .LYmed. bu      ly
    mem     .mem. bu        my
    nun     .nun. bu        ny
    samekh      .samex. bu      samex. bu
    ayin        .ai,in. bu      .ai,in bu
    pe      .pex. bu        py
    tzadi       .tsadik. bu     tsadik. bu
    quf     .kuf. bu        ky. bu
    resh        .rec. bu        ry
    shin        .cin. bu        cy
    sin     .sin. bu        sy
    taf     .taf. bu        ty.
    dagesh      .daGEC. bu      daGEC. bu
    hiriq       .xirik. bu      .ibu
    tzeirekh    .tseirex. bu        .eibu
    segol       .seGOL. bu      .ebu
    qubbutz     .kubuts. bu     .ubu
    qamatz      .kamats. bu     .abu
    patach      .patax. bu      .a'abu
    sheva       .cyVAS. bu      .y.bu
    kholem      .xolem. bu      .obu
    shuruq      .curuk. bu      .u'ubu
</pre>

    <h3><a id="s19" name="s19">19. Proposed lerfu words for some accent marks and multiple
    letters</h3>

    <p></p>

    <p>This list is intended to be suggestive, not complete: there
    are lerfu such as Polish ``dark'' l and Maltese h-bar that do
    not yet have symbols.</p>

    <p></p>
<pre>
   acute       .akut. bu or
                .pritygal. bu   [pritu galtu]
    grave       .grav. bu
                or .zulgal. bu  [zunle galtu]
    circumflex  .cirkumfleks. bu
                or .midgal. bu  [midju galtu]
    tilde       .tildes. bu
    macron      .makron. bu
    breve       .brevis. bu
    over-dot    .garmoc. bu     [gapru mokca]
    umlaut/trema    relmoc. bu      [re mokca]
    over-ring   .garjin. bu     [gapru djine]
    cedilla     .seDIlys. bu
    double-acute    .re'akut. bu        [re akut.]
    ogonek      .ogoniek. bu
    hacek       .xatcek. bu
    ligatured fi    tei fy. ibu foi
    Danish/Latin ae tei .abu .ebu foi
    Dutch ij    tei .ibu jy. foi
    German es-zed   tei sy. zy. foi
</pre>

    <h3><a id="s20" name="s20">20. Proposed lerfu words for radio communication</h3>

    <p>There is a set of English words which are used, by
    international agreement, as lerfu words (for the English
    alphabet) over the radio, or in noisy situations where the
    utmost clarity is required. Formally they are known as the
    ``ICAO Phonetic Alphabet'', and are used even in
    non-English-speaking countries.</p>

    <p>This table presents the standard English spellings and
    proposed Lojban versions. The Lojbanizations are not
    straightforward renderings of the English sounds, but make some
    concessions both to the English spellings of the words and to
    the Lojban pronunciations of the lerfu (thus ``carlis. bu'',
    not ``tcarlis. bu'').</p>
<pre>
   Alfa        .alfas. bu
    Bravo       .bravos. bu
    Charlie     .carlis. bu
    Delta       .deltas. bu
    Echo        .ekos. bu
    Foxtrot     .fokstrot. bu
    Golf        .golf. bu
    Hotel       .xoTEL. bu
    India       .indias. bu
    Juliet      .juliet. bu
    Kilo        .kilos. bu
    Lima        .limas. bu
    Mike        .maik. bu
    November    .novembr. bu
    Oscar       .oskar. bu
    Papa        .paPAS. bu
    Quebec      .keBEK. bu
    Romeo       .romios. bu
    Sierra      .sieras. bu
    Tango       .tangos. bu
    Uniform     .Uniform. bu
    Victor      .viktas. bu
    Whiskey     .uiskis. bu
    X-ray       .eksreis. bu
    Yankee      .iankis. bu
    Zulu        .zulus. bu
</pre>

    <hr />
    
    <p>Última modificación: Mon Jun 27 23:13:33 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
