
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//FR" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 18</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter18.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 18<br />
      lojbau mekso: Mathematical Expressions in Lojban</h2>

      <!--
      <h6>$Revision: 4.3 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. Introductory</h3>
    lojbau mekso (``Lojbanic mathematical-expression'') is the part
    of the Lojban language that is tailored for expressing
    statements of a mathematical character, or for adding numerical
    information to non-mathematical statements. Its formal design
    goals include: 

    <p></p>

    <dl>
      <dt>1)</dt>

      <dd>representing all the different forms of expression used
      by mathematicians in their normal modes of writing, so that a
      reader can unambiguously read off mathematical text as
      written with minimal effort and expect a listener to
      understand it;</dd>
    </dl>

    <dl>
      <dt>2)</dt>

      <dd>providing a vocabulary of commonly used mathematical
      terms which can readily be expanded to include newly coined
      words using the full resources of Lojban;</dd>
    </dl>

    <dl>
      <dt>3)</dt>

      <dd>permitting the formulation, both in writing and in
      speech, of unambiguous mathematical text;</dd>
    </dl>

    <dl>
      <dt>4)</dt>

      <dd>encompassing all forms of quantified expression found in
      natural languages, as well as encouraging greater precision
      in ordinary language situations than natural languages
      allow.</dd>
    </dl>
    Goal 1 requires that mekso not be constrained to a single
    notation such as Polish notation or reverse Polish notation,
    but make provision for all forms, with the most commonly used
    forms the most easily used. 

    <p>Goal 2 requires the provision of several conversion
    mechanisms, so that the boundary between mekso and full Lojban
    can be crossed from either side at many points.</p>

    <p>Goal 3 is the most subtle. Written mathematical expression
    is culturally unambiguous, in the sense that mathematicians in
    all parts of the world understand the same written texts to
    have the same meanings. However, international mathematical
    notation does not prescribe unique forms. For example, the
    expression</p>
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  3x + 2y
</pre>
    contains omitted multiplication operators, but there are other
    possible interpretations for the strings ``3x'' and ``2y'' than
    as mathematical multiplication. Therefore, the Lojban verbal
    (spoken and written) form of <a href="#e1d1">Example 1.1</a>
    must not omit the multiplication operators. 

    <p>The remainder of this chapter explains (in as much detail as
    is currently possible) the mekso system. This chapter is by
    intention complete as regards mekso components, but only
    suggestive about uses of those components --- as of now, there
    has been no really comprehensive use made of mekso facilities,
    and many matters must await the test of usage to be fully
    clarified.</p>

    <h3><a id="s2" name="s2">2. Lojban numbers</h3>

    <p>The following cmavo are discussed in this section:</p>

    <p></p>
<pre>
   pa  PA  1
    re  PA  2
    ci  PA  3
    vo  PA  4
    mu  PA  5
    xa  PA  6
    ze  PA  7
    bi  PA  8
    so  PA  9
    no  PA  0           
</pre>
    The simplest kind of mekso are numbers, which are cmavo or
    compound cmavo. There are cmavo for each of the 10 decimal
    digits, and numbers greater than 9 are made by stringing
    together the cmavo. Some examples: 

    <p></p>
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  pa re ci
    one two three
    123
    one hundred and twenty three

<a id="e2d2" name="e2d2">2.2)</a>   pa no
    one zero
    10
    ten

<a id="e2d3" name="e2d3">2.3)</a>   pa re ci vo mu xa ze bi so no
    one two three four five six seven eight nine zero
    1234567890
    one billion, two hundred and thirty-four million,
        five hundred and sixty-seven thousand,
        eight hundred and ninety.
</pre>
    Therefore, there are no separate cmavo for ``ten'',
    ``hundred'', etc. 

    <p>There is a pattern to the digit cmavo (except for ``no'', 0)
    which is worth explaining. The cmavo from 1 to 5 end in the
    vowels ``a'', ``e'', ``i'', ``o'', ``u'' respectively; and the
    cmavo from 6 to 9 likewise end in the vowels ``a'', ``e'',
    ``i'', and ``o'' respectively. None of the digit cmavo begin
    with the same consonant, to make them easy to tell apart in
    noisy environments.</p>

    <h3><a id="s3" name="s3">3. Signs and numerical punctuation</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ma'u    PA  positive sign
    ni'u    PA  negative sign
    pi  PA  decimal point
    fi'u    PA  fraction slash
    ra'e    PA  repeating decimal
    ce'i    PA  percent sign
    ki'o    PA  comma between digits
</pre>
    A number can be given an explicit sign by the use of ``ma'u''
    and ``ni'u'', which are the positive and negative signs as
    distinct from the addition, subtraction, and negation
    operators. For example: 

    <p></p>
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  ni'u pa
    negative-sign 1
    -1
</pre>
    Grammatically, the signs are part of the number to which they
    are attached. It is also possible to use ``ma'u'' and ``ni'u''
    by themselves as numbers; the meaning of these numbers is
    explained in <a href="#s8">Section 8</a>. 

    <p>Various numerical punctuation marks are likewise expressed
    by cmavo, as illustrated in the following examples:</p>

    <p></p>
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  ci pi pa vo pa mu
    three point one four one five
    3.1415
</pre>
    (In some cultures, a comma is used instead of a period in the
    symbolic version of <a href="#e3d2">Example 3.2</a>; ``pi'' is
    still the Lojban representation for the decimal point.) 

    <p></p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  re fi'u ze
    two fraction seven
    2/7
</pre>
    <a href="#e3d3">Example 3.3</a> is the name of the number
    two-sevenths; it is not the same as ``the result of 2 divided
    by 7'' in Lojban, although numerically these two are equal. If
    the denominator of the fraction is present but the numerator is
    not, the numerator is taken to be 1, thus expressing the
    reciprocal of the following number: 
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  fi'u ze
    fraction seven
    1/7
</pre>
<pre>
<a id="e3d5" name="e3d5">3.5)</a>  pi ci mu ra'e pa vo re bi mu ze
    point three five repeating one four two eight five seven
    .35142857142857...
</pre>
    Note that the ``ra'e'' marks unambiguously where the repeating
    portion ``142857'' begins. 

    <p></p>
<pre>
<a id="e3d6" name="e3d6">3.6)</a>  ci mu ce'i
    three five percent
    35%
</pre>
<pre>
<a id="e3d7" name="e3d7">3.7)</a>  pa ki'o re ci vo ki'o mu xa ze
    one comma two three four comma five six seven
    1,234,567
</pre>
    (In some cultures, spaces are used in the symbolic
    representation of <a href="#e3d7">Example 3.7</a>; ``ki'o'' is
    still the Lojban representation.) 

    <p>It is also possible to have less than three digits between
    successive ``ki'o''s, in which case zeros are assumed to have
    been elided:</p>
<pre>
<a id="e3d8" name="e3d8">3.8)</a>  pa ki'o re ci ki'o vo
    one comma two three comma four
    1,023,004
</pre>

    <p>In the same way, ``ki'o'' can be used after ``pi'' to divide
    fractions into groups of three:</p>
<pre>
<a id="e3d9" name="e3d9">3.9)</a>  pi ki'o re re
    point comma two two
    .022

<a id="e3d10" name="e3d10">3.10)</a>   pi pa ki'o pa re ki'o pa
    point one comma one two comma one
    .101012001
</pre>

    <h3><a id="s4" name="s4">4. Special numbers</h3>

    <p>The following cmavo are discussed in this section:</p>

    <p></p>
<pre>
   ci'i    PA  infinity
    ka'o    PA  imaginary i, sqrt(-1)
    pai PA  pi (approx 3.14159...)
    te'o    PA  exponential e (approx 2.71828...)
    fi'u    PA  golden ratio, phi,
            (1 + sqrt(5))/2 (approx. 1.61803...)
</pre>
    The last cmavo is the same as the fraction sign cmavo: a
    fraction sign with neither numerator nor denominator represents
    the golden ratio. 

    <p>Numbers can have any of these digit, punctuation, and
    special-number cmavo of Sections 2, 3, and 4 in any
    combination:</p>

    <p></p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  ma'u ci'i
    +<span class="c3">&yen;</span><!--infty-->
</pre>
<pre>
<a id="e4d2" name="e4d2">4.2)</a>  ci ka'o re
    3i2 (a complex number equivalent to ``3 + 2i'')
</pre>
    Note that ``ka'o'' is both a special number (meaning ``i'') and
    a number punctuation mark (separating the real and the
    imaginary parts of a complex number). 

    <p></p>
<pre>
<a id="e4d3" name="e4d3">4.3)</a>  ci'i no
    infinity zero
    <span class="c3">&Agrave;</span>
<!--aleph--><sub>0</sub> (a transfinite cardinal)
</pre>

    <p>The special numbers ``pai'' and ``te'o'' are mathematically
    important, which is why they are given their own cmavo:</p>
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  pai
    pi

<a id="e4d5" name="e4d5">4.5)</a>   te'o
    e
</pre>
    However, many combinations are as yet undefined: 
<pre>
<a id="e4d6" name="e4d6">4.6)</a>  pa pi re pi ci
    1.2.3

<a id="e4d7" name="e4d7">4.7)</a>   pa ni'u re
    1 negative-sign 2
</pre>
    <a href="#e4d5">Example 4.5</a> is not ``1 minus 2'', which is
    represented by a different cmavo sequence altogether. It is a
    single number which has not been assigned a meaning. There are
    many such numbers which have no well-defined meaning; they may
    be used for experimental purposes or for future expansion of
    the Lojban number system. 

    <p>It is possible, of course, that some of these ``oddities''
    do have a meaningful use in some restricted area of
    mathematics. A mathematician appropriating these structures for
    specialized use needs to consider whether some other branch of
    mathematics would use the structure differently.</p>

    <p>More information on numbers may be found in <a
    href="#s8">Sections 8</a> to <a href="#s12">12</a>.</p>

    <h3><a id="s5" name="s5">5. Simple infix expressions and equations</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   du  GOhA    equals
    su'i    VUhU    plus
    vu'u    VUhU    minus
    pi'i    VUhU    times
    te'a    VUhU    raised to the power
    ny. BY  letter ``n''
    vei VEI left parenthesis
    ve'o    VEhO    right parenthesis
</pre>
    Let us begin at the beginning: one plus one equals two. In
    Lojban, that sentence translates to: 
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  li pa su'i pa du li re
    the-number one plus one equals the-number two.
    1 + 1 = 2
</pre>
    <a href="#e5d1">Example 5.1</a>, a mekso sentence, is a regular
    Lojban bridi that exploits mekso features. ``du'' is the
    predicate meaning ``x1 is mathematically equal to x2''. It is a
    cmavo for conciseness, but it has the same grammatical uses as
    any brivla. Outside mathematical contexts, ``du'' means ``x1 is
    identical with x2'' or ``x1 is the same object as x2''. 

    <p>The cmavo ``li'' is the number article. It is required
    whenever a sentence talks about numbers as numbers, as opposed
    to using numbers to quantify things. For example:</p>
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  le ci prenu
    the three persons
</pre>
    requires no ``li'' article, because the ``ci'' is being used to
    specify the number of ``prenu''. However, the sentence 

    <p></p>
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  levi sfani cu grake li ci
    this fly masses-in-grams the-number three
    This fly has a mass of 3 grams.
</pre>
    requires ``li'' because ``ci'' is being used as a sumti. Note
    that this is the way in which measurements are stated in
    Lojban: all the predicates for units of length, mass,
    temperature, and so on have the measured object as the first
    place and a number as the second place. Using ``li'' for ``le''
    in <a href="#e5d2">Example 5.2</a> would produce 
<pre>
<a id="e5d4" name="e5d4">5.4)</a>  li ci prenu
    the-number 3 is-a-person
</pre>
    which is grammatical but nonsensical: numbers are not persons. 

    <p>The cmavo ``su'i'' belongs to selma'o VUhU, which is
    composed of mathematical operators, and means ``addition''. As
    mentioned before, it is distinct from ``ma'u'' which means the
    positive sign as an indication of a positive number:</p>

<pre>
<a id="e5d5" name="e5d5">5.5)</a>  li ma'u pa su'i ni'u pa
        du li no
    the-number positive-sign one plus negative-sign one
        equals the-number zero
    +1 + -1 = 0
</pre>

    <p>Of course, it is legal to have complex mekso on both sides
    of ``du'':</p>

    <p></p>
<pre>
<a id="e5d6" name="e5d6">5.6)</a>  li mu su'i pa
        du li ci su'i ci
    the-number five plus one
        equals the-number three plus three
    5 + 1 = 3 + 3
</pre>
    Why don't we say ``li mu su'i li pa'' rather than just ``li mu
    su'i pa''? The answer is that VUhU operators connect mekso
    operands (numbers, in <a href="#e5d6">Example 5.6</a>), not
    general sumti. ``li'' is used to make the entire mekso into a
    sumti, which then plays the roles applicable to other sumti: in
    <a href="#e5d6">Example 5.6</a>, filling the places of a bridi.
    

    <p>By default, Lojban mathematics is like simple calculator
    mathematics: there is no notion of ``operator precedence''.
    Consider the following example, where ``pi'i'' means ``times'',
    the multiplication operator:</p>

    <p></p>
<pre>
<a id="e5d7" name="e5d7">5.7)</a>  li ci su'i vo pi'i mu
        du li reci
    the-number three plus four times five
        equals the-number two-three
    3 + 4 &times; 5 = 23
</pre>

    <p>Is the Lojban version of <a href="#e5d7">Example 5.7</a>
    true? No! ``3 + 4 &times; 5'' is indeed 23, because the usual
    conventions of mathematics state that multiplication takes
    precedence over addition; that is, the multiplication ``4
    &times; 5'' is done first, giving 20, and only then the
    addition ``3 + 20''. But VUhU operators by default are done
    left to right, like other Lojban grouping, and so a truthful
    bridi would be:</p>
<pre>
<a id="e5d8" name="e5d8">5.8)</a>  li ci su'i vo pi'i mu
        du li cimu
    the-number three plus four times five
        equals the-number three-five
    3 + 4 &times; 5 = 35
</pre>
    Here we calculate 3 + 4 first, giving 7, and then calculate 7
    &times; 5 second, leading to the result 35. While possessing
    the advantage of simplicity, this result violates the design
    goal of matching the standards of mathematics. What can be
    done? 

    <p>There are three solutions, all of which will probably be
    used to some degree. The first solution is to ignore the
    problem. People will say ``li ci su'i vo pi'i mu'' and mean 23
    by it, because the notion that multiplication takes precedence
    over addition is too deeply ingrained to be eradicated by
    Lojban parsing, which totally ignores semantics. This
    convention essentially allows semantics to dominate syntax in
    this one area.</p>

    <p>(Why not hard-wire the precedences into the grammar, as is
    done in computer programming languages? Essentially because
    there are too many operators, known and unknown, with levels of
    precedence that vary according to usage. The programming
    language 'C' has 13 levels of precedence, and its list of
    operators is not even extensible. For Lojban this approach is
    just not practical. In addition, hard-wired precedence could
    not be overridden in mathematical systems such as spreadsheets
    where the conventions are different.)</p>

    <p>The second solution is to use explicit means to specify the
    precedence of operators. This approach is fully general, but
    clumsy, and will be explained in <a href="#s20">Section
    20</a>.</p>

    <p>The third solution is simple but not very general. When an
    operator is prefixed with the cmavo ``bi'e'' (of selma'o BIhE),
    it becomes automatically of higher precedence than other
    operators not so prefixed. Thus,</p>
<pre>
<a id="e5d9" name="e5d9">5.9)</a>  li ci su'i vo bi'e pi'i mu
        du li reci
    the-number three plus four-times-five
        equals the-number two-three
    3 + 4 &times; 5 = 23
</pre>
    is a truthful Lojban bridi. If more than one operator has a
    ``bi'e'' prefix, grouping is to the right; multiple ``bi'e''
    prefixes on a single operator are not allowed. 

    <p>In addition, of course, Lojban has the mathematical
    parentheses ``vei'' and ``ve'o'', which can be used just like
    their written equivalents ``('' and ``)'' to group expressions
    in any way desired:</p>

<pre>
<a id="e5d10"
name="e5d10">5.10)</a>    li vei ny. su'i pa ve'o pi'i vei ny. su'i pa [ve'o]
        du li ny. [bi'e] te'a re su'i re bi'e pi'i ny. su'i pa
    the-number ( ``n'' plus one ) times ( ``n'' plus one )
        equals the-number n-power-two plus two-times-``n'' plus 1
    (n + 1)(n + 1) = n<sup>2</sup> + 2n + 1
</pre>
    There are several new usages in <a href="#e5d10">Example
    5.10</a>: ``te'a'' means ``raised to the power'', and we also
    see the use of the lerfu word ``ny'', representing the letter
    ``n''. In mekso, letters stand for just what they do in
    ordinary mathematics: variables. The parser will accept a
    string of lerfu words (called a ``lerfu string'') as the
    equivalent of a single lerfu word, in agreement with
    computer-science conventions; ``abc'' is a single variable, not
    the equivalent of ``a &times; b &times; c''. (Of course, a
    local convention could state that the value of a variable like
    ``abc'', with a multi-lerfu name, was equal to the values of
    the variables ``a'', ``b'', and ``c'' multiplied together.) 

    <p>The explicit operator ``pi'i'' is required in the Lojban
    verbal form whereas multiplication is implicit in the symbolic
    form. Note that ``ve'o'' (the right parenthesis) is an elidable
    terminator: the first use of it in <a href="#e5d10">Example
    5.10</a> is required, but the second use (marked by square
    brackets) could be elided. Additionally, the first ``bi'e''
    (also marked by square brackets) is not necessary to get the
    proper grouping, but it is included here for symmetry with the
    other one.</p>

    <h3><a id="s6" name="s6">6. Forethought operators (Polish notation, functions)</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   boi BOI numeral/lerfu string terminator
    va'a    VUhU    negation/additive inverse
    pe'o    PEhO    forethought flag
    ku'e    KUhE    forethought terminator
    py. BY  letter ``p''
    xy. BY  letter ``x''
    zy. BY  letter ``z''
    ma'o    MAhO    convert operand to operator
    fy. BY  letter ``f''
</pre>
    The infix form explained so far is reasonable for many
    purposes, but it is limited and rigid. It works smoothly only
    where all operators have exactly two operands, and where
    precedences can either be assumed from context or are limited
    to just two levels, with some help from parentheses. 

    <p>But there are many operators which do not have two operands,
    or which have a variable number of operands. The preferred form
    of expression in such cases is the use of ``forethought
    operators'', also known as Polish notation. In this style of
    writing mathematics, the operator comes first and the operands
    afterwards:</p>

    <p></p>
<pre>
<a id="e6d1"
name="e6d1">6.1)</a>  li su'i paboi reboi ci[boi] du li xa
    the-number the-sum-of one two three equals the-number six
    sum(1,2,3) = 6
</pre>
    Note that the normally elidable number terminator ``boi'' is
    required after ``pa'' and ``re'' because otherwise the reading
    would be ``pareci'' = 123. It is not required after ``ci'' but
    is inserted here in brackets for the sake of symmetry. The only
    time ``boi'' is required is, as in <a href="#e6d1">Example
    6.1</a>, when there are two consecutive numbers or lerfu
    strings. 

    <p>Forethought mekso can use any number of operands, in <a
    href="#e6d1">Example 6.1</a> three. How do we know how many
    operands there are in ambiguous circumstances? The usual Lojban
    solution is employed: an elidable terminator, namely ``ku'e''.
    Here is an example:</p>

    <p></p>
<pre>
<a id="e6d2"
name="e6d2">6.2)</a>  li py. su'i va'a ny. ku'e su'i zy du li xy.
    the-number ``p'' plus negative-of( ``n'' ) plus ``z''
        equals the-number ``x''
    p + -n + z = x
</pre>
    where we know that ``va'a'' is a forethought operator because
    there is no operand preceding it. 

    <p>``va'a'' is the numerical negation operator, of selma'o
    VUhU. In contrast, j ``vu'u'' is not used for numerical
    negation, but only for subtraction, as it always has two or
    more operands. Do not confuse ``va'a'' and ``vu'u'', which are
    operators, with ``ni'u'', which is part of a number.</p>

    <p> In <a href="#e6d2">Example 6.2</a>, the operator ``va'a'' and
    the terminator ``ku'e'' serve in effect as parentheses. (The regular
    parentheses ``vei'' and ``ve'o'' are NOT used for this purpose.) If
    the ``ku'e'' were omitted, the ``su'i zy'' would be swallowed up by
    the ``va'a'' forethought operator, which would then appear to have
    two operands, ``ny'' and ``su'i zy.'', where the latter is also a
    forethought expression.</p>

    <p>Forethought mekso is also useful for matching standard
    functional notation. How do we represent ``z = f(x)''? The
    answer is:</p>

    <p></p>
<pre>
<a id="e6d3" name="e6d3">6.3)</a>  li zy du li ma'o fy.boi xy.
    the-number z equals the-number the-operator f x
    z = f(x)
</pre>
    Again, no parentheses are used. The construct ``ma'o fy.boi''
    is the equivalent of an operator, and appears in forethought
    here (although it could also be used as a regular infix
    operator). In mathematics, letters sometimes mean functions and
    sometimes mean variables, with only the context to tell which.
    Lojban chooses to accept the variable interpretation as the
    default, and uses the special flag ``ma'o'' to mark a lerfu
    string as an operator. The cmavo ``xy.'' and ``zy.'' are
    variables, but ``fy.'' is an operator (a function) because
    ``ma'o'' marks it as such. The ``boi'' is required because
    otherwise the ``xy.'' would look like part of the operator
    name. (The use of ``ma'o'' can be generalized from lerfu
    strings to any mekso operand: see <a href="#s21">Section
    21</a>.) 

    <p>When using forethought mekso, the optional marker ``pe'o''
    may be placed in front of the operator. This usage can help
    avoid confusion by providing clearly marked ``pe'o'' and
    ``ku'e'' pairs to delimit the operand list. <a
    href="#e6d1">Examples 6.1</a> to <a href="#e6d3">6.3</a>,
    respectively, with explicit ``pe'o'' and ``ku'e'':</p>
<pre>
<a id="e6d4"
name="e6d4">6.4)</a>  li pe'o su'i paboi reboi ciboi ku'e du li xa
<a id="e6d5"
name="e6d5">6.5)</a>   li py. su'i pe'o va'a ny. ku'e su'i zy du li xy.
<a id="e6d6"
name="e6d6">6.6)</a>   li zy du li pe'o ma'o fy.boi xy. ku'e
</pre>
    Note: When using forethought mekso, be sure that the operands
    really are operands: they cannot contain regular infix
    expressions unless parenthesized with ``vei'' and ``ve'o''. An
    earlier version of the complex <a href="#e17d6">Example
    17.6</a> came to grief because I forgot this rule. 

    <h3><a id="s7" name="s7">7. Other useful selbri for mekso bridi</h3>

    <p>So far our examples have been isolated mekso (it is legal to
    have a bare mekso as a sentence in Lojban) and equation bridi
    involving ``du''. What about inequalities such as ``x &lt; 5''?
    The answer is to use a bridi with an appropriate selbri,
    thus:</p>

<pre>
<a id="e7d1" name="e7d1">7.1)</a>  li xy. mleca li mu
    the-number x is-less-than the-number 5
</pre>

    <p>Here is a partial list of selbri useful in mathematical
    bridi:</p>
<pre>
   du      x1 is identical to x2, x3, x4, ...
    dunli       x1 is equal/congruent to x2 in/on
            property/quality/dimension/quantity x3
    mleca       x1 is less than x2
    zmadu       x1 is greater than x2
    dubjavme'a  x1 is less than or equal to x2
                [du ja mleca, equal or less]
    dubjavmau   x1 is greater than or equal to x2
                [du ja zmadu, equal or greater]
    tamdu'i     x1 is similar to x2
                [tarmi dunli, shape-equal]
    turdu'i     x1 is isomorphic to x2
                [stura dunli, structure-equal]
    cmima       x1 is a member of set x2
    gripau      x1 is a subset of set x2
                [girzu pagbu, set-part]
    na'ujbi     x1 is approximately equal to
                [namcu jibni, number-near]
    terci'e     x1 is a component with function x2
            of system x3
</pre>
    Note the difference between ``dunli'' and ``du''; ``dunli'' has
    a third place that specifies the kind of equality that is
    meant. ``du'' refers to actual identity, and can have any
    number of places: 

<pre>
<a id="e7d2" name="e7d2">7.2)</a>  py. du xy.boi zy.
    ``p'' is-identical-to ``x'' ``z''
    p = x = z
</pre>

    <p>Lojban bridi can have only one predicate, so the ``du'' is
    not repeated.</p>

    <p>Any of these selbri may usefully be prefixed with ``na'',
    the contradictory negation cmavo, to indicate that the relation
    is false:</p>
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  li re su'i re na du li mu
    the-number 2 + 2 is-not equal-to the-number 5.
    2 + 2 <span class="c3">&frac12;</span><!--notequal--> 5
</pre>

    <p>As usual in Lojban, negated bridi say what is false, and do
    not say anything about what might be true.</p>

    <h3><a id="s8" name="s8">8. Indefinite numbers</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ro  PA  all
    so'a    PA  almost all
    so'e    PA  most
    so'i    PA  many
    so'o    PA  several
    so'u    PA  a few
    no'o    PA  the typical number of
    da'a    PA  all but (one) of

    piro    PA+PA   the whole of/all of
    piso'a  PA+PA   almost the whole of
    piso'e  PA+PA   most of
    piso'i  PA+PA   much of
    piso'o  PA+PA   a small part of
    piso'u  PA+PA   a tiny part of
    pino'o  PA+PA   the typical portion of

    rau PA  enough
    du'e    PA  too many
    mo'a    PA  too few

    pirau   PA+PA   enough of
    pidu'e  PA+PA   too much of
    pimo'a  PA+PA   too little of
</pre>
    Not all the cmavo of PA represent numbers in the usual
    mathematical sense. For example, the cmavo ``ro'' means ``all''
    or ``each''. This number does not have a definite value in the
    abstract: ``li ro'' is undefined. But when used to count or
    quantify something, the parallel between ``ro'' and ``pa'' is
    clearer: 
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  mi catlu pa prenu
    I look-at one person

<a id="e8d2" name="e8d2">8.2)</a>   mi catlu ro prenu
    I look-at all persons
</pre>
    <a href="#e8d1">Example 8.1</a> might be true, whereas <a
    href="#e8d2">Example 8.2</a> is almost certainly false. 

    <p>The cmavo ``so'a'', ``so'e'', ``so'i'', ``so'o'', and
    ``so'u'' represent a set of indefinite numbers less than
    ``ro''. As you go down an alphabetical list, the magnitude
    decreases:</p>
<pre>
<a id="e8d3" name="e8d3">8.3)</a>  mi catlu so'a prenu
    I look-at almost-all persons

<a id="e8d4" name="e8d4">8.4)</a>   mi catlu so'e prenu
    I look-at most persons

<a id="e8d5" name="e8d5">8.5)</a>   mi catlu so'i prenu
    I look-at many persons

<a id="e8d6" name="e8d6">8.6)</a>   mi catlu so'o prenu
    I look-at several persons

<a id="e8d7" name="e8d7">8.7)</a>   mi catlu so'u prenu
    I look-at a-few persons
</pre>
    The English equivalents are only rough: the cmavo provide space
    for up to five indefinite numbers between ``ro'' and ``no'',
    with a built-in ordering. In particular, ``so'e'' does not mean
    ``most'' in the sense of ``a majority'' or ``more than half''. 

    <p>Each of these numbers, plus ``ro'', may be prefixed with
    ``pi'' (the decimal point) in order to make a fractional form
    which represents part of a whole rather than some elements of a
    totality. ``piro'' therefore means ``the whole of'':</p>

    <p></p>
<pre>
<a id="e8d8" name="e8d8">8.8)</a>  mi citka piro lei nanba
    I eat the-whole-of the-mass-of bread
</pre>
    Similarly, ``piso'a'' means ``almost the whole of''; and so on
    down to ``piso'u'', ``a tiny part of''. These numbers are
    particularly appropriate with masses, which are usually
    measured rather than counted, as <a href="#e8d8">Example
    8.8</a> shows. 

    <p>In addition to these cmavo, there is ``no'o'', meaning ``the
    typical value'', and ``pino'o'', meaning ``the typical
    portion'': Sometimes ``no'o'' can be translated ``the average
    value'', but the average in question is not, in general, a
    mathematical mean, median, or mode; these would be more
    appropriately represented by operators.</p>
<pre>
<a id="e8d9" name="e8d9">8.9)</a>  mi catlu no'o prenu
    I look-at a-typical-number-of persons

<a id="e8d10" name="e8d10">8.10)</a> mi citka pino'o lei nanba
    I eat a-typical-amount-of the-mass-of bread.
</pre>
    ``da'a'' is a related cmavo meaning ``all but'': 
<pre>
<a id="e8d11" name="e8d11">8.11)</a>    mi catlu da'a re prenu
    I look-at all-but two persons

<a id="e8d12" name="e8d12">8.12)</a> mi catlu da'a so'u prenu
    I look-at all-but a-few persons
</pre>
    <a href="#e8d12">Example 8.12</a> is similar in meaning to <a
    href="#e8d3">Example 8.3</a>. 

    <p>If no number follows ``da'a'', then ``pa'' is assumed;
    ``da'a'' by itself means ``all but one'', or in ordinal
    contexts ``all but the last'':</p>
<pre>
<a id="e8d13"
name="e8d13">8.13)</a>    ro ratcu ka'e citka da'a ratcu
    all rats can eat all-but-one rats.
    All rats can eat all other rats.
</pre>
    (The use of ``da'a'' means that <a href="#e8d13">Example
    8.13</a> does not require that all rats can eat themselves, but
    does allow it. Each rat has one rat it cannot eat, but that one
    might be some rat other than itself. Context often dictates
    that ``itself'' is, indeed, the ``other'' rat.) 

    <p>As mentioned in <a href="#s3">Section 3</a>, ``ma'u'' and
    ``ni'u'' are also legal numbers, and they mean ``some positive
    number'' and ``some negative number'' respectively.</p>
<pre>
<a id="e8d14" name="e8d14">8.14)</a>    li ci vu'u re du li ma'u
    the-number 3 - 2 = some-positive-number

<a id="e8d15" name="e8d15">8.15)</a> li ci vu'u vo du li ni'u
    the-number 3 - 4 = some-negative-number

<a id="e8d16" name="e8d16">8.16)</a> mi ponse ma'u rupnu
    I possess a-positive-number-of currency-units.
</pre>
    All of the numbers discussed so far are objective, even if
    indefinite. If there are exactly six superpowers
    (``rairgugde'', ``superlative-states'') in the world, then ``ro
    rairgugde'' means the same as ``xa rairgugde''. It is often
    useful, however, to express subjective indefinite values. The
    cmavo ``rau'' (enough), ``du'e'' (too many), and ``mo'a'' (too
    few) are then appropriate: 

    <p></p>
<pre>
<a id="e8d17" name="e8d17">8.17)</a>    mi ponse rau rupnu
    I possess enough currency-units.
</pre>
    Like the ``so'a''-series, ``rau'', ``du'e'', and ``mo'a'' can
    be preceded by ``pi''; for example, ``pirau'' means ``a
    sufficient part of.'' 

    <p>Another possibility is that of combining definite and
    indefinite numbers into a single number. This usage implies
    that the two kinds of numbers have the same value in the given
    context:</p>

    <p></p>
<pre>
<a id="e8d18" name="e8d18">8.18)</a>    mi viska le rore gerku
    I saw the all-of/two dogs.
    I saw both dogs.

<a id="e8d19" name="e8d19">8.19)</a> mi speni so'ici prenu
    I am-married-to many/three persons.
    I am married to three persons
        (which is ``many'' in the circumstances).
</pre>
    <a href="#e8d19">Example 8.19</a> assumes a mostly monogamous
    culture by stating that three is ``many''. 

    <h3><a id="s9" name="s9">9. Approximation and inexact numbers</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ji'i    PA  approximately
    su'e    PA  at most
    su'o    PA  at least
    me'i    PA  less than
    za'u    PA  more than
</pre>
    The cmavo ``ji'i'' (of selma'o PA) is used in several ways to
    indicate approximate or rounded numbers. If it appears at the
    beginning of a number, the whole number is approximate: 

    <p></p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  ji'i vo no
    approximation four zero
    approximately 40
</pre>
    If ``ji'i'' appears in the middle of a number, all the digits
    following it are approximate: 
<pre>
<a id="e9d2" name="e9d2">9.2)</a>  vo no ji'i mu no
    four zero approximation five zero
    roughly 4050
        (where the ``four thousand'' is exact,
        but the ``fifty'' is approximate)
</pre>
    If ``ji'i'' appears at the end of a number, it indicates that
    the number has been rounded. In addition, it can then be
    followed by a sign cmavo (``ma'u'' or ``ni'u''), which indicate
    truncation towards positive or negative infinity respectively. 
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  re pi ze re ji'i
    two point seven two approximation
    2.72 (rounded)
</pre>
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  re pi ze re ji'i ma'u
    two point seven two approximation positive-sign
    2.72 (rounded up)
</pre>
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  re pi ze pa ji'i ni'u
    two point seven one approximation negative-sign
    2.71 (rounded down)
</pre>
    <a href="#e9d3">Examples 9.3</a> through <a
    href="#e9d5">9.5</a> are all approximations to ``te'o''
    (exponential e). ``ji'i'' can also appear by itself, in which
    case it means ``approximately the typical value in this
    context''. 

    <p>The four cmavo ``su'e'', ``su'o'', ``me'i'', and ``za'u'',
    also of selma'o PA, express inexact numbers with upper or lower
    bounds:</p>

    <p></p>
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  mi catlu su'e re prenu
    I look-at at-most two persons
</pre>
<pre>
<a id="e9d7" name="e9d7">9.7)</a>  mi catlu su'o re prenu
    I look-at at-least two persons
</pre>
<pre>
<a id="e9d8" name="e9d8">9.8)</a>  mi catlu me'i re prenu
    I look-at less-than two persons
</pre>
<pre>
<a id="e9d9" name="e9d9">9.9)</a>  mi catlu za'u re prenu
    I look-at more-than two persons
</pre>
    Each of these is a subtly different claim: <a
    href="#e9d7">Example 9.7</a> is true of two or any greater
    number, whereas <a href="#e9d9">Example 9.9</a> requires three
    persons or more. Likewise, <a href="#e9d6">Example 9.6</a>
    refers to zero, one, or two; <a href="#e9d8">Example 9.8</a> to
    zero or one. (Of course, when the context allows numbers other
    than non-negative integers, ``me'i re'' can be any number less
    than 2, and likewise with the other cases.) The exact
    quantifier, ``exactly 2, neither more nor less'' is just
    ``re''. Note that ``su'ore'' is the exact Lojban equivalent of
    English plurals. 

    <p>If no number follows one of these cmavo, ``pa'' is
    understood: therefore,</p>
<pre>
<a id="e9d10" name="e9d10">9.10)</a>    mi catlu su'o prenu
    I look-at at-least [one] person
</pre>
    is a meaningful claim. 

    <p>Like the numbers in <a href="#s8">Section 8</a>, all of
    these cmavo may be preceded by ``pi'' to make the corresponding
    quantifiers for part of a whole. For example, ``pisu'o'' means
    ``at least some part of''. The quantifiers ``ro'', ``su'o'',
    ``piro'', and ``pisu'o'' are particularly important in Lojban,
    as they are implicitly used in the descriptions introduced by
    the cmavo of selma'o LA and LE, as explained in <a
    href="chapter6.html">Chapter 6</a>. Descriptions in general are
    outside the scope of this chapter.</p>

    <h3><a id="s10" name="s10">10. Non-decimal and compound bases</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ju'u    VUhU    to the base
    dau PA  hex digit A = 10
    fei PA  hex digit B = 11
    gai PA  hex digit C = 12
    jau PA  hex digit D = 13
    rei PA  hex digit E = 14
    vai PA  hex digit F = 15
    pi'e    PA  compound base point
</pre>
    In normal contexts, Lojban assumes that all numbers are
    expressed in the decimal (base 10) system. However, other bases
    are possible, and may be appropriate in particular
    circumstances. 

    <p>To specify a number in a particular base, the VUhU operator
    ``ju'u'' is suitable:</p>
<pre>
<a id="e10d1"
name="e10d1">10.1)</a>    li pa no pa no ju'u re du li pa no
    the-number 1010 base 2 equals the-number 10
</pre>
    Here, the final ``pa no'' is assumed to be base 10, as usual;
    so is the base specification. (The base may also be changed
    permanently by a metalinguistic specification; no standard way
    of doing so has as yet been worked out.) 

    <p>Lojban has digits for representing bases up to 16, because
    16 is a base often used in computer applications. In English,
    it is customary to use the letters A-F as the base 16 digits
    equivalent to the numbers ten through fifteen. In Lojban, this
    ambiguity is avoided:</p>

    <p></p>
<pre>
<a id="e10d2"
name="e10d2">10.2)</a>    li daufeigai ju'u paxa du li rezevobi
    the-number ABC base 16 equals the-number 2748

<a id="e10d3"
name="e10d3">10.3)</a> li jaureivai ju'u paxa du li cimuxaze
    the-number DEF base 16 equals the-number 3567
</pre>
    Note the pattern in the cmavo: the diphthongs ``au'', ``ei'',
    ``ai'' are used twice in the same order. The digits for A to D
    use consonants different from those used in the decimal digit
    cmavo; E and F unfortunately overlap 2 and 4 --- there was
    simply not enough available cmavo space to make a full
    differentiation possible. The cmavo are also in alphabetical
    order. 

    <p>The base point ``pi'' is used in non-decimal bases just as
    in base 10:</p>

    <p></p>
<pre>
<a id="e10d4"
name="e10d4">10.4)</a>    li vai pi bi ju'u paxa du li pamu pi mu
    the-number F.8 base 16 equals the-number 15.5
</pre>
    Since ``ju'u'' is an operator of selma'o VUhU, it is
    grammatical to use any operand as the left argument.
    Semantically, however, it is undefined to use anything but a
    numeral string on the left. The reason to make ``ju'u'' an
    operator is to allow reference to a base which is not a
    constant. 

    <p>There are some numerical values that require a ``base'' that
    varies from digit to digit. For example, times represented in
    hours, minutes, and seconds have, in effect, three ``digits'':
    the first is base 24, the second and third are base 60. To
    express such numbers, the compound base separator ``pi'e'' is
    used:</p>
<pre>
<a id="e10d5" name="e10d5">10.5)</a>    ci pi'e rere pi'e vono
    3:22:40
</pre>
    Each digit sequence separated by instances of ``pi'e'' is
    expressed in decimal notation, but the number as a whole is not
    decimal and can only be added and subtracted by special rules: 
<pre>
<a id="e10d6"
name="e10d6">10.6)</a>    li ci pi'e rere pi'e vono su'i pi'e ci pi'e cici
        du li ci pi'e rexa pi'e paci
    the-number 3:22:40 plus :3:33 equals the-number 3:26:13
    3:22:40 + 0:3:33 = 3:26:13
</pre>

    <p>Of course, only context tells you that the first part of the
    numbers in <a href="#e10d5">Example 10.5</a> and <a
    href="#e10d6">Example 10.6</a> is hours, the second minutes,
    and the third seconds.</p>

    <p>The same mechanism using ``pi'e'' can be used to express
    numbers which have a base larger than 16. For example, base-20
    Mayan mathematics might use digits from ``no'' to ``paso'',
    each separated by ``pi'e'':</p>
<pre>
<a id="e10d7"
name="e10d7">10.7)</a>    li pa pi'e re pi'e ci ju'u reno du li vovoci
    the-number 1;2;3 base 20 equals the-number 443
</pre>
    Carefully note the difference between: 
<pre>
<a id="e10d8" name="e10d8">10.8)</a>    pano ju'u reno
    the-digit-10 base 20
</pre>
    which is equal to ten, and: 
<pre>
<a id="e10d9" name="e10d9">10.9)</a>    pa pi'e no ju'u reno
    1;0 base 20
</pre>
    which is equal to twenty. 

    <p>Both ``pi'' and ``pi'e'' can be used to express large-base
    decimal fractions:</p>
<pre>
<a id="e10d10"
name="e10d10">10.10)</a>  li pa pi'e vo pi ze ju'u reno du li re vo pi ci mu
    the-number 1;4.7 base 20 equals the-number 24.35
</pre>
    ``pi'e'' is also used where the base of each digit is vague, as
    in the numbering of the examples in this chapter: 

    <p></p>
<pre>
<a id="e10d11" name="e10d11">10.11)</a>  dei jufra panopi'epapamoi
    This-utterance is-a-sentence-type-of 10;11th-thing.
    This is Sentence 10.11.
</pre>

    <h3><a id="s11" name="s11">11. Special mekso selbri</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   mei MOI cardinal selbri
    moi MOI ordinal selbri
    si'e    MOI portion selbri
    cu'o    MOI probability selbri
    va'e    MOI scale selbri

    me  ME  make sumti into selbri
    me'u    MEhU    terminator for ME
</pre>
    Lojban possesses a special category of selbri which are based
    on mekso. The simplest kind of such selbri are made by
    suffixing a member of selma'o MOI to a number. There are four
    members of MOI, each of which serves to create number-based
    selbri with specific place structures. 

    <p>``-mei'' creates cardinal selbri. The basic place structure
    is:</p>

    <dl>
      <dt></dt>

      <dd>x1 is a mass formed from the set x2 of n members, one or
      more of which is/are x3</dd>
    </dl>
    A cardinal selbri interrelates a set with a given number of
    members, the mass formed from that set, and the individuals
    which make the set up. The mass argument is placed first as a
    matter of convenience, not logical necessity. 

    <p>Some examples:</p>

    <p></p>
<pre>
<a id="e11d1" name="e11d1">11.1)</a>    lei mi ratcu cu cimei
    those-I-describe-as-the-mass-of my rats are-a-threesome.
    My rats are three.
    I have three rats.
</pre>

    <p>Here, the mass of my rats is said to have three components;
    that is, I have three rats.</p>

    <p>Another example, with one element this time:</p>

    <p></p>
<pre>
<a id="e11d2" name="e11d2">11.2)</a>    mi poi pamei cu cusku dei
    I who am-an-individual express this-sentence.
</pre>

    <p>In <a href="#e11d2">Example 11.2</a>, ``mi'' refers to a
    mass, ``the mass consisting of me''. Personal pronouns are
    vague between masses, sets, and individuals.</p>

    <p>However, when the number expressed before ``-mei'' is an
    objective indefinite number of the kind explained in <a
    href="#s8">Section 8</a>, a slightly different place structure
    is required:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>x1 is a mass formed from a set x2 of n members, one or
      more of which is/are x3, measured relative to the set
      x4.</dd>
    </dl>

    <p>An example:</p>

    <p></p>
<pre>
<a id="e11d3"
name="e11d3">11.3)</a>    lei ratcu poi zvati le panka cu so'umei
        fo lo'i ratcu
    the-mass-of rats which are-in the park are a-fewsome
        with-respect-to the-set-of rats.
    The rats in the park are a small number
        of all the rats there are.
</pre>
    In <a href="#e11d3">Example 11.3</a>, the x2 and x3 places are
    vacant, and the x4 place is filled by ``lo'i ratcu'', which
    (because no quantifiers are explicitly given) means ``the whole
    of the set of all those things which are rats'', or simply
    ``the set of all rats.'' 

    <p></p>
<pre>
<a id="e11d4"
name="e11d4">11.4)</a>    le'i ratcu poi zvati le panka cu se so'imei
    The-set-of rats which-are in the park is-a manysome.
    There are many rats in the park.
</pre>

    <p>In <a href="#e11d4">Example 11.4</a>, the conversion cmavo
    ``se'' swaps the x1 and the x2 places, so that the new x1 is
    the set. The x4 set is unspecified, so the implication is that
    the rats are ``many'' with respect to some unspecified
    comparison set.</p>

    <p>More explanations about the interrelationship of sets,
    masses, and individuals can be found in <a
    href="chapter6.html">Chapter 6</a>.</p>

    <p>``-moi'' creates ordinal selbri. The place structure is:</p>

    <dl>
      <dt></dt>

      <dd>x1 is the (n)th member of set x2 when ordered by rule
      x3</dd>
    </dl>

    <p>Some examples:</p>

    <p></p>
<pre>
<a id="e11d5" name="e11d5">11.5)</a>    ti pamoi le'i mi ratcu
    This-one is the first-of the rats associated-with me.
    This is my first rat.
</pre>
<pre>
<a id="e11d6" name="e11d6">11.6)</a>    ta romoi le'i mi ratcu
    That is-the-allth-of the rats associated-with me.
    That is my last rat.
</pre>
<pre>
<a id="e11d7" name="e11d7">11.7)</a>    mi raumoi le velskina porsi
    I am-enough-th-in the movie-audience sequence
    I am enough-th in the movie line.
</pre>
    <a href="#e11d7">Example 11.7</a> means, in the appropriate
    context, that my position in line is sufficiently far to the
    front that I will get a seat for the movie. 

    <p>``-si'e'' creates portion selbri. The place structure
    is:</p>

    <dl>
      <dt></dt>

      <dd>x1 is an (n)th portion of mass x2</dd>
    </dl>

    <p>Some examples:</p>

    <p></p>
<pre>
<a id="e11d8"
name="e11d8">11.8)</a>    levi sanmi cu fi'ucisi'e lei mi djedi cidja
    This-here meal is-a-slash-three-portion-of my day-food.
    This meal is one-third of my daily food.
</pre>
    ``-cu'o'' creates probability selbri. The place structure is: 

    <dl>
      <dt></dt>

      <dd>event x1 has probability (n) of occurring under
      conditions x2</dd>
    </dl>
    The number must be between 0 and 1 inclusive. For example: 

    <p></p>
<pre>
<a id="e11d9"
name="e11d9">11.9)</a>    le nu lo sicni cu sedja'o cu pimucu'o
    The event of a coin being a head-displayer
        has probability .5.
</pre>
    ``-va'e'' creates a scale selbri. The place structure is: 

    <dl>
      <dt></dt>

      <dd>x1 is at scale position (n) on the scale x2</dd>
    </dl>
    If the scale is granular rather than continuous, a form like
    ``cifi'uxa'' (3/6) may be used; in this case, 3/6 is not the
    same as 1/2. Here is an example: 

    <p></p>
<pre>
<a id="e11d10"
name="e11d10">11.10)</a>  le vi rozgu cu sofi'upanova'e xunre
    This rose is 8/10-scale red
    This rose is 8 out of 10 on the scale of redness.
    This rose is very red.
</pre>
    When the quantifier preceding any MOI cmavo includes the
    subjective numbers ``rau'', ``du'e'', or ``mo'a'' (enough, too
    many, too few) then an additional place is added for ``by
    standard''. For example: 

    <p></p>
<pre>
<a id="e11d11"
name="e11d11">11.11)</a>  le ratcu poi zvati le panka cu du'emei fo mi
    The rats which-are in the park are too-many
        by-standard me.
    There are too many rats in the park for me.
</pre>
    The extra place (which for ``-mei'' is the x4 place labeled by
    ``fo'') is provided rather than using a BAI tag such as
    ``ma'i'' because a specification of the standard for judgment
    is essential to the meaning of subjective words like
    ``enough''. 

    <p>This place is not normally explicit when using one of the
    subjective numbers directly as a number. Therefore, ``du'e
    ratcu'' means ``too many rats'' without specifying any
    standard.</p>

    <p>It is also grammatical to substitute a lerfu string for a
    number:</p>

    <p></p>
<pre>
<a id="e11d12" name="e11d12">11.12)</a>  ta ny.moi le'i mi ratcu
    that is-nth-of the-set-of my rats
    That is my nth rat.
</pre>
    More complex mekso cannot be placed directly in front of MOI,
    due to the resulting grammatical ambiguities. Instead, a
    somewhat artificial form of expression is required. 

    <p>The cmavo ``me'' (of selma'o ME) has the function of making
    a sumti into a selbri. It is often used to make a name into a
    predicate:</p>

    <p></p>
<pre>
<a id="e11d13" name="e11d13">11.13)</a>  ti me la nu,IORK. [me'u]
    this-here pertains-to what-I-call ``New York''.
    This is New York (or is New York-related).
</pre>
    A whole ``me'' construction can have a member of MOI added to
    the end to create a complex mekso selbri: 

    <p></p>
<pre>
<a id="e11d14"
name="e11d14">11.14)</a>  ta me li ny. su'i pa me'u moi le'i mi ratcu
    that is the-number n plus one-th-of the-set-of my rats.
    That is my (n+1)-th rat.
</pre>

    <p>Here the mekso ``ny. su'i pa'' is made into a sumti (with
    ``li'') and then changed into a mekso selbri with ``me'' and
    ``me'u moi''. The elidable terminator ``me'u'' is required here
    in order to keep the ``pa'' and the ``moi'' separate;
    otherwise, the parser will combine them into the compound
    ``pamoi'' and reject the sentence as ungrammatical.</p>

    <p>It is perfectly possible to use non-numerical sumti after
    ``me'' and before a member of MOI, producing strange results
    indeed:</p>

    <p></p>
<pre>
<a id="e11d15" name="e11d15">11.15)</a>  le nu mi nolraitru
        cu me le'e snime bolci
        be vi la xel. cu'o
    The event-of me being-a-nobly-superlative-ruler
        has-the-stereotypical snow type-of-ball
        at Hell probability.
    I have a snowball's chance in Hell of being king.
</pre>
    Note: the elidable terminator ``boi'' is not used between a
    number and a member of MOI. As a result, the ``me'u'' in <a
    href="#e11d14">Example 11.14</a> could also be replaced by a
    ``boi'', which would serve the same function of preventing the
    ``pa'' and ``moi'' from joining into a compound. 

    <h3><a id="s12" name="s12">12. Number questions</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   xo  PA  number question
</pre>
    The cmavo ``xo'', a member of selma'o PA, is used to ask
    questions whose answers are numbers. Like most Lojban question
    words, it fills the blank where the answer should go. (See <a
    href="chapter19.html">Chapter 19</a> for more on Lojban
    questions.) 
<pre>
<a id="e12d1" name="e12d1">12.1)</a>    li re su'i re du li xo
    the-number 2 plus 2 equals the-number what?
    What is 2 + 2?
</pre>
<pre>
<a id="e12d2" name="e12d2">12.2)</a>    le xomoi prenu cu darxi do
    the what-number-th person hit you?
    Which person [as in a police lineup] hit you?
</pre>
    ``xo'' can also be combined with other digits to ask questions
    whose answers are already partly specified. This ability could
    be very useful in writing tests of elementary arithmetical
    knowledge: 
<pre>
<a id="e12d3"
name="e12d3">12.3)</a>    li remu pi'i xa du li paxono
    the-number 25 times 6 equals the-number 1?0
</pre>
    to which the correct reply would be ``mu'', or 5. The ability
    to utter bare numbers as grammatical Lojban sentences is
    primarily intended for giving answers to ``xo'' questions.
    (Another use, obviously, is for counting off physical objects
    one by one.) 

    <h3><a id="s13" name="s13">13. Subscripts</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   xi  XI  subscript
</pre>
    Subscripting is a general Lojban feature, not used only in
    mekso; there are many things that can logically be subscripted,
    and grammatically a subscript is a free modifier, usable almost
    anywhere. In particular, of course, mekso variables (lerfu
    strings) can be subscripted: 

    <p></p>
<pre>
<a id="e13d1"
name="e13d1">13.1)</a>    li xy.boixici du li xy.boixipa su'i xy.boixire
    the-number x-sub-3 equals the-number x-sub-1 plus x-sub-2
    x<sub>3</sub>  = x<sub>1</sub>  + x<sub>2</sub>
</pre>
    Subscripts always begin with the flag ``xi'' (of selma'o XI).
    ``xi'' may be followed by a number, a lerfu string, or a
    general mekso expression in parentheses: 
<pre>
<a id="e13d2" name="e13d2">13.2)</a>    xy.boixino
    x<sub>0</sub>

<a id="e13d3" name="e13d3">13.3)</a> xy.boixiny.
    x<sub>n</sub>

<a id="e13d4"
name="e13d4">13.4)</a> xy.boixi vei ny. su'i pa [ve'o]
    x<sub>n+1}
</sub>
</pre>
    <sub>Note that subscripts attached directly to lerfu words
    (variables) generally need a ``boi'' terminating the variable.
    Free modifiers, of which subscripts are one variety, generally
    require the explicit presence of an otherwise elidable
    terminator.</sub>

    <p><sub>There is no standard way of handling superscripts
    (other than those used as exponents) or for subscripts or
    superscripts that come before the main expression. If
    necessary, further cmavo could be assigned to selma'o XI for
    these purposes.</sub></p>

    <p><sub>The elidable terminator for a subscript is that for a
    general number or lerfu string, namely ``boi''. By convention,
    a subscript following another subscript is taken to be a
    sub-subscript:</sub></p>
<pre>
<sub><a id="e13d5" name="e13d5">13.5)</a>    xy.boi xi by.boi xi vo
    x<sub>b</sub>4</sub>
</pre>

    <p>See <a href="#e17d10">Example 17.10</a> for the standard
    method of specifying multiple subscripts on a single
    object.</p>

    <p>More information on the uses of subscripts may be found in
    <a href="chapter19.html">Chapter 19</a>.</p>

    <h3><a id="s14" name="s14">14. Infix operators revisited</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   tu'o    PA  null operand
    ge'a    VUhU    null operator
    gei VUhU    exponential notation
</pre>
    The infix operators presented so far have always had exactly
    two operands, and for more or fewer operands forethought
    notation has been required. However, it is possible to use an
    operator in infix style even though it has more or fewer than
    two operands, through the use of a pair of tricks: the null
    operand ``tu'o'' and the null operator ``ge'a''. The first is
    suitable when there are too few operands, the second when there
    are too many. For example, suppose we wanted to express the
    numerical negation operator ``va'a'' in infix form. We would
    use: 
<pre>
<a id="e14d1" name="e14d1">14.1)</a>    li tu'o va'a ny. du
        li no vu'u ny.
    the-number (null) additive-inverse n equals
        the-number zero minus n
    -n = 0 - n
</pre>
    The ``tu'o'' fulfills the grammatical requirement for a left
    operand for the infix use of ``va'a'', even though semantically
    none is needed or wanted. 

    <p>Finding a suitable example of ``ge'a'' requires exhibiting a
    ternary operator, and ternary operators are not common. The
    operator ``gei'', however, has both a binary and a ternary use.
    As a binary operator, it provides a terse representation of
    scientific (also called ``exponential'') notation. The first
    operand of ``gei'' is the exponent, and the second operand is
    the mantissa or fraction:</p>

<pre>
<a id="e14d2" name="e14d2">14.2)</a>    li cinonoki'oki'o
        du li bi gei ci
    the-number three-zero-zero-comma-comma
        equals the-number eight scientific three.
    300,000,000 = 3 &times; 10<sup>8</sup>
</pre>
    Why are the arguments to ``gei'' in reverse order from the
    conventional symbolic notation? So that ``gei'' can be used in
    forethought to allow easy specification of a large (or small)
    imprecise number: 

<pre>
<a id="e14d3" name="e14d3">14.3)</a>    gei reno
    (scientific) two-zero
    10<sup>20</sup>
</pre>
    Note, however, that although 10 is far and away the most common
    exponent base, it is not the only possible one. The third
    operand of ``gei'', therefore, is the base, with 10 as the
    default value. Most computers internally store so-called
    ``floating-point'' numbers using 2 as the exponent base. (This
    has nothing to do with the fact that computers also represent
    all integers in base 2; the IBM 360 series used an exponent
    base of 16 for floating point, although each component of the
    number was expressed in base 2.) Here is a computer
    floating-point number with a value of 40: 

<pre>
<a id="e14d4" name="e14d4">14.4)</a>    papano bi'eju'u re
        gei pipanopano bi'eju'u re ge'a re
    (one-one-zero base 2)
        scientific (point-one-zero-one-zero base 2) with-base 2
    .1010<sub>2</sub> &times; 2<sup>110<sub>2</sub></sup>
</pre>

    <h3><a id="s15" name="s15">15. Vectors and matrices</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   jo'i    JOhI    start vector
    te'u    TEhU    end vector
    pi'a    VUhU    matrix row combiner
    sa'i    VUhU    matrix column combiner
</pre>
    A mathematical vector is a list of numbers, and a mathematical
    matrix is a table of numbers. Lojban considers matrices to be
    built up out of vectors, which are in turn built up out of
    operands. 

    <p>``jo'i'', the only cmavo of selma'o JOhI, is the vector
    indicator: it has a syntax reminiscent of a forethought
    operator, but has very high precedence. The components must be
    simple operands rather than full expressions (unless
    parenthesized). A vector can have any number of components;
    ``te'u'' is the elidable terminator. An example:</p>
<pre>
<a id="e15d1"
name="e15d1">15.1)</a>    li jo'i paboi reboi te'u su'i jo'i ciboi voboi
        du li jo'i voboi xaboi
    the-number array( one, two ) plus array( three, four)
        equals the-number array( four, six)
    (1,2) + (3,4) = (4,6)
</pre>
    Vectors can be combined into matrices using either ``pi'a'',
    the matrix row operator, or ``sa'i'', the matrix column
    operator. The first combines vectors representing rows of the
    matrix, and the second combines vectors representing columns of
    the matrix. Both of them allow any number of arguments:
    additional arguments are tacked on with the null operator
    ``ge'a''. 

    <p>Therefore, the ``magic square'' matrix</p>

    <dl>
      <dt></dt>

      <dd>8 1 6 3 5 7 4 9 2</dd>
    </dl>
    can be represented either as: 
<pre>
<a id="e15d2"
name="e15d2">15.2)</a>    jo'i biboi paboi xa pi'a jo'i ciboi muboi ze
        ge'a jo'i voboi soboi re
    the-vector (8 1 6) matrix-row the-vector (3 5 7)
        , the-vector (4 9 2)
</pre>
    or as 
<pre>
<a id="e15d3"
name="e15d3">15.3)</a>    jo'i biboi ciboi vo sa'i jo'i paboi muboi so
        ge'a jo'i xaboi zeboi re
    the-vector (8 3 4) matrix-column the-vector (1 5 9)
        , the-vector (6 7 2)
</pre>
    The regular mekso operators can be applied to vectors and to
    matrices, since grammatically both of these are expressions. It
    is usually necessary to parenthesize matrices when used with
    operators in order to avoid incorrect groupings. There are no
    VUhU operators for the matrix operators of inner or outer
    products, but appropriate operators can be created using a
    suitable symbolic lerfu word or string prefixed by ``ma'o''. 

    <p>Matrices of more than two dimensions can be built up using
    either ``pi'a'' or ``sa'i'' with an appropriate subscript
    numbering the dimension. When subscripted, there is no
    difference between ``pi'a'' and ``sa'i''.</p>

    <h3><a id="s16" name="s16">16. Reverse Polish notation</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   fu'a    FUhA    reverse Polish flag
</pre>
    So far, the Lojban notational conventions have mapped fairly
    familiar kinds of mathematical discourse. The use of
    forethought operators may have seemed odd when applied to
    ``+'', but when applied to ``f('' they appear as the usual
    functional notation. Now comes a sharp break. Reverse Polish
    (RP) notation represents something completely different; even
    mathematicians don't use it much. (The only common uses of RP,
    in fact, are in some kinds of calculators and in the
    implementation of some programming languages.) 

    <p>In RP notation, the operator follows the operands. (Polish
    notation, where the operator precedes its operands, is another
    name for forethought mekso of the kind explained in <a
    href="#s6">Section 6</a>.) The number of operands per operator
    is always fixed. No parentheses are required or permitted. In
    Lojban, RP notation is always explicitly marked by a ``fu'a''
    at the beginning of the expression; there is no terminator.
    Here is a simple example:</p>
<pre>
<a id="e16d1" name="e16d1">16.1)</a>    li fu'a reboi ci su'i
        du li mu
    the-number (RP!) two, three, plus
        equals the-number five.
</pre>

    <p>The operands are ``re'' and ``ci''; the operator is
    ``su'i''.</p>

    <p>Here is a more complex example:</p>
<pre>
<a id="e16d2" name="e16d2">16.2)</a>    li fu'a reboi ci pi'i
        voboi mu pi'i su'i
        du li rexa
    the-number (RP!) (two, three, times),
        (four, five, times), plus
        equals the-number two-six
</pre>

    <p>Here the operands of the first ``pi'i'' are ``re'' and
    ``ci''; the operands of the second ``pi'i'' are ``vo'' and
    ``mu'' (with ``boi'' inserted where needed), and the operands
    of the ``su'i'' are ``reboi ci pi'i'', or 6, and ``voboi mu
    pi'i'', or 20. As you can see, it is easy to get lost in the
    world of reverse Polish notation; on the other hand, it is
    especially easy for a mechanical listener (who has a deep
    mental stack and doesn't get lost) to comprehend.</p>

    <p>The operands of an RP operator can be any legal mekso
    operand, including parenthesized mekso that can contain any
    valid syntax, whether more RP or something more
    conventional.</p>

    <p>In Lojban, RP operators are always parsed with exactly two
    operands. What about operators which require only one operand,
    or more than two operands? The null operand ``tu'o'' and the
    null operator ``ge'a'' provide a simple solution. A one-operand
    operator like ``va'a'' always appears in a reverse Polish
    context as ``tu'o va'a''. The ``tu'o'' provides the second
    operand, which is semantically ignored but grammatically
    necessary. Likewise, the three-operand version of ``gei''
    appears in reverse Polish as ``ge'a gei'', where the ``ge'a''
    effectively merges the 2nd and 3rd operands into a single
    operand. Here are some examples:</p>
<pre>
<a id="e16d3" name="e16d3">16.3)</a>    li fu'a ciboi muboi vu'u
        du li fu'a reboi tu'o va'a
    The-number (RP!) (three, five, minus)
        equals the-number (RP!) two, null, negative-of.
    3 - 5 = -2

<a id="e16d4" name="e16d4">16.4)</a> li cinoki'oki'o du
        li fu'a biboi
        ciboi panoboi ge'a gei
    the-number 30-comma-comma equals
        the-number (RP!) 8,
        (3, 10, null-op), exponential-notation
    30,000,000 = 3 &times; 10<sup>8</sup>
</pre>

    <h3><a id="s17" name="s17">17. Logical and non-logical connectives within mekso</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   .abu    BY  letter ``a''
    by  BY  letter ``b''
    cy  BY  letter ``c''
    fe'a    VUhU    nth root of (default square root)
    lo'o    LOhO    terminator for LI
</pre>
    As befits a logical language, Lojban has extensive provision
    for logical connectives within both operators and operands.
    Full details on logical and non-logical connectives are
    provided in <a href="chapter14.html">Chapter 14</a>. Operands are
    connected in afterthought with selma'o A and in forethought
    with selma'o GA, just like sumti. Operators are connected in
    afterthought with selma'o JA and in forethought with selma'o
    GUhA, just like tanru components. This parallelism is no
    accident. 

    <p>In addition, A+BO and A+KE constructs are allowed for
    grouping logically connected operands, and ``ke ... ke'e'' is
    allowed for grouping logically connected operators, although
    there are no analogues of tanru among the operators.</p>

    <p>Despite the large number of rules required to support this
    feature, it is of relatively minor importance in the mekso
    scheme of things. <a href="#e17d1">Example 17.1</a> exhibits
    afterthought logical connection between operands:</p>

    <p></p>
<pre>
<a id="e17d1"
name="e17d1">17.1)</a>    vei ci .a vo ve'o prenu cu klama le zarci
    ( three or four ) people go-to the market.
</pre>
    <a href="#e17d2">Example 17.2</a> is equivalent in meaning, but
    uses forethought connection: 
<pre>
<a id="e17d2"
name="e17d2">17.2)</a>    vei ga ci gi vo ve'o prenu cu klama le zarci
    ( either 3 or 4 ) people go-to the market.
</pre>
    Note that the mekso here are being used as quantifiers. Lojban
    requires that any mekso other than a simple number be enclosed
    in parentheses when used as a quantifier. This rule prevents
    ambiguities that do not exist when using ``li''. 

    <p>By the way, ``li'' has an elidable terminator, ``lo'o'',
    which is needed when a ``li'' sumti is followed by a logical
    connective that could seem to be within the mekso. For
    example:</p>
<pre>
<a id="e17d3" name="e17d3">17.3)</a>    li re su'i re du
        li vo lo'o .onai lo nalseldjuno namcu
    the-number two plus two equals
        the-number four or else a non-known number.
</pre>

    <p>Omitting the ``lo'o'' would cause the parser to assume that
    another operand followed the ``.onai'' and reject ``lo'' as an
    invalid operand.</p>

    <p>Simple examples of logical connection between operators are
    hard to come by. A contrived example is:</p>
<pre>
<a id="e17d4"
name="e17d4">17.4)</a>    li re su'i je pi'i re du li vo
    the-number two plus and times two equals the-number four.
    2 + 2 = 4 and 2 &times; 2 = 4.
</pre>

    <p>The forethought-connection form of <a href="#e17d4">Example
    17.4</a> is:</p>
<pre>
<a id="e17d5" name="e17d5">17.5)</a>    li re ge su'i gi pi'i re
        du li vo
    the-number two both plus and times two
        equals the-number four.
    Both 2 + 2 = 4 and 2 &times; 2 = 4.
</pre>

    <p>Here is a classic example of operand logical connection:</p>

    <p></p>
<pre>
<a id="e17d6"
name="e17d6">17.6)</a>    go li .abu bi'epi'i vei xy. te'a re ve'o
        su'i by. bi'epi'i xy. su'i cy.
        du li no
    gi li xy. du li vei va'a by. ku'e
        su'i ja vu'u fe'a
        vei by. bi'ete'a re vu'u
        vo bi'epi'i .abu bi'epi'i cy. ve'o [ku'e] ve'o
        fe'i re bi'epi'i .abu
    if-and-only-if the-number ``a''-times-( ``x'' power two )
        plus ``b''-times-``x'' plus ``c''
        equals the-number zero
    then the-number x equals the-number [ the-negation-of( b )
        plus or minus the-root-of
        ( ``b''-power-2 minus
        four-times-``a''-times-``c'' ) ]
        divided-by two-times-``a''.
    Iff ax<sup>2</sup>  + bx + c = 0,
        then x =-b &plusmn; <span class="c3">&Ouml;</span>
<!--sqrt-->(b<sup>2</sup>  - 4ac)
            -----------------------
                2a
</pre>
    Note the mixture of styles in <a href="#e17d6">Example
    17.6</a>: the negation of b and the square root are represented
    by forethought and most of the operator precedence by prefixed
    ``bi'e'', but explicit parentheses had to be added to group the
    numerator properly. In addition, the square root parentheses
    cannot be removed here in favor of simple ``fe'a'' and ``ku'e''
    bracketing, because infix operators are present in the operand.
    Getting <a href="#e17d6">Example 17.6</a> to parse perfectly
    using the current parser took several tries: a more relaxed
    style would dispense with most of the ``bi'e'' cmavo and just
    let the standard precedence rules be understood. 

    <p>Non-logical connection with JOI and BIhI is also permitted
    between operands and between operators. One use for this
    construct is to connect operands with ``bi'o'' to create
    intervals:</p>
<pre>
<a id="e17d7" name="e17d7">17.7)</a>    li no ga'o bi'o ke'i pa
    the-number zero (inclusive) from-to (exclusive) one
    [0,1)
    the numbers from zero to one, including zero
        but not including one
</pre>
    Intervals defined by a midpoint and range rather than beginning
    and end points can be expressed by ``mi'i'': 

    <p></p>
<pre>
<a id="e17d8" name="e17d8">17.8)</a>    li pimu ga'o mi'i ke'i pimu
    the-number 0.5 plus-or-minus 0.5
</pre>
    which expresses the same interval as <a href="#e17d7">Example
    17.7</a>. Note that the ``ga'o'' and ``ke'i'' still refer to
    the endpoints, although these are now implied rather than
    expressed. Another way of expressing the same thing: 
<pre>
<a id="e17d9"
name="e17d9">17.9)</a>    li pimu su'i ni'upimu bi'o ma'upimu
    the-number 0.5 plus [-0.5 from-to +0.5]
</pre>
    Here we have the sum of a number and an interval, which
    produces another interval centered on the number. As <a
    href="#e17d9">Example 17.9</a> shows, non-logical (or logical)
    connection of operands has higher precedence than any mekso
    operator. 

    <p>You can also combine two operands with ``ce'o'', the
    sequence connective of selma'o JOI, to make a compound
    subscript:</p>

<pre>
<a id="e17d10"
name="e17d10">17.10)</a>  xy. xi vei by. ce'o dy. [ve'o]
    ``x'' sub ( ``b'' sequence ``d'' )
</pre>
    x<sub>{b,d}</sub>

    <h3><a id="s18" name="s18">18. Using Lojban resources within mekso</h3>

    <p>The following cmavo are discussed in this
    section:</p>
<pre>
   na'u    NAhU    selbri to operator
    ni'e    NIhE    selbri to operand
    mo'e    MOhE    sumti to operand
    te'u    TEhU    terminator for all three

</pre>
    One of the mekso design goals requires the ability to make
    use of Lojban's vocabulary resources within mekso to extend the
    built-in cmavo for operands and operators. There are three
    relevant constructs: all three share the elidable terminator
    ``te'u'' (which is also used to terminate vectors marked with
    ``jo'i'').

    <p>The cmavo ``na'u'' makes a selbri into an operator. In
    general, the first place of the selbri specifies the result of
    the operator, and the other unfilled places specify the
    operands:</p>

    <p></p>
<pre>
<a id="e18d1" name="e18d1">18.1)</a>    li na'u tanjo te'u
        vei pai fe'i re [ve'o] du li ci'i
    the-number the-operator tangent
        ( pi / 2 ) = the-number infinity
    tan(pi/2) = <span class="c3">&yen;</span><!--infty-->

</pre>
    ``tanjo'' is the gismu for ``x1 is the tangent of x2'',
    and the ``na'u'' here makes it into an operator which is then
    used in forethought.

    <p>The cmavo ``ni'e'' makes a selbri into an operand. The
    x1 place of the selbri generally represents a number, and
    therefore is often a ``ni'' abstraction, since ``ni''
    abstractions represent numbers. The ``ni'e'' makes that number
    available as a mekso operand. A common application is to make
    equations relating pure dimensions:</p>

    <p></p>
<pre>
<a id="e18d2"
name="e18d2">18.2)</a>    li ni'e ni clani [te'u] pi'i
        ni'e ni ganra [te'u] pi'i
        ni'e ni condi te'u
        du li ni'e ni canlu
    the-number quantity-of length times
        quantity-of width times
        quantity-of depth
        equals the-number quantity-of volume.
    Length &times; Width &times; Depth = Volume

</pre>
    The cmavo ``mo'e'' operates similarly to ``ni'e'', but
    makes a sumti (rather than a selbri) into an operand. This
    construction is useful in stating equations involving
    dimensioned numbers:

    <p></p>
<pre>
<a id="e18d3"
name="e18d3">18.3)</a>    li mo'e re ratcu su'i mo'e re ractu
        du li mo'e vo danlu
    the-number two rats plus two rabbits
        equals the-number four animals
    2 rats + 2 rabbits = 4 animals.

</pre>
    Another use is in constructing Lojbanic versions of
    so-called ``folk quantifiers'', such as ``a pride of
    lions'':
<pre>
<a id="e18d4"
name="e18d4">18.4)</a>    mi viska vei mo'e lo'e lanzu ve'o cinfo
    I see ( the-typical family )-number-of lions.
    I see a pride of lions.

</pre>

    <h3><a id="s19" name="s19">19. Other uses of mekso</h3>

    <p>The following cmavo are discussed in this
    section:</p>
<pre>
   me'o    LI  the mekso
    nu'a    NUhA    operator to selbri
    mai MAI utterance ordinal
    mo'o    MAI higher order utterance ordinal
    roi ROI quantified tense

</pre>

    <p>So far we have seen mekso used as sumti (with ``li''),
    as quantifiers (often parenthesized), and in MOI and ME-MOI
    selbri. There are a few other minor uses of mekso within
    Lojban.</p>

    <p>The cmavo ``me'o'' has the same grammatical use as
    ``li'' but slightly different semantics. ``li'' means ``the
    number which is the value of the mekso ...'', whereas ``me'o''
    just means ``the mekso ...'' So it is true that:</p>
<pre>
<a id="e19d1" name="e19d1">19.1)</a>    li re su'i re du li vo
    the-number two plus two equals the-number four
    2 + 2 = 4

</pre>
    but false that:
<pre>
<a id="e19d2"
name="e19d2">19.2)</a>    me'o re su'i re du me'o vo
    the-mekso two plus two equals the-mekso four
    ``2 + 2'' = ``4''

</pre>
    since the expressions ``2 + 2'' and ``4'' are not the
    same. The relationship between ``li'' and ``me'o'' is related
    to that between ``la djan.'', the person named John, and ``zo
    .djan.'', the name ``John''.

    <p>The cmavo ``nu'a'' is the inverse of ``na'u'', and
    allows a mekso operator to be used as a normal selbri, with the
    place structure:</p>

    <dl>
      <dt></dt>

      <dd>x1 is the result of applying (operator) to x2, x3,
      ...</dd>
    </dl>
    f or as many places as may be required. For example:
<pre>
<a id="e19d3"
name="e19d3">19.3)</a>    li ni'umu cu nu'a va'a li ma'umu
    the-number -5 is-the-negation-of the-number +5

</pre>
    uses ``nu'a'' to make the operator ``va'a'' into a
    two-place bridi.

    <p>Used together, ``nu'a'' and ``na'u'' make it possible
    to ask questions about mekso operators, even though there is no
    specific cmavo for an operator question, nor is it grammatical
    to utter an operator in isolation. Consider <a
    href="#e19d4">Example 19.4</a>, to which <a
    href="#e19d5">Example 19.5</a> is one correct answer:</p>
<pre>
<a id="e19d4"
name="e19d4">19.4)</a>    li re na'u mo re du li vo
    the-number two what-operator? two equals the-number four
    2 ? 2 = 4

<a id="e19d5" name="e19d5">19.5)</a> nu'a su'i
    plus

</pre>

    <p>In <a href="#e19d4">Example 19.4</a>, ``na'u mo'' is an
    operator question, because ``mo'' is the selbri question cmavo
    and ``na'u'' makes the selbri into an operator. <a
    href="#e19d5">Example 19.5</a> makes the true answer ``su'i''
    into a selbri (which is a legal utterance) with the inverse
    cmavo ``nu'a''. Mechanically speaking, inserting <a
    href="#e19d5">Example 19.5</a> into <a href="#e19d4">Example
    19.4</a> produces:</p>
<pre>
<a id="e19d6"
name="e19d6">19.6)</a>    li re na'u nu'a su'i re du li vo
    the-number two (the-operator the-selbri plus)
        two equals the-number four

</pre>
    where the ``na'u nu'a'' cancels out, leaving a truthful
    bridi.

    <p>Numerical free modifiers, corresponding to English
    ``firstly'', ``secondly'', and so on, can be created by
    suffixing a member of selma'o MAI to a digit string or a lerfu
    string. (Digit strings are compound cmavo beginning with a
    cmavo of selma'o PA, and containing only cmavo of PA or BY;
    lerfu strings begin with a cmavo of selma'o BY, and likewise
    contain only PA or BY cmavo.) Here are some examples:</p>
<pre>
<a id="e19d7" name="e19d7">19.7)</a>    pamai
    firstly

<a id="e19d8" name="e19d8">19.8)</a> remai
    secondly

<a id="e19d9" name="e19d9">19.9)</a> romai
    all-ly
    lastly

<a id="e19d10" name="e19d10">19.10)</a>   ny.mai
    nth-ly

<a id="e19d11" name="e19d11">19.11)</a>   pasomo'o
    nineteenthly (higher order)
    <a href="#s19">Section 19</a>

</pre>
    The difference between ``mai'' and ``mo'o'' is that
    ``mo'o'' enumerates larger subdivisions of a text. Each
    ``mo'o'' subdivision can then be divided into pieces and
    internally numbered with ``mai''. If this chapter were
    translated into Lojban, it would number each section with
    ``mo'o''.

    <p>A numerical tense can be created by suffixing a digit
    string with ``roi''. This usage generates tenses corresponding
    to English ``once'', ``twice'', and so on. This topic belongs
    to a detailed discussion of Lojban tenses, and is explained
    further in <a href="chapter10.html">Chapter 10</a>.</p>

    <p>Note: the elidable terminator ``boi'' is not used
    between a number and a member of MAI or ROI.</p>

    <h3><a id="s20" name="s20">20. Explicit operator precedence</h3>

    <p>As mentioned earlier, Lojban does provide a way for the
    precedences of operators to be explicitly declared, although
    current parsers do not understand these declarations.</p>

    <p>The declaration is made in the form of a metalinguistic
    comment using ``ti'o'', a member of selma'o SEI. ``sei'', the
    other member of SEI, is used to insert metalinguistic comments
    on a bridi which give information about the discourse which the
    bridi comprises. The format of a ``ti'o'' declaration has not
    been formally established, but presumably would take the form
    of mentioning a mekso operator and then giving it either an
    absolute numerical precedence on some pre-established scale, or
    else specifying relative precedences between new operators and
    existing operators.</p>

    <p>In future, we hope to create an improved machine parser
    that can understand declarations of the precedences of simple
    operators belonging to selma'o VUhU. Originally, all operators
    would have the same precedence. Declarations would have the
    effect of raising the specified cmavo of VUhU to higher
    precedence levels. Complex operators formed with ``na'u'',
    ``ni'e'', or ``ma'o'' would remain at the standard low
    precedence; declarations with respect to them are for future
    implementation efforts. It is probable that such a parser would
    have a set of ``commonly assumed precedences'' built into it
    (selectable by a special ``ti'o'' declaration) that would match
    mathematical intuition: times higher than plus, and so
    on.</p>

    <h3><a id="s21" name="s21">21. Miscellany</h3>

    <p>A few other points:</p>

    <p>``se'' can be used to convert an operator as if it were
    a selbri, so that its arguments are exchanged. For
    example:</p>
<pre>
<a id="e21d1" name="e21d1">21.1)</a>    li ci se vu'u vo
        du li pa
    the-number three (inverse) minus four
        equals the-number one.
    3 subtracted from 4 equals 1.

</pre>
    The other converters of selma'o SE can also be used on
    operators with more than two operands, and they can be
    compounded to create (probably unintelligible) operators as
    needed.

    <p>Members of selma'o NAhE are also legal on an operator
    to produce a scalar negation of it. The implication is that
    some other operator would apply to make the bridi
    true:</p>
<pre>
<a id="e21d2"
name="e21d2">21.2)</a>    li ci na'e su'i vo du li pare
    the-number 3 non-plus 4 equals the-number 12

</pre>
<pre>
<a id="e21d3"
name="e21d3">21.3)</a>    li ci to'e vu'u re du li mu
    the-number 3 opposite-of-minus 2 equals the-number 5

</pre>

    <p>The sense in which ``plus'' is the opposite of
    ``minus'' is not a mathematical but rather a linguistic one;
    negated operators are defined only loosely.</p>

    <p>``la'e'' and ``lu'e'' can be used on operands with the
    usual semantics to get the referent of or a symbol for an
    operand. Likewise, a member of selma'o NAhE followed by ``bo''
    serves to scalar-negate an operand, implying that some other
    operand would make the bridi true:</p>
<pre>
<a id="e21d4"
name="e21d4">21.4)</a>    li re su'i re du li na'ebo mu
    the-number 2 plus 2 equals the-number non-5.
    2 + 2 = something other than 5.

</pre>
    The digits 0-9 have rafsi, and therefore can be used in
    making lujvo. Additionally, all the rafsi have CVC form and can
    stand alone or together as names:
<pre>
<a id="e21d5" name="e21d5">21.5)</a>    la zel. poi gunta
        la tebes. pu nanmu
    those-named ``Seven'' who attack
        that-named ``Thebes'' [past] are-men
    The Seven Against Thebes were men.

</pre>

    <p>Of course, there is no guarantee that the name ``zel.''
    is connected with the number rafsi: an alternative which cannot
    be misconstrued is:</p>
<pre>
<a id="e21d6" name="e21d6">21.6)</a>    la zemei poi gunta
        la tebes. pu nanmu
    those-named-the Sevensome who attack
        Thebes [past] are-men.

</pre>
    Certain other members of PA also have assigned rafsi:
    ``so'a'', ``so'e'', ``so'i'', ``so'o'', ``so'u'', ``da'a'',
    ``ro'', ``su'e'', ``su'o'', ``pi'', and ``ce'i''. Furthermore,
    although the cmavo ``fi'u'' does not have a rafsi as such, it
    is closely related to the gismu ``frinu'', meaning
    ``fraction''; therefore, in a context of numeric rafsi, you can
    use any of the rafsi for ``frinu'' to indicate a fraction
    slash.

    <p>A similar convention is used for the cmavo ``cu'o'' of
    selma'o MOI, which is closely related to ``cunso''
    (probability); use a rafsi for ``cunso'' in order to create
    lujvo based on ``cu'o''. The cmavo ``mei'' and ``moi'' of MOI
    have their own rafsi, two each in fact: ``mem''/``mei'' and
    ``mom''/``moi'' respectively.</p>

    <p>The grammar of mekso as described so far imposes a
    rigid distinction between operators and operands. Some flavors
    of mathematics (lambda calculus, algebra of functions) blur
    this distinction, and Lojban must have a method of doing the
    same. An operator can be changed into an operand with
    ``ni'enu'a'', which transforms the operator into a matching
    selbri and then the selbri into an operand.</p>

    <p>To change an operand into an operator, we use the cmavo
    ``ma'o'', already introduced as a means of changing a lerfu
    string such as ``fy.'' into an operator. In fact, ``ma'o'' can
    be followed by any mekso operand, using the elidable terminator
    ``te'u'' if necessary.</p>

    <p>There is a potential semantic ambiguity in ``ma'o fy.
    [te'u]'' if ``fy.'' is already in use as a variable: it comes
    to mean ``the function whose value is always 'f'''. However,
    mathematicians do not normally use the same lerfu words or
    strings as both functions and variables, so this case should
    not arise in practice.</p>

    <h3><a id="s22" name="s22">22. Four score and seven: a mekso problem</h3>

    <p>Abraham Lincoln's Gettysburg Address begins with the
    words ``Four score and seven years ago''. This section exhibits
    several different ways of saying the number ``four score and
    seven''. (A ``score'', for those not familiar with the term, is
    20; it is analogous to a ``dozen'' for 12.) The trivial
    way:</p>
<pre>
<a id="e22d1" name="e22d1">22.1)</a>    bize
    eight seven
    87

</pre>
    <a href="#e22d1">Example 22.1</a> is mathematically
    correct, but sacrifices the spirit of the English words, which
    are intended to be complex and formal.
<pre>
<a id="e22d2" name="e22d2">22.2)</a>    vo pi'i reno su'i ze
    four times twenty plus seven
    4 &times; 20 + 7

</pre>
    <a href="#e22d2">Example 22.2</a> is also mathematically
    correct, but still misses something. ``Score'' is not a word
    for 20 in the same way that ``ten'' is a word for 10: it
    contains the implication of 20 objects. The original may be
    taken as short for ``Four score years and seven years ago''.
    Thinking of a score as a twentysome rather than as 20 leads
    to:
<pre>
<a id="e22d3"
name="e22d3">22.3)</a>    mo'e voboi renomei su'i ze
    the-number-of four twentysomes plus seven

</pre>

    <p>In <a href="#e22d3">Example 22.3</a>, ``voboi renomei''
    is a sumti signifying four things each of which are groups of
    twenty; the ``mo'e'' and ``te'u'' then make this sumti into a
    number in order to allow it to be the operand of
    ``su'i''.</p>

    <p>Another approach is to think of ``score'' as setting a
    representation base. There are remnants of base-20 arithmetic
    in some languages, notably French, in which 87 is
    ``quatre-vingt-sept'', literally ``four-twenties-seven''. (This
    fact makes the Gettysburg Address hard to translate into
    French!) If ``score'' is the representation base, then we
    have:</p>
<pre>
<a id="e22d4" name="e22d4">22.4)</a>    vo pi'e ze ju'u reno
    four ; seven base 20
    4720

</pre>

    <p>Overall, <a href="#e22d3">Example 22.3</a> probably captures
    the flavor of the English best. <a href="#e22d1">Example
    22.1</a> and <a href="#e22d2">Example 22.2</a> are too simple,
    and <a href="#e22d4">Example 22.4</a> is too tricky.
    Nevertheless, all four examples are good Lojban. Pedagogically,
    these examples illustrate the richness of lojbau mekso:
    anything that can be said at all, can probably be said in more
    than one way.</p>

    <h3><a id="s23" name="s23">23. mekso selma'o summary</h3>

    <p>Except as noted, each selma'o has only one cmavo.</p>

    <p></p>
<pre>
   BOI elidable terminator for numerals
        and lerfu strings
    BY  lerfu for variables and functions
        (see <a href="chapter17.html">Chapter 17</a>)
    FUhA    reverse-Polish flag
    GOhA    includes ``du'' (mathematical equality)
        and other non-mekso cmavo
    JOhI    array flag
    KUhE    elidable terminator for forethought mekso
    LI  mekso articles (li and me'o)
    MAhO    make operand into operator
    MOI creates mekso selbri
        (moi, mei, si'e, and cu'o, see <a
href="#s11">Section 11</a>)
    MOhE    make sumti into operand
    NAhU    make selbri into operator
    NIhE    make selbri into operand
    NUhA    make operator into selbri
    PA  numbers (see <a href="#s25">Section 25</a>)
    PEhO    optional forethought mekso marker
    TEhU    elidable terminator for
        NAhU, NIhE, MOhE, MAhO, and JOhI
    VEI left parenthesis
    VEhO    right parenthesis
    VUhU    operators (see <a href="#s24">Section 24</a>)
    XI  subscript flag
</pre>

    <h3><a id="s24" name="s24">24. Complete table of VUhU cmavo, with operand
    structures</h3>

    <p>The operand structures specify what various operands
    (labeled a, b, c, ...) mean. The implied context is
    forethought, since only forethought operators can have a
    variable number of operands; however, the same rules apply to
    infix and RP uses of VUhU.</p>

    <p></p>

    <dl>
      <dt>su'i</dt>

      <dd>plus (((a + b) + c) + ...)</dd>
<dt>pi'i</dt><dd>times (((a &times; b) &times; c) &times; ...)</dd>
<dt>vu'u</dt><dd>minus (((a - b) - c) - ...)</dd>
<dt>fe'i</dt><dd>divided by (((a / b) / c) / ...)</dd>
<dt>ju'u</dt><dd>number base numeral string ``a'' interpreted in the base b</dd>
<dt>pa'i</dt><dd>ratio the ratio of a to b, a:b</dd>
<dt>fa'i</dt><dd>reciprocal of/multiplicative inverse 1 / a</dd>
<dt>gei</dt><dd>scientific notation b &times; (c [default 10] to the a power)</dd>
<dt>ge'a</dt><dd>null operator (no operands)</dd>
<dt>de'o</dt><dd>logarithm log <i>a</i> to base <i>b</i> (default 10 or <i>e</i> as appropriate)</dd>
<dt>te'a</dt><dd>to the power/exponential a to the b power</dd>
<dt>fe'a</dt><dd>nth root of/inverse power b'th root of a (default square root: b = 2)</dd>
<dt>cu'a</dt><dd>absolute value/norm | a |</dd>
<dt>ne'o</dt><dd>factorial a!</dd>
<dt>pi'a</dt><dd>matrix row vector combiner (all operands are row vectors)</dd>
<dt>sa'i</dt><dd>matrix column vector combiner (all operands are column vectors)</dd>
<dt>ri'o</dt><dd>integral integral of a with respect to b over range c</dd>
<dt>sa'o</dt><dd>derivative derivative of a with respect to b of degree c (default 1)</dd>
<dt>fu'u</dt><dd>non-specific operator (variable)</dd>
<dt>si'i</dt><dd>sigma summation summation of a using variable b over range c</dd>
<dt>va'a</dt><dd>negation of/additive inverse: - a
<dt>re'a</dt><dd>matrix transpose/dual a*</dd>
    </dl>

    <h3><a id="s25" name="s25">25. Complete table of PA cmavo: digits, punctuation, and
    other numbers.</h3>

    <h4>Decimal digits:</h4>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>rafsi:</td><td>non</td><td> pav</td><td> rel</td><td> cib</td><td> von</td><td> mum</td><td> xav</td><td> zel</td><td> biv</td><td> soz</td>
	</tr>
	<tr>
	    <td>cmavo:</td><td>no</td><td> pa</td><td> re</td><td> ci</td><td> vo</td><td> mu</td><td> xa</td><td> ze</td><td> bi</td><td> so</td>
	</tr>
	<tr>
	    <td>numeral:</td><td>0</td><td> 1</td><td> 2</td><td> 3</td><td> 4</td><td> 5</td><td> 6</td><td> 7</td><td> 8</td><td> 9 </td>
	</tr>
    </table>

    <h4>Hexadecimal digits</h4>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>A/10</td><td> B/11</td><td> C/12</td><td> D/13</td><td> E/14</td><td> F/15</td>
	</tr>
	<tr>
	    <td>dau</td><td> fei</td><td> gai</td><td> jau</td><td> rei</td><td> vai </td>
	</tr>
    </table>

    <h4>Special numbers</h4>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>pi</td><td> imaginary i</td><td> exponential e</td><td> infinity</td>
	</tr>
	<tr>
	    <td>pai</td><td> ka'o</td><td> te'o</td><td> ci'i </td>
	</tr>
    </table>

    <h4>Number punctuation</h4>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>cmavo:</td><td>pi</td><td> ce'i</td><td> fi'u </td>
	</tr>
	<tr>
	    <td>English:</td><td>decimal point</td><td> percentage</td><td> fraction (not division) </td>
	</tr>
	<tr>
	    <td>rafsi:</td><td>piz</td><td> cez</td><td> fi'u (from frinu; see <a href="#s20">Section 20</a>)</td>
	</tr>
    </table>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>pi'e</td><td> ma'u</td><td> ni'u </td>
	</tr>
	<tr>
	    <td>mixed-base point</td><td> plus sign (not addition)</td><td> minus sign (not subtraction)</td>
	</tr>
    </table>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>ki'o</td><td> ra'e </td>
	</tr>
	<tr>
	    <td>thousands comma</td><td> repeating-decimal indicator</td>
	</tr>
    </table>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>ji'i</td><td> ka'o </td>
	</tr>
	<tr>
	    <td>approximation sign</td><td> complex number separator</td>
	</tr>
    </table>


    <h4>Indefinite numbers</h4> 

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>ro</td><td> so'a</td><td> so'e</td><td> so'i</td><td> so'o</td><td> so'u</td><td> da'a </td>
	</tr>
	<tr>
	    <td>all</td><td> almost all</td><td> most</td><td> many</td><td> several</td><td> few</td><td> all but rafsi: rol</td><td> soj</td><td> sor or so'i</td><td> sos</td><td> sot</td><td> daz</td>
	</tr>
    </table>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>cmavo:</td><td>su'e</td><td> su'o </td>
	</tr>
	<tr>
	    <td>English:</td><td>at most</td><td> at least 
	</tr>
	<tr>
	    <td>rafsi:</td><td> su'e</td><td> su'o</td>
	</tr>
    </table>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>me'i</td><td> za'u </td>
	</tr>
	<tr>
	    <td>less than</td><td> more than</td>
	</tr>
    </table>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>no'o </td>
	</tr>
	<tr>
	    <td>the typical number</dd>
	</tr>
    </table>

    <h4>Subjective numbers</h4>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>rau</td><td> du'e</td><td> mo'a </td>
	</tr>
	<tr>
	    <td>enough</td><td> too many</td><td> too few</td>
	</tr>
    </table>

    <h4>Miscellaneous:</h4>

    <table cellpadding="10%" frame="box" rules="all">
	<tr>
	    <td>xo</td><td> tu'o </td>
	</tr>
	<tr>
	    <td>number question</td><td> null operand</td>
	</tr>
    </table>

    <h3><a id="s26" name="s26">26. Table of MOI cmavo, with associated rafsi and place
    structures</h3>

    <p></p>
<pre>
   mei x1 is a mass formed from a set x2
        of n members, one or more of which is/are x3,
        [measured relative to the set x4/by standard x4]
    rafsi: mem, mei

    moi x1 is the (n)th member of set x2
        when ordered by rule x3 [by standard x4]
    rafsi: mom, moi

    si'e    x1 is an (n)th portion of mass x2
        [by standard x3]
    rafsi: none

    cu'o    event x1 has probability (n) of occurring
        under conditions x2 [by standard x3]
    rafsi: cu'o (borrowed from cunso; see <a
href="#s20">Section 20</a>)
</pre>

    <hr />
    
    <p>Derni&egrave;res modifications&nbsp;: Mon Jun 27 23:13:20 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
