
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//FR" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 2</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

  <div class="centered">
      <img src="chapter2.gif" alt="[Cartoon]" width="405" height="405" />

    <h2>Chapter 2 <br /> A Quick Tour of Lojban Grammar, With
    Diagrams</h2>

    <!--
	<h6>$Revision: 4.4 $ <br /> mkhtml: 1.1</h6>
    -->
  </div>

  <h3><a id="s1" name="s1">1. The concept of the bridi</h3>

  <p>This chapter gives diagrammed examples of basic Lojban
  sentence structures. The most general pattern is covered first,
  followed by successive variations on the basic components of the
  Lojban sentence. There are many more capabilities not covered in
  this chapter, but covered in detail in later chapters, so this
  chapter is a ``quick tour'' of the material later covered more
  slowly throughout the book. It also introduces most of the Lojban
  words used to discuss Lojban grammar.</p>

  <p>Let us consider John and Sam and three statements about
  them:</p>

<pre>
<a id="e1d1" name="e1d1">1.1)</a>  John is the father of Sam.

<a id="e1d2" name="e1d2">1.2)</a>   John hits Sam.

<a id="e1d3" name="e1d3">1.3)</a>   John is taller than Sam.
</pre>

  These examples all describe relationships between John and Sam.
  However, in English, we use the noun ``father'' to describe a
  static relationship in 
  <a href="#e1d1">Example 1.1</a>

  , the verb ``hits'' to describe an active relationship in 
  <a href="#e1d2">Example 1.2</a>

  , and the adjective ``taller'' to describe an attributive
  relationship in 
  <a href="#e1d3">Example 1.3</a>

  . In Lojban we make no such grammatical distinctions; these three
  sentences, when expressed in Lojban, are structurally identical.
  The same part of speech is used to represent the relationship. In
  formal logic this whole structure is called a ``predication''; in
  Lojban it is called a ``bridi'', and the central part of speech
  is the ``selbri''. Logicians refer to the things thus related as
  arguments, while Lojbanists call them ``sumti''. These Lojban
  terms will be used for the rest of the book. 
<pre>
         bridi (predicate)
    ______________|________________
    |                              |
    John     is the father of       Sam
    |____|   |______________|      |___|
       |              |              |
    sumti      selbri          sumti (argument)
</pre>

  In a relationship, there are a definite number of things being
  related. In English, for example, ``give'' has three places: the
  donor, the recipient and the gift. For example: 
<pre>
<a id="e1d4" name="e1d4">1.4)</a>  John gives Sam the book.
</pre>

  and 

<pre>
<a id="e1d5" name="e1d5">1.5)</a>  Sam gives John the book.
</pre>

  mean two different things because the relative positions of
  ``John'' and ``Sam'' have been switched. 
  <p>Further,</p>

<pre>
<a id="e1d6" name="e1d6">1.6)</a>  The book gives John Sam.
</pre>

  seems strange to us merely because the places are being filled by
  unorthodox arguments. The relationship expressed by ``give'' has
  not changed. 

  <p>In Lojban, each selbri has a specified number and type of
  arguments, known collectively as its ``place structure''. The
  simplest kind of selbri consists of a single root word, called a
  ``gismu'', and the definition in a dictionary gives the place
  structure explicitly. The primary task of constructing a Lojban
  sentence, after choosing the relationship itself, is deciding
  what you will use to fill in the sumti places.</p>

  <p>This book uses the Lojban terms ``bridi'', ``sumti'', and
  ``selbri'', because it is best to come to understand them
  independently of the English associations of the corresponding
  words, which are only roughly similar in meaning anyhow.</p>

  <p>The Lojban examples in this chapter (but not in the rest of
  the book) use a single underline (---) under each sumti, and a
  double underline (===) under each selbri, to help you to tell
  them apart.</p>

  <h3><a id="s2" name="s2">2. Pronunciation</h3>

  <p>Detailed pronunciation and spelling rules are given in 
  <a href="chapter3.html">Chapter 3</a>

  , but what follows will keep the reader from going too far astray
  while digesting this chapter.</p>

  <p>Lojban has six recognized vowels: ``a'', ``e'', ``i'', ``o'',
  ``u'' and ``y''. The first five are roughly pronounced as ``a''
  as in ``father'', ``e'' as in ``let'', ``i'' as in ``machine'',
  ``o'' as in ``dome'' and ``u'' as in ``flute''. ``y'' is
  pronounced as the sound called ``schwa'', that is, as the
  unstressed ``a'' as in ``about'' or ``around''.</p>

  <p>Twelve consonants in Lojban are pronounced more or less as
  their counterparts are in English: ``b'', ``d'', ``f'', ``k'',
  ``l'', ``m'', ``n'', ``p'', ``r'', ``t'', ``v'' and ``z''. The
  letter ``c'', on the other hand is pronounced as the ``sh'' in
  ``hush'', while ``j'' is its voiced counterpart, the sound of the
  ``s'' in ``pleasure''. ``g'' is always pronounced as it is in
  ``gift'', never as in ``giant''. ``s'' is as in ``sell'', never
  as in ``rose''. The sound of ``x'' is not found in English in
  normal words. It is found as ``ch'' in Scottish ``loch'', as
  ``j'' in Spanish ``junta'', and as ``ch'' in German ``Bach''; it
  also appears in the English interjection ``yecchh!''. It gets
  easier to say as you practice it. The letter ``r'' can be
  trilled, but doesn't have to be.</p>

  <p>The Lojban diphthongs ``ai'', ``ei'', ``oi'', and ``au'' are
  pronounced much as in the English words ``sigh'', ``say'',
  ``boy'', and ``how''. Other Lojban diphthongs begin with an ``i''
  pronounced like English ``y'' (for example, ``io'' is pronounced
  ``yo'') or else with a ``u'' pronounced like English ``w'' (for
  example, ``ua'' is pronounced ``wa'').</p>

  <p>Lojban also has three ``semi-letters'': the period, the comma
  and the apostrophe. The period represents a glottal stop or a
  pause; it is a required stoppage of the flow of air in the speech
  stream. The apostrophe sounds just like the English letter ``h''.
  Unlike a regular consonant, it is not found at the beginning or
  end of a word, nor is it found adjacent to a consonant; it is
  only found between two vowels. The comma has no sound associated
  with it, and is used to separate syllables that might ordinarily
  run together. It is not used in this chapter.</p>

  <p>Stress falls on the next to the last syllable of all words,
  unless that vowel is ``y'', which is never stressed; in such
  words the third-to-last syllable is stressed. If a word only has
  one syllable, then that syllable is not stressed.</p>

  <p>All Lojban words are pronounced as they are spelled: there are
  no silent letters.</p>

  <h3><a id="s3" name="s3">3. Words that can act as sumti</h3>

  <p>Here is a short table of single words used as sumti. This
  table provides examples only, not the entire set of such words,
  which may be found in 
  <a href="chapter7.html">Chapter 7</a>

  .</p>

<pre>
   mi  I/me, we/us
    do  you
    ti  this, these
    ta  that, those
    tu  that far away, those far away
    zo'e    unspecified value (used when a sumti is
            unimportant or obvious)
</pre>

  <p>Lojban sumti are not specific as to number (singular or
  plural), nor gender (masculine/feminine/neutral). Such
  distinctions can be optionally added by methods that are beyond
  the scope of this chapter.</p>

  <p>The cmavo ``ti'', ``ta'', and ``tu'' refer to whatever the
  speaker is pointing at, and should not be used to refer to things
  that cannot in principle be pointed at.</p>

  <p>Names may also be used as sumti, provided they are preceded
  with the word ``la'':</p>

<pre>
   la meris.   the one/ones named Mary
    la djan.    the one/ones named John
</pre>

  <p>Other Lojban spelling versions are possible for names from
  other languages, and there are restrictions on which letters may
  appear in Lojban names: see 
  <a href="chapter6.html">Chapter 6</a>

  for more information.</p>

  <h3><a id="s4" name="s4">4. Some words used to indicate selbri relations</h3>

  <p>Here is a short table of some words used as Lojban selbri in
  this chapter:</p>

<pre>
   vecnu   x1 (seller) sells x2 (goods) to x3 (buyer)
            for x4 (price)
    tavla   x1 (talker) talks to x2 (audience)
            about x3 (topic) in language x4
    sutra   x1 (agent) is fast at doing x2 (action)
    blari'o x1 (object/light source) is blue-green
    melbi   x1 (object/idea) is beautiful to x2 (observer)
            by standard x3
    cutci   x1 is a shoe/boot for x2 (foot)
            made of x3 (material)
    bajra   x1 runs on x2 (surface) using x3 (limbs)
            in manner x4 (gait)
    klama   x1 goes/comes to x2 (destination) from
            x3 (origin point) via x4 (route)
            using x5 (means of transportation)
    pluka   x1 pleases/is pleasing to x2 (experiencer)
            under conditions x3
    gerku   x1 is a dog of breed x2
    kurji   x1 takes care of x2
    kanro   x1 is healthy by standard x2
    stali   x1 stays/remains with x2
    zarci   x1 is a market/store/shop selling x2 (products)
            operated by x3 (storekeeper)
</pre>

  Each selbri (relation) has a specific rule that defines the role
  of each sumti in the bridi, based on its position. In the table
  above, that order was expressed by labeling the sumti positions
  as x1, x2, x3, and x4. 
  <p>Like the table in 
  <a href="#s3">Section 3</a>

  , this table is far from complete: in fact, no complete table can
  exist, because Lojban allows new words to be created (in
  specified ways) whenever a speaker or writer finds the existing
  supply of words inadequate. This notion is a basic difference
  between Lojban (and some other languages such as German and
  Chinese) and English; in English, most people are very leery of
  using words that ``aren't in the dictionary''. Lojbanists are
  encouraged to invent new words; doing so is a major way of
  participating in the development of the language. 
  <a href="chapter4.html">Chapter 4</a>

  explains how to make new words, and 
  <a href="chapter12.html">Chapter 12</a>

  explains how to give them appropriate meanings.</p>

  <h3><a id="s5" name="s5">5. Some simple Lojban bridi</h3>

  <p>Let's look at a simple Lojban bridi. The place structure of
  the gismu ``tavla'' is</p>

<pre>
<a id="e5d1" name="e5d1">5.1)</a>  x1 talks to x2 about x3 in language
x4
</pre>

  where the ``x''es with following numbers represent the various
  arguments that could be inserted at the given positions in the
  English sentence. For example: 
  <p>
  </p>

<pre>
<a id="e5d2" name="e5d2">5.2)</a>  John talks to Sam about engineering
in Lojban.
</pre>

  has ``John'' in the x1 place, ``Sam'' in the x2 place,
  ``engineering'' in the x3 place, and ``Lojban'' in the x4 place,
  and could be paraphrased: 
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  Talking is going on,
        with speaker John
        and listener Sam
        and subject matter engineering
        and language Lojban.
</pre>

  <p>The Lojban bridi corresponding to 
  <a href="#e5d1">Example 5.1</a>

  will have the form</p>

  <p>
  </p>

<pre>
<a id="e5d4" name="e5d4">5.4)</a>  x1 [cu] tavla x2 x3 x4
    --      ===== -- -- --
</pre>

  The word ``cu'' serves as a separator between any preceding sumti
  and the selbri. It can often be omitted, as in the following
  examples. 
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  mi tavla do zo'e zo'e
    -- ===== -- ---- ----
    I talk to you about something in some language.

<a id="e5d6" name="e5d6">5.6)</a>   do tavla mi ta zo'e
    -- ===== -- -- ----
    You talk to me about that thing in a language.

<a id="e5d7" name="e5d7">5.7)</a>   mi tavla zo'e tu ti
    -- ===== ---- -- --
    I talk to someone about that thing yonder
        in this language.
</pre>

  (
  <a href="#e5d7">Example 5.7</a>

  is a bit unusual, as there is no easy way to point to a language;
  one might point to a copy of this book, and hope the meaning gets
  across!) 
  <p>When there are one or more occurrences of the cmavo ``zo'e''
  at the end of a bridi, they may be omitted, a process called
  ``ellipsis''. 
  <a href="#e5d5">Example 5.5</a>

  and 
  <a href="#e5d6">Example 5.6</a>

  may be expressed thus:</p>

<pre>
<a id="e5d8" name="e5d8">5.8)</a>  mi tavla do
    -- ===== --
    I talk to you (about something in some language).

<a id="e5d9" name="e5d9">5.9)</a>   do tavla mi ta
    -- ===== -- --
    You talk to me about that thing (in some language).
</pre>

  <p>Note that 
  <a href="#e5d7">Example 5.7</a>

  is not subject to ellipsis by this direct method, as the ``zo'e''
  in it is not at the end of the bridi.</p>

  <h3><a id="s6" name="s6">6. Variant bridi structure</h3>

  <p>Consider the sentence</p>

<pre>
<a id="e6d1" name="e6d1">6.1)</a>  mi       [cu] vecnu  ti           
ta       zo'e
    --            =====  --            --       ----
    seller-x1     sells  goods-sold-x2 buyer-x3 price-x4
    I             sell   this          to that  for some price.
    I sell this-thing/these-things to that-buyer/those-buyers.
    (The price is obvious or unimportant.)
</pre>

  <a href="#e6d1">Example 6.1</a>

  has one sumti (the x1) before the selbri. It is also possible to
  put more than one sumti before the selbri, without changing the
  order of sumti: 
<pre>
<a id="e6d2" name="e6d2">6.2)</a>  mi        ti           [cu] vecnu ta
    --        --                ===== --
    seller-x1 goods-sold-x2     sells buyer-x3
    I         this              sell  to that.
    (translates as stilted or poetic English)
    I this thing do sell to that buyer.

<a id="e6d3" name="e6d3">6.3)</a>   mi        ti            ta      
[cu] vecnu
    --        --            --            =====
    seller-x1 goods-sold-x2 buyer-x3      sells
    I         this          to-that       sell.
    (translates as stilted or poetic English)
    I this thing to that buyer do sell.
</pre>

  <a href="#e6d1">Examples 6.1</a>

  through 
  <a href="#e6d3">6.3</a>

  mean the same thing. Usually, placing more than one sumti before
  the selbri is done for style or for emphasis on the sumti that
  are out-of-place from their normal position. (Native speakers of
  languages other than English may prefer such orders.) 
  <p>If there are no sumti before the selbri, then it is understood
  that the x1 sumti value is equivalent to ``zo'e''; i.e.
  unimportant or obvious, and therefore not given. Any sumti after
  the selbri start counting from x2.</p>

<pre>
<a id="e6d4" name="e6d4">6.4)</a>  ta            [cu] melbi
    --                 =====
    object/idea-x1     is-beautiful
        (to someone by some standard)
    That/Those         is/are beautiful.
    That is beautiful.
    Those are beautiful.
</pre>

  when the x1 is omitted, becomes: 
<pre>
<a id="e6d5" name="e6d5">6.5)</a>                 melbi
    -------------- =====
    unspecified-x1 is-beautiful
        (to someone by some standard)
    Beautiful!
    It's beautiful!
</pre>

  <p>Omitting the x1 adds emphasis to the selbri relation, which
  has become first in the sentence. This kind of sentence is termed
  an observative, because it is often used when someone first
  observes or takes note of the relationship, and wishes to quickly
  communicate it to someone else. Commonly understood English
  observatives include ``Smoke!'' upon seeing smoke or smelling the
  odor, or ``Car!'' to a person crossing the street who might be in
  danger. Any Lojban selbri can be used as an observative if no
  sumti appear before the selbri.</p>

  <p>The word ``cu'' does not occur in an observative; ``cu'' is a
  separator, and there must be a sumti before the selbri that needs
  to be kept separate for ``cu'' to be used. With no sumti
  preceding the selbri, ``cu'' is not permitted. Short words like
  ``cu'' which serve grammatical functions are called ``cmavo'' in
  Lojban.</p>

  <h3><a id="s7" name="s7">7. Varying the order of sumti</h3>

  <p>For one reason or another you may want to change the order,
  placing one particular sumti at the front of the bridi. The cmavo
  ``se'', when placed before the last word of the selbri, will
  switch the meanings of the first and second sumti places. So</p>

<pre>
<a id="e7d1" name="e7d1">7.1)</a>  mi tavla do ti
    -- ===== -- --
    I talk to you about this.
</pre>

  has the same meaning as 
<pre>
<a id="e7d2" name="e7d2">7.2)</a>  do se tavla mi ti
    -- ======== -- --
    You are talked to by me about this.
</pre>

  The cmavo ``te'', when used in the same location, switches the
  meanings of the first and the third sumti places. 
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  mi tavla do ti
    -- ===== -- --
    I talk to you about this.
</pre>

  has the same meaning as 
<pre>
<a id="e7d4" name="e7d4">7.4)</a>  ti te tavla do mi
    -- ======== -- --
    This is talked about to you by me.
</pre>

  <p>Note that only the first and third sumti have switched places;
  the second sumti has remained in the second place.</p>

  <p>The cmavo ``ve'' and ``xe'' switch the first and fourth sumti
  places, and the first and fifth sumti places, respectively. These
  changes in the order of places are known as ``conversions'', and
  the ``se'', ``te'', ``ve'', and ``xe'' cmavo are said to convert
  the selbri.</p>

  <p>More than one of these operators may be used on a given selbri
  at one time, and in such a case they are evaluated from left to
  right. However, in practice they are used one at a time, as there
  are better tools for complex manipulation of the sumti places.
  See 
  <a href="chapter5.html">Chapter 5</a>

  for details.</p>

  <p>The effect is similar to what in English is called the
  ``passive voice''. In Lojban, the converted selbri has a new
  place structure that is renumbered to reflect the place reversal,
  thus having effects when such a conversion is used in combination
  with other constructs such as ``le selbri [ku]'' (see 
  <a href="#s10">Section 10</a>

  ).</p>

  <h3><a id="s8" name="s8">8. The basic structure of longer utterances</h3>

  <p>People don't always say just one sentence. Lojban has a
  specific structure for talk or writing that is longer than one
  sentence. The entirety of a given speech event or written text is
  called an utterance. The sentences (usually, but not always,
  bridi) in an utterance are separated by the cmavo ``ni'o'' and
  ``.i''. These correspond to a brief pause (or nothing at all) in
  spoken English, and the various punctuation marks like period,
  question mark, and exclamation mark in written English. These
  separators prevent the sumti at the beginning of the next
  sentence from being mistaken for a trailing sumti of the previous
  sentence.</p>

  <p>The cmavo ``ni'o'' separates paragraphs (covering different
  topics of discussion). In a long text or utterance, the topical
  structure of the text may be indicated by multiple ``ni'o''s,
  with perhaps ``ni'oni'oni'o'' used to indicate a chapter,
  ``ni'oni'o'' to indicate a section, and a single ``ni'o'' to
  indicate a subtopic corresponding to a single English
  paragraph.</p>

  <p>The cmavo ``.i'' separates sentences. It is sometimes
  compounded with words that modify the exact meaning (the
  semantics) of the sentence in the context of the utterance. (The
  cmavo ``xu'', discussed in 
  <a href="#s1">Section 1</a>

  .7, is one such word --- it turns the sentence from a statement
  to a question about truth.) When more than one person is talking,
  a new speaker will usually omit the ``.i'' even though she/he may
  be continuing on the same topic.</p>

  <p>It is still O.K. for a new speaker to say the ``.i'' before
  continuing; indeed, it is encouraged for maximum clarity (since
  it is possible that the second speaker might merely be adding
  words onto the end of the first speaker's sentence). A good
  translation for ``.i'' is the ``and'' used in run-on sentences
  when people are talking informally: ``I did this, and then I did
  that, and ..., and ...''.</p>

  <h3><a id="s9" name="s9">9. tanru</h3>

  <p>When two gismu are adjacent, the first one modifies the
  second, and the selbri takes its place structure from the
  rightmost word. Such combinations of gismu are called ``tanru''.
  For example,</p>

<pre>
<a id="e9d1" name="e9d1">9.1)</a>  sutra tavla
</pre>

  has the place structure 
  <p>
  </p>

<pre>
<a id="e9d2" name="e9d2">9.2)</a>  x1 is a fast type-of talker to x2
about x3
        in language x4
    x1 talks fast to x2 about x3 in language x4
</pre>

  When three or more gismu are in a row, the first modifies the
  second, and that combined meaning modifies the third, and that
  combined meaning modifies the fourth, and so on. For example 
  <p>
  </p>

<pre>
<a id="e9d3" name="e9d3">9.3)</a>  sutra tavla cutci
</pre>

  has the place structure 
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  s1 is a fast-talker type of shoe
        worn by s2 of material s3
</pre>

  <p>That is, it is a shoe that is worn by a fast talker rather
  than a shoe that is fast and is also worn by a talker.</p>

  <p>Note especially the use of ``type-of'' as a mechanism for
  connecting the English translations of the two or more gismu;
  this convention helps the learner understand each tanru in its
  context. Creative interpretations are also possible, however:</p>

  <p>
  </p>

<pre>
<a id="e9d5" name="e9d5">9.5)</a>  bajra cutci
    runner shoe
</pre>

  most probably refers to shoes suitable for runners, but might be
  interpreted in some imaginative instances as ``shoes that run (by
  themselves?)''. In general, however, the meaning of a tanru is
  determined by the literal meaning of its components, and not by
  any connotations or figurative meanings. Thus 
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  sutra tavla
    fast-talker
</pre>

  would not necessarily imply any trickery or deception, unlike the
  English idiom, and a 
  <p>
  </p>

<pre>
<a id="e9d7" name="e9d7">9.7)</a>  jikca toldi
    social butterfly
</pre>

  must always be an insect with large brightly-colored wings, of
  the family 
  <i>Lepidoptera</i>

  . 
  <p>The place structure of a tanru is always that of the final
  component of the tanru. Thus, the following has the place
  structure of ``klama'':</p>

<pre>
<a id="e9d8" name="e9d8">9.8)</a>  mi [cu] sutra klama la meris.
    --      =========== ---------
    I quickly-go to Mary.
</pre>

  With the conversion ``se klama'' as the final component of the
  tanru, the place structure of the entire selbri is that of ``se
  klama'': the x1 place is the destination, and the x2 place is the
  one who goes: 
<pre>
<a id="e9d9" name="e9d9">9.9)</a>  mi [cu] sutra se klama la meris.
    --      ============== ---------
    I quickly am-gone-to by Mary.
</pre>

  The following example shows that there is more to conversion than
  merely switching places, though: 
<pre>
<a id="e9d10" name="e9d10">9.10)</a>    la tam. [cu] melbi tavla la
meris.
    -------      =========== ---------
    Tom beautifully-talks to Mary.
    Tom is a beautiful-talker to Mary.
</pre>

  has the place structure of ``tavla'', but note the two distinct
  interpretations. 
  <p>Now, using conversion, we can modify the place structure
  order:</p>

<pre>
<a id="e9d11" name="e9d11">9.11)</a>    la meris. [cu] melbi se tavla
la tam.
    ---------      ============== -------
    Mary is beautifully-talked-to by Tom.
    Mary is a beautiful-audience for Tom.
</pre>

  and we see that the modification has been changed so as to focus
  on Mary's role in the bridi relationship, leading to a different
  set of possible interpretations. 
  <p>Note that there is no place structure change if the modifying
  term is converted, and so less drastic variation in possible
  meanings:</p>

<pre>
<a id="e9d12" name="e9d12">9.12)</a>    la tam. [cu] tavla melbi la
meris.
    -------      =========== ---------
    Tom is talkerly-beautiful to Mary.

<a id="e9d13" name="e9d13">9.13)</a> la tam. [cu] se tavla melbi la
meris.
    -------      ============== ---------
    Tom is audiencely-beautiful to Mary.
</pre>

  and we see that the manner in which Tom is seen as beautiful by
  Mary changes, but Tom is still the one perceived as beautiful,
  and Mary, the observer of beauty. 
  <h3><a id="s10" name="s10">10. Description sumti</h3>

  <p>Often we wish to talk about things other than the speaker, the
  listener and things we can point to. Let's say I want to talk
  about a talker other than ``mi''. What I want to talk about would
  naturally fit into the first place of ``tavla''. Lojban, it turns
  out, has an operator that pulls this first place out of a selbri
  and converts it to a sumti called a ``description sumti''. The
  description sumti ``le tavla ku'' means ``the talker'', and may
  be used wherever any sumti may be used.</p>

  <p>For example,</p>

<pre>
<a id="e10d1" name="e10d1">10.1)</a>    mi tavla do le tavla ku
    -- ===== -- -----------
</pre>

  means the same as 
<pre>
<a id="e10d2" name="e10d2">10.2)</a>    I talk to you about the talker
</pre>

  where ``the talker'' is presumably someone other than me, though
  not necessarily. 
  <p>Similarly ``le sutra tavla ku'' is ``the fast talker'', and
  ``le sutra te tavla ku'' is ``the fast subject of talk'' or ``the
  subject of fast talk''. Which of these related meanings is
  understood will depend on the context in which the expression is
  used. The most plausible interpretation within the context will
  generally be assumed by a listener to be the intended one.</p>

  <p>In many cases the word ``ku'' may be omitted. In particular,
  it is never necessary in a description at the end of a sentence,
  so:</p>

<pre>
<a id="e10d3" name="e10d3">10.3)</a>    mi tavla   do  le tavla ku
    -- =====   --  -----------
    I  talk-to you about-the talker
</pre>

  means exactly the same thing as 
  <a href="#e10d1">Example 10.1</a>

  . 
  <p>There is a problem when we want to say ``The fast one is
  talking.'' The ``obvious'' translation ``le sutra tavla'' turns
  out to mean ``the fast talker'', and has no selbri at all. To
  solve this problem we can use the word ``cu'', which so far has
  always been optional, in front of the selbri.</p>

  <p>The word ``cu'' has no meaning, and exists only to mark the
  beginning of the selbri within the bridi, separating it from a
  previous sumti. It comes before any other part of the selbri,
  including other cmavo like ``se'' or ``te''. Thus:</p>

<pre>
<a id="e10d4" name="e10d4">10.4)</a>    le sutra tavla
    --------------
    The fast talker

<a id="e10d5" name="e10d5">10.5)</a> le sutra cu tavla
    --------    =====
    The fast one is talking.

<a id="e10d6" name="e10d6">10.6)</a> le sutra se tavla
    -----------------
    The fast talked-to one

<a id="e10d7" name="e10d7">10.7)</a> le sutra cu se tavla
    --------    ========
    The fast one is talked to.
</pre>

  Consider the following more complex example, with two description
  sumti. 
  <p>
  </p>

<pre>
<a id="e10d8" name="e10d8">10.8)</a>    mi [cu] tavla   le vecnu [ku]
le blari'o [ku]
    --      =====   ------------- ---------------
    I       talk-to the seller    about the blue-green-thing.
</pre>

  <p>The sumti ``le vecnu'' contains the selbri ``vecnu'', which
  has the ``seller'' in the x1 place, and uses it in this sentence
  to describe a particular ``seller'' that the speaker has in mind
  (one that he or she probably expects the listener will also know
  about). Similarly, the speaker has a particular blue-green thing
  in mind, which is described using ``le'' to mark ``blari'o'', a
  selbri whose first sumti is something blue-green.</p>

  <p>It is safe to omit both occurrences of ``ku'' in 
  <a href="#e10d8">Example 10.8</a>

  , and it is also safe to omit the ``cu''.</p>

  <h3><a id="s11" name="s11">11. Examples of brivla</h3>

  <p>The simplest form of selbri is an individual word. A word
  which may by itself express a selbri relation is called a
  ``brivla''. The three types of brivla are gismu (root words),
  lujvo (compounds), and fu'ivla (borrowings from other languages).
  All have identical grammatical uses. So far, most of our selbri
  have been gismu or tanru built from gismu.</p>

  <p>gismu:</p>

<pre>
<a id="e11d1" name="e11d1">11.1)</a>    mi   [cu] klama ti         
zo'e   zo'e  ta
    --        ===== --          ----   ----  --
    Go-er     goes  destination origin route means.
    I go here (to this) using that means
        (from somewhere via some route).
</pre>

  lujvo: 
<pre>
<a id="e11d2" name="e11d2">11.2)</a>    ta  [cu] blari'o
    --       =======
    That    is-blue-green.
</pre>

  fu'ivla: 
<pre>
<a id="e11d3" name="e11d3">11.3)</a>    ti  [cu] djarspageti
    --       ===========
    This     is-spaghetti.
</pre>

  Some cmavo may also serve as selbri, acting as variables that
  stand for another selbri. The most commonly used of these is
  ``go'i'', which represents the main bridi of the previous Lojban
  sentence, with any new sumti or other sentence features being
  expressed replacing the previously expressed ones. Thus, in this
  context: 
  <p>
  </p>

<pre>
<a id="e11d4" name="e11d4">11.4)</a>    ta  [cu] go'i
    --       ====
    That     too/same-as-last selbri.
    That (is spaghetti), too.
</pre>

  <h3><a id="s12" name="s12">12. The sumti ``di'u'' and ``la'e di'u''</h3>

  <p>In English, I might say ``The dog is beautiful'', and you
  might reply ``This pleases me.'' How do you know what ``this''
  refers to? Lojban uses different expressions to convey the
  possible meanings of the English:</p>

  <p>
  </p>

<pre>
<a id="e12d1" name="e12d1">12.1)</a>    le gerku [ku] cu melbi
    -------------    =====
    The dog is beautiful.
</pre>

  <p>The following three sentences all might translate as ``This
  pleases me.''</p>

  <p>
  </p>

<pre>
<a id="e12d2" name="e12d2">12.2)</a>    ti [cu] pluka mi
    --      ===== --
    This (the dog) pleases me.
</pre>

<pre>
<a id="e12d3" name="e12d3">12.3)</a>    di'u [cu] pluka mi
    ----      ===== --
    This (the last sentence) pleases me
    (perhaps because it is grammatical or sounds nice).
</pre>

<pre>
<a id="e12d4" name="e12d4">12.4)</a>    la'e di'u [cu] pluka mi
    ---------      =====
    This (the meaning of the last sentence; i.e. that
    the dog is beautiful) pleases me.
</pre>

  <a href="#e12d4">Example 12.4</a>

  uses one sumti to point to or refer to another by inference. It
  is common to write ``la'edi'u'' as a single word; it is used more
  often than ``di'u'' by itself. 
  <h3><a id="s13" name="s13">13. Possession</h3>

  <p>``Possession'' refers to the concept of specifying an object
  by saying who it belongs to (or with). A full explanation of
  Lojban possession is given in 
  <a href="chapter8.html">Chapter 8</a>

  . A simple means of expressing possession, however, is to place a
  sumti representing the possessor of an object within the
  description sumti that refers to the object: specifically,
  between the ``le'' and the selbri of the description:</p>

  <p>
  </p>

<pre>
<a id="e13d1" name="e13d1">13.1)</a>    le mi gerku cu sutra
    -----------    =====
    The of-me dog is fast.
    My dog is fast.
</pre>

  In Lojban, possession doesn't necessarily mean ownership: one may
  ``possess'' a chair simply by sitting on it, even though it
  actually belongs to someone else. English uses possession
  casually in the same way, but also uses it to refer to actual
  ownership or even more intimate relationships: ``my arm'' doesn't
  mean ``some arm I own'' but rather ``the arm that is part of my
  body''. Lojban has methods of specifying all these different
  kinds of possession precisely and easily. 
  <h3><a id="s14" name="s14">14. Vocatives and commands</h3>

  <p>You may call someone's attention to the fact that you are
  addressing them by using ``doi'' followed by their name. The
  sentence</p>

<pre>
<a id="e14d1" name="e14d1">14.1)</a>    doi djan.
</pre>

  means ``Oh, John, I'm talking to you''. It also has the effect of
  setting the value of ``do''; ``do'' now refers to ``John'' until
  it is changed in some way in the conversation. Note that 
  <a href="#e14d1">Example 14.1</a>

  is not a bridi, but it is a legitimate Lojban sentence
  nevertheless; it is known as a ``vocative phrase''. 
  <p>Other cmavo can be used instead of ``doi'' in a vocative
  phrase, with a different significance. For example, the cmavo
  ``coi'' means ``hello'' and ``co'o'' means ``good-bye''. Either
  word may stand alone, they may follow one another, or either may
  be followed by a pause and a name. (Vocative phrases with ``doi''
  do not need a pause before the name.)</p>

<pre>
<a id="e14d2" name="e14d2">14.2)</a>    coi. djan.
    Hello, John.

<a id="e14d3" name="e14d3">14.3)</a> co'o. djan.
    Good-bye, John.
</pre>

  Commands are expressed in Lojban by a simple variation of the
  main bridi structure. If you say 
<pre>
<a id="e14d4" name="e14d4">14.4)</a>    do tavla
    -- =====
    You are-talking.
</pre>

  you are simply making a statement of fact. In order to issue a
  command in Lojban, substitute the word ``ko'' for ``do''. The
  bridi 
  <p>
  </p>

<pre>
<a id="e14d5" name="e14d5">14.5)</a>    ko tavla
    -- =====
</pre>

  instructs the listener to do whatever is necessary to make 
  <a href="#e14d4">Example 14.4</a>

  true; it means ``Talk!'' Other examples: 
<pre>
<a id="e14d6" name="e14d6">14.6)</a>    ko sutra
    -- =====
    Be fast!
</pre>

  <p>The ``ko'' need not be in the x1 place, but rather can occur
  anywhere a sumti is allowed, leading to possible Lojban commands
  that are very unlike English commands:</p>

<pre>
<a id="e14d7" name="e14d7">14.7)</a>    mi tavla ko
    -- ===== --
    Be talked to by me
    Let me talk to you.
</pre>

  <p>The cmavo ``ko'' can fill any appropriate sumti place, and can
  be used as often as is appropriate for the selbri:</p>

<pre>
<a id="e14d8" name="e14d8">14.8)</a>    ko kurji ko
    -- ===== --
</pre>

  and 
  <p>
  </p>

<pre>
<a id="e14d9" name="e14d9">14.9)</a>    ko ko kurji
    -- -- =====
</pre>

  both mean ``You take care of you'' and ``Be taken care of by
  you'', or to put it colloquially, ``Take care of yourself''. 
  <h3><a id="s15" name="s15">15. Questions</h3>

  <p>There are many kinds of questions in Lojban: full explanations
  appear in 
  <a href="chapter19.html">Chapter 19</a>

  and in various other chapters throughout the book. In this
  chapter, we will introduce three kinds: sumti questions, selbri
  questions, and yes/no questions.</p>

  <p>The cmavo ``ma'' is used to create a sumti question: it
  indicates that the speaker wishes to know the sumti which should
  be placed at the location of the ``ma'' to make the bridi true.
  It can be translated as ``Who?'' or ``What?'' in most cases, but
  also serves for ``When?'', ``Where?'', and ``Why?'' when used in
  sumti places that express time, location, or cause. For
  example:</p>

  <p>
  </p>

<pre>
<a id="e15d1" name="e15d1">15.1)</a>    ma   tavla do     mi
    --   ===== --     --
    Who? talks to-you about-me.
    Who is talking to you about me?
</pre>

  <p>The listener can reply by simply stating a sumti:</p>

<pre>
<a id="e15d2" name="e15d2">15.2)</a>    la djan.
    --------
    John (is talking to you about me).
</pre>

  <p>Like ``ko'', ``ma'' can occur in any position where a sumti is
  allowed, not just in the first position:</p>

<pre>
<a id="e15d3" name="e15d3">15.3)</a>    do [cu] tavla   ma
    --      =====   --
    You     talk to what/whom?
</pre>

  <p>A ``ma'' can also appear in multiple sumti positions in one
  sentence, in effect asking several questions at once.</p>

<pre>
<a id="e15d4" name="e15d4">15.4)</a>    ma [cu]  tavla    ma
    --       =====    --
    What/Who talks to what/whom?
</pre>

  The two separate ``ma'' positions ask two separate questions, and
  can therefore be answered with different values in each sumti
  place. 
  <p>The cmavo ``mo'' is the selbri analogue of ``ma''. It asks the
  respondent to provide a selbri that would be a true relation if
  inserted in place of the ``mo'':</p>

<pre>
<a id="e15d5" name="e15d5">15.5)</a>    do [cu] mo
    --      ==
    You are-what/do-what?
</pre>

  <p>A ``mo'' may be used anywhere a brivla or other selbri might.
  Keep this in mind for later examples. Unfortunately, by itself,
  ``mo'' is a very non-specific question. The response to the
  question in 
  <a href="#e15d5">Example 15.5</a>

  could be:</p>

<pre>
<a id="e15d6" name="e15d6">15.6)</a>    mi [cu] melbi
    --      =====
    I am beautiful.
</pre>

  or: 
<pre>
<a id="e15d7" name="e15d7">15.7)</a>    mi [cu] tavla
    --      =====
    I talk.
</pre>

  Clearly, ``mo'' requires some cooperation between the speaker and
  the respondent to ensure that the right question is being
  answered. If context doesn't make the question specific enough,
  the speaker must ask the question more specifically using a more
  complex construction such as a tanru (see 
  <a href="#s9">Section 9</a>

  ). 
  <p>It is perfectly permissible for the respondent to fill in
  other unspecified places in responding to a ``mo'' question.
  Thus, the respondent in 
  <a href="#e15d7">Example 15.7</a>

  could have also specified an audience, a topic, and/or a language
  in the response.</p>

  <p>Finally, we must consider questions that can be answered
  ``Yes'' or ``No'', such as</p>

<pre>
<a id="e15d8" name="e15d8">15.8)</a>    Are you talking to me?
</pre>

  <p>Like all yes-or-no questions in English, 
  <a href="#e15d8">Example 15.8</a>

  may be reformulated as</p>

<pre>
<a id="e15d9" name="e15d9">15.9)</a>    Is it true that you are talking
to me?
</pre>

  In Lojban we have a word that asks precisely that question in
  precisely the same way. The cmavo ``xu'', when placed in front of
  a bridi, asks whether that bridi is true as stated. So 
<pre>
<a id="e15d10" name="e15d10">15.10)</a>  xu              do  tavla     
 mi
                    --  =====       --
    Is-it-true-that you are-talking to-me?
</pre>

  is the Lojban translation of 
  <a href="#e15d8">Example 15.8</a>

  . 
  <p>The answer ``Yes'' may be given by simply restating the bridi
  without the ``xu'' question word. Lojban has a shorthand for
  doing this with the word ``go'i'', mentioned in 
  <a href="#s11">Section 11</a>

  . Instead of a negative answer, the bridi may be restated in such
  a way as to make it true. If this can be done by substituting
  sumti, it may be done with ``go'i'' as well. For example:</p>

  <p>
  </p>

<pre>
<a id="e15d11" name="e15d11">15.11)</a>  xu do kanro
       -- =====
    Are you healthy?
</pre>

  can be answered with 
<pre>
<a id="e15d12" name="e15d12">15.12)</a>  mi kanro
    -- =====
    I am healthy.
</pre>

  or 
<pre>
<a id="e15d13" name="e15d13">15.13)</a>  go'i
    ====
    I am healthy.
</pre>

  (Note that ``do'' to the questioner is ``mi'' to the respondent.)
  
  <p>or</p>

<pre>
<a id="e15d14" name="e15d14">15.14)</a>  le tavla cu kanro
    --------    =====
    The talker is healthy.
</pre>

  or 
<pre>
<a id="e15d15" name="e15d15">15.15)</a>  le tavla cu go'i
    --------    ====
    The talker is healthy.
</pre>

  A general negative answer may be given by ``na go'i''. ``na'' may
  be placed before any selbri (but after the ``cu''). It is
  equivalent to stating ``It is not true that ...'' before the
  bridi. It does not imply that anything else is true or untrue,
  only that that specific bridi is not true. More details on
  negative statements are available in 
  <a href="chapter15.html">Chapter 15</a>

  . 
  <h3><a id="s16" name="s16">16. Indicators</h3>

  <p>Different cultures express emotions and attitudes with a
  variety of intonations and gestures that are not usually included
  in written language. Some of these are available in some
  languages as interjections (i.e. Aha!, Oh no!, Ouch!, Aahh!,
  etc.), but they vary greatly from culture to culture.</p>

  <p>Lojban has a group of cmavo known as ``attitudinal
  indicators'' which specifically covers this type of commentary on
  spoken statements. They are both written and spoken, but require
  no specific intonation or gestures. Grammatically they are very
  simple: one or more attitudinals at the beginning of a bridi
  apply to the entire bridi; anywhere else in the bridi they apply
  to the word immediately to the left. For example:</p>

  <p>
  </p>

<pre>
<a id="e16d1" name="e16d1">16.1)</a>    .ie mi [cu] klama
        --      =====
    Agreement! I go.
    Yep! I'll go.

<a id="e16d2" name="e16d2">16.2)</a> .ei mi [cu] klama
        --      =====
    Obligation! I go.
    I should go.

<a id="e16d3" name="e16d3">16.3)</a> mi [cu] klama le melbi .ui [ku]
    --      ===== --------(   )---
    I go to the beautiful-thing
        (and I am happy because it is the beautiful
        thing I'm going to).
</pre>

  Not all indicators indicate attitudes. Discursives, another group
  of cmavo with the same grammatical rules as attitudinal
  indicators, allow free expression of certain kinds of commentary
  about the main utterances. Using discursives allows a clear
  separation of these so-called ``metalinguistic'' features from
  the underlying statements and logical structure. By comparison,
  the English words ``but'' and ``also'', which discursively
  indicate contrast or an added weight of example, are logically
  equivalent to ``and'', which does not have a discursive content.
  The average English-speaker does not think about, and may not
  even realize, the paradoxical idea that ``but'' basically means
  ``and''. 
<pre>
<a id="e16d4" name="e16d4">16.4)</a>    mi [cu] klama .i do [cu] stali
    --      =====    --      =====
    I go.  You stay.

<a id="e16d5" name="e16d5">16.5)</a> mi [cu] klama .i ji'a do [cu]
stali
    --      =====         --      =====
    I go.  In addition, you stay.  (added weight)

<a id="e16d6" name="e16d6">16.6)</a> mi [cu] klama .i ku'i do [cu]
stali
    --      =====         --      =====
    I go.  However, you stay.  (contrast)
</pre>

  Another group of indicators are called ``evidentials''.
  Evidentials show the speaker's relationship to the statement,
  specifically how the speaker came to make the statement. These
  include ``za'a'' (I directly observe the relationship), ``pe'i''
  (I believe that the relationship holds), ``ru'a'' (I postulate
  the relationship), and others. Many American Indian languages use
  this kind of words. 
<pre>
<a id="e16d7" name="e16d7">16.7)</a>    pe'i do [cu] melbi
    --           =====
    I opine!  You are beautiful.

<a id="e16d8" name="e16d8">16.8)</a> za'a do [cu] melbi
    --           =====
    I directly observe!  You are beautiful.
</pre>

  <h3><a id="s17" name="s17">17. Tenses</h3>

  <p>In English, every verb is tagged for the grammatical category
  called tense: past, present, or future. The sentence</p>

<pre>
<a id="e17d1" name="e17d1">17.1)</a>    John went to the store
</pre>

  necessarily happens at some time in the past, whereas 
<pre>
<a id="e17d2" name="e17d2">17.2)</a>    John is going to the store
</pre>

  is necessarily happening right now. 
  <p>The Lojban sentence</p>

<pre>
<a id="e17d3" name="e17d3">17.3)</a>    la djan.  [cu] klama         le
zarci
    --------  ==========         --------
    John      goes/went/will   go to-the store
</pre>

  serves as a translation of either 
  <a href="#e17d1">Example 17.1</a>

  or 
  <a href="#e17d2">Example 17.2</a>

  , and of many other possible English sentences as well. it is not
  marked for tense, and can refer to an event in the past, the
  present or the future. This rule does not mean that Lojban has no
  way of representing the time of an event. A close translation of 
  <a href="#e17d1">Example 17.1</a>

  would be: 
<pre>
<a id="e17d4" name="e17d4">17.4)</a>    la djan.   pu klama    le zarci
    --------   ========    --------
    John       [past] goes to-the store
</pre>

  where the tag ``pu'' forces the sentence to refer to a time in
  the past. Similarly, 
<pre>
<a id="e17d5" name="e17d5">17.5)</a>    la djan.   ca klama       le
zarci
    --------   ========       --------
    John       [present] goes to-the store
</pre>

  necessarily refers to the present, because of the tag ``ca''.
  Tags used in this way always appear at the very beginning of the
  selbri, just after the ``cu'', and they may make a ``cu''
  unnecessary, since tags cannot be absorbed into tanru. Note that 
  <a href="#e17d3">Example 17.3</a>

  has and requires a ``cu'' to prevent ``bajra'' and ``klama'' from
  forming a tanru, but 
  <a href="#e17d4">Example 17.4</a>

  and 
  <a href="#e17d5">Example 17.5</a>

  lack the unnecessary ``cu''. Such tags serve as an equivalent to
  English tenses and adverbs. In Lojban, tense information is
  completely optional. If unspecified, the appropriate tense is
  picked up from context. 
  <p>Lojban also extends the notion of ``tense'' to refer not only
  to time but to space. The following example uses the tag ``vu''
  to specify that the event it describes happens far away from the
  speaker:</p>

<pre>
<a id="e17d6" name="e17d6">17.6)</a>    do [cu] vu vecnu    zo'e
    --      ========
    You     yonder sell something-unspecified.
</pre>

  <p>In addition, tense tags (either for time or space) can be
  prefixed to the selbri of a description, producing a tensed
  sumti:</p>

<pre>
<a id="e17d7" name="e17d7">17.7)</a>    le pu bajra [ku] cu           
tavla
    ----------------               =====
    The earlier/former/past runner talked/talks.
</pre>

  (Since Lojban tense is optional, we don't know when he or she
  talks.) 
  <p>Tensed sumti with space tags correspond roughly to the English
  use of ``this'' or ``that'' as adjectives, as in the following
  example, which uses the tag ``vi'' meaning ``nearby'':</p>

  <p>
  </p>

<pre>
<a id="e17d8" name="e17d8">17.8)</a>    le vi bajra [ku]   cu tavla
    ----------------      =====
    The nearby runner     talks.
    This runner talks.
</pre>

  <p>Do not confuse the use of ``vi'' in 
  <a href="#e17d8">Example 17.8</a>

  with the cmavo ``ti'', which also means ``this'', but in the
  sense of ``this thing''.</p>

  <p>Furthermore, a tense tag can appear both on the selbri and
  within a description, as in the following example (where ``ba''
  is the tag for future time):</p>

<pre>
<a id="e17d9" name="e17d9">17.9)</a>    le vi tavla [ku] cu ba klama
    ----------------    ========
    The here talker     [future] goes.
    The talker who is here will go
    This talker will go.
</pre>

  <h3><a id="s18" name="s18">18. Lojban grammatical terms</h3>

  <p>Here is a review of the Lojban grammatical terms used in this
  chapter, plus some others used throughout this book. Only terms
  that are themselves Lojban words are included: there are of
  course many expressions like ``indicator'' in 
  <a href="chapter16.html">Chapter 16</a>

  that are not explained here. See the Index for further help with
  these.</p>

  <p>
  </p>

  <dl>
    <dt>bridi:</dt>

    <dd>predication; the basic unit of Lojban expression; the main
    kind of Lojban sentence; a claim that some objects stand in
    some relationship, or that some single object has some
    property.</dd>
    <dt>sumti:</dt>

    <dd>argument; words identifying something which stands in a
    specified relationship to something else, or which has a
    specified property. See 
    <a href="chapter6.html">Chapter 6</a>

    .</dd>

    <dt>selbri:</dt>

    <dd>logical predicate; the core of a bridi; the word or words
    specifying the relationship between the objects referred to by
    the sumti. See 
    <a href="chapter5.html">Chapter 5</a>

    .</dd>
  
    <dt>cmavo:</dt>

    <dd>one of the Lojban parts of speech; a short word; a
    structural word; a word used for its grammatical function.</dd>
 


    <dt>brivla:</dt>

    <dd>one of the Lojban parts of speech; a content word; a
    predicate word; can function as a selbri; is a gismu, a lujvo,
    or a fu'ivla. See 
    <a href="chapter4.html">Chapter 4</a>

    .</dd>
  

 
    <dt>gismu:</dt>

    <dd>a root word; a kind of brivla; has associated rafsi. See 
    <a href="chapter4.html">Chapter 4</a>

    .</dd>
  

 
    <dt>lujvo:</dt>

    <dd>a compound word; a kind of brivla; may or may not appear in
    a dictionary; does not have associated rafsi. See 
    <a href="chapter4.html">Chapter 4</a>

    and 
    <a href="chapter12.html">Chapter 12</a>

    .</dd>
  

 
    <dt>fu'ivla:</dt>

    <dd>a borrowed word; a kind of brivla; may or may not appear in
    a dictionary; copied in a modified form from some non-Lojban
    language; usually refers to some aspect of culture or the
    natural world; does not have associated rafsi. See 
    <a href="chapter4.html">Chapter 4</a>

    .</dd>
 

  
    <dt>rafsi:</dt>

    <dd>a word fragment; one or more is associated with each gismu;
    can be assembled according to rules in order to make lujvo; not
    a valid word by itself. See 
    <a href="chapter4.html">Chapter 4</a>

    .</dd>
  

  
    <dt>tanru:</dt>

    <dd>a group of two or more brivla, possibly with associated
    cmavo, that form a selbri; always divisible into two parts,
    with the first part modifying the meaning of the second part
    (which is taken to be basic). See 
    <a href="chapter5.html">Chapter 5</a>

    .</dd>
 

  
    <dt>selma'o:</dt>

    <dd>a group of cmavo that have the same grammatical use (can
    appear interchangeably in sentences, as far as the grammar is
    concerned) but differ in meaning or other usage. See 
    <a href="chapter20.html">Chapter 20</a>

    .</dd>
  </dl>

    <hr />
    
    <p>Derni&egrave;res modifications&nbsp;: Mon Jun 27 23:12:25 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
