
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//ES" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 5</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter5.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 5<br />
      ``Pretty Little Girls' School'': The Structure Of Lojban
      selbri</h2>

      <!--
      <h6>$Revision: 4.1 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. Lojban content words: brivla</h3>

    <p>At the center, logically and often physically, of every
    Lojban bridi is one or more words which constitute the selbri.
    A bridi expresses a relationship between things: the selbri
    specifies which relationship is referred to. The difference
    between:</p>
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  do mamta mi
    You are-a-mother-of me.
    You are my mother.
</pre>
    and 
<pre>
<a id="e1d2" name="e1d2">1.2)</a>  do patfu mi
    You are-a-father-of me.
    You are my father.
</pre>
    lies in the different selbri. 

    <p>The simplest kind of selbri is a single Lojban content word:
    a brivla. There are three different varieties of brivla: those
    which are built into the language (the gismu), those which are
    derived from combinations of the gismu (the lujvo), and those
    which are taken (usually in a modified form) from other
    languages (the fu'ivla). In addition, there are a few cmavo
    that can act like brivla; these are mentioned in <a
    href="#s9">Section 9</a>, and discussed in full in <a
    href="chapter7.html">Chapter 7</a>.</p>

    <p>For the purposes of this chapter, however, all brivla are
    alike. For example,</p>
<pre>
<a id="e1d3" name="e1d3">1.3)</a>  ta bloti
    That is-a-boat.
    That is a boat.

<a id="e1d4" name="e1d4">1.4)</a>   ta brablo
    that is-a-large-boat.
    That is a ship.
</pre>
<pre>
<a id="e1d5" name="e1d5">1.5)</a>  ta blotrskunri
    That is-a-(boat)-schooner.
    That is a schooner.
</pre>
    illustrate the three types of brivla (gismu, lujvo, and fu'ivla
    respectively), but in each case the selbri is composed of a
    single word whose meaning can be learned independent of its
    origins. 

    <p>The remainder of this chapter will mostly use gismu as
    example brivla, because they are short. However, it is
    important to keep in mind that wherever a gismu appears, it
    could be replaced by any other kind of brivla.</p>

    <h3><a id="s2" name="s2">2. Simple tanru</h3>

    <p>Beyond the single brivla, a selbri may consist of two brivla
    placed together. When a selbri is built in this way from more
    than one brivla, it is called a tanru, a word with no single
    English equivalent. The nearest analogue to tanru in English
    are combinations of two nouns such as ``lemon tree''. There is
    no way to tell just by looking at the phrase ``lemon tree''
    exactly what it refers to, even if you know the meanings of
    ``lemon'' and ``tree'' by themselves. As English-speakers, we
    must simply know that it refers to ``a tree which bears lemons
    as fruits''. A person who didn't know English very well might
    think of it as analogous to ``brown tree'' and wonder, ``What
    kind of tree is lemon-colored?''</p>

    <p>In Lojban, tanru are also used for the same purposes as
    English adjective- noun combinations like ``big boy'' and
    adverb-verb combinations like ``quickly run''. This is a
    consequence of Lojban not having any such categories as
    ``noun'', ``verb'', ``adjective'', or ``adverb''. English words
    belonging to any of these categories are translated by simple
    brivla in Lojban. Here are some examples of tanru:</p>

    <p></p>
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  tu pelnimre tricu
    that-yonder is-a-(lemon tree).
    That is a lemon tree.

<a id="e2d2" name="e2d2">2.2)</a>   la djan. barda nanla
    John is-a-big boy.
    John is a big boy.

<a id="e2d3" name="e2d3">2.3)</a>   mi sutra bajra
    I quick run.
    I quickly run/I run quickly.
</pre>

    <p>Note that ``pelnimre'' is a lujvo for ``lemon''; it is
    derived from the gismu ``pelxu'', yellow, and ``nimre'',
    citrus. Note also that ``sutra'' can mean ``fast/quick'' or
    ``quickly'' depending on its use:</p>
<pre>
<a id="e2d4" name="e2d4">2.4)</a>  mi sutra
    I am-fast/quick.
</pre>
    shows ``sutra'' used to translate an adjective, whereas in <a
    href="#e2d3">Example 2.3</a> it is translating an adverb.
    (Another correct translation of <a href="#e2d3">Example
    2.3</a>, however, would be ``I am a quick runner''.) 

    <p>There are special Lojban terms for the two components of a
    tanru, derived from the place structure of the word ``tanru''.
    The first component is called the ``seltau'', and the second
    component is called the ``tertau''.</p>

    <p>The most important rule for use in interpreting tanru is
    that the tertau carries the primary meaning. A ``pelnimre
    tricu'' is primarily a tree, and only secondarily is it
    connected with lemons in some way. For this reason, an
    alternative translation of <a href="#e2d1">Example 2.1</a>
    would be:</p>
<pre>
<a id="e2d5" name="e2d5">2.5)</a>  That is a lemon type of tree.
</pre>

    <p>This ``type of'' relationship between the components of a
    tanru is fundamental to the tanru concept.</p>

    <p>We may also say that the seltau modifies the meaning of the
    tertau:</p>
<pre>
<a id="e2d6" name="e2d6">2.6)</a>  That is a tree which is lemon-ish
        (in the way appropriate to trees)
</pre>
    would be another possible translation of <a
    href="#e2d1">Example 2.1</a>. In the same way, a more explicit
    translation of <a href="#e2d2">Example 2.2</a> might be: 
<pre>
<a id="e2d7" name="e2d7">2.7)</a>  John is a boy who is big in the way that boys are big.
</pre>

    <p>This ``way that boys are big'' would be quite different from
    the way in which elephants are big; big-for-a-boy is
    small-for-an-elephant.</p>

    <p>All tanru are ambiguous semantically. Possible translations
    of:</p>
<pre>
<a id="e2d8" name="e2d8">2.8)</a>  ta klama jubme
    That is-a-goer type-of-table.
</pre>
    include: 

    <p></p>

    <dl>
      <dt></dt>

      <dd>That is a table which goes (a wheeled table, perhaps).
      That is a table owned by one who goes. That is a table used
      by those who go (a sports doctor's table?). That is a table
      when it goes (otherwise it is a chair?).</dd>
    </dl>
    In each case the object referred to is a ``goer type of
    table'', but the ambiguous ``type of'' relationship can mean
    one of many things. A speaker who uses tanru (and pragmatically
    all speakers must) takes the risk of being misunderstood. Using
    tanru is convenient because they are short and expressive; the
    circumlocution required to squeeze out all ambiguity can
    require too much effort. 

    <p>No general theory covering the meaning of all possible tanru
    exists; probably no such theory can exist. However, some
    regularities obviously do exist:</p>
<pre>
<a id="e2d9" name="e2d9">2.9)</a>  do barda prenu
    You are-a-large person.

<a id="e2d10" name="e2d10">2.10)</a> do cmalu prenu
    You are-a-small person.
</pre>
    are parallel tanru, in the sense that the relationship between
    ``barda'' and ``prenu'' is the same as that between ``cmalu''
    and ``prenu''. <a href="#s14">Section 14</a> and <a
    href="#s15">Section 15</a> contain a partial listing of some
    types of tanru, with examples. 

    <h3><a id="s3" name="s3">3. Three-part tanru grouping with ``bo''</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   bo  BO  closest scope grouping
</pre>
    Consider the English sentence: 
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  That's a little girls' school.
</pre>

    <p>What does it mean? Two possible readings are:</p>
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  That's a little school for girls.

<a id="e3d3" name="e3d3">3.3)</a>   That's a school for little girls.
</pre>
    This ambiguity is quite different from the simple tanru
    ambiguity described in <a href="#s2">Section 2</a>. We
    understand that ``girls' school'' means ``a school where girls
    are the students'', and not ``a school where girls are the
    teachers'' or ``a school which is a girl'' (!). Likewise, we
    understand that ``little girl'' means ``girl who is small''.
    This is an ambiguity of grouping. Is ``girls' school'' to be
    taken as a unit, with ``little'' specifying the type of girls'
    school? Or is ``little girl'' to be taken as a unit, specifying
    the type of school? In English speech, different tones of
    voice, or exaggerated speech rhythm showing the grouping, are
    used to make the distinction; English writing usually leaves it
    unrepresented. 

    <p>Lojban makes no use of tones of voice for any purpose;
    explicit words are used to do the work. The cmavo ``bo'' (which
    belongs to selma'o BO) may be placed between the two brivla
    which are most closely associated. Therefore, a Lojban
    translation of <a href="#e3d2">Example 3.2</a> would be:</p>
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  ta cmalu nixli bo ckule
    That is-a-small girl -- school.
</pre>
    <a href="#e3d3">Example 3.3</a> might be translated: 
<pre>
<a id="e3d5" name="e3d5">3.5)</a>  ta cmalu bo nixli ckule
    That is-a-small -- girl school.
</pre>

    <p>The ``bo'' is represented in the literal translation by a
    hyphen because in written English a hyphen is sometimes used
    for the same purpose: ``a big dog-catcher'' would be quite
    different from a ``big-dog catcher'' (presumably someone who
    catches only big dogs).</p>

    <p>Analysis of <a href="#e3d4">Example 3.4</a> and <a
    href="#e3d5">Example 3.5</a> reveals a tanru nested within a
    tanru. In <a href="#e3d4">Example 3.4</a>, the main tanru has a
    seltau of ``cmalu'' and a tertau of ``nixli bo ckule''; the
    tertau is itself a tanru with ``nixli'' as the seltau and
    ``ckule'' as the tertau. In <a href="#e3d5">Example 3.5</a>, on
    the other hand, the seltau is ``cmalu bo nixli'' (itself a
    tanru), whereas the tertau is ``ckule''. This structure of
    tanru nested within tanru forms the basis for all the more
    complex types of selbri that will be explained below.</p>

    <p>What about <a href="#e3d6">Example 3.6</a>? What does it
    mean?</p>
<pre>
<a id="e3d6" name="e3d6">3.6)</a>  ta cmalu nixli ckule
    That is-a-small girl school.
</pre>
    The rules of Lojban do not leave this sentence ambiguous, as
    the rules of English do with <a href="#e3d1">Example 3.1</a>.
    The choice made by the language designers is to say that <a
    href="#e3d6">Example 3.6</a> means the same as <a
    href="#e3d5">Example 3.5</a>. This is true no matter what three
    brivla are used: the leftmost two are always grouped together.
    This rule is called the ``left-grouping rule''. Left-grouping
    in seemingly ambiguous structures is quite common --- though
    not universal --- in other contexts in Lojban. 

    <p>Another way to express the English meaning of <a
    href="#e3d4">Example 3.4</a> and <a href="#e3d5">Example
    3.5</a>, using parentheses to mark grouping, is:</p>
<pre>
<a id="e3d7" name="e3d7">3.7)</a>  ta cmalu nixli bo ckule
    That is-a-small type-of (girl type-of school).

<a id="e3d8" name="e3d8">3.8)</a>   ta cmalu bo nixli ckule
    That is-a-(small type-of girl) type-of school.
</pre>

    <p>Because ``type-of'' is implicit in the Lojban tanru form, it
    has no Lojban equivalent.</p>

    <p>Note: It is perfectly legal, though pointless, to insert
    ``bo'' into a simple tanru:</p>
<pre>
<a id="e3d9" name="e3d9">3.9)</a>  ta klama bo jubme
    That is-a goer -- table
</pre>
    is a legal Lojban bridi that means exactly the same thing as <a
    href="#e2d8">Example 2.8</a>, and is ambiguous in exactly the
    same ways. The cmavo ``bo'' serves only to resolve grouping
    ambiguity: it says nothing about the more basic ambiguity
    present in all tanru. 

    <h3><a id="s4" name="s4">4. Complex tanru grouping</h3>

    <p>If one element of a tanru can be another tanru, why not both
    elements?</p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  do mutce bo barda gerku bo kavbu
    You are-a-(very type-of large) (dog type-of capturer).
    You are a very large dog-catcher.
</pre>

    <p>In <a href="#e4d1">Example 4.1</a>, the selbri is a tanru
    with seltau ``mutce bo barda'' and tertau ``gerku bo kavbu''.
    It is worth emphasizing once again that this tanru has the same
    fundamental ambiguity as all other Lojban tanru: the sense in
    which the ``dog type-of capturer'' is said to be ``very type-of
    large'' is not precisely specified. Presumably it is his body
    which is large, but theoretically it could be one of his other
    properties.</p>

    <p>We will now justify the title of this chapter by exploring
    the ramifications of the phrase ``pretty little girls'
    school'', an expansion of the tanru used in <a
    href="#s3">Section 3</a> to four brivla. (Although this example
    has been used in the Loglan Project almost since the beginning
    --- it first appeared in Quine's book <cite>Word and
    Object</cite> (1960) --- it is actually a mediocre example
    because of the ambiguity of English ``pretty''; it can mean
    ``beautiful'', the sense intended here, or it can mean
    ``very''. Lojban ``melbi'' is not subject to this ambiguity: it
    means only ``beautiful''.) Here are four ways to group this
    phrase:</p>
<pre>
<a id="e4d2" name="e4d2">4.2)</a>  ta melbi cmalu
        nixli ckule
    That is-a-((pretty type-of little)
        type-of girl) type-of school.
    That is a school for girls who are beautifully small.

<a id="e4d3" name="e4d3">4.3)</a>   ta melbi cmalu nixli bo ckule
    That is-a-(pretty type-of little) (girl type-of school).
    That is a girls' school which is beautifully small.

<a id="e4d4" name="e4d4">4.4)</a>   ta melbi cmalu bo nixli
        ckule
    That is-a-(pretty type-of (little type-of girl))
        type-of school.
    That is a school for small girls who are beautiful.

<a id="e4d5" name="e4d5">4.5)</a>   ta melbi cmalu bo
        nixli bo ckule
    That is-a-pretty type-of (little type-of
        (girl type-of school)).
    That is a small school for girls which is beautiful.
</pre>
    <a href="#e4d5">Example 4.5</a> uses a construction which has
    not been seen before: ``cmalu bo nixli bo ckule'', with two
    consecutive uses of ``bo'' between brivla. The rule for
    multiple ``bo'' constructions is the opposite of the rule when
    no ``bo'' is present at all: the last two are grouped together.
    Not surprisingly, this is called the ``right-grouping rule'',
    and it is associated with every use of ``bo'' in the language.
    Therefore, 
<pre>
<a id="e4d6" name="e4d6">4.6)</a>  ta cmalu bo nixli bo ckule
    That is-a-little type-of (girl type-of school).
</pre>
    means the same as <a href="#e3d4">Example 3.4</a>, not <a
    href="#e3d5">Example 3.5</a>. This rule may seem peculiar at
    first, but one of its consequences is that ``bo'' is never
    necessary between the first two elements of any of the complex
    tanru presented so far: all of <a href="#e4d2">Examples
    4.2</a> through <a href="#e4d5">4.5</a> could have ``bo''
    inserted between ``melbi'' and ``cmalu'' with no change in
    meaning. 

    <h3><a id="s5" name="s5">5. Complex tanru with ``ke'' and ``ke'e''</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ke  KE  start grouping
    ke'e    KEhE    end grouping
</pre>
    There is, in fact, a fifth grouping of ``pretty little girls'
    school'' that cannot be expressed with the resources explained
    so far. To handle it, we must introduce the grouping
    parentheses cmavo, ``ke'' and ``ke'e'' (belonging to selma'o KE
    and KEhE respectively). Any portion of a selbri sandwiched
    between these two cmavo is taken to be a single tanru
    component, independently of what is adjacent to it. Thus, <a
    href="#e4d2">Example 4.2</a> can be rewritten in any of the
    following ways: 
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  ta ke melbi cmalu ke'e nixli ckule
    That is-a-( pretty little ) girl school.

<a id="e5d2" name="e5d2">5.2)</a>   ta ke ke melbi cmalu ke'e nixli ke'e ckule
    That is-a-( ( pretty little ) girl ) school.

<a id="e5d3" name="e5d3">5.3)</a>   ta ke ke ke melbi cmalu ke'e nixli ke'e ckule ke'e
    That is-a-( ( ( pretty little ) girl ) school ).
</pre>

    <p>Even more versions could be created simply by placing any
    number of ``ke'' cmavo at the beginning of the selbri, and a
    like number of ``ke'e'' cmavo at its end. Obviously, all of
    these are a waste of breath once the left-grouping rule has
    been grasped. However, the following is equivalent to <a
    href="#e4d4">Example 4.4</a> and may be easier to
    understand:</p>
<pre>
<a id="e5d4" name="e5d4">5.4)</a>  ta melbi ke cmalu nixli ke'e
        ckule
    That is-a-(pretty type-of ( little type-of girl ))
        type-of school.
</pre>

    <p>Likewise, a ``ke'' and ``ke'e'' version of <a
    href="#e4d3">Example 4.3</a> would be:</p>
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  ta melbi cmalu
        ke nixli ckule [ke'e]
    That is-a-(pretty type-of little)
        ( girl type-of school ).
</pre>

    <p>The final ``ke'e'' is given in square brackets here to
    indicate that it can be elided. It is always possible to elide
    ``ke'e'' at the end of the selbri, making <a
    href="#e5d5">Example 5.5</a> as terse as <a
    href="#e4d3">Example 4.3</a>.</p>

    <p>Now how about that fifth grouping? It is</p>
<pre>
<a id="e5d6" name="e5d6">5.6)</a>  ta melbi
        ke cmalu nixli ckule [ke'e]
    That is-a-pretty type-of
        ( (little type-of girl) type-of school )
    That is a beautiful school for small girls.
</pre>
    <a href="#e5d6">Example 5.6</a> is distinctly different in
    meaning from any of Examples 4.2 through 4.5. Note that within
    the ``ke ... ke'e'' parentheses, the left-grouping rule is
    applied to ``cmalu nixli ckule''. 

    <p>It is perfectly all right to mix ``bo'' and ``ke ... ke'e''
    in a single selbri. For instance, <a href="#e4d5">Example
    4.5</a>, which in pure ``ke ... ke'e'' form is</p>
<pre>
<a id="e5d7" name="e5d7">5.7)</a>  ta melbi
        ke cmalu ke nixli ckule [ke'e] [ke'e]
    That is-a-pretty type-of
        ( little type-of ( girl type-of school ) ).
</pre>
    can equivalently be expressed as: 
<pre>
<a id="e5d8" name="e5d8">5.8)</a>  ta melbi
        ke cmalu nixli bo ckule [ke'e]
    That is-a-pretty
        type-of ( little type-of (girl type-of school) ).
</pre>
    and in many other different forms as well. 

    <h3><a id="s6" name="s6">6. Logical connection within tanru</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   je  JA  tanru logical ``and''
    ja  JA  tanru logical ``or''
    joi JOI mixed mass ``and''
    gu'e    GUhA    tanru forethought logical ``and''
    gi  GI  forethought connection separator
</pre>
    Consider the English phrase ``big red dog''. How shall this be
    rendered as a Lojban tanru? The naive attempt: 
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  barda xunre gerku
    (big type-of red) type-of dog
</pre>
    will not do, as it means a dog whose redness is big, in
    whatever way redness might be described as ``big''. Nor is 
<pre>
<a id="e6d2" name="e6d2">6.2)</a>  barda xunre bo gerku
    big type-of (red type-of dog)
</pre>
    much better. After all, the straightforward understanding of
    the English phrase is that the dog is big as compared with
    other dogs, not merely as compared with other red dogs. In
    fact, the bigness and redness are independent properties of the
    dog, and only obscure rules of English adjective ordering
    prevent us from saying ``red big dog''. 

    <p>The Lojban approach to this problem is to introduce the
    cmavo ``je'', which is one of the many equivalents of English
    ``and''. A big red dog is one that is both big and red, and we
    can say:</p>
<pre>
<a id="e6d3" name="e6d3">6.3)</a>  barda je xunre gerku
    (big and red) type-of dog
</pre>

    <p>Of course,</p>
<pre>
<a id="e6d4" name="e6d4">6.4)</a>  xunre je barda gerku
    (red and big) type-of dog
</pre>
    is equally satisfactory and means the same thing. As these
    examples indicate, joining two brivla with ``je'' makes them a
    unit for tanru purposes. However, explicit grouping with ``bo''
    or ``ke ... ke'e'' associates brivla more closely than ``je''
    does: 
<pre>
<a id="e6d5" name="e6d5">6.5)</a>  barda je pelxu bo xunre gerku
    barda je ke pelxu xunre ke'e gerku
    (big and (yellow type-of red)) dog
    big yellowish-red dog
</pre>

    <p>With no grouping indicators, we get:</p>
<pre>
<a id="e6d6" name="e6d6">6.6)</a>  barda je pelxu xunre gerku
    ((big and yellow) type-of red) type-of dog
    biggish- and yellowish-red dog
</pre>
    which again raises the question of <a href="#e6d1">Example
    6.1</a>: what is does ``biggish-red'' mean? 

    <p>Unlike ``bo'' and ``ke ... ke'e'', ``je'' is useful as well
    as merely legal within simple tanru. It may be used to partly
    resolve the ambiguity of simple tanru:</p>
<pre>
<a id="e6d7" name="e6d7">6.7)</a>  ta blanu je zdani
    that is-blue and is-a-house
</pre>
    definitely refers to something which is both blue and is a
    house, and not to any of the other possible interpretations of
    simple ``blanu zdani''. Furthermore, ``blanu zdani'' refers to
    something which is blue in the way that houses are blue;
    ``blanu je zdani'' has no such implication --- the blueness of
    a ``blanu je zdani'' is independent of its houseness. 

    <p>With the addition of ``je'', many more versions of ``pretty
    little girls' school'' are made possible: see <a
    href="#s16">Section 16</a> for a complete list.</p>

    <p>A subtle point in the semantics of tanru like <a
    href="#e6d3">Example 6.3</a> needs special elucidation. There
    are at least two possible interpretations of:</p>
<pre>
<a id="e6d8" name="e6d8">6.8)</a>  ta melbi je nixli ckule
    That is-a-(beautiful and girl) type-of school.
</pre>

    <p>It can be understood as:</p>
<pre>
<a id="e6d9" name="e6d9">6.9)</a>  That is a girls' school and a beautiful school.
</pre>
    or as: 
<pre>
<a id="e6d10" name="e6d10">6.10)</a>    That is a school for things
        which are both girls and beautiful.
</pre>
    The interpretation specified by <a href="#e6d9">Example 6.9</a>
    treats the tanru as a sort of abbreviation for: 
<pre>
<a id="e6d11" name="e6d11">6.11)</a>    ta ke melbi ckule ke'e
        je ke nixli ckule [ke'e]
    That is-a-( beautiful type-of school )
        and ( girl type-of school )
</pre>
    whereas the interpretation specified by <a
    href="#e6d10">Example 6.10</a> does not. This is a kind of
    semantic ambiguity for which Lojban does not compel a firm
    resolution. The way in which the school is said to be of type
    ``beautiful and girl'' may entail that it is separately a
    beautiful school and a girls' school; but the alternative
    interpretation, that the members of the school are beautiful
    and girls, is also possible. Still another interpretation is: 
<pre>
<a id="e6d12" name="e6d12">6.12)</a>    That is a school for beautiful things
        and also for girls.
</pre>
    so while the logical connectives help to resolve the meaning of
    tanru, they by no means compel a single meaning in and of
    themselves. 

    <p>In general, logical connectives within tanru cannot undergo
    the formal manipulations that are possible with the related
    logical connectives that exist outside tanru; see <a
    href="chapter14.html">Chapter 14</a> for further details.</p>

    <p>The logical connective ``je'' is only one of the fourteen
    logical connectives that Lojban provides. Here are a few
    examples of some of the others:</p>
<pre>
<a id="e6d13" name="e6d13">6.13)</a>    le bajra cu jinga ja te jinga
    the runner(s) is/are winner(s) or loser(s).

<a id="e6d14" name="e6d14">6.14)</a> blanu naja lenku skapi
    (blue only-if cold) skin
    skin which is blue only if it is cold

<a id="e6d15" name="e6d15">6.15)</a> xamgu jo cortu nuntavla
    (good if-and-only-if short) speech
    speech which is good if (and only if) it is short

<a id="e6d16" name="e6d16">6.16)</a> vajni ju pluka nuntavla
    (important whether-or-not pleasing) event-of-talking
    speech which is important, whether or not it is pleasing
</pre>

    <p>In <a href="#e6d13">Example 6.13</a>, ``ja'' is
    grammatically equivalent to ``je'' but means ``or'' (more
    precisely, ``and/or''). Likewise, ``naja'' means ``only if'' in
    <a href="#e6d14">Example 6.14</a>, ``jo'' means ``if and only
    if'' in <a href="#e6d15">Example 6.15</a>, and ``ju'' means
    ``whether or not'' in <a href="#e6d16">Example 6.16</a>.</p>

    <p>Now consider the following example:</p>
<pre>
<a id="e6d17" name="e6d17">6.17)</a>    ricfu je blanu jabo crino
    rich and (blue or green)
</pre>
    which illustrates a new grammatical feature: the use of both
    ``ja'' and ``bo'' between tanru components. The two cmavo
    combine to form a compound whose meaning is that of ``ja'' but
    which groups more closely; ``jabo'' is to ``ja'' as plain
    ``bo'' is to no cmavo at all. However, both ``ja'' and ``jabo''
    group less closely than ``bo'' does: 
<pre>
<a id="e6d18" name="e6d18">6.18)</a>    ricfu je blanu jabo crino bo blanu
    rich and (blue or green -- blue)
    rich and (blue or greenish-blue)
</pre>

    <p>An alternative form of <a href="#e6d17">Example 6.17</a>
    is:</p>
<pre>
<a id="e6d19" name="e6d19">6.19)</a>    ricfu je ke blanu ja crino [ke'e]
    rich and ( blue or green )
</pre>
    In addition to the logical connectives, there are also a
    variety of non-logical connectives, grammatically equivalent to
    the logical ones. The only one with a well-understood meaning
    in tanru contexts is ``joi'', which is the kind of ``and'' that
    denotes a mixture: 
<pre>
<a id="e6d20" name="e6d20">6.20)</a>    ti blanu joi xunre bolci
    This is-a-(blue and red) ball.
</pre>

    <p>The ball described is neither solely red nor solely blue,
    but probably striped or in some other way exhibiting a
    combination of the two colors. <a href="#e6d20">Example
    6.20</a> is distinct from:</p>
<pre>
<a id="e6d21" name="e6d21">6.21)</a>    ti blanu xunre bolci
    This is a bluish-red ball
</pre>
    which would be a ball whose color is some sort of purple
    tending toward red, since ``xunre'' is the more important of
    the two components. On the other hand, 
<pre>
<a id="e6d22" name="e6d22">6.22)</a>    ti blanu je xunre bolci
    This is a (blue and red) ball
</pre>
    is probably self-contradictory, seeming to claim that the ball
    is independently both blu and red at the same time, although
    some sensible interpretation may exist. 

    <p>Finally, just as English ``and'' has the variant form ``both
    ... and'', so ``je'' between tanru components has the variant
    form ``gu'e ... gi'', where ``gu'e'' is placed before the
    components and ``gi'' between them:</p>
<pre>
<a id="e6d23" name="e6d23">6.23)</a>    gu'e barda gi xunre gerku
    (both big and red) type-of dog
</pre>
    is equivalent in meaning to <a href="#e6d3">Example 6.3</a>.
    For each logical connective related to ``je'', there is a
    corresponding connective related to ``gu'e ... gi'' in a
    systematic way. 

    <p>The portion of a ``gu'e ... gi'' construction before the
    ``gi'' is a full selbri, and may use any of the selbri
    resources including ``je'' logical connections. After the
    ``gi'', logical connections are taken to be wider in scope than
    the ``gu'e ... gi'', which has in effect the same scope as
    ``bo'':</p>
<pre>
<a id="e6d24" name="e6d24">6.23)</a>    gu'e barda je xunre gi gerku ja mlatu
    (both (big and red) and dog) or cat
    something which is either big, red, and a dog,
        or else a cat
</pre>
    leaves ``mlatu'' outside the ``gu'e--gi'' construction. The
    scope of the ``gi'' arm extends only to a single brivla or to
    two or more brivla connected with ``bo'' or ``ke--ke'e''. 

    <h3><a id="s7" name="s7">7. Linked sumti: ``be--bei--be'o''</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   be  BE  linked sumti marker
    bei BEI linked sumti separator
    be'o    BEhO    linked sumti terminator
</pre>

    <p>The question of the place structures of selbri has been
    glossed over so far. This chapter does not attempt to treat
    place structure issues in detail; they are discussed in <a
    href="chapter9.html">Chapter 9</a>. One grammatical structure
    related to places belongs here, however. In simple sentences
    such as <a href="#e1d1">Example 1.1</a>, the place structure of
    the selbri is simply the defined place structure of the gismu
    ``mamta''. What about more complex selbri?</p>

    <p>For tanru, the place structure rule is simple: the place
    structure of a tanru is always the place structure of its
    tertau. Thus, the place structure of ``blanu zdani'' is that of
    ``zdani'': the x1 place is a house or nest, and the x2 place is
    its occupants.</p>

    <p>What about the places of ``blanu''? Is there any way to get
    them into the act? In fact, ``blanu'' has only one place, and
    this is merged, as it were, with the x1 place of ``zdani''. It
    is whatever is in the x1 place that is being characterized as
    blue-for-a-house. But if we replace ``blanu'' with ``xamgu'',
    we get:</p>

    <p></p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  ti xamgu zdani
    this is-a-good house.
    This is a good (for someone, by some standard) house.
</pre>

    <p>Since ``xamgu'' has three places (x1, the good thing; x2,
    the person for whom it is good; and x3, the standard of
    goodness), <a href="#e7d1">Example 7.1</a> necessarily omits
    information about the last two: there is no room for them. Room
    can be made, however!</p>
<pre>
<a id="e7d2" name="e7d2">7.2)</a>  ti xamgu be do bei mi [be'o] zdani
    this is-a-good ( for you by-standard me ) house.
    This is a house that is good for you by my standards.
</pre>
    Here, the gismu ``xamgu'' has been followed by the cmavo ``be''
    (of selma'o BE), which signals that one or more sumti follows.
    These sumti are not part of the overall bridi place structure,
    but fill the places of the brivla they are attached to,
    starting with x2. If there is more than one sumti, they are
    separated by the cmavo ``bei'' (of selma'o BEI), and the list
    of sumti is terminated by the elidable terminator ``be'o'' (of
    selma'o BEhO). 

    <p>Grammatically, a brivla with sumti linked to it in this
    fashion plays the same role in tanru as a simple brivla. To
    illustrate, here is a fully fleshed-out version of <a
    href="#e3d4">Example 3.4</a>, with all places filled in:</p>

    <p></p>
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  ti cmalu be le ka canlu
            bei lo'e ckule be'o
        nixli be li mu
            bei lo merko be'o bo
        ckule la bryklyn. loi pemci
            le mela nu,IORK. prenu
            le jecta
    This is a small (in-dimension the property-of volume
            by-standard the-typical school)
        (girl (of-years the-number five
            by-standard some American-thing)
        school) in-Brooklyn with-subject poems
            for-audience New-York persons
            with-operator the state.
    This is a school, small in volume compared to the
        typical school, pertaining to five-year-old
        girls (by American standards), in Brooklyn,
        teaching poetry to the New York community
        and operated by the state.
</pre>

    <p>Here the three places of ``cmalu'', the three of ``nixli'',
    and the four of ``ckule'' are fully specified. Since the places
    of ``ckule'' are the places of the bridi as a whole, it was not
    necessary to link the sumti which follow ``ckule''. It would
    have been legal to do so, however:</p>
<pre>
<a id="e7d4" name="e7d4">7.4)</a>  mi klama be le zarci bei le zdani [be'o]
    I go (to-the market from-the house).
</pre>
    means the same as 
<pre>
<a id="e7d5" name="e7d5">7.5)</a>  mi klama le zarci le zdani
    I go to-the market from-the house.
</pre>
    No matter how complex a tanru gets, the last brivla always
    dictates the place structure: the place structure of 
<pre>
<a id="e7d6" name="e7d6">7.6)</a>  melbi je cmalu nixli bo ckule
    a (pretty and little) (girl school)
    a school for girls which is both beautiful and small
</pre>
    is simply that of ``ckule''. (The sole exception to this rule
    is discussed in <a href="#s8">Section 8</a>.) 

    <p>It is possible to precede linked sumti by the place
    structure ordering tags ``fe'', ``fi'', ``fo'', and ``fu'' (of
    selma'o FA, discussed further in <a href="chapter9.html">Chapter
    9</a>), which serve to explicitly specify the x2, x3, x4, and
    x5 places respectively. Normally, the place following the
    ``be'' is the x2 place and the other places follow in order. If
    it seems convenient to change the order, however, it can be
    accomplished as follows:</p>
<pre>
<a id="e7d7" name="e7d7">7.7)</a>  ti xamgu be fi mi bei fe do [be'o] zdani
    this is-a-good ( by-standard me for you ) house
</pre>
    which is equivalent in meaning to <a href="#e7d2">Example
    7.2</a>. Note that the order of ``be'', ``bei'', and ``be'o''
    does not change; only the inserted ``fi'' tells us that ``mi''
    is the x3 place (and correspondingly, the inserted ``fe'' tells
    us that ``do'' is the x2 place). Changing the order of sumti is
    often done to match the order of another language, or for
    emphasis or rhythm. 

    <p>Of course, using FA cmavo makes it easy to specify one place
    while omitting a previous place:</p>
<pre>
<a id="e7d8" name="e7d8">7.8)</a>  ti xamgu be fi mi [be'o] zdani
    this is-a-good (by-standard me) house
    This is a good house by my standards.
</pre>
    Similarly, sumti labeled by modal or tense tags can be inserted
    into strings of linked sumti just as they can into bridi: 
<pre>
<a id="e7d9" name="e7d9">7.9)</a>  ta blanu be ga'a mi [be'o] zdani
    That is-a-blue ( to-observer me ) house.
    That is a blue, as I see it, house.
</pre>

    <p>The meaning of <a href="#e7d9">Example 7.9</a> is slightly
    different from:</p>
<pre>
<a id="e7d10" name="e7d10">7.10)</a>    ta blanu zdani ga'a mi
    That is-a-blue house to-observer me.
    That is a blue house, as I see it.
</pre>

    <p>See discussions in <a href="chapter9.html">Chapter 9</a> of
    modals and in <a href="chapter10.html">Chapter 10</a> of tenses
    for more explanations.</p>

    <p>The terminator ``be'o'' is almost always elidable: however,
    if the selbri belongs to a description, then a relative clause
    following it will attach to the last linked sumti unless
    ``be'o'' is used, in which case it will attach to the outer
    description:</p>
<pre>
<a id="e7d11" name="e7d11">7.11)</a>    le xamgu be do noi barda cu zdani
    The good-thing for you (who are-large) is-a-house.

<a id="e7d12" name="e7d12">7.12)</a> le xamgu be do be'o noi barda cu zdani
    The (good-thing for you) (which is-large) is-a-house
</pre>
    (Relative clauses are explained in <a href="chapter8.html">Chapter
    8</a>.) 

    <p>In other cases, however, ``be'o'' cannot be elided if ``ku''
    has also been elided:</p>
<pre>
<a id="e7d13" name="e7d13">7.13)</a>    le xamgu be le ctuca [ku] be'o zdani
    the good (for the teacher ) house
</pre>
    requires either ``ku'' or ``be'o'', and since there is only one
    occurrence of ``be'', the ``be'o'' must match it, whereas it
    may be confusing which occurrence of ``le'' the ``ku''
    terminates (in fact the second one is correct). 

    <h3><a id="s8" name="s8">8. Inversion of tanru: ``co''</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   co  CO  tanru inversion marker
</pre>
    The standard order of Lojban tanru, whereby the modifier
    precedes what it modifies, is very natural to English-speakers:
    we talk of ``blue houses'', not of ``houses blue''. In other
    languages, however, such matters are differently arranged, and
    Lojban supports this reverse order (tertau before seltau) by
    inserting the particle ``co''. <a href="#e8d1">Example 8.1</a>
    and <a href="#e8d2">Example 8.2</a> mean exactly the same
    thing: 
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  ta blanu zdani
    That is-a-blue type-of-house.
    That is a blue house.

<a id="e8d2" name="e8d2">8.2)</a>   ta zdani co blanu
    That is-a-house of-type blue.
    That is a blue house.
</pre>
    This change is called ``tanru inversion''. In tanru inversion,
    the element before ``co'' (``zdani'' in <a href="#e8d2">Example
    8.2</a>) is the tertau, and the element following ``co''
    (``blanu'') in <a href="#e8d2">Example 8.2</a>) is the seltau. 

    <p>The meaning, and more specifically, the place structure, of
    a tanru is not affected by inversion: the place structure of
    ``zdani co blanu'' is still that of ``zdani''. However, the
    existence of inversion in a selbri has a very special effect on
    any sumti which follow that selbri. Instead of being
    interpreted as filling places of the selbri, they actually fill
    the places (starting with x2) of the seltau. In <a
    href="#s7">Section 7</a>, we saw how to fill interior places
    with ``be ... bei ... be'o'', and in fact <a
    href="#e8d3">Example 8.3</a> and <a href="#e8d4">Example
    8.4</a> have the same meaning:</p>
<pre>
<a id="e8d3" name="e8d3">8.3)</a>  mi klama be le zarci bei le zdani be'o
        troci
    I am-a-(goer to the market from the house)
        type-of trier.
    I try to go to the market from the house.

<a id="e8d4" name="e8d4">8.4)</a>   mi troci co klama le zarci le zdani
    I am-a-trier
        of-type (goer to-the market from-the house).
    I try to go to the market from the house.
</pre>
    <a href="#e8d4">Example 8.4</a> is a less deeply nested
    construction, requiring fewer cmavo. As a result it is probably
    easier to understand. 

    <p>Note that in Lojban ``trying to go'' is expressed using
    ``troci'' as the tertau. The reason is that ``trying to go'' is
    a ``going type of trying'', not a ``trying type of going''. The
    trying is more fundamental than the going --- if the attempt
    fails, we may not have a going at all.</p>

    <p>Any sumti which precede a selbri with an inverted tanru fill
    the places of the selbri (i.e., the places of the tertau) in
    the ordinary way. In <a href="#e8d4">Example 8.4</a>, ``mi''
    fills the x1 place of ``troci co klama'', which is the x1 place
    of ``troci''. The other places of the selbri remain unfilled.
    The trailing sumti ``le zarci'' and ``le zdani'' do not occupy
    selbri places, despite appearances.</p>

    <p>As a result, the regular mechanisms (involving selma'o VOhA
    and GOhI, explained in <a href="chapter7.html">Chapter 7</a>) for
    referring to individual sumti of a bridi cannot refer to any of
    the trailing places of <a href="#e8d4">Example 8.4</a>, because
    they are not really ``sumti of the bridi'' at all.</p>

    <p>When inverting a more complex tanru, it is possible to
    invert it only at the most general modifier-modified pair. The
    only possible inversion of <a href="#e3d4">Example 3.4</a>, for
    instance, is:</p>
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  ta nixli [bo] ckule co cmalu
    that (is-a-girl type-of school) of-type little.
    That's a girls' school which is small.
</pre>
    Note that the ``bo'' of <a href="#e3d4">Example 3.4</a> is
    optional in <a href="#e8d5">Example 8.5</a>, because ``co''
    groups more loosely than any other cmavo used in tanru,
    including none at all. Not even ``ke ... ke'e'' parentheses can
    encompass a ``co'': 
<pre>
<a id="e8d6" name="e8d6">8.6)</a>  ta cmalu ke nixli ckule [ke'e]
        co melbi
    that is-a-(little type-of (girl type-of school))
        of-type pretty.
    That's a small school for girls which is beautiful.
</pre>
    In <a href="#e8d6">Example 8.6</a>, the ``ke'e'' is
    automatically inserted before the ``co'' rather than at its
    usual place at the end of the selbri. As a result, there is a
    simple and mechanical rule for removing ``co'' from any selbri:
    change ``A co B'' to ``ke B ke'e A''. (At the same time, any
    sumti following the selbri must be transformed into ``be ...
    bei ... be'o'' form and attached following B.) Therefore, 
<pre>
<a id="e8d7" name="e8d7">8.7)</a>  ckule co melbi nixli
    school of-type pretty girl
    school for beautiful girls
</pre>
    means the same as: 
<pre>
<a id="e8d8" name="e8d8">8.8)</a>  ke melbi nixli ke'e ckule
    ( pretty girl ) school
</pre>
    Multiple ``co'' cmavo can appear within a selbri, indicating
    multiple inversions: a right-grouping rule is employed, as for
    ``bo''. The above rule can be applied to interpret such selbri,
    but all ``co'' cmavo must be removed simultaneously: 
<pre>
<a id="e8d9" name="e8d9">8.9)</a>  ckule co nixli co cmalu
    school of-type (girl of-type little)
</pre>
    becomes formally 
<pre>
<a id="e8d10" name="e8d10">8.10)</a>    ke ke cmalu ke'e nixli ke'e ckule
    ( ( little ) girl ) school
</pre>
    which by the left-grouping rule is simply 
<pre>
<a id="e8d11" name="e8d11">8.11)</a>    cmalu nixli ckule
    little girl school
    school for little girls
</pre>

    <p>As stated above, the selbri places, other than the first,
    of</p>
<pre>
<a id="e8d12" name="e8d12">8.12)</a>    mi klama co sutra
    I am-a-goer of-type quick
    I go quickly
</pre>
    cannot be filled by placing sumti after the selbri, because any
    sumti in that position fill the places of ``sutra'', the
    seltau. However, the tertau places (which means in effect the
    selbri places) can be filled with ``be'': 
<pre>
<a id="e8d13" name="e8d13">8.13)</a>    mi klama be le zarci co sutra
    I am-a-goer (to the store) of-type quick.
    I go to the store quickly.
</pre>

    <h3><a id="s9" name="s9">9. Other kinds of simple selbri</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   go'i    GOhA    repeats the previous bridi
    du  GOhA    equality
    nu'a    NUhA    math operator to selbri
    moi MOI changes number to ordinal selbri
    mei MOI changes number to cardinal selbri
    nu  NU  event abstraction
    kei KEI terminator for ``nu''
</pre>
    So far we have only discussed brivla and tanru built up from
    brivla as possible selbri. In fact, there are a few other
    constructions in Lojban which are grammatically equivalent to
    brivla: they can be used either directly as selbri, or as
    components in tanru. Some of these types of simple selbri are
    discussed at length in <a href="chapter7.html">Chapter 7</a>, <a
    href="chapter11.html">Chapter 11</a>, and <a
    href="chapter18.html">Chapter 18</a>; but for completeness these
    types are mentioned here with a brief explanation and an
    example of their use in selbri. 

    <p>The cmavo of selma'o GOhA (with one exception) serve as
    pro-bridi, providing a reference to the content of other bridi;
    none of them has a fixed meaning. The most commonly used member
    of GOhA is probably ``go'i'', which amounts to a repetition of
    the previous bridi, or part of it. If I say:</p>

    <p></p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  la djan. klama le zarci
    John goes-to the market.
</pre>
    you may retort: 
<pre>
<a id="e9d2" name="e9d2">9.2)</a>  la djan. go'i troci
    John [repeat last] are-a-tryer
    John tries to.
</pre>
    <a href="#e9d2">Example 9.2</a> is short for: 
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  la djan. klama be le zarci be'o troci
    John is-a-goer (to the market) type-of trier.
</pre>
    because the whole bridi of <a href="#e9d1">Example 9.1</a> has
    been packaged up into the single word ``go'i'' and inserted
    into <a href="#e9d2">Example 9.2</a>. 

    <p>The exceptional member of GOhA is ``du'', which represents
    the relation of identity. Its place structure is:</p>

    <dl>
      <dt></dt>

      <dd>x1 is identical with x2, x3, ...</dd>
    </dl>
    for as many places as are given. More information on selma'o
    GOhA is available in <a href="chapter7.html">Chapter 7</a>. 

    <p>Lojban mathematical expressions (mekso) can be incorporated
    into selbri in two different ways. Mathematical operators such
    as ``su'i'', meaning ``plus'', can be transformed into selbri
    by prefixing them with ``nu'a'' (of selma'o NUhA). The
    resulting place structure is:</p>

    <dl>
      <dt></dt>

      <dd>x1 is the result of applying (the operator) to arguments
      x2, x3, etc.</dd>
    </dl>
    for as many arguments as are required. (The result goes in the
    x1 place because the number of following places may be
    indefinite.) For example: 
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  li vo nu'a su'i li re li re
    The-number 4 is-the-sum-of the-number 2 and-the-number 2.
</pre>

    <p>A possible tanru example might be:</p>

    <p></p>
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  mi jimpe tu'a nu'a su'i nabmi
    I understand something-about the-mass-of is-the-sum-of problems.
    I understand addition problems.
</pre>
    More usefully, it is possible to combine a mathematical
    expression with a cmavo of selma'o MOI to create one of various
    numerical selbri. Details are available in <a
    href="chapter18.html">Chapter 18</a>. Here are a few tanru: 

    <p></p>
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  la prim. palvr. pamoi cusku
    Preem Palver is-the-1-th speaker.
    Preem Palver is the first speaker.
</pre>
<pre>
<a id="e9d7" name="e9d7">9.7)</a>  la an,iis. joi la .asun. bruna remei
    Anyi massed-with Asun are-a-brother type-of-twosome.
    Anyi and Asun are two brothers.
</pre>
    Finally, an important type of simple selbri which is not a
    brivla is the abstraction. Grammatically, abstractions are
    simple: a cmavo of selma'o NU, followed by a bridi, followed by
    the elidable terminator ``kei'' of selma'o KEI. Semantically,
    abstractions are an extremely subtle and powerful feature of
    Lojban whose full ramifications are documented in <a
    href="chapter11.html">Chapter 11</a>. A few examples: 

    <p></p>
<pre>
<a id="e9d8" name="e9d8">9.8)</a>  ti nu zdile kei kumfa
    This is-an-event-of amusement room.
    This is an amusement room.
</pre>
    <a href="#e9d8">Example 9.8</a> is quite distinct in meaning
    from: 
<pre>
<a id="e9d9" name="e9d9">9.9)</a>  ti zdile kumfa
    This is-an-amuser room.
</pre>
    which suggests the meaning ``a room that amuses someone''. 

    <h3><a id="s10" name="s10">10. selbri based on sumti: ``me''</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   me  ME  changes sumti to simple selbri
    me'u    MEhU    terminator for ``me''
</pre>
    A sumti can be made into a simple selbri by preceding it with
    ``me'' (of selma'o ME) and following it with the elidable
    terminator ``me'u'' (of selma'o MEhU). This makes a selbri with
    the place structure 

    <dl>
      <dt></dt>

      <dd>x1 is one of the referents of ``[the sumti]''</dd>
    </dl>
    which is true of the thing, or things, that are the referents
    of the sumti, and not of anything else. For example, consider
    the sumti 
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    le ci nolraitru
    the three noblest-governors
    the three kings
</pre>
    If these are understood to be the Three Kings of Christian
    tradition, who arrive every year on January 6, then we may say:
    
<pre>
<a id="e10d2" name="e10d2">10.2)</a>    la BALtazar. cu me le ci nolraitru
    Balthazar is one-of-the-referents-of ``the three kings''.
    Balthazar is one of the three kings.
</pre>
    and likewise 
<pre>
<a id="e10d3" name="e10d3">10.3)</a>    la kaspar. cu me le ci nolraitru
    Caspar is one of the three kings.
</pre>
    and 
<pre>
<a id="e10d4" name="e10d4">10.4)</a>    la melxi,or. cu me le ci nolraitru
    Melchior is one of the three kings.
</pre>
    If the sumti refers to a single object, then the effect of
    ``me'' is much like that of ``du'': 
<pre>
<a id="e10d5" name="e10d5">10.5)</a>    do du la djan.
    You are-identical-with the-one-called ``John''.
    You are John.
</pre>
    means the same as 
<pre>
<a id="e10d6" name="e10d6">10.6)</a>    do me la djan.
    You are-the-referent-of ``the-one-called `John'''.
    You are John.
</pre>
    It is common to use ``me'' selbri, especially those based on
    name sumti using ``la'', as seltau. For example: 

    <p></p>
<pre>
<a id="e10d7" name="e10d7">10.7)</a>    ta me lai kraislr. [me'u] karce
    That (is-a-referent of ``the-mass-called `Chrysler''') car.
    That is a Chrysler car.
</pre>
    The elidable terminator ``me'u'' can usually be omitted. It is
    absolutely required only if the ``me'' selbri is being used in
    an indefinite description (a type of sumti explained in <a
    href="chapter6.html">Chapter 6</a>), and if the indefinite
    description is followed by a relative clause (explained in <a
    href="chapter8.html">Chapter 8</a>) or a sumti logical connective
    (explained in <a href="chapter14.html">Chapter 14</a>). Without a
    ``me'u'', the relative clause or logical connective would
    appear to belong to the sumti embedded in the ``me''
    expression. Here is a contrasting pair of sentences: 
<pre>
<a id="e10d8" name="e10d8">10.8)</a>    re me le ci nolraitru .e la djan. [me'u] cu blabi
    Two of the group ``the three kings and John'' are white.

<a id="e10d9" name="e10d9">10.9)</a> re me le ci nolraitru me'u .e la djan. cu blabi
    Two of the three kings, and John, are white.
</pre>

    <p>In <a href="#e10d8">Example 10.8</a> the ``me'' selbri
    covers the three kings plus John, and the indefinite
    description picks out two of them that are said to be white: we
    cannot say which two. In <a href="#e10d9">Example 10.9</a>,
    though, the ``me'' selbri covers only the three kings: two of
    them are said to be white, and so is John.</p>

    <p>Finally, here is another example requiring ``me'u'':</p>
<pre>
<a id="e10d10" name="e10d10">10.10)</a>  ta me la'e le se cusku be do me'u cukta
    That  is-a-(what-you-said) type of book.
    That is the kind of book you were talking about.
</pre>

    <p>There are other sentences where either ``me'u'' or some
    other elidable terminator must be expressed:</p>
<pre>
<a id="e10d11" name="e10d11">10.11)</a>  le me le ci nolraitru [ku] me'u nunsalci
    the (the three kings) type-of-event-of-celebrating
    the Three Kings celebration
</pre>
    requires either ``ku'' or ``me'u'' to be explicit, and (as with
    ``be'o'' in <a href="#s7">Section 7</a>) the ``me'u'' leaves no
    doubt which cmavo it is paired with. 

    <h3><a id="s11" name="s11">11. Conversion of simple selbri</h3>

    <p>Conversion is the process of changing a selbri so that its
    places appear in a different order. This is not the same as
    labeling the sumti with the cmavo of FA, as mentioned in <a
    href="#s7">Section 7</a>, and then rearranging the order in
    which the sumti are spoken or written. Conversion transforms
    the selbri into a distinct, though closely related, selbri with
    renumbered places.</p>

    <p>In Lojban, conversion is accomplished by placing a cmavo of
    selma'o SE before the selbri:</p>
<pre>
<a id="e11d1" name="e11d1">11.1)</a>    mi prami do
    I love you.
</pre>
    is equivalent in meaning to: 
<pre>
<a id="e11d2" name="e11d2">11.2)</a>    do se prami mi
    You [swap x1 and x2] love me.
    You are loved by me.
</pre>

    <p>Conversion is fully explained in <a
    href="chapter9.html">Chapter 9</a>. For the purposes of this
    chapter, the important point about conversion is that it
    applies only to the following simple selbri. When trying to
    convert a tanru, therefore, it is necessary to be careful!
    Consider <a href="#e11d3">Example 11.3</a>:</p>

    <p></p>
<pre>
<a id="e11d3" name="e11d3">11.3)</a>    la .alis. cu cadzu klama le zarci
    Alice is-a-walker type-of goer to-the market.
    Alice walkingly goes to the market.
    Alice walks to the market.
</pre>

    <p>To convert this sentence so that ``le zarci'' is in the x1
    place, one correct way is:</p>
<pre>
<a id="e11d4" name="e11d4">11.4)</a>    le zarci cu se ke cadzu klama [ke'e] la .alis.
    The market is-a-[swap x1/x2] ( walker type-of goer) Alice.
    The market is-walkingly gone-to by-Alice.
</pre>
    The ``ke ... ke'e'' brackets cause the entire tanru to be
    converted by the ``se'', which would otherwise convert only
    ``cadzu'', leading to: 
<pre>
<a id="e11d5" name="e11d5">11.5)</a>    le zarci cu se cadzu
        klama la .alis.
    The market (is-a-[swap x1/x2] walker)
        type-of goer to Alice.
    The market is-a-walking-surface type-of goer to Alice.
</pre>
    whatever that might mean. An alternative approach, since the
    place structure of ``cadzu klama'' is that of ``klama'' alone,
    is to convert only the latter: 
<pre>
<a id="e11d6" name="e11d6">11.6)</a>    le zarci cu cadzu se klama la .alis.
    The market walkingly is-gone-to by-Alice.
</pre>

    <p>But the tanru in <a href="#e11d6">Example 11.6</a> may or
    may not have the same meaning as that in <a
    href="#e11d3">Example 11.3</a>; in particular, because
    ``cadzu'' is not converted, there is a suggestion that although
    Alice is the goer, the market is the walker. With a different
    sumti as x1, this seemingly odd interpretation might make
    considerable sense:</p>
<pre>
<a id="e11d7" name="e11d7">11.7)</a>    la djan. cu cadzu se klama la .alis
    John walkingly is-gone-to by Alice
</pre>
    suggests that Alice is going to John, who is a moving target. 

    <p>There is an alternative type of conversion, using the cmavo
    ``jai'' of selma'o JAI optionally followed by a modal or tense
    construction. Grammatically, such a combination behaves exactly
    like conversion using SE. More details can be found in <a
    href="chapter9.html">Chapter 9</a>.</p>

    <h3><a id="s12" name="s12">12. Scalar negation of selbri</h3>

    <p>Negation is too large and complex a topic to explain fully
    in this chapter; see <a href="chapter15.html">Chapter 15</a>. In
    brief, there are two main types of negation in Lojban. This
    section is concerned with so-called ``scalar negation'', which
    is used to state that a true relation between the sumti is
    something other than what the selbri specifies. Scalar negation
    is expressed by cmavo of selma'o NAhE:</p>

    <p></p>
<pre>
<a id="e12d1" name="e12d1">12.1)</a>    la .alis. cu na'e ke cadzu klama [ke'e] le zarci
    Alice non- (walkingly goes) to-the market.
    Alice other-than (walkingly goes) to-the market.
    Alice doesn't walk to the market.
</pre>
    meaning that Alice's relationship to the market is something
    other than that of walking there. But if the ``ke'' were
    omitted, the result would be: 
<pre>
<a id="e12d2" name="e12d2">12.2)</a>    la .alis. cu na'e cadzu klama le zarci
    Alice non- walkingly goes to-the market.
    Alice doesn't walk to the market.
</pre>
    meaning that Alice does go there in some way (``klama'' is not
    negated), but by a means other than that of walking. <a
    href="#e12d1">Example 12.1</a> negates both ``cadzu'' and
    ``klama'', suggesting that Alice's relation to the market is
    something different from walkingly-going; it might be walking
    without going, or going without walking, or neither. 

    <p>Of course, any of the simple selbri types explained in <a
    href="#s9">Section 9</a> may be used in place of brivla in any
    of these examples:</p>
<pre>
<a id="e12d3" name="e12d3">12.3)</a>    la djonz. cu na'e pamoi cusku
    Jones is non-1st speaker
    Jones is not the first speaker.
</pre>

    <p>Since only ``pamoi'' is negated, an appropriate inference is
    that he is some other kind of speaker.</p>

    <p>Here is an assortment of more complex examples showing the
    interaction of scalar negation with ``bo'' grouping, ``ke'' and
    ``ke'e'' grouping, logical connection, and sumti linked with
    ``be'' and ``bei'':</p>

    <p></p>
<pre>
<a id="e12d4" name="e12d4">12.4)</a>    mi na'e sutra cadzu be fi le birka be'o
        klama le zarci
    I ((non-quickly) ( walking using the arms))
        go-to the market.
    I go to the market, walking using my arms
        other than quickly.
</pre>

    <p>In <a href="#e12d4">Example 12.4</a>, ``na'e'' negates only
    ``sutra''. Contrast <a href="#e12d5">Example 12.5</a>:</p>
<pre>
<a id="e12d5" name="e12d5">12.5)</a>    mi na'e ke sutra cadzu be fi le birka [be'o] ke'e
        klama le zarci
    I non- ( quickly (walking using the arms) )
        go-to the market.
    I go to the market, other than by walking
        quickly on my arms.
</pre>

    <p>Now consider <a href="#e12d6">Example 12.6</a> and <a
    href="#e12d7">Example 12.7</a>, which are equivalent in
    meaning, but use ``ke'' grouping and ``bo'' grouping
    respectively:</p>
<pre>
<a id="e12d6" name="e12d6">12.6)</a>    mi sutra cadzu be fi le birka be'o je masno
        klama le zarci
    I (quickly -- (walking using the arms) and slowly)
        go-to the market.
    I go to the market, both quickly walking
        using my arms and slowly.

<a id="e12d7" name="e12d7">12.7)</a> mi ke sutra cadzu be fi le birka [be'o] ke'e
        je masno klama le zarci
    I ((quickly (walking using the arms))
        and slowly) go-to the market.
    I go to the market, both quickly walking
        using my arms and slowly.
</pre>

    <p>However, if we place a ``na'e'' at the beginning of the
    selbri in both <a href="#e12d6">Example 12.6</a> and <a
    href="#e12d7">Example 12.7</a>, we get different results:</p>
<pre>
<a id="e12d8" name="e12d8">12.8)</a>    mi na'e sutra cadzu be fi le birka be'o
        je masno klama le zarci
    I ((non- quickly) -- (walking using the arms)
        and slowly) go-to the market.
    I go to the market, both walking using my arms
        other than quickly, and also slowly.

<a id="e12d9" name="e12d9">12.9)</a> mi na'e ke sutra cadzu be fi le birka [be'o] ke'e
        je masno klama le zarci
    I (non-(quickly (walking using the arms))
        and slowly) go-to the market.
    I go to the market, both other than quickly
        walking using my arms, and also slowly.
</pre>

    <p>The difference arises because the ``na'e'' in <a
    href="#e12d9">Example 12.9</a> negates the whole construction
    from ``ke'' to ``ke'e'', whereas in <a href="#e12d8">Example
    12.8</a> it negates ``sutra'' alone.</p>

    <p>Beware of omitting terminators in these complex examples! If
    the explicit ``ke'e'' is left out in <a href="#e12d9">Example
    12.9</a>, it is transformed into:</p>
<pre>
<a id="e12d10" name="e12d10">12.10)</a>  mi na'e ke sutra cadzu be fi le birka be'o
        je masno klama [ke'e] le zarci
    I non-(quickly ((walking using the arms))
        and slowly) go-to) the market.
    I do something other than quickly both
        going to the market walking using my arms
        and slowly going to the market.
</pre>

    <p>And if both ``ke'e'' and ``be'o'' are omitted, the results
    are even sillier:</p>
<pre>
<a id="e12d11" name="e12d11">12.11)</a>  mi na'e ke sutra cadzu be fi le birka
        je masno klama [be'o] [ke'e] le zarci
    I non-(quickly walk on my (arm-type
        and slow) goers) on the market.
    I do something other than quickly walking using the
        goers, both arm-type and slow, relative-to the market.
</pre>

    <p>In <a href="#e12d11">Example 12.11</a>, everything after
    ``be'' is a linked sumti, so the place structure is that of
    ``cadzu'', whose x2 place is the surface walked upon. It is
    less than clear what an ``arm-type goer'' might be.
    Furthermore, since the x3 place has been occupied by the linked
    sumti, the ``le zarci'' following the selbri falls into the
    nonexistent x4 place of ``cadzu''. As a result, the whole
    example, though grammatical, is complete nonsense. (The
    bracketed Lojban words appear where a fluent Lojbanist would
    understand them to be implied.)</p>

    <p>Finally, it is also possible to place ``na'e'' before a
    ``gu'e ... gi'' logically connected tanru construction. The
    meaning of this usage has not yet been firmly established.</p>

    <h3><a id="s13" name="s13">13. Tenses and bridi negation</h3>

    <p>A bridi can have cmavo associated with it which specify the
    time, place, or mode of action. For example, in</p>
<pre>
<a id="e13d1" name="e13d1">13.1)</a>    mi pu klama le zarci
    I [past] go to-the market.
    I went to the market.
</pre>
    the cmavo ``pu'' specifies that the action of the speaker going
    to the market takes place in the past. Tenses are explained in
    full detail in <a href="chapter10.html">Chapter 10</a>. Tense is
    semantically a property of the entire bridi; however, the usual
    syntax for tenses attaches them at the front of the selbri, as
    in <a href="#e13d1">Example 13.1</a>. There are alternative
    ways of expressing tense information as well. Modals, which are
    explained in <a href="chapter9.html">Chapter 9</a>, behave in the
    same way as tenses. 

    <p>Similarly, a bridi may have the particle ``na'' (of selma'o
    NA) attached to the beginning of the selbri to negate the
    bridi. A negated bridi expresses what is false without saying
    anything about what is true. Do not confuse this usage with the
    scalar negation of <a href="#s12">Section 12</a>. For
    example:</p>
<pre>
<a id="e13d2" name="e13d2">13.2)</a>    la djonz. na pamoi cusku
    Jones (Not!) is-the-first speaker
    It is not true that Jones is the first speaker.
    Jones isn't the first speaker.
</pre>

    <p>Jones may be the second speaker, or not a speaker at all; <a
    href="#e13d2">Example 13.2</a> doesn't say. There are other
    ways of expressing bridi negation as well; the topic is
    explained fully in <a href="chapter15.html">Chapter 15</a>.</p>

    <p>Various combinations of tense and bridi negation cmavo are
    permitted. If both are expressed, either order is permissible
    with no change in meaning:</p>
<pre>
<a id="e13d3" name="e13d3">13.3)</a>    mi na pu klama le zarci
    mi pu na klama le zarci
    It is false that I went to the market.
    I didn't go to the market.
</pre>
    It is also possible to have more than one ``na'', in which case
    pairs of ``na'' cmavo cancel out: 
<pre>
<a id="e13d4" name="e13d4">13.4)</a>    mi na na klama le zarci
    It is false that it is false that I go to the market.
    I go to the market.
</pre>
    It is even possible, though somewhat pointless, to have
    multiple ``na'' cmavo and tense cmavo mixed together, subject
    to the limitation that two adjacent tense cmavo will be
    understood as a compound tense, and must fit the grammar of
    tenses as explained in <a href="chapter10.html">Chapter 10</a>. 
<pre>
<a id="e13d5" name="e13d5">13.5)</a>    mi na pu na ca klama le zarci
    I [not] [past]
        [not] [present] go to-the market
    It is not the case that in the past it was not
        the case that in the present I went
        to the market.
    I didn't not go to the market.
    I went to the market.
</pre>
    Tense, modal, and negation cmavo can appear only at the
    beginning of the selbri. They cannot be embedded within it. 

    <h3><a id="s14" name="s14">14. Some types of asymmetrical tanru</h3>

    <p>This section and <a href="#s15">Section 15</a> contain some
    example tanru classified into groups based on the type of
    relationship between the modifying seltau and the modified
    tertau. All the examples are paralleled by compounds actually
    observed in various natural languages. In the tables which
    follow, each group is preceded by a brief explanation of the
    relationship. The tables themselves contain a tanru, a literal
    gloss, an indication of the languages which exhibit a compound
    analogous to this tanru, and (for those tanru with no English
    parallel) a translation.</p>

    <p>Here are the 3-letter abbreviations used for the various
    languages (it is presumed to be obvious whether a compound is
    found in English or not, so English is not explicitly
    noted):</p>

    <dl>
      <dt></dt>

      <dd>Aba = Abazin Chi = Chinese Eng = English Ewe = Ewe Fin =
      Finnish Geo = Georgian Gua = Guarani Hop = Hopi Hun =
      Hungarian Imb = Imbabura Quechua Kar = Karaitic Kaz = Kazakh
      Kor = Korean Mon = Mongolian Qab = Qabardian Que = Quechua
      Rus = Russian Skt = Sanskrit Swe = Swedish Tur = Turkish Udm
      = Udmurt</dd>
    </dl>

    <p>Any lujvo or fu'ivla used in a group are glossed at the end
    of that group.</p>

    <p>The tanru discussed in this section are asymmetrical tanru;
    that is, ones in which the order of the terms is fundamental to
    the meaning of the tanru. For example, ``junla dadylsi'', or
    ``clock pendulum'', is the kind of pendulum used in a clock,
    whereas ``dadysli junla'', or ``pendulum clock'', is the kind
    of clock that employs a pendulum. Most tanru are asymmetrical
    in this sense. Symmetrical tanru are discussed in <a
    href="#s15">Section 15</a>.</p>

    <p>The tertau represents an action, and the seltau then
    represents the object of that action:</p>

    <dl>
      <dt>pinsi kilbra</dt>

      <dd>pencil sharpener (Hun) zgike nunctu music instruction
      (Hun) mirli nunkalte deer hunting (Hun) finpe nunkalte fish
      hunting (Tur,Kor,Udm,Aba = fishing) smacu terkavbu mousetrap
      (Tur,Kor,Hun,Udm,Aba) zdani turni house ruler (Kar = host)
      zerle'a nunte'a thief fear (Skt = fear of thieves) cevni
      zekri god crime (Skt = offense against the gods) kilbra =
      sharp-apparatus nunctu = event-of-teaching nunkalte =
      event-of-hunting terkavbu = trap zerle'a = crime-taker
      nunte'a = event-of-fearing</dd>
    </dl>
    The tertau represents a set, and the seltau the type of the
    elements contained in that set: 

    <dl>
      <dt>zdani lijgri</dt>

      <dd>house row selci lamgri cell block karda mulgri card pack
      (Swe) rokci derxi stone heap (Swe) tadni girzu student group
      (Hun) remna girzu human-being group (Qab = group of people)
      cpumi'i lijgri tractor column (Qab) cevni jenmi god army
      (Skt) cevni prenu god folk (Skt) lijgri = line-group lamgri =
      adjacent-group mulgri = complete-group cpami'i =
      pull-machine</dd>
    </dl>
    Conversely: the tertau is an element, and the seltau represents
    a set in which that element is contained. Implicitly, the
    meaning of the tertau is restricted from its usual general
    meaning to the specific meaning appropriate for elements in the
    given set. Note the opposition between ``zdani linji'' in the
    previous group, and ``linji zdani'' in this one, which shows
    why this kind of tanru is called ``asymmetrical''. 

    <dl>
      <dt>carvi dirgo</dt>

      <dd>raindrop (Tur,Kor,Hun,Udm,Aba) linji zdani row house</dd>
    </dl>
    The seltau specifies an object and the tertau a component or
    detail of that object; the tanru as a whole refers to the
    detail, specifying that it is a detail of that whole and not
    some other. 

    <dl>
      <dt>junla dadysli</dt>

      <dd>clock pendulum (Hun) purdi vorme garden door (Qab) purdi
      bitmu garden wall (Que) moklu skapi mouth skin (Imb = lips)
      nazbi kevna nose hole (Imb = nostril) karce xislu automobile
      wheel (Chi) jipci pimlu chicken feather (Chi) vinji rebla
      airplane tail (Chi) dadysli = hang-oscillator</dd>
    </dl>
    Conversely: the seltau specifies a characteristic or important
    detail of the object described by the tertau; objects described
    by the tanru as a whole are differentiated from other similar
    objects by this detail. 

    <dl>
      <dt>pixra cukta</dt>

      <dd>picture book kerfa silka hair silk (Kar = velvet) plise
      tapla apple cake (Tur) dadysli junla pendulum clock (Hun)
      dadysli = hang-oscillator</dd>
    </dl>
    The tertau specifies a general class of object (a genus), and
    the seltau specifies a sub-class of that class (a species): 

    <dl>
      <dt>ckunu tricu</dt>

      <dd>pine tree (Hun,Tur,Hop)</dd>
    </dl>
    The tertau specifies an object of possession, and the seltau
    may specify the possessor (the possession may be intrinsic or
    otherwise). In English, these compounds have an explicit
    possessive element in them: ``lion's mane'', ``child's foot'',
    ``noble's cow''. 

    <dl>
      <dt>cinfo kerfa</dt>

      <dd>lion mane (Kor,Tur,Hun,Udm,Qab) verba jamfu child foot
      (Swe) nixli tuple girl leg (Swe) cinfo jamfu lion foot (Que)
      danlu skapi animal skin (Ewe) ralju zdani chief house (Ewe)
      jmive munje living world (Skt) nobli bakni noble cow (Skt)
      nolraitru ralju king chief (Skt = emperor) nolraitru =
      nobly-superlative-ruler</dd>
    </dl>
    The tertau specifies a habitat, and the seltau specifies the
    inhabitant: 

    <dl>
      <dt>lanzu tumla</dt>

      <dd>family land</dd>
    </dl>
    The tertau specifies a causative agent, and the seltau
    specifies the effect of that cause: 

    <dl>
      <dt>kalselvi'i gapci</dt>

      <dd>tear gas (Hun) terbi'a jurme disease germ (Tur) fenki
      litki crazy liquid (Hop = whisky) pinca litki urine liquid
      (Hop = beer) kalselvi'i = eye-excreted-thing terbi'a =
      disease</dd>
    </dl>
    Conversely: the tertau specifies an effect, and the seltau
    specifies its cause. 

    <dl>
      <dt>djacu barna</dt>

      <dd>water mark (Chi)</dd>
    </dl>
    The tertau specifies an instrument, and the seltau specifies
    the purpose of that instrument: 

    <dl>
      <dt>taxfu dadgreku</dt>

      <dd>garment rack (Chi) tergu'i ti'otci lamp shade (Chi) xirma
      zdani horse house (Chi = stall) nuzba tanbo news board (Chi =
      bulletin board) dadgreku = hang-frame tergu'i = source of
      illumination ti'otci = shadow-tool</dd>
    </dl>
    More vaguely: the tertau specifies an instrument, and the
    seltau specifies the object of the purpose for which that
    instrument is used: 

    <dl>
      <dt>cpina rokci</dt>

      <dd>pepper stone (Que = stone for grinding pepper) jamfu
      djacu foot water (Skt = water for washing the feet) grana
      mudri post wood (Skt = wood for making a post) moklu djacu
      mouth water (Hun = water for washing the mouth) lanme gerku
      sheep dog (dog for working sheep)</dd>
    </dl>
    The tertau specifies a product from some source, and the seltau
    specifies the source of the product: 

    <dl>
      <dt>moklu djacu</dt>

      <dd>mouth water (Aba,Qab = saliva) ractu mapku rabbit hat
      (Rus) jipci sovda chicken egg (Chi) sikcurnu silka silkworm
      silk (Chi) mlatu kalci cat feces (Chi) bifce lakse bee wax
      (Chi = beeswax) cribe rectu bear meat (Tur,Kor,Hun,Udm,Aba)
      solxrula grasu sunflower oil (Tur,Kor,Hun,Udm,Aba) bifce
      jisra bee juice (Hop = honey) tatru litki breast liquid (Hop
      = milk) kanla djacu eye water (Kor = tear) sikcurnu =
      silk-worm solxrula = solar-flower</dd>
    </dl>
    Conversely: the tertau specifies the source of a product, and
    the seltau specifies the product: 

    <dl>
      <dt>silna jinto</dt>

      <dd>salt well (Chi) kolme terkakpa coal mine (Chi) ctile
      jinto oil well (Chi) terkakpa = source of digging</dd>
    </dl>
    The tertau specifies an object, and the seltau specifies the
    material from which the object is made. This case is especially
    interesting, because the referent of the tertau may normally be
    made from just one kind of material, which is then overridden
    in the tanru. 

    <dl>
      <dt>rokci cinfo</dt>

      <dd>stone lion snime nanmu snow man (Hun) kliti cipni clay
      bird blaci kanla glass eye (Hun) blaci kanla glass eye (Que =
      spectacles) solji sicni gold coin (Tur) solji junla gold
      watch (Tur,Kor,Hun) solji djine gold ring (Udm,Aba,Que) rokci
      zdani stone house (Imb) mudri zdani wood house (Ewe = wooden
      house) rokci bitmu stone wall (Ewe) solji carce gold chariot
      (Skt) mudri xarci wood weapon (Skt = wooden weapon) cmaro'i
      dargu pebble road (Chi) sudysrasu cutci straw shoe (Chi)
      cmaro'i = small-rock sudysrasu = dry-grass</dd>
    </dl>

    <p>Note: the two senses of ``blaci kanla'' can be discriminated
    as:</p>

    <dl>
      <dt>blaci kanla bo tarmi</dt>

      <dd>glass (eye shape) = glass eye blaci kanla bo sidju glass
      (eye helper) = spectacles</dd>
    </dl>
    The tertau specifies a typical object used to measure a
    quantity and the seltau specifies something measured. The tanru
    as a whole refers to a given quantity of the thing being
    measured. English does not have compounds of this form, as a
    rule. 

    <dl>
      <dt>tumla spisa</dt>

      <dd>land piece (Tur = piece of land) tcati kabri tea cup
      (Kor,Aba = cup of tea) nanba spisa bread piece (Kor = piece
      of bread) bukpu spisa cloth piece (Udm,Aba = piece of cloth)
      djacu calkyguzme water calabash (Ewe = calabash of water)
      calkyguzme = shell-fruit, calabash</dd>
    </dl>
    The tertau specifies an object with certain implicit
    properties, and the seltau overrides one of those implicit
    properties: 

    <dl>
      <dt>kensa bloti</dt>

      <dd>spaceship bakni verba cattle child (Ewe = calf)</dd>
    </dl>
    The seltau specifies a whole, and the tertau specifies a part
    which normally is associated with a different whole. The tanru
    then refers to a part of the seltau which stands in the same
    relationship to the whole seltau as the tertau stands to its
    typical whole. 

    <dl>
      <dt>kosta degji</dt>

      <dd>coat finger (Hun = coat sleeve) denci genja tooth root
      (Imb) tricu stedu tree head (Imb = treetop)</dd>
    </dl>
    The tertau specifies the producer of a certain product, and the
    seltau specifies the product. In this way, the tanru as a whole
    distinguishes its referents from other referents of the tertau
    which do not produce the product. 

    <dl>
      <dt>silka curnu</dt>

      <dd>silkworm (Tur,Hun,Aba)</dd>
    </dl>
    The tertau specifies an object, and the seltau specifies
    another object which has a characteristic property. The tanru
    as a whole refers to those referents of the tertau which
    possess the property. 

    <dl>
      <dt>sonci manti</dt>

      <dd>soldier ant ninmu bakni woman cattle (Imb = cow) mamta
      degji mother finger (Imb = thumb) cifnu degji baby finger
      (Imb = pinky) pacraistu zdani hell house (Skt) fagri dapma
      fire curse (Skt = curse destructive as fire) pacraistu =
      evil-superlative-site</dd>
    </dl>
    As a particular case (when the property is that of
    resemblance): the seltau specifies an object which the referent
    of the tanru resembles. 

    <dl>
      <dt>grutrceraso jbama</dt>

      <dd>cherry bomb solji kerfa gold hair (Hun = golden hair)
      kanla djacu eye water (Kar = spring) bakni rokci bull stone
      (Mon = boulder) grutrceraso = fu'ivla for ``cherry'' based on
      Linnean name sorprema'e = many-person-vehicle</dd>
    </dl>
    The seltau specifies a place, and the tertau an object
    characteristically located in or at that place. 

    <dl>
      <dt>ckana boxfo</dt>

      <dd>bed sheet (Chi) mrostu mojysu'a tomb monument (Chi =
      tombstone) jubme tergusni table lamp (Chi) foldi smacu field
      mouse (Chi) briju ci'ajbu office desk (Chi) rirxe xirma river
      horse (Chi = hippopotamus) xamsi gerku sea dog (Chi = seal)
      cagyce'u zdani village house (Skt) mrostu = dead-site
      mojysu'a = remember-structure ci'ajbu = write-table cagyce'u
      = farm-community</dd>
    </dl>
    Specifically: the tertau is a place where the seltau is sold or
    made available to the public. 

    <dl>
      <dt>cidja barja</dt>

      <dd>food bar (Chi = restaurant) cukta barja book bar (Chi =
      library)</dd>
    </dl>
    The seltau specifies the locus of application of the tertau. 

    <dl>
      <dt>kanla velmikce</dt>

      <dd>eye medicine (Chi) jgalu grasu nail oil (Chi = nail
      polish) denci pesxu tooth paste (Chi) velmikce = treatment
      used by doctor</dd>
    </dl>
    The tertau specifies an implement used in the activity denoted
    by the seltau. 

    <dl>
      <dt>me la pinpan. bolci</dt>

      <dd>Ping-Pong ball (Chi)</dd>
    </dl>
    The tertau specifies a protective device against the
    undesirable features of the referent of the seltau. 

    <dl>
      <dt>carvi mapku</dt>

      <dd>rain cap (Chi) carvi taxfu rain garment (Chi = raincoat)
      vindu firgai poison mask (Chi = gas mask) firgai =
      face-cover</dd>
    </dl>
    The tertau specifies a container characteristically used to
    hold the referent of the seltau. 

    <dl>
      <dt>cukta vasru</dt>

      <dd>book vessel (Chi = satchel) vanju kabri wine cup (Chi)
      spatrkoka lanka coca basket (Que) djacu calkyzme water
      calabash (Ewe) rismi dakli rice bag (Ewe,Chi) tcati kabri tea
      cup (Chi) ladru botpi milk bottle (Chi) rismi patxu rice pot
      (Chi) festi lante trash can (Chi) bifce zdani bee house (Kor
      = beehive) cladakyxa'i zdani sword house (Kor = sheath) manti
      zdani ant nest (Gua = anthill) spatrkoka = fu'ivla for
      ``coca'' calkyzme = shell-fruit, calabash cladakyxa'i =
      (long-knife)-weapon</dd>
    </dl>
    The seltau specifies the characteristic time of the event
    specified by the tertau. 

    <dl>
      <dt>vensa djedi</dt>

      <dd>spring day (Chi) crisa citsi summer season (Chi) cerni
      bumru morning fog (Chi) critu lunra autumn moon (Chi) dunra
      nicte winter night (Chi) nicte ckule night school (Chi)</dd>
    </dl>
    The seltau specifies a source of energy for the referent of the
    tertau. 

    <dl>
      <dt>dikca tergusni</dt>

      <dd>electric lamp (Chi) ratni nejni atom energy (Chi) brife
      molki windmill (Tur,Kor,Hun,Udm,Aba) tergusni =
      illumination-source</dd>
    </dl>
    Finally, some tanru which don't fall into any of the above
    categories. 

    <dl>
      <dt>ladru denci</dt>

      <dd>milk tooth (Tur,Hun,Udm,Qab) kanla denci eye tooth</dd>
    </dl>

    <p>It is clear that ``tooth'' is being specified, and that
    ``milk'' and ``eye'' act as modifiers. However, the
    relationship between ``ladru'' and ``denci'' is something like
    ``tooth which one has when one is drinking milk from one's
    mother'', a relationship certainly present nowhere except in
    this particular concept. As for ``kanla denci'', the
    relationship is not only not present on the surface, it is
    hardly possible to formulate it at all.</p>

    <h3><a id="s15" name="s15">15. Some types of symmetrical tanru</h3>

    <p>This section deals with symmetrical tanru, where order is
    not important. Many of these tanru can be expressed with a
    logical or non-logical connective between the components.</p>

    <p>The tanru may refer to things which are correctly specified
    by both tanru components. Some of these instances may also be
    seen as asymmetrical tanru where the seltau specifies a
    material. The connective ``je'' is appropriate:</p>

    <dl>
      <dt>cipnrstrigi pacru'i</dt>

      <dd>owl demon (Skt) nolraitru prije royal sage (Skt) remna
      nakni human-being male (Qab = man) remna fetsi human-being
      female (Qab = woman) sonci tolvri soldier coward (Que) panzi
      nanmu offspring man (Ewe = son) panzi ninmu offspring woman
      (Ewe = daughter) solji sicni gold coin (Tur) solji junla gold
      watch (Tur,Kor,Hun) solji djine gold ring (Udm,Aba,Que) rokci
      zdani stone house (Imb) mudri zdani wooden house (Ewe) rokci
      bitmu stone wall (Ewe) solji carce gold chariot (Skt) mudri
      xarci wooden weapon (Skt) zdani tcadu home town (Chi)
      cipnrstrigi = fu'ivla for ``owl'' based on Linnean name
      pacru'i = evil-spirit tolvri = opposite-of-brave</dd>
    </dl>
    The tanru may refer to all things which are specified by either
    of the tanru components. The connective ``ja'' is appropriate: 

    <dl>
      <dt>nunji'a nunterji'a</dt>

      <dd>victory defeat (Skt = victory or defeat) donri nicte day
      night (Skt = day and night) lunra tarci moon stars (Skt =
      moon and stars) patfu mamta father mother (Imb,Kaz,Chi =
      parents) tuple birka leg arm (Kaz = extremity) nuncti
      nunpinxe eating drinking (Udm = cuisine) bersa tixnu son
      daughter (Chi = children) nunji'a = event-of-winning
      nunterji'a = event-of-losing nuncti = event-of-eating
      nunpinxe = event-of-drinking</dd>
    </dl>
    Alternatively, the tanru may refer to things which are
    specified by either of the tanru components or by some more
    inclusive class of things which the components typify: 

    <dl>
      <dt>curnu jalra</dt>

      <dd>worm beetle (Mon = insect) jalra curnu beetle worm (Mon =
      insect) kabri palta cup plate (Kaz = crockery) jipci gunse
      hen goose (Qab = housefowl) xrula tricu flower tree (Chi =
      vegetation)</dd>
    </dl>
    The tanru components specify crucial or typical parts of the
    referent of the tanru as a whole: 

    <dl>
      <dt>tumla vacri</dt>

      <dd>land air (Fin = world) moklu stedu mouth head (Aba =
      face) sudysrasu cunmi hay millet (Qab = agriculture) gugde
      ciste state system (Mon = politics) prenu so'imei people
      multitude (Mon = masses) djacu dertu water earth (Chi =
      climate) sudysrasu = dry-grass so'imei = manysome</dd>
    </dl>

    <h3><a id="s16" name="s16">16. ``Pretty little girls' school'': forty ways to say
    it</h3>

    <p>The following examples show every possible grouping
    arrangement of ``melbi cmalu nixli ckule'' using ``bo'' or ``ke
    ... ke'e'' for grouping and ``je'' or ``jebo'' for logical
    connection. Most of these are definitely not plausible
    interpretations of the English phrase ``pretty little girls'
    school'', especially those which describe something which is
    both a girl and a school.</p>

    <p>Examples 4.2, 4.3, 4.4, 4.5, and 5.6 are repeated here as
    Examples 16.1, 16.9, 16.17, 16.25, and 16.33 respectively. The
    seven examples following each of these share the same grouping
    pattern, but differ in the presence or absence of ``je'' at
    each possible site. Some of the examples have more than one
    Lojban version. In that case, they differ only in grouping
    mechanism, and are always equivalent in meaning.</p>

    <p>The logical connective ``je'' is associative: that is, ``A
    and (B and C)'' is the same as ``(A and B) and C''. Therefore,
    some of the examples have the same meaning as others. In
    particular, 16.8, 16.16, 16.24, 16.32, and 16.40 all have the
    same meaning because all four brivla are logically connected
    and the grouping is simply irrelevant. Other equivalent forms
    are noted in the examples themselves. However, if ``je'' were
    replaced by ``naja'' or ``jo'' or most of the other logical
    connectives, the meanings would become distinct.</p>

    <p>It must be emphasized that, because of the ambiguity of all
    tanru, the English translations are by no means definitive ---
    they represent only one possible interpretation of the
    corresponding Lojban sentence.</p>
<pre>
<a id="e16d1" name="e16d1">16.1)</a>    melbi cmalu nixli ckule
    ((pretty type-of little) type-of girl) type-of school
    school for girls who are beautifully small

<a id="e16d2" name="e16d2">16.2)</a> melbi je cmalu nixli ckule
    ((pretty and little) type-of girl) type-of school
    school for girls who are beautiful and small

<a id="e16d3" name="e16d3">16.3)</a> melbi bo cmalu je nixli ckule
    ((pretty type-of little) and girl) type-of school
    school for girls and for beautifully small things

<a id="e16d4" name="e16d4">16.4)</a> ke melbi cmalu nixli ke'e je ckule
    ((pretty type-of little) type-of girl) and school
    thing which is a school and a beautifully small girl

<a id="e16d5" name="e16d5">16.5)</a> melbi je cmalu je nixli ckule
    ((pretty and little) and girl) type-of school
    school for things which are beautiful, small, and girls
    Note: same as 16.21

<a id="e16d6" name="e16d6">16.6)</a> melbi bo cmalu je nixli je ckule
    ((pretty type-of little) and girl) and school
    thing which is beautifully small, a school, and a girl
    Note: same as 16.14

<a id="e16d7" name="e16d7">16.7)</a> ke melbi je cmalu nixli ke'e je ckule
    ((pretty and little) type-of girl) and school
    thing which is a school and a girl who is both
        beautiful and small

<a id="e16d8" name="e16d8">16.8)</a> melbi je cmalu je nixli je ckule
    ((pretty and little) and girl) and school
    thing which is beautiful, small, a girl, and a school

<a id="e16d9" name="e16d9">16.9)</a> melbi cmalu nixli bo ckule
    (pretty type-of little) type-of (girl type-of school)
    girls' school which is beautifully small

<a id="e16d10" name="e16d10">16.10)</a>   melbi je cmalu nixli bo ckule
    (pretty and little) type-of (girl type-of school)
    girls' school which is beautiful and small

<a id="e16d11" name="e16d11">16.11)</a>   melbi cmalu nixli je ckule
    (pretty type-of little) type-of (girl and school)
    something which is a girl and a school
        which is beautifully small

<a id="e16d12" name="e16d12">16.12)</a>   melbi bo cmalu je nixli bo ckule
    (pretty type-of little) and (girl type-of school)
    something which is beautifully small and a girls' school

<a id="e16d13" name="e16d13">16.13)</a>   melbi je cmalu nixli je ckule
    (pretty and little) type-of (girl and school)
    a pretty and little type of thing which is
        both a girl and a school

<a id="e16d14" name="e16d14">16.14)</a>   melbi bo cmalu je nixli jebo ckule
    (pretty type-of little) and (girl and school)
    thing which is beautifully small, a school, and a girl
    Note: same as 16.6

<a id="e16d15" name="e16d15">16.15)</a>   melbi jebo cmalu je nixli bo ckule
    (pretty and little) and (girl type-of school)
    thing which is beautiful and small and a girl's school
    Note: same as 16.30

<a id="e16d16" name="e16d16">16.16)</a>   melbi jebo cmalu je nixli jebo ckule
    (pretty and little) and (girl and school)
    thing which is beautiful, small, a girl, and a school

<a id="e16d17" name="e16d17">16.17)</a>   melbi cmalu bo nixli ckule
    (pretty type-of (little type-of girl)) type-of school
    school for beautiful girls who are small

<a id="e16d18" name="e16d18">16.18)</a>   melbi cmalu je nixli ckule
    (pretty type-of (little and girl)) type-of school
    school for beautiful things which are small and are girls

<a id="e16d19" name="e16d19">16.19)</a>   melbi je cmalu bo nixli ckule
    (pretty and (little type-of girl)) type-of school
    school for things which are beautiful and are small girls

<a id="e16d20" name="e16d20">16.20)</a>   ke melbi cmalu bo nixli ke'e je ckule
    melbi bo cmalu bo nixli je ckule
    (pretty type-of (little type-of girl)) and school
    thing which is a school and a small girl who is beautiful

<a id="e16d21" name="e16d21">16.21)</a>   melbi je cmalu jebo nixli ckule
    (pretty and (little and girl)) type-of school
    school for things which are beautiful, small, and girls
    Note: same as 16.5

<a id="e16d22" name="e16d22">16.22)</a>   melbi je cmalu bo nixli je ckule
    (pretty and (little type-of girl)) and school
    thing which is beautiful, a small girl, and a school
    Note: same as 16.38

<a id="e16d23" name="e16d23">16.23)</a>   ke melbi cmalu je nixli ke'e je ckule
    (pretty type-of (little and girl)) and school
    thing which is beautifully small, a beautiful girl,
        and a school

<a id="e16d24" name="e16d24">16.24)</a>   melbi je cmalu jebo nixli je ckule
    (pretty and (little and girl)) and school
    thing which is beautiful, small, a girl, and a school

<a id="e16d25" name="e16d25">16.25)</a>   melbi cmalu bo nixli bo ckule
    melbi ke cmalu ke nixli ckule [ke'e] [ke'e]
    pretty type-of (little type-of (girl type-of school))
    small school for girls which is beautiful

<a id="e16d26" name="e16d26">16.26)</a>   melbi ke cmalu nixli je ckule [ke'e]
    pretty type-of (little type-of (girl and school))
    small thing, both a girl and a school, which is beautiful

<a id="e16d27" name="e16d27">16.27)</a>   melbi cmalu je nixli bo ckule
    pretty type-of (little and (girl type-of school))
    thing which is beautifully small
        and a girls' school that is beautiful

<a id="e16d28" name="e16d28">16.28)</a>   melbi je cmalu bo nixli bo ckule
    melbi je ke cmalu nixli bo ckule [ke'e]
    melbi je ke cmalu ke nixli ckule [ke'e] [ke'e]
    pretty and (little type-of (girl type-of school))
    thing which is beautiful and a small type of
        girls' school

<a id="e16d29" name="e16d29">16.29)</a>   melbi cmalu je nixli jebo ckule
    melbi cmalu je ke nixli je ckule [ke'e]
    pretty type-of (little and (girl and school))
    thing which is beautifully small, a beautiful girl,
        and a beautiful school
    Note: same as 16.37

<a id="e16d30" name="e16d30">16.30)</a>   melbi je cmalu jebo nixli bo ckule
    melbi je ke cmalu je nixli bo ckule [ke'e]
    pretty and (little and (girl type-of school))
    thing which is beautiful, small and a girls' school
    Note: same as 16.15

<a id="e16d31" name="e16d31">16.31)</a>   melbi je ke cmalu nixli je ckule [ke'e]
    pretty and (little type-of (girl and school))
    beautiful thing which is a small girl and a small school

<a id="e16d32" name="e16d32">16.32)</a>   melbi jebo cmalu jebo nixli jebo ckule
    pretty and (little and (girl and school))
    thing which is beautiful, small, a girl, and a school

<a id="e16d33" name="e16d33">16.33)</a>   melbi ke cmalu nixli ckule [ke'e]
    pretty type-of ((little type-of girl) type-of school)
    beautiful school for small girls

<a id="e16d34" name="e16d34">16.34)</a>   melbi ke cmalu je nixli ckule [ke'e]
    pretty type-of ((little and girl) type-of school
    beautiful school for things which are small
        and are girls

<a id="e16d35" name="e16d35">16.35)</a>   melbi ke cmalu bo nixli je ckule [ke'e]
    pretty type-of ((little type-of girl) and school)
    beautiful thing which is a small girl and a school

<a id="e16d36" name="e16d36">16.36)</a>   melbi je ke cmalu nixli ckule [ke'e]
    pretty and ((little type-of girl) type-of school)
    thing which is beautiful and a school for small girls

<a id="e16d37" name="e16d37">16.37)</a>   melbi cmalu je nixli je ckule
    pretty type-of ((little and girl) and school)
    thing which is beautifully small, a beautiful girl,
        and a beautiful school
    Note: same as 16.29

<a id="e16d38" name="e16d38">16.38)</a>   melbi je ke cmalu bo nixli je ckule [ke'e]
    pretty and ((little type-of girl) and school)
    thing which is beautiful, a small girl and a school
    Note: same as 16.22

<a id="e16d39" name="e16d39">16.39)</a>   melbi je ke cmalu je nixli ckule [ke'e]
    pretty and ((little and girl) type-of school)
    thing which is beautiful and is a small school
        and a girls' school

<a id="e16d40" name="e16d40">16.40)</a>   melbi je ke cmalu je nixli je ckule [ke'e]
    pretty and ((little and girl) and school)
    thing which is beautiful, small, a girl, and a school
</pre>

    <hr />
    
    <p>Última modificación: Mon Jun 27 23:11:02 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
