
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//SV" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="sv" lang="sv">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 6</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter6.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 6<br />
      To Speak Of Many Things: The Lojban sumti</h2>

      <!--
      <h6>Revision: 4.1<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. The five kinds of simple sumti</h3>

    <p>If you understand anything about Lojban, you know what a
    sumti is by now, right? An argument, one of those things that
    fills the places of simple Lojban sentences like:</p>
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  mi klama le zarci
    I go-to the market
</pre>
    In <a href="#e1d1">Example 1.1</a>, ``mi'' and ``le zarci'' are
    the sumti. It is easy to see that these two sumti are not of
    the same kind: ``mi'' is a pro-sumti (the Lojban analogue of a
    pronoun) referring to the speaker, whereas ``le zarci'' is a
    description which refers to something described as being a
    market. 

    <p>There are five kinds of simple sumti provided by Lojban:</p>

    <p></p>

    <dl>
      <dt>1)</dt>

      <dd>descriptions like ``le zarci'', which usually begin with
      a descriptor (called a ``gadri'' in Lojban) such as
      ``le'';</dd>
    </dl>

    <dl>
      <dt>2)</dt>

      <dd>pro-sumti, such as ``mi'';</dd>
    </dl>

    <dl>
      <dt>3)</dt>

      <dd>names, such as ``la lojban.'', which usually begin with
      ``la'';</dd>
    </dl>

    <dl>
      <dt>4)</dt>

      <dd>quotations, which begin with ``lu'', ``le'u'', ``zo'', or
      ``zoi'';</dd>
    </dl>

    <dl>
      <dt>5)</dt>

      <dd>pure numbers, which usually begin with ``li''.</dd>
    </dl>

    <p>Here are a few examples of each kind of sumti:</p>

    <p></p>
<pre>
<a id="e1d2" name="e1d2">1.2)</a>  e'osai ko sarji la lojban.
    Please support Lojban!
</pre>
    <a href="#e1d2">Example 1.2</a> exhibits ``ko'', a pro-sumti;
    and ``la lojban.'', a name. 

    <p></p>
<pre>
<a id="e1d3" name="e1d3">1.3)</a>  mi cusku lu e'osai li'u le tcidu
    I express ``Please!'' to-the reader.
</pre>
    <a href="#e1d3">Example 1.3</a> exhibits ``mi'', a pro-sumti;
    ``lu e'osai li'u'', a quotation; and ``le tcidu'', a
    description. 

    <p></p>
<pre>
<a id="e1d4" name="e1d4">1.4)</a>  ti mitre li ci
    This measures-in-meters the-number three.
    This is three meters long.
</pre>
    <a href="#e1d4">Example 1.4</a> exhibits ``ti'', a pro-sumti;
    and ``li ci'', a number. 

    <p>Most of this chapter is about descriptions, as they have the
    most complicated syntax and usage. Some attention is also given
    to names, which are closely interwoven with descriptions.
    Pro-sumti, numbers, and quotations are described in more detail
    in <a href="chapter7.html">Chapter 7</a>, <a
    href="chapter18.html">Chapter 18</a>, and <a
    href="chapter19.html">Chapter 19</a> respectively, so this chapter
    only gives summaries of their forms and uses. See <a
    href="#s13">Section 13</a> through <a href="#s15">Section
    15</a> for these summaries.</p>

    <h3><a id="s2" name="s2">2. The three basic description types</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   le  LE  the, the one(s) described as
    lo  LE  some, some of those which really are
    la  LA  the one(s) named
    ku  KU  elidable terminator for LE, LA
</pre>
    The syntax of descriptions is fairly complex, and not all of it
    can be explained within the confines of this chapter: relative
    clauses, in particular, are discussed in <a
    href="chapter8.html">Chapter 8</a>. However, most descriptions
    have just two components: a descriptor belonging to selma'o LE
    or LA, and a selbri. (The difference between selma'o LE and
    selma'o LA is not important until <a href="#s12">Section
    12</a>.) Furthermore, the selbri is often just a single brivla.
    Here is an elementary example: 
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  le zarci
    one-or-more-specific-things-each-of-which-
        I-describe-as being-a-market
    the market
</pre>
    The long gloss for ``le'' is of course far too long to use most
    of the time, and in fact ``le'' is quite close in meaning to
    English ``the''. It has particular implications, however, which
    ``the'' does not have. 

    <p>The general purpose of all descriptors is to create a sumti
    which might occur in the x1 place of the selbri belonging to
    the description. Thus ``le zarci'' conveys something which
    might be found in the x1 place of ``zarci'', namely a
    market.</p>

    <p>The specific purpose of ``le'' is twofold. First, it
    indicates that the speaker has one or more specific markets in
    mind (whether or not the listener knows which ones they are).
    Second, it also indicates that the speaker is merely describing
    the things he or she has in mind as markets, without being
    committed to the truth of that description.</p>
<pre>
<a id="e2d2" name="e2d2">2.2)</a>  le zarci
        cu barda
    one-or-more-specific-things-which-I-describe as ``markets''
        is/are-big.
    The market is big.
    The markets are big.
</pre>
    Note that English-speakers must state whether a reference to
    markets is to just one (``the market'') or to more than one
    (``the markets''). Lojban requires no such forced choice, so
    both colloquial translations of <a href="#e2d2">Example 2.2</a>
    are valid. Only the context can specify which is meant. (This
    rule does not mean that Lojban has no way of specifying the
    number of markets in such a case: that mechanism is explained
    in <a href="#s7">Section 7</a>.) 

    <p>Now consider the following strange-looking example:</p>
<pre>
<a id="e2d3" name="e2d3">2.3)</a>  le nanmu cu ninmu
    one-or-more-specific-things-which-I-describe as ``men''
        are women
    The man is a woman.
    The men are women.
</pre>
    <a href="#e2d3">Example 2.3</a> is not self-contradictory in
    Lojban, because ``le nanmu'' merely means something or other
    which, for my present purposes, I choose to describe as a man,
    whether or not it really is a man. A plausible instance would
    be: someone we had assumed to be a man at a distance turned out
    to be actually a woman on closer observation. <a
    href="#e2d3">Example 2.3</a> is what I would say to point out
    my observation to you. 

    <p>In all descriptions with ``le'', the listener is presumed to
    either know what I have in mind or else not to be concerned at
    present (perhaps I will give more identifying details later).
    In particular, I might be pointing at the supposed man or men:
    <a href="#e2d3">Example 2.3</a> would then be perfectly
    intelligible, since ``le nanmu'' merely clarifies that I am
    pointing at the supposed man, not at a landscape, or a nose,
    which happens to lie in the same direction.</p>

    <p>The second descriptor dealt with in this section is ``lo''.
    Unlike ``le'', ``lo'' is nonspecific:</p>
<pre>
<a id="e2d4" name="e2d4">2.4)</a>  lo zarci
    one-or-more-of-all-the-things-which-really are-markets
    a market
    some markets
</pre>
    Again, there are two colloquial English translations. The
    effect of using ``lo'' in <a href="#e2d4">Example 2.4</a> is to
    refer generally to one or more markets, without being specific
    about which. Unlike ``le zarci'', ``lo zarci'' must refer to
    something which actually is a market (that is, which can appear
    in the x1 place of a truthful bridi whose selbri is ``zarci'').
    Thus 

    <dl>
      <dt>2.5</dt>

      <dd>lo nanmu cu ninmu Some man is a woman. Some men are
      women.</dd>
    </dl>
    must be false in Lojban, given that there are no objects in the
    real world which are both men and women. Pointing at some
    specific men or women would not make <a href="#e2d5">Example
    2.5</a> true, because those specific individuals are no more
    both-men-and-women than any others. In general, ``lo'' refers
    to whatever individuals meet its description. 

    <p>The last descriptor of this section is ``la'', which
    indicates that the selbri which follows it has been dissociated
    from its normal meaning and is being used as a name. Like
    ``le'' descriptions, ``la'' descriptions are implicitly
    restricted to those I have in mind. (Do not confuse this use of
    ``la'' with its use before regular Lojbanized names, which is
    discussed in <a href="#s12">Section 12</a>.) For example:</p>

    <p></p>
<pre>
<a id="e2d6" name="e2d6">2.6)</a>  la cribe pu finti le lisri
    the-one-named ``bear'' [past] creates the story.
    Bear wrote the story.
</pre>
    In <a href="#e2d6">Example 2.6</a>, ``la cribe'' refers to
    someone whose naming predicate is ``cribe'', i.e. ``Bear''. In
    English, most names don't mean anything, or at least not
    anything obvious. The name ``Frank'' coincides with the English
    word ``frank'', meaning ``honest'', and so one way of
    translating ``Frank ate some cheese'' into Lojban would be: 
<pre>
<a id="e2d7" name="e2d7">2.7)</a>  la stace pu citka lo cirla
    The-one-called ``Honest/Frank'' [past] eats some cheese.
</pre>

    <p>English-speakers typically would not do this, as we tend to
    be more attached to the sound of our names than their meaning,
    even if the meaning (etymological or current) is known.
    Speakers of other languages may feel differently. (In point of
    fact, ``Frank'' originally meant ``the free one'' rather than
    ``the honest one''.)</p>

    <p>It is important to note the differences between <a
    href="#e2d6">Example 2.6</a> and the following:</p>
<pre>
<a id="e2d8" name="e2d8">2.8)</a>  le cribe pu finti le lisri
    One-or-more-specific-things-which-I-describe-as a-bear
        [past] creates the story.
    The bear(s) wrote the story.
</pre>
<pre>
<a id="e2d9" name="e2d9">2.9)</a>  lo cribe pu finti le lisri
    One-or-more-of-the-things-which-really are-bears
        [past] creates the story.
    A bear wrote the story.
    Some bears wrote the story.
</pre>
    <a href="#e2d8">Example 2.8</a> is about a specific bear or
    bearlike thing(s), or thing(s) which the speaker (perhaps
    whimsically or metaphorically) describes as a bear (or more
    than one); <a href="#e2d9">Example 2.9</a> is about one or more
    of the really existing, objectively defined bears. In either
    case, though, each of them must have contributed to the writing
    of the story, if more than one bear (or ``bear'') is meant. 

    <p>(The notion of a ``really existing, objectively defined
    bear'' raises certain difficulties. Is a panda bear a ``real
    bear''? How about a teddy bear? In general, the answer is
    ``yes''. Lojban gismu are defined as broadly as possible,
    allowing tanru and lujvo to narrow down the definition. There
    probably are no necessary and sufficient conditions for
    defining what is and what is not a bear that can be pinned down
    with complete precision: the real world is fuzzy. In borderline
    cases, ``le'' may communicate better than ``lo''.)</p>

    <p>So while <a href="#e2d6">Example 2.6</a> could easily be
    true (there is a real writer named ``Greg Bear''), and <a
    href="#e2d8">Example 2.8</a> could be true if the speaker is
    sufficiently peculiar in what he or she describes as a bear, <a
    href="#e2d9">Example 2.9</a> is certainly false.</p>

    <p>Similarly, compare the following two examples, which are
    analogous to <a href="#e2d8">Example 2.8</a> and <a
    href="#e2d9">Example 2.9</a> respectively:</p>

    <p></p>
<pre>
<a id="e2d10" name="e2d10">2.10)</a>    le remna pu finti le lisri
    The human being(s) wrote the story.

<a id="e2d11" name="e2d11">2.11)</a> lo remna pu finti le lisri
    A human being wrote the story.
    Some human beings wrote the story.
</pre>
    <a href="#e2d10">Example 2.10</a> says who the author of the
    story is: one or more particular human beings that the speaker
    has in mind. If the topic of conversation is the story, then <a
    href="#e2d10">Example 2.10</a> identifies the author as someone
    who can be pointed out or who has been previously mentioned;
    whereas if the topic is a person, then ``le remna'' is in
    effect a shorthand reference to that person. <a
    href="#e2d11">Example 2.11</a> merely says that the author is
    human. 

    <p>The elidable terminator for all descriptions is ``ku''. It
    can almost always be omitted with no danger of ambiguity. The
    main exceptions are in certain uses of relative clauses, which
    are discussed in <a href="chapter8.html">Chapter 8</a>, and in the
    case of a description immediately preceding the selbri. In this
    latter case, using an explicit ``cu'' before the selbri makes
    the ``ku'' unnecessary. There are also a few other uses of
    ``ku'': in the compound negator ``naku'' (discussed in <a
    href="chapter15.html">Chapter 15</a>) and to terminate
    place-structure, tense, and modal tags that do not have
    associated sumti (discussed in <a href="chapter9.html">Chapter
    9</a> and <a href="chapter10.html">Chapter 10</a>).</p>

    <h3><a id="s3" name="s3">3. Individuals and masses</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   lei LE  the mass I describe as
    loi LE  part of the mass of those which really are
    lai LA  the mass of those named
</pre>
    All Lojban sumti are classified by whether they refer to one of
    three types of objects, known as ``individuals'', ``masses'',
    and ``sets''. The term ``individual'' is misleading when used
    to refer to more than one object, but no less-confusing term
    has as yet been found. All the descriptions in <a
    href="#s1">Sections 1</a> and <a href="#s2">2</a> refer to
    individuals, whether one or more than one. Consider the
    following example: 
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  le prenu cu bevri le pipno
    One-or-more-of-those-I-describe-as persons
        carry the piano.
    The person(s) carry the piano.
</pre>
    (Of course the second ``le'' should really get the same
    translation as the first, but I am putting the focus of this
    discussion on the first ``le'', the one preceding ``prenu''. I
    will assume that there is only one piano under discussion.) 

    <p>Suppose the context of <a href="#e3d1">Example 3.1</a> is
    such that you can determine that I am talking about three
    persons. What am I claiming? I am claiming that each of the
    three persons carried the piano. This claim can be true if the
    persons carried the piano one at a time, or in turns, or in a
    variety of other ways. But in order for <a href="#e3d1">Example
    3.1</a> to be true, I must be willing to assert that person 1
    carried the piano, and that person 2 carried the piano, and
    that person 3 carried the piano.</p>

    <p>But suppose I am not willing to claim that. For in fact
    pianos are heavy, and very few persons can carry a piano all by
    themselves. The most likely factual situation is that person 1
    carried one end of the piano, and person 2 the other end, while
    person 3 either held up the middle or else supervised the whole
    operation without actually lifting anything. The correct way of
    expressing such a situation in Lojban is:</p>

    <p></p>
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  lei prenu cu bevri le pipno
    The-mass-of-one-or-more-of-those-I-describe-as persons
        carry the piano.
</pre>
    Here the same three persons are treated not as individuals, but
    as a so-called ``mass entity'', or just ``mass''. A mass has
    the properties of each individual which composes it, and may
    have other properties of its own as well. This can lead to
    apparent contradictions. Thus suppose in the piano-moving
    example above that person 1 has fair skin, whereas person 2 has
    dark skin. Then it is correct to say that the person-mass has
    both fair skin and dark skin. Using the mass descriptor ``lei''
    signals that ordinary logical reasoning is not applicable:
    contradictions can be maintained, and all sorts of other
    peculiarities may exist. However, we can safely say that a mass
    inherits only the component properties that are relevant to it;
    it would be ludicrous to say that a mass of two persons is of
    molecular dimensions, simply because some of the parts (namely,
    the molecules) of the persons are that small. 

    <p>The descriptors ``loi'' and ``lai'' are analogous to ``lo''
    and ``la'' respectively, but refer to masses either by property
    (``loi'') or by name (``lai''). A classic example of ``loi''
    use is:</p>

    <p></p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  loi cinfo cu xabju le fi'ortu'a
    part-of-the-mass-of-those-which-really are-lions
        dwell in-the African-land.
    The lion dwells in Africa.
    Lions dwell in Africa.
</pre>
    The difference between ``lei'' and ``loi'' is that ``lei
    cinfo'' refers to a mass of specific individuals which the
    speaker calls lions, whereas ``loi cinfo'' refers to some part
    of the mass of all those individuals which actually are lions.
    The restriction to ``some part of the mass'' allows statements
    like <a href="#e3d3">Example 3.3</a> to be true even though
    some lions do not dwell in Africa --- they live in various zoos
    around the world. On the other hand, <a href="#e3d3">Example
    3.3</a> doesn't actually say that most lions live in Africa:
    equally true is 

    <p></p>
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  loi glinanmu cu xabju le fi'ortu'a
    part-of-the-mass-of-those-which-really are-English-men
        dwell in-the African-land.
    The Englishman dwells in Africa.
</pre>
    since there is at least one Englishman living there. <a
    href="#s4">Section 4</a> explains another method of saying what
    is usually meant by ``The lion lives in Africa'' which does
    imply that living in Africa is normal, not exceptional, for
    lions. 

    <p>Note that the Lojban mass articles are sometimes translated
    by English plurals (the most usual case), sometimes by English
    singulars (when the singular is used to express typicalness or
    abstraction), and sometimes by singulars with no article:</p>

    <p></p>
<pre>
<a id="e3d5" name="e3d5">3.5)</a>  loi matne cu ranti
    part-of-the-mass-of-that-which-really
        is-a-quantity-of-butter is-soft.
    Butter is soft.
</pre>
    Of course, some butter is hard (for example, if it is frozen
    butter), so the ``part-of'' implication of ``loi'' becomes once
    again useful. The reason this mechanism works is that the
    English words like ``butter'', which are seen as already
    describing masses, are translated in Lojban by non- mass forms.
    The place structure of ``matne'' is ``x1 is a quantity of
    butter from source x2'', so the single English word ``butter''
    is translated as something like ``a part of the mass formed
    from all the quantities of butter that exist''. (Note that the
    operation of forming a mass entity does not imply, in Lojban,
    that the components of the mass are necessarily close to one
    another or even related in any way other than conceptually.
    Masses are formed by the speaker's intention to form a mass,
    and can in principle contain anything.) 

    <p>The mass name descriptor ``lai'' is used in circumstances
    where we wish to talk about a mass of things identified by a
    name which is common to all of them. It is not used to identify
    a mass by a single name peculiar to it. Thus the mass version
    of <a href="#e2d5">Example 2.5</a>,</p>

    <p></p>
<pre>
<a id="e3d6" name="e3d6">3.6)</a>  lai cribe pu finti
        le vi cukta
    the-mass-of-those-named ``bear'' [past] creates
        the nearby book.
    The Bears wrote this book.
</pre>
    in a context where ``la cribe'' would be understood as plural,
    would mean that either Tom Bear or Fred Bear (to make up some
    names) might have written the book, or that Tom and Fred might
    have written it as collaborators. Using ``la'' instead of
    ``lai'' in <a href="#e3d6">Example 3.6</a> would give the
    implication that each of Tom and Fred, considered individually,
    had written it. 

    <h3><a id="s4" name="s4">4. Masses and sets</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   le'i    LE  the set described as
    lo'i    LE  the set of those which really are
    la'i    LA  the set of those named
</pre>
    Having said so much about masses, let us turn to sets. Sets are
    easier to understand than masses, but are more rarely used.
    Like a mass, a set is an abstract object formed from a number
    of individuals; however, the properties of a set are not
    derived from any of the properties of the individuals that
    compose it. 

    <p>Sets have properties like cardinality (how many elements in
    the set), membership (the relationship between a set and its
    elements), and set inclusion (the relationship between two
    sets, one of which --- the superset -- contains all the
    elements of the other --- the subset). The set descriptors
    ``le'i'', ``lo'i'' and ``la'i'' correspond exactly to the mass
    descriptors ``lei'', ``loi'', and ``lai'' except that normally
    we talk of the whole of a set, not just part of it. Here are
    some examples contrasting ``lo'', ``loi'', and ``lo'i'':</p>

    <p></p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  lo ratcu cu bunre
    one-or-more-of-those-which-really-are rats are-brown.
    Some rats are brown.

<a id="e4d2" name="e4d2">4.2)</a>   loi ratcu
        cu cmalu
    part-of-the-mass-of-those-which-really-are rats
        are-small.
    Rats are small.

<a id="e4d3" name="e4d3">4.3)</a>   lo'i ratcu cu barda
    The-set-of rats is-large.
    There are a lot of rats.
</pre>

    <p>The mass of rats is small because at least one rat is small;
    the mass of rats is also large; the set of rats, though, is
    unquestionably large -- it has billions of members. The mass of
    rats is also brown, since some of its components are; but it
    would be incorrect to call the set of rats brown --- brown-ness
    is not the sort of property that sets possess.</p>

    <p>Lojban speakers should generally think twice before
    employing the set descriptors. However, certain predicates have
    places that require set sumti to fill them. For example, the
    place structure of ``fadni'' is:</p>

    <dl>
      <dt></dt>

      <dd>x1 is ordinary/common/typical/usual in property x2 among
      the members of set x3</dd>
    </dl>

    <p>Why is it necessary for the x3 place of ``fadni'' to be a
    set? Because it makes no sense for an individual to be typical
    of another individual: an individual is typical of a group. In
    order to make sure that the bridi containing ``fadni'' is about
    an entire group, its x3 place must be filled with a set:</p>

    <p></p>
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  mi fadni fi lo'i lobypli
    I am-ordinary among the-set-of Lojban-users.
    I am a typical Lojban user.
</pre>

    <p>Note that the x2 place has been omitted; I am not specifying
    in exactly which way I am typical --- whether in language
    knowledge, or age, or interests, or something else. If ``lo'i''
    were changed to ``lo'' in <a href="#e4d4">Example 4.4</a>, the
    meaning would be something like ``I am typical of some Lojban
    user'', which is nonsense.</p>

    <h3><a id="s5" name="s5">5. Descriptors for typical objects</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   lo'e    LE  the typical
    le'e    LE  the stereotypical
</pre>
    As promised in <a href="#s3">Section 3</a>, Lojban has a method
    for discriminating between ``the lion'' who lives in Africa and
    ``the Englishman'' who, generally speaking, doesn't live in
    Africa even though some Englishmen do. The descriptor ``lo'e''
    means ``the typical'', as in 

    <p></p>
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  lo'e cinfo cu xabju le fi'ortu'a
    The-typical lion dwells-in the African-land.
    The lion dwells in Africa.
</pre>
    What is this ``typical lion''? Surely it is not any particular
    lion, because no lion has all of the ``typical''
    characteristics, and (worse yet) some characteristics that all
    real lions have can't be viewed as typical. For example, all
    real lions are either male or female, but it would be bizarre
    to suppose that the typical lion is either one. So the typical
    lion has no particular sex, but does have a color (golden
    brown), a residence (Africa), a diet (game), and so on.
    Likewise we can say that 

    <p></p>
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  lo'e glinanmu cu xabju le fi'ortu'a
        na.e le gligugde
    The-typical English-man dwells-in the African-land
        (Not!) and the English-country.
    The typical Englishman dwells not in Africa
        but in England.
</pre>
    The relationship between ``lo'e cinfo'' and ``lo'i cinfo'' may
    be explained thus: the typical lion is an imaginary
    lion-abstraction which best exemplifies the set of lions. There
    is a similar relationship between ``le'e'' and ``le'i'': 

    <p></p>
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  le'e xelso merko
        cu gusta ponse
    The-stereotypical Greek-type-of American
        is-a-restaurant-type-of owner.
    Lots of Greek-Americans own restaurants.
</pre>
    Here we are concerned not with the actual set of
    Greek-Americans, but with the set of those the speaker has in
    mind, which is typified by one (real or imaginary) who owns a
    restaurant. The word ``stereotypical'' is often derogatory in
    English, but ``le'e'' need not be derogatory in Lojban: it
    simply suggests that the example is typical in the speaker's
    imagination rather than in some objectively agreed-upon way. Of
    course, different speakers may disagree about what the features
    of ``the typical lion'' are (some would include having a short
    intestine, whereas others would know nothing of lions'
    intestines), so the distinction between ``lo'e cinfo'' and
    ``le'e cinfo'' may be very fine. 

    <p>Furthermore,</p>

    <p></p>
<pre>
<a id="e5d4" name="e5d4">5.4)</a>  le'e skina cu se finti ne'i la xali,uyd.
    The-stereotypical movie is-invented in Hollywood.
</pre>
    is probably true to an American, but might be false (not the
    stereotype) to someone living in India or Russia. 

    <p>Note that there is no naming equivalent of ``lo'e'' and
    ``le'e'', because there is no need, as a rule, for a ``typical
    George'' or a ``typical Smith''. People or things who share a
    common name do not, in general, have any other common
    attributes worth mentioning.</p>

    <h3><a id="s6" name="s6">6. Quantified sumti</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ro  PA  all of/each of
    su'o    PA  at least (one of)
</pre>
    Quantifiers tell us how many: in the case of quantifiers with
    sumti, how many things we are talking about. In Lojban,
    quantifiers are expressed by numbers and mathematical
    expressions: a large topic discussed in some detail in <a
    href="chapter18.html">Chapter 18</a>. For the purposes of this
    chapter, a simplified treatment will suffice. Our examples will
    employ either the simple Lojban numbers ``pa'', ``re'', ``ci'',
    ``vo'', and ``mu'', meaning ``one'', ``two'', ``three'',
    ``four'', ``five'' respectively, or else one of four special
    quantifiers, two of which are discussed in this section and
    listed above. These four quantifiers are important because
    every Lojban sumti has either one or two of them implicitly
    present in it --- which one or two depends on the particular
    kind of sumti. There is more explanation of implicit
    quantifiers later in this section. (The other two quantifiers,
    ``piro'' and ``pisu'o'', are explained in <a href="#s7">Section
    7</a>.) 

    <p>Every Lojban sumti may optionally be preceded by an explicit
    quantifier. The purpose of this quantifier is to specify how
    many of the things referred to by the sumti are being talked
    about. Here are some simple examples contrasting sumti with and
    without explicit quantifiers:</p>

    <p></p>
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  do cadzu le bisli
    You walk-on the ice.

<a id="e6d2" name="e6d2">6.2)</a>   re do cadzu le bisli
    Two-of you walk-on the ice.
</pre>
    The difference between <a href="#e6d1">Example 6.1</a> and <a
    href="#e6d2">Example 6.2</a> is the presence of the explicit
    quantifier ``re'' in the latter example. Although ``re'' by
    itself means ``two'', when used as a quantifier it means
    ``two-of''. Out of the group of listeners (the number of which
    isn't stated), two (we are not told which ones) are asserted to
    be ``walkers on the ice''. Implicitly, the others (if any) are
    not walkers on the ice. In Lojban, you cannot say ``I own three
    shoes'' if in fact you own four shoes. Numbers need never be
    specified, but if they are specified they must be correct. 

    <p>(This rule does not mean that there is no way to specify a
    number which is vague. The sentence</p>
<pre>
<a id="e6d3" name="e6d3">6.3)</a>  mi ponse su'o ci cutci
    I possess at-least three shoes.
</pre>
    is true if you own three shoes, or four, or indeed any larger
    number. More details on vague numbers appear in the discussion
    of mathematical expressions in <a href="chapter18.html">Chapter
    18</a>.) 

    <p>Now consider <a href="#e6d1">Example 6.1</a> again. How many
    of the listeners are claimed to walk on the ice? The answer
    turns out to be: all of them, however many that is. So <a
    href="#e6d1">Example 6.1</a> and <a href="#e6d4">Example
    6.4</a>:</p>
<pre>
<a id="e6d4" name="e6d4">6.4)</a>  ro do cadzu le bisli
    All-of you walk-on the ice.
</pre>
    turn out to mean exactly the same thing. This is a safe
    strategy, because if one of my listeners doesn't turn out to be
    walking on the ice, I can safely claim that I didn't intend
    that person to be a listener! And in fact, all of the personal
    pro-sumti such as ``mi'' and ``mi'o'' and ``ko'' obey the same
    rule. We say that personal pro-sumti have a so-called
    ``implicit quantifier'' of ``ro'' (all). This just means that
    if no quantifier is given explicitly, the meaning is the same
    as if the implicit quantifier had been used. 

    <p>Not all sumti have ``ro'' as the implicit quantifier,
    however. Consider the quotation in:</p>
<pre>
<a id="e6d5" name="e6d5">6.5)</a>  mi cusku lu do cadzu le bisli li'u
    I express [quote] you walk-on the ice [unquote].
    I say, ``You walk on the ice.''
</pre>

    <p>What is the implicit quantifier of the quotation ``lu do
    cadzu le bisli li'u''? Surely not ``ro''. If ``ro'' were
    supplied explicitly, thus:</p>
<pre>
<a id="e6d6" name="e6d6">6.6)</a>  mi cusku ro lu do cadzu le bisli li'u
    I express all-of [quote] you walk-on the ice [unquote].
</pre>
    the meaning would be something like ``I say every occurrence of
    the sentence 'You walk on the ice'''. Of course I don't say
    every occurrence of it, only some occurrences. One might
    suppose that <a href="#e6d5">Example 6.5</a> means that I
    express exactly one occurrence, but it is more Lojbanic to
    leave the number unspecified, as with other sumti. We can say
    definitely, however, that I say it at least once. 

    <p>The Lojban cmavo meaning ``at least'' is ``su'o'', and if no
    ordinary number follows, ``su'o'' means ``at least once''. (See
    <a href="#e6d3">Example 6.3</a> for the use of ``su'o'' with an
    ordinary number). Therefore, the explicitly quantified version
    of <a href="#e6d5">Example 6.5</a> is</p>

    <p></p>
<pre>
<a id="e6d7" name="e6d7">6.7)</a>  mi cusku su'o lu do cadzu
        le bisli li'u
    I express at-least-one-of [quote] you walk-on
        the ice [unquote].
    I say one or more instances of ``You walk on the ice''.
    I say ``You walk on the ice''.
</pre>

    <p>If an explicit ordinary number such as ``re'' were to
    appear, it would have to convey an exact expression, so</p>
<pre>
<a id="e6d8" name="e6d8">6.8)</a>  mi cusku re lu do cadzu le bisli li'u
    I express two-of [quote] you walk-on the ice [unquote].
</pre>
    means that I say the sentence exactly twice, neither more nor
    less. 

    <h3><a id="s7" name="s7">7. Quantified descriptions</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   piro    PA  the whole of
    pisu'o  PA  a part of
</pre>
    Like other sumti, descriptions can be quantified. When a
    quantifier appears before a description, it has the same
    meaning as one appearing before a non-description sumti: it
    specifies how many things, of all those referred to by the
    description, are being talked about in this particular bridi.
    Suppose that context tells us that ``le gerku'' refers to three
    dogs. Then we can say that exactly two of them are white as
    follows: 

    <p></p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  re le gerku cu blabi
    two-of the dogs are-white.
    Two of the dogs are white.
</pre>
    When discussing descriptions, this ordinary quantifier is
    called an ``outer quantifier'', since it appears outside the
    description. But there is another possible location for a
    quantifier: between the descriptor and the selbri. This
    quantifier is called an ``inner quantifier'', and its meaning
    is quite different: it tells the listener how many objects the
    description selbri characterizes. 

    <p>For example, the context of <a href="#e7d1">Example 7.1</a>
    supposedly told us that ``le gerku'' referred to some three
    specific dogs. This assumption can be made certain with the use
    of an explicit inner quantifier:</p>
<pre>
<a id="e7d2" name="e7d2">7.2)</a>  re le ci gerku cu blabi
    two-of the three dogs are-white.
    Two of the three dogs are white.
</pre>
    (As explained in the discussion of <a href="#e6d3">Example
    6.3</a>, simple numbers like those in <a href="#e7d2">Example
    7.2</a> must be exact: it therefore follows that the third dog
    cannot be white.) 

    <p>You may also specify an explicit inner quantifier and leave
    the outer quantifier implicit:</p>
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  le ci gerku cu blabi
    the three dogs are-white.
    The three dogs are white.
</pre>
    There are rules for each of the 11 descriptors specifying what
    the implicit values for the inner and outer quantifiers are.
    They are meant to provide sensible default values when context
    is absent, not necessarily to prescribe hard and fast rules.
    The following table lists the implicit values: 

    <p></p>

    <dl>
      <dt>le:</dt>

      <dd>ro le su'o all of the at-least-one described as</dd>
    </dl>

    <dl>
      <dt>lo:</dt>

      <dd>su'o lo ro at least one of all of those which really
      are</dd>
    </dl>

    <dl>
      <dt>la:</dt>

      <dd>ro la su'o all of the at least one named</dd>
    </dl>

    <dl>
      <dt>lei:</dt>

      <dd>pisu'o lei su'o some part of the mass of the at-least-one
      described as</dd>
    </dl>

    <dl>
      <dt>loi:</dt>

      <dd>pisu'o loi ro some part of the mass of all those that
      really are</dd>
    </dl>

    <dl>
      <dt>lai:</dt>

      <dd>pisu'o lai su'o some part of the mass of the at-least-one
      named</dd>
    </dl>

    <dl>
      <dt>le'i:</dt>

      <dd>piro le'i su'o the whole of the set of the at-least-one
      described as</dd>
    </dl>

    <dl>
      <dt>lo'i:</dt>

      <dd>piro lo'i ro the whole of the set of all those that
      really are</dd>
    </dl>

    <dl>
      <dt>la'i:</dt>

      <dd>piro la'i su'o the whole of the set of the at-least-one
      named</dd>
    </dl>

    <dl>
      <dt>le'e:</dt>

      <dd>ro le'e su'o all the stereotypes of the at-least-one
      described as</dd>
    </dl>

    <dl>
      <dt>lo'e:</dt>

      <dd>su'o lo'e ro at least one of the types of all those that
      really are</dd>
    </dl>
    When examined for the first time, this table looks dreadfully
    arbitrary. In fact, there are quite a few regularities in it.
    First of all, the la-series (that is, the descriptors ``la'',
    ``lai'', and ``la'i'') and the le-series (that is, the
    descriptors ``le'', ``lei'', ``le'i'', and ``le'e'') always
    have corresponding implicit quantifiers, so we may subsume the
    la-series under the le-series for the rest of this discussion:
    ``le-series cmavo'' will refer to both the le-series proper and
    to the la-series. 

    <p>The rule for the inner quantifier is very simple: the
    lo-series cmavo (namely, ``lo'', ``loi'', ``lo'i'', and
    ``lo'e'') all have an implicit inner quantifier of ``ro'',
    whereas the le-series cmavo all have an implicit inner
    quantifier of ``su'o''.</p>

    <p>Why? Because lo-series descriptors always refer to all of
    the things which really fit into the x1 place of the selbri.
    They are not restricted by the speaker's intention. Descriptors
    of the le-series, however, are so restricted, and therefore
    talk about some number, definite or indefinite, of objects the
    speaker has in mind --- but never less than one.</p>

    <p>Understanding the implicit outer quantifier requires rules
    of greater subtlety. In the case of mass and set descriptors, a
    single rule suffices for each: reference to a mass is
    implicitly a reference to some part of the mass; reference to a
    set is implicitly a reference to the whole set. Masses and sets
    are inherently singular objects: it makes no sense to talk
    about two distinct masses with the same components, or two
    distinct sets with the same members. Therefore, the largest
    possible outer quantifier for either a set description or a
    mass description is ``piro'', the whole of it.</p>

    <p>(Pedantically, it is possible that the mass of water
    molecules composing an ice cube might be thought of as
    different from the same mass of water molecules in liquid form,
    in which case we might talk about ``re lei djacu'', two masses
    of the water-bits I have in mind.)</p>

    <p>Why ``pi-''? It is the Lojban cmavo for the decimal point.
    Just as ``pimu'' means ``.5'', and when used as a quantifier
    specifies a portion consisting of five tenths of a thing,
    ``piro'' means a portion consisting of the all-ness -- the
    entirety --- of a thing. Similarly, ``pisu'o'' specifies a
    portion consisting of at least one part of a thing, i.e. some
    of it.</p>

    <p>Smaller quantifiers are possible for sets, and refer to
    subsets. Thus ``pimu le'i nanmu'' is a subset of the set of men
    I have in mind; we don't know precisely which elements make up
    this subset, but it must have half the size of the full set.
    This is the best way to say ``half of the men''; saying ``pimu
    le nanmu'' would give us a half-portion of one of them instead!
    Of course, the result of ``pimu le'i nanmu'' is still a set; if
    you need to refer to the individuals of the subset, you must
    say so (see ``lu'a'' in <a href="#s10">Section 10</a>).</p>

    <p>The case of outer quantifiers for individual descriptors
    (including ``le'', ``lo'', ``la'', and the typical descriptors
    ``le'e'' and ``lo'e'') is special. When we refer to specific
    individuals with ``le'', we mean to refer to all of those we
    have in mind, so ``ro'' is appropriate as the implicit
    quantifier, just as it is appropriate for ``do''. Reference to
    non-specific individuals with ``lo'', however, is typically to
    only some of the objects which can be correctly described, and
    so ``su'o'' is the appropriate implicit quantifier, just as for
    quotations.</p>

    <p>From the English-speaking point of view, the difference in
    structure between the following example using ``le'':</p>
<pre>
<a id="e7d4" name="e7d4">7.4)</a>  [ro] le ci gerku cu blabi
    [all-of] those-described-as three dogs are-white.
    The three dogs are white.
</pre>
    and the corresponding form with ``lo'': 
<pre>
<a id="e7d5" name="e7d5">7.5)</a>  ci lo [ro] gerku cu blabi
    three-of those-which-are [all] dogs are-white
    Three dogs are white.
</pre>
    looks very peculiar. Why is the number ``ci'' found as an inner
    quantifier in <a href="#e7d4">Example 7.4</a> and as an outer
    quantifier in <a href="#e7d5">Example 7.5</a>? The number of
    dogs is the same in either case. The answer is that the ``ci''
    in <a href="#e7d4">Example 7.4</a> is part of the
    specification: it tells us the actual number of dogs in the
    group that the speaker has in mind. In <a href="#e7d5">Example
    7.5</a>, however, the dogs referred to by ``... lo gerku'' are
    all the dogs that exist: the outer quantifier then restricts
    the number to three; which three, we cannot tell. The implicit
    quantifiers are chosen to avoid claiming too much or too
    little: in the case of ``le'', the implicit outer quantifier
    ``ro'' says that each of the dogs in the restricted group is
    white; in the case of ``lo'', the implicit inner quantifier
    simply says that three dogs, chosen from the group of all the
    dogs there are, are white. 

    <p>Using exact numbers as inner quantifiers in lo-series
    descriptions is dangerous, because you are stating that exactly
    that many things exist which really fit the description. So
    examples like</p>
<pre>
<a id="e7d7" name="e7d7">7.7)</a>  [su'o] lo ci gerku cu blabi
    [some-of] those-which-really-are three dogs are-white
</pre>
    are semantically anomalous; <a href="#e7d7">Example 7.7</a>
    claims that some dog (or dogs) is white, but also that there
    are just three dogs in the universe! 

    <p>Nevertheless, inner quantifiers are permitted on ``lo''
    descriptors for consistency's sake, and may occasionally be
    useful.</p>

    <p>Note that the inner quantifier of ``le'', even when exact,
    need not be truthful: ``le ci nanmu'' means ``what I describe
    as three men'', not ``three of what I describe as men''. This
    follows from the rule that what is described by a ``le''
    description represents the speaker's viewpoint rather than the
    objective way things are.</p>

    <h3><a id="s8" name="s8">8. Indefinite descriptions</h3>

    <p>By a quirk of Lojban syntax, it is possible to omit the
    descriptor ``lo'', but never any other descriptor, from a
    description like that of <a href="#e7d5">Example 7.5</a>;
    namely, one which has an explicit outer quantifier but no
    explicit inner quantifier. The following example:</p>
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  ci gerku [ku] cu blabi
    Three dogs are white.
</pre>
    is equivalent in meaning to <a href="#e7d5">Example 7.5</a>.
    Even though the descriptor is not present, the elidable
    terminator ``ku'' may still be used. The name ``indefinite
    description'' for this syntactic form is historically based: of
    course, it is no more and no less indefinite than its
    counterpart with an explicit ``lo''. Indefinite descriptions
    were introduced into the language in order to imitate the
    syntax of English and other natural languages. 

    <p>Indefinite descriptions must fit this mold exactly: there is
    no way to make one which does not have an explicit outer
    quantifier (thus ``*gerku cu blabi'' is ungrammatical), or
    which has an explicit inner quantifier (thus ``*reboi ci gerku
    cu blabi'' is also ungrammatical --- ``re ci gerku cu blabi''
    is fine, but means ``23 dogs are white'').</p>

    <p>Note: <a href="#e6d3">Example 6.3</a> also contains an
    indefinite description, namely ``su'o ci cutci''; another
    version of that example using an explicit ``lo'' would be:</p>
<pre>
<a id="e8d2" name="e8d2">8.2)</a>  mi ponse su'o ci lo cutci
    I possess at-least three things-which-really-are shoes
    I own three (or more) shoes.
</pre>

    <h3><a id="s9" name="s9">9. sumti-based descriptions</h3>

    <p>As stated in <a href="#s2">Section 2</a>, most descriptions
    consist of just a descriptor and a selbri. (In this chapter,
    the selbri have always been single gismu, but of course any
    selbri, however complex, can be employed in a description. The
    syntax and semantics of selbri are explained in <a
    href="chapter5.html">Chapter 5</a>.) In the intervening sections,
    inner and outer quantifiers have been added to the syntax. Now
    it is time to discuss a description of a radically different
    kind: the sumti-based description.</p>

    <p>A sumti-based description has a sumti where the selbri would
    normally be, and the inner quantifier is required --- it cannot
    be implicit. An outer quantifier is permitted but not
    required.</p>

    <p>A full theory of sumti-based descriptions has yet to be
    worked out. One common case, however, is well understood.
    Compare the following:</p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  re do cu nanmu
    Two-of you are-men.
</pre>
<pre>
<a id="e9d2" name="e9d2">9.2)</a>  le re do cu nanmu
    The two-of you are men.
</pre>
    <a href="#e9d1">Example 9.1</a> simply specifies that of the
    group of listeners, size unknown, two are men. <a
    href="#e9d2">Example 9.2</a>, which has the sumti-based
    description ``le re do'', says that of the two listeners, all
    (the implicit outer quantifier ``ro'') are men. So in effect
    the inner quantifier ``re'' gives the number of individuals
    which the inner sumti ``do'' refers to. 

    <p>Here is another group of examples:</p>

    <p></p>
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  re le ci cribe cu bunre
    Two-of the three bears are-brown.

<a id="e9d4" name="e9d4">9.4)</a>   le re le ci cribe cu bunre
    The two-of the three bears are-brown.

<a id="e9d5" name="e9d5">9.5)</a>   pa le re le ci cribe cu bunre
    One-of the two-of the three bears are-brown.
</pre>
    In each case, ``le ci cribe'' restricts the bears (or alleged
    bears) being talked of to some group of three which the speaker
    has in mind. <a href="#e9d3">Example 9.3</a> says that two of
    them (which two is not stated) are brown. <a
    href="#e9d4">Example 9.4</a> says that a specific pair of them
    are brown. <a href="#e9d5">Example 9.5</a> says that of a
    specific pair chosen from the original three, one or the other
    of that pair is brown. 

    <h3><a id="s10" name="s10">10. sumti qualifiers</h3>

    <p>The following cmavo are discussed in this section:</p>

    <p></p>
<pre>
   la'e    LAhE    something referred to by
    lu'e    LAhE    a reference to
    tu'a    LAhE    an abstraction involving

    lu'a    LAhE    an individual/member/component of
    lu'i    LAhE    a set formed from
    lu'o    LAhE    a mass formed from
    vu'i    LAhE    a sequence formed from

    na'ebo  NAhE+BO something other than
    to'ebo  NAhE+BO the opposite of
    no'ebo  NAhE+BO the neutral form of
    je'abo  NAhE+BO that which indeed is

    lu'u    LUhU    elidable terminator for LAhE and NAhE+BO
</pre>

    <p>Well, that's quite a list of cmavo. What are they all
    about?</p>

    <p>The above cmavo and compound cmavo are called the ``sumti
    qualifiers''. All of them are either single cmavo of selma'o
    LAhE, or else compound cmavo involving a scalar negation cmavo
    of selma'o NAhE immediately followed by ``bo'' of selma'o BO.
    Syntactically, you can prefix a sumti qualifier to any sumti
    and produce another simple sumti. (You may need to add the
    elidable terminator ``lu'u'' to show where the qualified sumti
    ends.)</p>

    <p>Semantically, sumti qualifiers represent short forms of
    certain common special cases. Suppose you want to say ``I see
    'The Red Pony''', where ``The Red Pony'' is the title of a
    book. How about:</p>

    <p></p>
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    mi viska lu le xunre cmaxirma li'u
    I see [quote] the red small-horse [unquote]
</pre>

    <p>But <a href="#e10d1">Example 10.1</a> doesn't work: it says
    that you see a piece of text ``The Red Pony''. That might be
    all right if you were looking at the cover of the book, where
    the words ``The Red Pony'' are presumably written. (More
    precisely, where the words ``le xunre cmaxirma'' are written --
    but we may suppose the book has been translated into
    Lojban.)</p>

    <p>What you really want to say is:</p>
<pre>
<a id="e10d2" name="e10d2">10.2)</a>    mi viska le selsinxa be
        lu le xunre cmaxirma li'u
    I see the thing-represented-by
        [quote] the red small-horse [unquote]
</pre>

    <p>The x2 place of ``selsinxa'' (the x1 place of ``sinxa'') is
    a sign or symbol, and the x1 place of ``selsinxa'' (the x2
    place of ``sinxa'') is the thing represented by the sign. <a
    href="#e10d2">Example 10.2</a> allows us to use a symbol
    (namely the title of a book) to represent the thing it is a
    symbol of (namely the book itself).</p>

    <p>This operation turns out to be needed often enough that it's
    useful to be able to say:</p>

    <p></p>
<pre>
<a id="e10d3" name="e10d3">10.3)</a>    mi viska la'e lu le xunre cmaxirma li'u [lu'u]
    I see the-referent-of
        [quote] the red small-horse [unquote].
</pre>
    So when ``la'e'' is prefixed to a sumti referring to a symbol,
    it produces a sumti referring to the referent of that symbol.
    (In computer jargon, ``la'e'' dereferences a pointer.) 

    <p>By introducing a sumti qualifier, we correct a false
    sentence (<a href="#e10d1">Example 10.1</a>), which too closely
    resembles its literal English equivalent, into a true sentence
    (<a href="#e10d3">Example 10.3</a>), without having to change
    it overmuch; in particular, the structure remains the same.
    Most of the uses of sumti qualifiers are of this general
    kind.</p>

    <p>The sumti qualifier ``lu'e'' provides the converse
    operation: it can be prefixed to a sumti referring to some
    thing to produce a sumti referring to a sign or symbol for the
    thing. For example,</p>

    <p></p>
<pre>
<a id="e10d4" name="e10d4">10.4)</a>    mi pu cusku lu'e le vi cukta
    I [past] express a-symbol-for the nearby book.
    I said the title of this book.
</pre>

    <p>The equivalent form not using a sumti qualifier would
    be:</p>
<pre>
<a id="e10d5" name="e10d5">10.5)</a>    mi pu cusku le sinxa be le vi cukta
    I [past] express the symbol-for the nearby book.
</pre>
    which is equivalent to <a href="#e10d4">Example 10.4</a>, but
    longer. 

    <p>The other sumti qualifiers follow the same rules. The cmavo
    ``tu'a'' is used in forming abstractions, and is explained more
    fully in <a href="chapter11.html">Chapter 11</a>. The triplet
    ``lu'a'', ``lu'i'', and ``lu'o'' convert between individuals,
    masses, and sets; ``vu'i'' belongs to this group as well, but
    creates a sequence, which is similar to a set but has a
    definite order. (The set of John and Charles is the same as the
    set of Charles and John, but the sequences are different.) Here
    are some examples:</p>
<pre>
<a id="e10d6" name="e10d6">10.6)</a>    mi troci tu'a le vorme
    I try some-abstraction-about the door.
    I try (to open) the door.
</pre>
    <a href="#e10d6">Example 10.6</a> might mean that I try to do
    something else involving the door; the form is deliberately
    vague. 

    <p>Most of the following examples make use of the cmavo ``ri'',
    belonging to selma'o KOhA. This cmavo means ``the thing last
    mentioned''; it is equivalent to repeating the immediately
    previous sumti (but in its original context). It is explained
    in more detail in <a href="chapter7.html">Chapter 7</a>.</p>

    <p></p>
<pre>
<a id="e10d7" name="e10d7">10.7)</a>    lo'i ratcu cu barda
        .iku'i lu'a ri cmalu
    the-set-of rats is-large.
        But some-members-of it-last-mentioned is-small
    The set of rats is large,
        but some of its members are small.

<a id="e10d8" name="e10d8">10.8)</a> lo ratcu cu cmalu
        .iku'i lu'i ri barda
    some rats are-small.
        But the-set-of them-last-mentioned is-large.
    Some rats are small, but the set of rats is large.

<a id="e10d9" name="e10d9">10.9)</a> mi ce do girzu
        .i lu'o ri gunma
        .i vu'i ri porsi
    I in-a-set-with you are-a-set.
        The-mass-of it-last-mentioned is-a-mass.
        The-sequence-of it-last-mentioned is-a-sequence
    The set of you and me is a set.
        The mass of you and me is a mass.
        The sequence of you and me is a sequence.
</pre>
    (Yes, I know these examples are a bit silly. This set was
    introduced for completeness, and practical examples are as yet
    hard to come by.) 

    <p>Finally, the four sumti qualifiers formed from a cmavo of
    NAhE and ``bo'' are all concerned with negation, which is
    discussed in detail in <a href="chapter15.html">Chapter 15</a>.
    Here are a few examples of negation sumti qualifiers:</p>

    <p></p>
<pre>
<a id="e10d10" name="e10d10">10.10)</a>  mi viska na'ebo le gerka
    I see something-other-than the dog.
</pre>

    <p>This compound, ``na'ebo'', is the most common of the four
    negation sumti qualifiers. The others usually only make sense
    in the context of repeating, with modifications, something
    already referred to:</p>

    <p></p>
<pre>
<a id="e10d11" name="e10d11">10.11)</a>  mi nelci loi glare cidja
        .ije do nelci
            to'ebo ri
        .ije la djein. nelci
            no'ebo ra
    I like part-of-the-mass-of hot-type-of food.
        And you like
            the-opposite-of the-last-mentioned.
        And Jane likes
            the-neutral-value-of something-mentioned.
    I like hot food, and you like cold food,
        and Jane likes lukewarm food.
</pre>
    (In <a href="#e10d11">Example 10.11</a>, the sumti ``ra''
    refers to some previously mentioned sumti other than that
    referred to by ``ri''. We cannot use ``ri'' here, because it
    would signify ``la djein.'', that being the most recent sumti
    available to ``ri''. See more detailed explanations in <a
    href="chapter7.html">Chapter 7</a>.) 

    <h3><a id="s11" name="s11">11. The syntax of vocative phrases</h3>

    <p>Vocative phrases are not sumti, but are explained in this
    chapter because their syntax is very similar to that of sumti.
    Grammatically, a vocative phrase is one of the so-called ``free
    modifiers'' of Lojban, along with subscripts, parentheses, and
    various other constructs explained in <a
    href="chapter19.html">Chapter 19</a>. They can be placed after
    many, but not all, constructions of the grammar: in general,
    after any elidable terminator (which, however, must not then be
    elided!), at the beginnings and ends of sentences, and in many
    other places.</p>

    <p>The purpose of a vocative phrase is to indicate who the
    person being addressed is, or to indicate to that person that
    he or she ought to be listening. A vocative phrase begins with
    a cmavo of selma'o COI or DOI, all of which are explained in
    more detail in <a href="chapter13.html">Chapter 13</a>. Sometimes
    that is all there is to the phrase:</p>
<pre>
<a id="e11d1" name="e11d1">11.1)</a>    coi
    [greetings]
    Hello.

<a id="e11d2" name="e11d2">11.2)</a> je'e
    [acknowledgement]
    Uh-huh.
    Roger!
</pre>
    In these cases, the person being addressed is obvious from the
    context. However, a vocative word (more precisely, one or more
    cmavo of COI, possibly followed by ``doi'', or else just
    ``doi'' by itself) can be followed by one of several kinds of
    phrases, all of which are intended to indicate the addressee.
    The most common case is a name: 

    <p></p>
<pre>
<a id="e11d2.5" name="e11d2.5">11.2.5)</a>    coi. djan.
    Hello, John.
</pre>

    <p>A pause is required (for morphological reasons) between a
    member of COI and a name. You can use ``doi'' instead of a
    pause:</p>

    <p></p>
<pre>
<a id="e11d3" name="e11d3">11.3)</a>    coi doi djan.
    Hello, John.
</pre>
    means exactly the same thing and does not require a pause.
    Using ``doi'' by itself is like just saying someone's name to
    attract his or her attention: 
<pre>
<a id="e11d4" name="e11d4">11.4)</a>    doi djan.
    John!
</pre>
    In place of a name, a description may appear, lacking its
    descriptor, which is understood to be ``le'': 
<pre>
<a id="e11d5" name="e11d5">11.5)</a>    coi xunre pastu nixli
    Hello, (red-type-of dress)-type-of girl.
    Hello, girl with the red dress!
</pre>
    The listener need not really be a ``xunre pastu nixli'', as
    long as she understands herself correctly from the description.
    (Actually, only a bare selbri can appear; explicit quantifiers
    are forbidden in this form of vocative, so the implicit
    quantifiers ``su'o le ro'' are in effect.) 

    <p>Finally, a complete sumti may be used, the most general
    case.</p>

    <p></p>
<pre>
<a id="e11d6" name="e11d6">11.6)</a>    co'o la bab. .e la noras.
    Goodbye, Bob and Nora.
</pre>
    <a href="#e11d5">Example 11.5</a> is thus the same as: 
<pre>
<a id="e11d7" name="e11d7">11.7)</a>    coi le xunre pastu nixli
    Hello, the-one-described-as red-dress girl!
</pre>
    and <a href="#e11d4">Example 11.4</a> is the same as: 
<pre>
<a id="e11d8" name="e11d8">11.8)</a>    doi la djan.
    The-one-named John!
</pre>
    Finally, the elidable terminator for vocative phrases is
    ``do'u'' (of selma'o DOhU), which is rarely needed except when
    a simple vocative word is being placed somewhere within a
    bridi. It may also be required when a vocative is placed
    between a sumti and its relative clause, or when there are a
    sequence of so-called ``free modifiers'' (vocatives,
    subscripts, utterance ordinals --- see <a
    href="chapter18.html">Chapter 18</a> --- metalinguistic comments
    --- see <a href="chapter19.html">Chapter 19</a> --- or reciprocals
    --- see <a href="chapter19.html">Chapter 19</a>) which must be
    properly separated. 

    <p>The meaning of a vocative phrase that is within a sentence
    is not affected by its position in the sentence: thus <a
    href="#e11d9">Example 11.9</a> and <a href="#e11d10">Example
    11.10</a> mean the same thing:</p>
<pre>
<a id="e11d9" name="e11d9">11.9)</a>    doi djan. ko klama mi
    John, come to me!

<a id="e11d10" name="e11d10">11.10)</a>   ko klama mi doi djan.
    Come to me, John!
</pre>

    <p>As usual for this chapter, the full syntax of vocative
    phrases has not been explained: relative clauses, discussed in
    <a href="chapter8.html">Chapter 8</a>, make for more
    possibilities.</p>

    <h3><a id="s12" name="s12">12. Lojban names</h3>

    <p>Names have been used freely as sumti throughout this chapter
    without too much explanation. The time for the explanation has
    now come.</p>

    <p>First of all, there are two different kinds of things
    usually called ``names'' when talking about Lojban. The naming
    predicates of <a href="#s2">Section 2</a> are just ordinary
    predicates which are being used in a special sense. In
    addition, though, there is a class of Lojban words which are
    used only to name things: these can be recognized by the fact
    that they end in a consonant followed by a pause. Some
    examples:</p>
<pre>
<a id="e12d1" name="e12d1">12.1)</a>    djan. meris. djein. .alis.
    John.  Mary.  Jane.  Alice.
</pre>
    (Note that ``.alis.'' begins as well as ends with a pause,
    because all Lojban words beginning with a vowel must be
    preceded by a pause. See <a href="chapter4.html">Chapter 4</a> for
    more information.) 

    <p>Names of this kind have two basic uses in Lojban: when used
    in a vocative phrase (see <a href="#s11">Section 11</a>) they
    indicate who the listener is or should be. When used with a
    descriptor of selma'o LA, namely ``la'', ``lai'', or ``la'i'',
    they form sumti which refer to the persons or things known by
    the name.</p>

    <p></p>
<pre>
<a id="e12d2" name="e12d2">12.2)</a>    la djonz. klama le zarci
    Jones goes to-the store.
    The Joneses go to-the store.
</pre>
<pre>
<a id="e12d3" name="e12d3">12.3)</a>    lai djonz. klama le zarci
    The-mass-of Joneses go to-the store.
    The Joneses go to the store.
</pre>

    <p>In <a href="#e12d2">Example 12.2</a>, the significance is
    that all the persons (perhaps only one) I mean to refer to by
    the name ``djonz.'' are going to the store. In <a
    href="#e12d3">Example 12.3</a>, the Joneses are massified, and
    only some part of them needs to be going. Of course, by
    ``djonz.'' I can mean whomever I want: that person need not use
    the name ``djonz.'' at all.</p>

    <p>The sumti in <a href="#e12d2">Example 12.2</a> and <a
    href="#e12d3">Example 12.3</a> operate exactly like the similar
    uses of ``la'' and ``lai'' in <a href="#e2d5">Examples
    2.5</a> and <a href="#e3d6">3.6</a> respectively. The only
    difference is that these descriptors are followed by Lojban
    name-words. And in fact, the only difference between
    descriptors of selma'o LA (these three) and of selma'o LE (all
    the other descriptors) is that the former can be followed by
    name-words, whereas the latter cannot.</p>

    <p>There are certain limitations on the form of name-words in
    Lojban. In particular, they cannot contain the letter-sequences
    (or sound-sequences) ``la'', ``lai'', or ``doi'' unless a
    consonant immediately precedes within the name. Reciprocally,
    every name not preceded by ``la'', ``lai'', ``la'i'', or
    ``doi'' must be preceded by a pause instead:</p>
<pre>
<a id="e12d4" name="e12d4">12.4)</a>    coi .djan.
    Hello, John.

<a id="e12d5" name="e12d5">12.5)</a> zo .djan. cmene mi
    The-word ``John'' is-the-name-of me.
    My name is John.
</pre>

    <p>In <a href="#e12d4">Example 12.4</a> and <a
    href="#e12d5">Example 12.5</a>, ``.djan.'' appears with a pause
    before it as well as after it, because the preceding word is
    not one of the four special cases. These rules force names to
    always be separable from the general word-stream.</p>

    <p>Unless some other rule prevents it (such as the rule that
    ``zo'' is always followed by a single word, which is quoted),
    multiple names may appear wherever one name is permitted, each
    with its terminating pause:</p>

    <p></p>
<pre>
<a id="e12d6" name="e12d6">12.6)</a>    doi djan. pol. djonz.
        le bloti cu klama fi la niuport. niuz.
    John Paul Jones,
        the boat comes (to somewhere) from Newport News.
</pre>
    A name may not contain any consonant combination that is
    illegal in Lojban words generally: the ``impermissible
    consonant clusters'' of Lojban morphology (explained in <a
    href="chapter3.html">Chapter 3</a>). Thus ``djeimz.'' is not a
    valid version of ``James'' (because ``mz'' is invalid):
    ``djeimyz'' will suffice. Similarly, ``la'' may be replaced by
    ``ly'', ``lai'' by ``ly'i'', ``doi'' by ``do'i'' or ``dai''.
    Here are a few examples: 
<pre>
   English name        invalid Lojban name valid Lojban names
</pre>
<pre>
   Doyle           *doi,l          do'il or dai,l
    Lyra            *lairas         ly'iras
    Lottie (American pron.) *latis          LYtis. or lotis.
</pre>
    Names may be borrowed from other languages or created
    arbitrarily. Another common practice is to use one or more
    rafsi, arranged to end with a consonant, to form a name: thus
    the rafsi ``loj-'' for ``logji'' (logical) and ``ban-'' for
    ``bangu'' (language) unite to form the name of this language: 
<pre>
<a id="e12d7" name="e12d7">12.7)</a>    lojban.
    Lojban
</pre>
    When borrowing names from another language which end in a
    vowel, or when turning a Lojban brivla (all of which end in
    vowels) into a name, the vowel may be removed or an arbitrary
    consonant added. It is common (but not required) to use the
    consonants ``s'' or ``n'' when borrowing vowel-final names from
    English; speakers of other languages may wish to use other
    consonant endings. 

    <p>The implicit quantifier for name sumti of the form ``la''
    followed by a name is ``su'o'', just as for ``la'' followed by
    a selbri.</p>

    <h3><a id="s13" name="s13">13. Pro-sumti summary</h3>

    <p>The Lojban pro-sumti are the cmavo of selma'o KOhA. They
    fall into several classes: personal, definable,
    quantificational, reflexive, back-counting, indefinite,
    demonstrative, metalinguistic, relative, question. More details
    are given in <a href="chapter7.html">Chapter 7</a>; this section
    mostly duplicates information found there, but adds material on
    the implicit quantifier of each pro-sumti.</p>

    <p>The following examples illustrate each of the classes.
    Unless otherwise noted below, the implicit quantification for
    pro-sumti is ``ro'' (all). In the case of pro-sumti which refer
    to other sumti, the ``ro'' signifies ``all of those referred to
    by the other sumti'': thus it is possible to restrict, but not
    to extend, the quantification of the other sumti.</p>

    <p>Personal pro-sumti (``mi'', ``do'', ``mi'o'', ``mi'a'',
    ``ma'a'', ``do'o'', ``ko'') refer to the speaker or the
    listener or both, with or without third parties:</p>
<pre>
<a id="e13d1" name="e13d1">13.1)</a>    mi prami do
    I love you.
</pre>
    The personal pro-sumti may be interpreted in context as either
    representing individuals or masses, so the implicit quantifier
    may be ``pisu'o'' rather than ``ro'': in particular, ``mi'o'',
    ``mi'a'', ``ma'a'', and ``do'o'' specifically represent mass
    combinations of the individuals (you and I, I and others, you
    and I and others, you and others) that make them up. 

    <p>Definable pro-sumti (``ko'a'', ``ko'e'', ``ko'i'', ``ko'o'',
    ``ko'u'', ``fo'a'', ``fo'e'', ``fo'i'', ``fo'o'', ``fo'u'')
    refer to whatever the speaker has explicitly made them refer
    to. This reference is accomplished with ``goi'' (of selma'o
    GOI), which means ``defined-as''.</p>
<pre>
<a id="e13d2" name="e13d2">13.2)</a>    le cribe goi ko'a cu xekri
        .i ko'a citka le smacu
    The bear defined-as it-1 is-black.
        It-1 eats the mouse.
</pre>
    Quantificational pro-sumti (``da'', ``de'', ``di'') are used as
    variables in bridi involving predicate logic: 
<pre>
<a id="e13d3" name="e13d3">13.3)</a>    ro da poi prenu
        cu prami pa de poi finpe
    All somethings-1 which-are persons
        love one something-2 which-is a-fish.
    All persons love a fish (each his/her own).
</pre>
    (This is not the same as ``All persons love a certain fish'';
    the difference between the two is one of quantifier order.) The
    implicit quantification rules for quantificational pro-sumti
    are particular to them, and are discussed in detail in <a
    href="chapter16.html">Chapter 16</a>. Roughly speaking, the
    quantifier is ``su'o'' (at least one) when the pro-sumti is
    first used, and ``ro'' (all) thereafter. 

    <p>Reflexive pro-sumti (``vo'a'', ``vo'e'', ``vo'i'', ``vo'o'',
    ``vo'u'') refer to the same referents as sumti filling other
    places in the same bridi, with the effect that the same thing
    is referred to twice:</p>
<pre>
<a id="e13d4" name="e13d4">13.4)</a>    le cribe cu batci vo'a
    The bear bites what-is-in-the-x1-place.
    The bear bites itself.
</pre>
    Back-counting pro-sumti (``ri'', ``ra'', ``ru'') refer to the
    referents of previous sumti counted backwards from the
    pro-sumti: 
<pre>
<a id="e13d5" name="e13d5">13.5)</a>    mi klama la frankfurt. ri
    I go to-Frankfurt from-the-referent-of-the-last-sumti
    I go from Frankfurt to Frankfurt (by some unstated route).
</pre>
    Indefinite pro-sumti (``zo'e'', ``zu'i'', ``zi'o'') refer to
    something which is unspecified: 
<pre>
<a id="e13d6" name="e13d6">13.6)</a>    mi klama la frankfurt. zo'e zo'e zo'e
    I go to-Frankfurt from-unspecified via-unspecified
        by-means-unspecified.
</pre>
    The implicit quantifier for indefinite pro-sumti is, well,
    indefinite. It might be ``ro'' (all) or ``su'o'' (at least one)
    or conceivably even ``no'' (none), though ``no'' would require
    a very odd context indeed. 

    <p>Demonstrative pro-sumti (``ti'', ``ta'', ``tu'') refer to
    things pointed at by the speaker, or when pointing is not
    possible, to things near or far from the speaker:</p>
<pre>
<a id="e13d7" name="e13d7">13.7)</a>    ko muvgau ti ta tu
    you [imperative] move this-thing from-that-nearby-place
        to-that-further-away-place
    Move this from there to over there!
</pre>
    Metalinguistic pro-sumti (``di'u'', ``de'u'', ``da'u'',
    ``di'e'', ``de'e'', ``da'e'', ``dei'', ``do'i'') refer to
    spoken or written utterances, either preceding, following, or
    the same as the current utterance. 
<pre>
<a id="e13d8" name="e13d8">13.8)</a>    li re su'i re du li vo
        .i la'e di'u jetnu
    The-number two plus two equals the-number four.
        The-referent-of the-previous-utterance is-true.
</pre>
    The implicit quantifier for metalinguistic pro-sumti is
    ``su'o'' (at least one), because they are considered analogous
    to ``lo'' descriptions: they refer to things which really are
    previous, current, or following utterances. 

    <p>The relative pro-sumti (``ke'a'') is used within relative
    clauses (see <a href="chapter8.html">Chapter 8</a> for a
    discussion of relative clauses) to refer to whatever sumti the
    relative clause is attached to.</p>
<pre>
<a id="e13d9" name="e13d9">13.9)</a>    mi viska le mlatu ku
        poi zo'e zbasu ke'a
        loi slasi
    I see the cat(s)
        such-that something-unspecified makes it/them (the cats)
        from-a-mass-of plastic.
    I see the cat(s) made of plastic.
</pre>
    The question pro-sumti (``ma'') is used to ask questions which
    request the listener to supply a sumti which will make the
    question into a truth: 
<pre>
<a id="e13d10" name="e13d10">13.10)</a>  do klama ma
    You go to-what-sumti?
    Where are you going?
</pre>
    The implicit quantifier for the question pro-sumti is ``su'o''
    (at least one), because the listener is only being asked to
    supply a single answer, not all correct answers. 

    <p>In addition, sequences of lerfu words (of selma'o BY and
    related selma'o) can also be used as definable pro-sumti.</p>

    <h3><a id="s14" name="s14">14. Quotation summary</h3>

    <p>There are four kinds of quotation in Lojban: text quotation,
    words quotation, single-word quotation, non-Lojban quotation.
    More information is provided in <a href="chapter19.html">Chapter
    19</a>.</p>

    <p>Text quotations are preceded by ``lu'' and followed by
    ``li'u'', and are an essential part of the surrounding text:
    they must be grammatical Lojban texts.</p>
<pre>
<a id="e14d1" name="e14d1">14.1)</a>    mi cusku lu mi'e djan. li'u
    I say the-text [quote] I-am John [unquote].
    I say ``I'm John''.
</pre>
    Words quotations are quotations of one or more Lojban words.
    The words need not mean anything, but they must be
    morphologically valid so that the end of the quotation can be
    discerned. 

    <p></p>
<pre>
<a id="e14d2" name="e14d2">14.2)</a>    mi cusku lo'u li mi le'u
    I say the-words [quote] ``li mi'' [unquote].
    I say ``li mi''.
</pre>

    <p>Note that the translation of <a href="#e14d2">Example
    14.2</a> does not translate the Lojban words, because they are
    not presumed to have any meaning (in fact, they are
    ungrammatical).</p>

    <p>Single-word quotation quotes a single Lojban word. Compound
    cmavo are not allowed.</p>
<pre>
<a id="e14d3" name="e14d3">14.3)</a>    mi cusku zo .ai
    I say the-word ``.ai''.
</pre>
    Non-Lojban quotation can quote anything, Lojban or not, even
    non-speech such as drum talk, whistle words, music, or
    belching. A Lojban word which does not appear within the
    quotation is used before and after it to set it off from the
    surrounding Lojban text. 
<pre>
<a id="e14d4" name="e14d4">14.4)</a>    mi cusku zoi kuot. I'm John .kuot
    I say ``I'm John''.
</pre>
    The implicit quantifier for all types of quotation is ``su'o''
    (at least one), because quotations are analogous to ``lo''
    descriptions: they refer to things which actually are words or
    sequences of words. 

    <h3><a id="s15" name="s15">15. Number summary</h3>

    <p>The sumti which refer to numbers consist of the cmavo ``li''
    (of selma'o LI) followed by an arbitrary Lojban mekso, or
    mathematical expression. This can be anything from a simple
    number up to the most complicated combination of numbers,
    variables, operators, and so on. Much more information on
    numbers is given in <a href="chapter18.html">Chapter 18</a>. Here
    are a few examples of increasing complexity:</p>
<pre>
<a id="e15d1" name="e15d1">15.1)</a>    li vo
    the-number four
    4

<a id="e15d2" name="e15d2">15.2)</a> li re su'i re
    the-number two plus two
    2 + 2

<a id="e15d3" name="e15d3">15.3)</a> li .abu bopi'i xy. bote'a re
        su'i by. bopi'i xy. su'i cy.
    the-number a times x to-power 2
        plus b times x plus c
    ax<sup>2</sup>  + bx + c
</pre>
    An alternative to ``li'' is ``me'o'', also of selma'o LI.
    Number expressions beginning with ``me'o'' refer to the actual
    expression, rather than its value. Thus <a
    href="#e15d1">Example 15.1</a> and <a href="#e15d2">Example
    15.2</a> above have the same meaning, the number four, whereas 
<pre>
<a id="e15d4" name="e15d4">15.4)</a>    me'o vo
    the-expression four
    ``4''
</pre>
    and 
<pre>
<a id="e15d5" name="e15d5">15.5)</a>    me'o re su'i re
    the-expression two plus two
    ``2+2''
</pre>
    refer to different pieces of text. 

    <p>The implicit quantifier for numbers and mathematical
    expressions is ``su'o'', because these sumti are analogous to
    ``lo'' descriptions: they refer to things which actually are
    numbers or pieces of text. In the case of numbers (with
    ``li''), this is a distinction without a difference, as there
    is only one number which is 4; but there are many texts ``4'',
    as many as there are documents in which that numeral
    appears.</p>

    <hr />
    
    <p>Senast modifierad: Mon Jun 27 23:12:13 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
