
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//ES" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 7</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter7.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 7<br />
      Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</h2>

      <!--
      <h6>$Revision: 4.3 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. What are pro-sumti and pro-bridi? What are they
    for?</h3>

    <p>Speakers of Lojban, like speakers of other languages,
    require mechanisms of abbreviation. If every time we referred
    to something, we had to express a complete description of it,
    life would be too short to say what we have to say. In English,
    we have words called ``pronouns'' which allow us to replace
    nouns or noun phrases with shorter terms. An English with no
    pronouns might look something like this:</p>
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  Speakers of Lojban, like speakers of other languages,
    require mechanisms of abbreviation.  If every time
    speakers of Lojban referred to a thing to which
    speakers of Lojban refer, speakers of Lojban had to
    express a complete description of what speakers
    of Lojban referred to, life would be too short to say
    what speakers of Lojban have to say.
</pre>
    Speakers of this kind of English would get mightily sick of
    talking. Furthermore, there are uses of pronouns in English
    which are independent of abbreviation. There is all the
    difference in the world between: 

    <p></p>
<pre>
<a id="e1d2" name="e1d2">1.2)</a>  John picked up a stick and shook it.
</pre>
    and 
<pre>
<a id="e1d3" name="e1d3">1.3)</a>  John picked up a stick and shook a stick.
</pre>
    <a href="#e1d3">Example 1.3</a> does not imply that the two
    sticks are necessarily the same, whereas <a
    href="#e1d2">Example 1.2</a> requires that they are. 

    <p>In Lojban, we have sumti rather than nouns, so our
    equivalent of pronouns are called by the hybrid term
    ``pro-sumti''. A purely Lojban term would be ``sumti cmavo'':
    all of the pro-sumti are cmavo belonging to selma'o KOhA. In
    exactly the same way, Lojban has a group of cmavo (belonging to
    selma'o GOhA) which serve as selbri or full bridi. These may be
    called ``pro-bridi'' or ``bridi cmavo''. This chapter explains
    the uses of all the members of selma'o KOhA and GOhA. They fall
    into a number of groups, known as series: thus, in selma'o
    KOhA, we have among others the mi-series, the ko'a-series, the
    da-series, and so on. In each section, a series of pro-sumti is
    explained, and if there is a corresponding series of pro-bridi,
    it is explained and contrasted. Many pro-sumti series don't
    have pro-bridi analogues, however.</p>

    <p>A few technical terms: The term ``referent'' means the thing
    to which a pro-sumti (by extension, a pro-bridi) refers. If the
    speaker of a sentence is James, then the referent of the word
    ``I'' is James. On the other hand, the term ``antecedent''
    refers to a piece of language which a pro-sumti (or pro-bridi)
    implicitly repeats. In</p>
<pre>
<a id="e1d4" name="e1d4">1.4)</a>  John loves himself
</pre>
    the antecedent of ``himself'' is ``John''; not the person, but
    a piece of text (a name, in this case). John, the person, would
    be the referent of ``himself''. Not all pro-sumti or pro-bridi
    have antecedents, but all of them have referents. 

    <h3><a id="s2" name="s2">2. Personal pro-sumti: the mi-series</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   mi  KOhA    mi-series   I, me
    do  KOhA    mi-series   you
    mi'o    KOhA    mi-series   you and I
    mi'a    KOhA    mi-series   I and others,
                    we but not you
    ma'a    KOhA    mi-series   you and I and others
    do'o    KOhA    mi-series   you and others
    ko  KOhA    mi-series   you-imperative
</pre>
    The mi-series of pro-sumti refer to the speaker, the listener,
    and others in various combinations. ``mi'' refers to the
    speaker and perhaps others for whom the speaker speaks; it may
    be a Lojbanic mass. ``do'' refers to the listener or listeners.
    Neither ``mi'' nor ``do'' is specific about the number of
    persons referred to; for example, the foreman of a jury may
    refer to the members of the jury as ``mi'', since in speaking
    officially he represents all of them. 

    <p>The referents of ``mi'' and ``do'' are usually obvious from
    the context, but may be assigned by the vocative words of
    selma'o COI, explained in <a href="chapter13.html">Chapter 13</a>.
    The vocative ``mi'e'' assigns ``mi'', whereas all of the other
    vocatives assign ``do''.</p>
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  mi'e djan. doi frank.
        mi cusku lu mi bajra li'u do
    I-am John, O Frank,
        I express [quote] I run [unquote] to-you
    I am John, Frank; I tell you ``I run''.
</pre>
    The cmavo ``mi'o'', ``mi'a'', ``ma'a'', and ``do'o'' express
    various combinations of the speaker and/or the listener and/or
    other people: 

    <dl>
      <dt></dt>

      <dd>``mi'o'' includes only the speaker and the listener but
      no one else; ``mi'a'' includes the speaker and others but
      excludes the listener;</dd>

      <dt></dt>

      <dd>``do'o'' includes the listener and others but excludes
      the speaker;</dd>

      <dt></dt>

      <dd>``ma'a'' includes all three: speaker, listener,
      others.</dd>
    </dl>
    All of these pro-sumti represent masses. For example, ``mi'o''
    is the same as ``mi joi do'', the mass of me and you considered
    jointly. 

    <p>In English, ``we'' can mean ``mi'' or ``mi'o'' or ``mi'a''
    or even ``ma'a'', and English-speakers often suffer because
    they mistake ``mi'o'' for ``mi'a'':</p>
<pre>
<a id="e2d2" name="e2d2">2.2)</a>  We're going to the store.
</pre>

    <p>Does this include the listener or not? There's no way to be
    sure.</p>

    <p>Finally, the cmavo ``ko'' is logically equivalent to ``do'';
    its referent is the listener. However, its use alters an
    assertion about the listener into a command to the listener to
    make the assertion true:</p>
<pre>
<a id="e2d3" name="e2d3">2.3)</a>  do klama le zarci
    You go to-the store.
</pre>
    becomes: 
<pre>
<a id="e2d4" name="e2d4">2.4)</a>  ko klama le zarci
    You [imperative] go to-the store.
    Make ``you go to the store'' true!
    Go to the store!
</pre>
    In English, the subject of a command is omitted, but in Lojban,
    the word ``ko'' must be used. However, ``ko'' does not have to
    appear in the x1 place: 
<pre>
<a id="e2d5" name="e2d5">2.5)</a>  mi viska ko
    I see you [imperative]
    Make ``I see you'' true!
    Be seen by me!
</pre>
    In <a href="#e2d5">Example 2.5</a>, it is necessary to make the
    verb passive in English in order to convey the effect of ``ko''
    in the x2 place. Indeed, ``ko'' does not even have to be a
    sumti of the main bridi: 
<pre>
<a id="e2d6" name="e2d6">2.6)</a>  mi viska le prenu poi prami ko
    I see the person that loves you [imperative]
    Make ``I see the person that loves you'' true!
    Be such that the person who loves you is seen by me!
    Show me the person who loves you!
</pre>
    As mentioned in <a href="#s1">Section 1</a>, some pro-sumti
    series have corresponding pro-bridi series. However, there is
    no equivalent of the mi-series among pro-bridi, since a person
    isn't a relationship. 

    <h3><a id="s3" name="s3">3. Demonstrative pro-sumti: the ti-series</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ti  KOhA    ti-series   this here,
                    a nearby object
    ta  KOhA    ti-series   that there,
                    a medium-distant object
    tu  KOhA    ti-series   that yonder,
                    a far-distant object
</pre>
    It is often useful to refer to things by pointing to them or by
    some related non-linguistic mechanism. In English, the words
    ``this'' and ``that'' serve this function among others:
    ``this'' refers to something pointed at that is near the
    speaker, and ``that'' refers to something further away. The
    Lojban pro-sumti of the ti-series serve the same functions, but
    more narrowly. The cmavo ``ti'', ``ta'', and ``tu'' provide
    only the pointing function of ``this'' and ``that''; they are
    not used to refer to things that cannot be pointed at. 

    <p>There are three pro-sumti of the ti-series rather than just
    two because it is often useful to distinguish between objects
    that are at more than two different distances. Japanese, among
    other languages, regularly does this. Until the 16th century,
    English did too; the pronoun ``that'' referred to something at
    a medium distance from the speaker, and the now-archaic pronoun
    ``yon'' to something far away.</p>

    <p>In conversation, there is a special rule about ``ta'' and
    ``tu'' that is often helpful in interpreting them. When used
    contrastingly, ``ta'' refers to something that is near the
    listener, whereas ``tu'' refers to something far from both
    speaker and listener. This makes for a parallelism between
    ``ti'' and ``mi'', and ``ta'' and ``do'', that is convenient
    when pointing is not possible; for example, when talking by
    telephone. In written text, on the other hand, the meaning of
    the ti-series is inherently vague; is the writer to be taken as
    pointing to something, and if so, to what? In all cases, what
    counts as ``near'' and ``far away'' is relative to the current
    situation.</p>

    <p>It is important to distinguish between the English pronoun
    ``this'' and the English adjective ``this'' as in ``this
    boat''. The latter is not represented in Lojban by ``ti'':</p>

    <p></p>
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  le ti bloti
    the this boat
</pre>
    does not mean ``this boat'' but rather ``this one's boat'',
    ``the boat associated with this thing'', as explained in <a
    href="chapter8.html">Chapter 8</a>. A correct Lojban translation
    of <a href="#e3d1">Example 3.1</a> is 
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  le vi bloti
    the here boat
    the nearby boat
</pre>
    using a spatial tense before the selbri ``bloti'' to express
    that the boat is near the speaker. (Tenses are explained in
    full in <a href="chapter11.html">Chapter 11</a>.) Another correct
    translation would be: 

    <p></p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  ti noi bloti
    this-thing which-incidentally is-a-boat
</pre>
    There are no demonstrative pro-bridi to correspond to the
    ti-series: you can't point to a relationship. 

    <h3><a id="s4" name="s4">4. Utterance pro-sumti: the di'u-series</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   di'u    KOhA    di'u-series the previous utterance
    de'u    KOhA    di'u-series an earlier utterance
    da'u    KOhA    di'u-series a much earlier utterance
    di'e    KOhA    di'u-series the next utterance
    de'e    KOhA    di'u-series a later utterance
    da'e    KOhA    di'u-series a much later utterance
    dei KOhA    di'u-series this very utterance
    do'i    KOhA    di'u-series some utterance
</pre>
    The cmavo of the di'u-series enable us to talk about things
    that have been, are being, or will be said. In English, it is
    normal to use ``this'' and ``that'' for this (indeed, the
    immediately preceding ``this'' is an example of such a usage): 
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  You don't like cats.
    That is untrue.
</pre>

    <p>Here ``that'' does not refer to something that can be
    pointed to, but to the preceding sentence ``You don't like
    cats''. In Lojban, therefore, <a href="#e4d1">Example 4.1</a>
    is rendered:</p>
<pre>
<a id="e4d2" name="e4d2">4.2)</a>  do na nelci loi mlatu
        .i di'u jitfa jufra
    You not like the-mass-of cats.
        The-previous-utterance is-a-false sentence..
</pre>
    Using ``ta'' instead of ``di'u'' would cause the listener to
    look around to see what the speaker of the second sentence was
    physically pointing to. 

    <p>As with ``ti'', ``ta'', and ``tu'', the cmavo of the
    di'u-series come in threes: a close utterance, a
    medium-distance utterance, and a distant utterance, either in
    the past or in the future. It turned out to be impossible to
    use the ``i''/``a''/``u'' vowel convention discussed in <a
    href="#s3">Section 3</a> without causing collisions with other
    cmavo, and so the di'u-series has a unique ``i''/``e''/``a''
    convention in the first vowel of the cmavo.</p>

    <p>Most references in speech are to the past (what has already
    been said), so ``di'e'', ``de'e'', and ``da'e'' are not very
    useful when speaking. In writing, they are frequently
    handy:</p>

    <p></p>
<pre>
<a id="e4d3" name="e4d3">4.3)</a>  la saimn. cusku di'e
    Simon expresses the-following-utterance.
    Simon says:
</pre>
    <a href="#e4d3">Example 4.3</a> would typically be followed by
    a quotation. Note that although presumably the quotation is of
    something Simon has said in the past, the quotation utterance
    itself would appear after <a href="#e4d3">Example 4.3</a>, and
    so ``di'e'' is appropriate. 

    <p>The remaining two cmavo, ``dei'' and ``do'i'', refer
    respectively to the very utterance that the speaker is
    uttering, and to some vague or unspecified utterance uttered by
    someone at some time:</p>
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  dei jetnu jufra
    This-utterance is-a-true sentence.
    What I am saying (at this moment) is true.

<a id="e4d5" name="e4d5">4.5)</a>   do'i jetnu jufra
    Some-utterance is-a-true sentence.
    That's true (where ``that'' is not necessarily what
        was just said).
</pre>
    The cmavo of the di'u-series have a meaning that is relative to
    the context. The referent of ``dei'' in the current utterance
    is the same as the referent of ``di'u'' in the next utterance.
    The term ``utterance'' is used rather than ``sentence'' because
    the amount of speech or written text referred to by any of
    these words is vague. Often, a single bridi is intended, but
    longer utterances may be thus referred to. 

    <p>Note one very common construction with ``di'u'' and the
    cmavo ``la'e'' (of selma'o LAhE; see <a
    href="chapter6.html">Chapter 6</a>) which precedes a sumti and
    means ``the thing referred to by (the sumti)'':</p>
<pre>
<a id="e4d6" name="e4d6">4.6)</a>  mi prami la djein.
        .i mi nelci la'e di'u
    I love Jane.
        And I like the-referent-of the-last-utterance.
    I love Jane, and I like that.
</pre>
    The effect of ``la'e di'u'' in <a href="#e4d6">Example 4.6</a>
    is that the speaker likes, not the previous sentence, but
    rather the state of affairs referred to by the previous
    sentence, namely his loving Jane. This cmavo compound is often
    written as a single word: ``la'edi'u''. It is important not to
    mix up ``di'u'' and ``la'edi'u'', or the wrong meaning will
    generally result: 
<pre>
<a id="e4d7" name="e4d7">4.7)</a>  mi prami la djein.
        .i mi nelci di'u
    I love Jane.
        And I like the-last-utterance.
</pre>
    says that the speaker likes one of his own sentences. 

    <p>There are no pro-bridi corresponding to the di'u-series.</p>

    <h3><a id="s5" name="s5">5. Assignable pro-sumti and pro-bridi: the ko'a-series and
    the broda-series</h3>

    <p>The following cmavo and gismu are discussed in this
    section:</p>
<pre>
   ko'a    KOhA    ko'a-series it-1
    ko'e    KOhA    ko'a-series it-2
    ko'i    KOhA    ko'a-series it-3
    ko'o    KOhA    ko'a-series it-4
    ko'u    KOhA    ko'a-series it-5
    fo'a    KOhA    ko'a-series it-6
    fo'e    KOhA    ko'a-series it-7
    fo'i    KOhA    ko'a-series it-8
    fo'o    KOhA    ko'a-series it-9
    fo'u    KOhA    ko'a-series it-10
    broda   BRIVLA  broda-series    is-thing-1
    brode   BRIVLA  broda-series    is-thing-2
    brodi   BRIVLA  broda-series    is-thing-3
    brodo   BRIVLA  broda-series    is-thing-4
    brodu   BRIVLA  broda-series    is-thing-5
    goi GOI         pro-sumti assignment
    cei CEI         pro-bridi assignment
</pre>
    The discussion of personal pro-sumti in <a href="#s2">Section
    2</a> may have seemed incomplete. In English, the personal
    pronouns include not only ``I'' and ``you'' but also ``he'',
    ``she'', ``it'', and ``they''. Lojban does have equivalents of
    this latter group: in fact, it has more of them than English
    does. However, they are organized and used very differently. 

    <p>There are ten cmavo in the ko'a-series, and they may be
    assigned freely to any sumti whatsoever. The English word
    ``he'' can refer only to males, ``she'' only to females (and
    ships and a few other things), ``it'' only to inanimate things,
    and ``they'' only to plurals; the cmavo of the ko'a-series have
    no restrictions at all. Therefore, it is almost impossible to
    guess from the context what ko'a-series cmavo might refer to if
    they are just used freely:</p>

    <p></p>
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  la .alis. klama le zarci .i ko'a blanu
    Alice goes-to the store.  It-1 is-blue.
</pre>

    <p>The English gloss ``it-1'', plus knowledge about the real
    world, would tend to make English-speakers believe that
    ``ko'a'' refers to the store; in other words, that its
    antecedent is ``le zarci''. To a Lojbanist, however, ``la
    .alis.'' is just as likely an antecedent, in which case <a
    href="#e5d1">Example 5.1</a> means that Alice, not the store,
    is blue.</p>

    <p>To avoid this pitfall, Lojban employs special syntax, using
    the cmavo ``goi'':</p>
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  la .alis. klama le zarci
        .i ko'a goi la .alis. cu blanu
    Alice goes-to the store.
        It-1, also-known-as Alice, is-blue.
</pre>
    Syntactically, ``goi la .alis.'' is a relative phrase (relative
    phrases are explained in <a href="chapter8.html">Chapter 8</a>).
    Semantically, it says that ``ko'a'' and ``la .alis.'' refer to
    the same thing, and furthermore that this is true because
    ``ko'a'' is being defined as meaning ``la .alis.''. It is
    equally correct to say: 
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  la .alis. klama le zarci
        .i la .alis. goi ko'a cu blanu
    Alice goes-to the store.
        Alice, also-known-as it-1, is-blue.
</pre>
    in other words, ``goi'' is symmetrical. There is a terminator,
    ``ge'u'' (of selma'o GEhU), which is almost always elidable.
    The details are in <a href="chapter8.html">Chapter 8</a>. 

    <p>The afterthought form of ``goi'' shown in <a
    href="#e5d2">Example 5.2</a> and <a href="#e5d3">Example
    5.3</a> is probably most common in speech, where we do not know
    until part way through our utterance that we will want to refer
    to Alice again. In writing, though, ``ko'a'' may be assigned at
    the point where Alice is first mentioned. An example of this
    forethought form of ``goi'' is:</p>
<pre>
<a id="e5d4" name="e5d4">5.4)</a>  la .alis. goi ko'a klama le zarci
        .i ko'a cu blanu
    Alice, also-known-as it-1, goes-to the store.
        It-1 is-blue.
</pre>
    Again, ``ko'a goi la .alis.'' would have been entirely
    acceptable in <a href="#e5d4">Example 5.4</a>. This last form
    is reminiscent of legal jargon: ``The party of the first part,
    hereafter known as Buyer, ... ''. 

    <p>Just as the ko'a-series of pro-sumti allows a substitute for
    a sumti which is long or complex, or which for some other
    reason we do not want to repeat, so the broda-series of
    pro-bridi allows a substitute for a selbri or even a whole
    bridi:</p>

    <p></p>
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  ti slasi je mlatu bo cidja lante gacri cei broda
        .i le crino broda cu barda
        .i le xunre broda cu cmalu
    These are plastic cat-food can covers, or thingies.
        The green thingy is large.
        The red thingy is small.
</pre>
    The pro-bridi ``broda'' has as its antecedent the selbri
    ``slasi je mlatu bo cidja lante gacri''. The cmavo ``cei''
    performs the role of ``goi'' in assigning ``broda'' to this
    long phrase, and ``broda'' can then be used just like any other
    brivla. (In fact, ``broda'' and its relatives actually
    <i>are</i> brivla: they are gismu in morphology, although they
    behave exactly like the members of selma'o GOhA. The reasons
    for using gismu rather than cmavo are buried in the Loglan
    Project's history.) 

    <p>Note that pro-bridi are so called because, even though they
    have the grammar of selbri, their antecedents are whole bridi.
    In the following rather contrived example, the antecedent of
    ``brode'' is the whole bridi ``mi klama le zarci'':</p>
<pre>
<a id="e5d6" name="e5d6">5.6)</a>  mi klama cei brode le zarci .i do brode
    I go-to (which-is claim-1) the store.  You claim-1
    I go to the store.  You, too.
</pre>
    In the second bridi, ``do brode'' means ``do klama le zarci'',
    because ``brode'' carries the x2 sumti of ``mi klama le zarci''
    along with it. It also potentially carries the x1 sumti as
    well, but the explicit x1 sumti ``do'' overrides the ``mi'' of
    the antecedent bridi. (Similarly, any tense or negation that is
    present in the antecedent is also carried, and can be
    overridden by explicit tense or negation cmavo on the
    pro-bridi.) These rules hold for all pro-bridi that have
    antecedents. 

    <p>Another use of ``broda'' and its relatives, without
    assignment, is as ``sample gismu'':</p>
<pre>
<a id="e5d7" name="e5d7">5.7)</a>  broda ke brode brodi
    a thing-1 type of ( thing-2 type-of thing-3 )
</pre>
    represents an abstract pattern, a certain kind of tanru.
    (Historically, this use was the original one.) 

    <p>As is explained in <a href="chapter17.html">Chapter 17</a>, the
    words for Lojban letters, belonging to selma'o BY and certain
    related selma'o, are also usable as assignable pro-sumti. The
    main difference between letter pro-sumti and ko'a-series
    pro-sumti is that, in the absence of an explicit assignment,
    letters are taken to refer to the most recent name or
    description sumti beginning with the same letter:</p>
<pre>
<a id="e5d8" name="e5d8">5.8)</a>  mi viska le gerku .i gy. cusku zo arf.
    I see the dog.  D expresses the-word ``Arf!''.
</pre>
    The Lojban word ``gerku'' begins with ``g'', so the antecedent
    of ``gy.'', the cmavo for the letter ``g'', must be ``le
    gerku''. In the English translation, we use the same principle
    to refer to the dog as ``D''. Of course, in case of ambiguity,
    ``goi'' can be used to make an explicit assignment. 

    <p>Furthermore, ``goi'' can even be used to assign a name:</p>
<pre>
<a id="e5d9" name="e5d9">5.9)</a>  le ninmu goi la sam. cu klama le zarci
    The woman also-known-as Sam goes to-the store.
    The woman, whom I'll call Sam, goes to the store.
</pre>

    <p>This usage does not imply that the woman's name is Sam, or
    even that the speaker usually calls the woman ``Sam''. ``Sam''
    is simply a name chosen, as if at random, for use in the
    current context only.</p>

    <h3><a id="s6" name="s6">6. Anaphoric pro-sumti and pro-bridi: the ri-series and the
    go'i-series</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ri  KOhA    ri-series   (repeats last sumti)
    ra  KOhA    ri-series   (repeats previous sumti)
    ru  KOhA    ri-series   (repeats long-ago sumti)
    go'i    GOhA    go'i-series (repeats last bridi)
    go'a    GOhA    go'i-series (repeats previous bridi)
    go'u    GOhA    go'i-series (repeats long-ago bridi)
    go'e    GOhA    go'i-series (repeats last-but-one bridi)
    go'o    GOhA    go'i-series (repeats future bridi)
    nei GOhA    go'i-series (repeats current bridi)
    no'a    GOhA    go'i-series (repeats outer bridi)
    ra'o    RAhO            pro-cmavo update
</pre>
    The term ``anaphora'' literally means ``repetition'', but is
    used in linguistics to refer to pronouns whose significance is
    the repetition of earlier words, namely their antecedents.
    Lojban provides three pro-sumti anaphora, ``ri'', ``ra'', and
    ``ru''; and three corresponding pro-bridi anaphora, ``go'i'',
    ``go'a'', and ``go'u''. These cmavo reveal the same vowel
    pattern as the ti-series, but the ``distances'' referred to are
    not physical distances, but distances from the anaphoric cmavo
    to its antecedent. 

    <p>The cmavo ``ri'' is the simplest of these; it has the same
    referent as the last complete sumti appearing before the
    ``ri'':</p>
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  la .alis. sipna le ri kumfa
    Alice sleeps-in the of-[repeat last sumti] room.
    Alice sleeps in her room.
</pre>
    The ``ri'' in <a href="#e6d1">Example 6.1</a> is equivalent to
    repeating the last sumti, which is ``la .alis.'', so <a
    href="#e6d1">Example 6.1</a> is equivalent to: 
<pre>
<a id="e6d2" name="e6d2">6.2)</a>  la .alis. sipna le la .alis. kumfa
    Alice sleeps-in the of-Alice room.
    Alice sleeps in Alice's room.
</pre>
    Note that ``ri'' does not repeat ``le ri kumfa'', because that
    sumti is not yet complete when ``ri'' appears. This prevents
    ``ri'' from getting entangled in paradoxes of self-reference.
    (There are plenty of other ways to do that!) Note also that
    sumti within other sumti, as in quotations, abstractions, and
    the like, are counted in the order of their beginnings; thus a
    lower level sumti like ``la alis.'' in <a href="#e6d2">Example
    6.2</a> is considered to be more recent than a higher level
    sumti that contains it. 

    <p>Certain sumti are ignored by ``ri''; specifically, most of
    the other cmavo of KOhA, and the
    almost-grammatically-equivalent lerfu words of selma'o BY. It
    is simpler just to repeat these directly:</p>
<pre>
<a id="e6d3" name="e6d3">6.3)</a>  mi prami mi
    I love me.
    I love myself.
</pre>
    However, the cmavo of the ti-series can be picked up by ``ri'',
    because you might have changed what you are pointing at, so
    repeating ``ti'' may not be effective. Likewise, ``ri'' itself
    (or rather its antecedent) can be repeated by a later ``ri'';
    in fact, a string of ``ri'' cmavo with no other intervening
    sumti always all repeat the same sumti: 
<pre>
<a id="e6d4" name="e6d4">6.4)</a>  la djan. viska le tricu
        .i ri se jadni
            le ri jimca
    John sees the tree.
        [repeat last] is-adorned-by
            the of-[repeat last] branch
    John sees the tree.  It is adorned by its branches.
</pre>

    <p>Here the second ``ri'' has as antecedent the first ``ri'',
    which has as antecedent ``le tricu''. All three refer to the
    same thing: a tree.</p>

    <p>To refer to the next-to-last sumti, the third-from-last
    sumti, and so on, ``ri'' may be subscripted (subscripts are
    explained in <a href="chapter19.html">Chapter 19</a>):</p>
<pre>
<a id="e6d5" name="e6d5">6.5)</a>  lo smuci .i lo forca .i la rik. pilno rixire
        .i la .alis. pilno riximu
    A spoon.  A fork.  Rick uses [repeat next-to-last].
        Alice uses [repeat fifth-from-last].
</pre>

    <p>Here ``rixire'', or ``ri-sub-2'', skips ``la rik.'' to reach
    ``lo forca''. In the same way, ``riximu'', or ``ri-sub-5'',
    skips ``la .alis.'', ``rixire'', ``la rik.'', and ``lo forca''
    to reach ``lo smuci''. As can clearly be seen, this procedure
    is barely practicable in writing, and would break down totally
    in speech.</p>

    <p>Therefore, the vaguer ``ra'' and ``ru'' are also provided.
    The cmavo ``ra'' repeats a recently used sumti, and ``ru'' one
    that was further back in the speech or text. The use of ``ra''
    and ``ru'' forces the listener to guess at the referent, but
    makes life easier for the speaker. Can ``ra'' refer to the last
    sumti, like ``ri''? The answer is no if ``ri'' has also been
    used. If ``ri'' has not been used, then ``ra'' might be the
    last sumti. Likewise, if ``ra'' has been used, then any use of
    ``ru'' would repeat a sumti earlier than the one ``ra'' is
    repeating. A more reasonable version of Example 6.5, but one
    that depends more on context, is:</p>
<pre>
<a id="e6d6" name="e6d6">6.6)</a>  lo smuci .i lo forca .i la rik. pilno ra
        .i la .alis. pilno ru
    A spoon.  A fork.  Rick uses [some previous thing].
        Alice uses [some more remote thing].
</pre>

    <p>In <a href="#e6d6">Example 6.6</a>, the use of ``ra'' tells
    us that something other than ``la rik.'' is the antecedent;
    ``lo forca'' is the nearest sumti, so it is probably the
    antecedent. Similarly, the antecedent of ``ru'' must be
    something even further back in the utterance than ``lo forca'',
    and ``lo smuci'' is the obvious candidate.</p>

    <p>The meaning of ``ri'' must be determined every time it is
    used. Since ``ra'' and ``ru'' are more vaguely defined, they
    may well retain the same meaning for a while, but the listener
    cannot count on this behavior. To make a permanent reference to
    something repeated by ``ri'', ``ra'', or ``ru'', use ``goi''
    and a ko'a-series cmavo:</p>
<pre>
<a id="e6d7" name="e6d7">6.7)</a>  la .alis. klama le zarci
        .i ri goi ko'a blanu
    Alice goes-to the store.
        It-last-mentioned also-known-as it-1 is-blue.
</pre>
    allows the store to be referred to henceforth as ``ko'a''
    without ambiguity. <a href="#e6d7">Example 6.7</a> is
    equivalent to <a href="#e5d1">Example 5.1</a> and eliminates
    any possibility of ``ko'a'' being interpreted by the listener
    as referring to Alice. 

    <p>The cmavo ``go'i'', ``go'a'', and ``go'u'' follow exactly
    the same rules as ``ri'', ``ra'', and ``ru'', except that they
    are pro-bridi, and therefore repeat bridi, not sumti ---
    specifically, main sentence bridi. Any bridi that are embedded
    within other bridi, such as relative clauses or abstractions,
    are not counted. Like the cmavo of the broda-series, the cmavo
    of the go'i-series copy all sumti with them. This makes
    ``go'i'' by itself convenient for answering a question
    affirmatively, or for repeating the last bridi, possibly with
    new sumti:</p>
<pre>
<a id="e6d8" name="e6d8">6.8)</a>  xu zo djan. cmene do
        .i go'i
    [True-false?] The-word ``John'' is-the-name of you?
        [repeat last bridi].
    Is John your name?  Yes.

<a id="e6d9" name="e6d9">6.9)</a>   mi klama le zarci .i do go'i
    I go-to the store.  You [repeat last bridi].
    I go to the store.  You, too.
</pre>
    Note that <a href="#e6d9">Example 6.9</a> means the same as <a
    href="#e5d6">Example 5.6</a>, but without the bother of
    assigning an actual broda-series word to the first bridi. For
    long-term reference, use ``go'i cei broda'' or the like,
    analogously to ``ri goi ko'a'' in <a href="#e6d7">Example
    6.7</a>. 

    <p>The remaining four cmavo of the go'i-series are provided for
    convenience or for achieving special effects. The cmavo
    ``go'e'' means the same as ``go'ixire'': it repeats the last
    bridi but one. This is useful in conversation:</p>
<pre>
<a id="e6d10" name="e6d10">6.10)</a>    A: mi ba klama le zarci
    B: mi nelci le si'o mi go'i
    A: do go'e

    A: I [future] go-to the store.
    B: I like the concept-of I [repeat last bridi].
    A: You [repeat last bridi but one].

    A: I am going to the store.
    B: I like the idea of my going.
    A: You'll go, too.
</pre>

    <p>Here B's sentence repeats A's within an abstraction
    (explained in Chapter 11): ``le si'o mi go'i'' means ``le si'o
    mi klama le zarci''. Why must B use the word ``mi'' explicitly
    to replace the x1 of ``mi klama le zarci'', even though it
    looks like ``mi'' is replacing ``mi''? Because B's ``mi''
    refers to B, whereas A's ``mi'' refers to A. If B said:</p>
<pre>
<a id="e6d11" name="e6d11">6.11)</a>    mi nelci le si'o go'i
</pre>
    that would mean: 

    <dl>
      <dt></dt>

      <dd>I like the idea of your going to the store.</dd>
    </dl>
    The repetition implied by ``go'i'' is not literally by words,
    but by concepts. Finally, A repeats her own sentence, but with
    the x1 changed to ``do'', meaning B. Note that in <a
    href="#e6d10">Example 6.10</a>, the tense ``ba'' (future time)
    is carried along by both ``go'i'' and ``go'e''. 

    <p>Descriptions based on go'i-series cmavo can be very useful
    for repeating specific sumti of previous bridi:</p>

    <p></p>
<pre>
<a id="e6d12" name="e6d12">6.12)</a>    le xekri mlatu cu klama le zarci
        .i le go'i cu
            cadzu le bisli
    The black cat goes-to the store.
        That-described-as-the-x1-place-of [repeat last bridi]
            walks-on the ice.
    The black cat goes to the store.  It walks on the ice.
</pre>

    <p>Here the ``go'i'' repeats ``le xekri mlatu cu klama le
    zarci'', and since ``le'' makes the x1 place into a
    description, and the x1 place of this bridi is ``le xekri
    mlatu'', ``le go'i'' means ``le xekri mlatu''.</p>

    <p>The cmavo ``go'o'', ``nei'', and ``no'a'' have been little
    used so far. They repeat respectively some future bridi, the
    current bridi, and the bridi that encloses the current bridi
    (``no'a'', unlike the other members of the go'i- series, can
    repeat non-sentence bridi). Here are a few examples:</p>
<pre>
<a id="e6d13" name="e6d13">6.13)</a>    mi nupre le nu mi go'o
        .i ba dunda le djini le bersa
        .i ba dunda le zdani le tixnu
    I promise the event-of I [repeat future bridi]
        [Future] give the money to-the son
        [Future] give the house to-the daughter
    I promise to do the following:
        Give the money to my son.
        Give the house to my daughter.
</pre>
    (Note: The Lojban does not contain an equivalent of the ``my''
    in the colloquial English; it leaves the fact that it is the
    speaker's son and daughter that are referred to implicit. To
    make the fact explicit, use ``le bersa/tixnu be mi''.) 

    <p>For good examples of ``nei'' and ``no'a'', we need nested
    bridi contexts:</p>
<pre>
<a id="e6d14" name="e6d14">6.14)</a>    mi se pluka le nu do pensi
        le nu nei kei
        pu le nu do zukte
    I am-pleased-by the event-of (you think-about
        (the event-of [main bridi])
        before the-event of (your acting).
    I am pleased that you thought about whether I
        would be pleased (about ... ) before you acted.

<a id="e6d15" name="e6d15">6.15)</a> mi ba klama ca le nu
        do no'a
    I [future] go [present] the event-of
        you [repeats outer bridi]
    I will go when you do.
</pre>
    Finally, ``ra'o'' is a cmavo that can be appended to any
    go'i-series cmavo, or indeed any cmavo of selma'o GOhA, to
    signal that pro-sumti or pro-bridi cmavo in the antecedent are
    to be repeated literally and reinterpreted in their new
    context. Normally, any pro-sumti used within the antecedent of
    the pro-bridi keep their meanings intact. In the presence of
    ``ra'o'', however, their meanings must be reinterpreted with
    reference to the new environment. If someone says to you: 
<pre>
<a id="e6d16" name="e6d16">6.16)</a>    mi ba lumci lemi karca
    I will wash my car.
</pre>
    you might reply either: 
<pre>
<a id="e6d17" name="e6d17">6.17)</a>    mi go'i
    I will wash your car.
</pre>
    or: 
<pre>
<a id="e6d18" name="e6d18">6.18)</a>    mi go'i ra'o
    I will wash my car.
</pre>

    <p>The ``ra'o'' forces the second ``mi'' from the original
    bridi to mean the new speaker rather than the former speaker.
    This means that ``go'e ra'o'' would be an acceptable
    alternative to ``do go'e'' in B's statement in <a
    href="#e6d10">Example 6.10</a>.</p>

    <p>The anaphoric pro-sumti of this section can be used in
    quotations, but never refer to any of the supporting text
    outside the quotation, since speakers presumably do not know
    that they may be quoted by someone else.</p>

    <p>However, a ``ri''-series or ``go'a''-series reference within
    a quotation can refer to something mentioned in an earlier
    quotation if the two quotations are closely related in time and
    context. This allows a quotation to be broken up by narrative
    material without interfering with the pro-sumti within it.
    Here's an example:</p>
<pre>
<a id="e6d19" name="e6d19">6.19)</a>    la djan. cusku lu mi klama le zarci li'u
        .i la .alis. cusku lu mi go'i li'u
    John says [quote] I go-to the store [unquote].
        Alice says [quote] I [repeat] [unquote].
    John says, ``I am going to the store.''
        Alice says, ``Me too.''
</pre>
    Of course, there is no problem with narrative material
    referring to something within a quotation: people who quote,
    unlike people who are quoted, are aware of what they are doing.
    

    <h3><a id="s7" name="s7">7. Indefinite pro-sumti and pro-bridi: the zo'e-series and
    the co'e-series</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   zo'e    KOhA    zo'e-series the obvious value
    zu'i    KOhA    zo'e-series the typical value
    zi'o    KOhA    zo'e-series the nonexistent value
    co'e    GOhA    co'e-series has the obvious relationship
</pre>
    The cmavo of the zo'e-series represent indefinite, unspecified
    sumti. The cmavo ``zo'e'' represents an elliptical value for
    this sumti place; it is the optional spoken place holder when a
    sumti is skipped without being specified. Note that the
    elliptical value is not always the typical value. The
    properties of ellipsis lead to an elliptical sumti being
    defined as ``whatever I want it to mean but haven't bothered to
    figure out, or figure out how to express''. 

    <p>The cmavo ``zu'i'', on the other hand, represents the
    typical value for this place of this bridi:</p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  mi klama le bartu be le zdani
        le nenri be le zdani
        zu'i zu'i
    I go to-the outside of the house
        from-the inside of the house
        [by-typical-route] [by-typical-means]
</pre>

    <p>In <a href="#e7d1">Example 7.1</a>, the first ``zu'i''
    probably means something like ``by the door'', and the second
    ``zu'i'' probably means something like ``on foot'', those being
    the typical route and means for leaving a house. On the other
    hand, if you are at the top of a high rise during a fire,
    neither ``zu'i'' is appropriate. It's also common to use
    ``zu'i'' in ``by standard'' places.</p>

    <p>Finally, the cmavo ``zi'o'' represents a value which does
    not even exist. When a bridi fills one of its places with
    ``zi'o'', what is really meant is that the selbri has a place
    which is irrelevant to the true relationship the speaker wishes
    to express. For example, the place structure of ``zbasu''
    is</p>

    <dl>
      <dt></dt>

      <dd>actor x1 makes x2 from materials x3</dd>
    </dl>
    Consider the sentence 

    <dl>
      <dt></dt>

      <dd>Living things are made from cells.</dd>
    </dl>

    <p>This cannot be correctly expressed as:</p>
<pre>
<a id="e7d2" name="e7d2">7.2)</a>  loi jmive cu se zbasu [zo'e] fi loi selci
    The-mass-of living-things is-made [by-something]
        from the-mass-of cells
</pre>
    because the ``zo'e'', expressed or understood, in <a
    href="#e7d2">Example 7.2</a> indicates that there is still a
    ``maker'' in this relationship. We do not generally suppose,
    however, that someone ``makes'' living things from cells. The
    best answer is probably to find a different selbri, one which
    does not imply a ``maker'': however, an alternative strategy is
    to use ``zi'o'' to eliminate the maker place: 
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  loi jmive cu se zbasu zi'o
        loi selci
    The-mass-of living-things is-made [without-maker]
        from the-mass-of cells.
</pre>
    Note: The use of ``zi'o'' to block up, as it were, one place of
    a selbri actually creates a new selbri with a different place
    structure. Consider the following examples: 
<pre>
<a id="e7d4" name="e7d4">7.4)</a>  mi zbasu le dinju loi mudri
    I make the building from-some-of-the-mass-of wood.
    I make the building out of wood.

<a id="e7d5" name="e7d5">7.5)</a>   zi'o zbasu le dinju
        loi mudri
    [without-maker] makes the building
        from-some-of-the-mass-of wood.
    The building is made out of wood.

<a id="e7d6" name="e7d6">7.6)</a>   mi zbasu zi'o
        loi mudri
    I make [without-thing-made]
        from-some-of-the-mass-of wood.
    I build using wood.

<a id="e7d7" name="e7d7">7.7)</a>   mi zbasu loi mudri zi'o
    I make the building [without-material].
    I make the building.
</pre>

    <p>If <a href="#e7d4">Example 7.4</a> is true, then <a
    href="#e7d5">Examples 7.5</a> through <a href="#e7d7">7.7</a>
    must be true also. However, <a href="#e7d3">Example 7.3</a>
    does not correspond to any sentence with three regular
    (non-``zi'o'') sumti.</p>

    <p>The pro-bridi ``co'e'' (which by itself constitutes the
    co'e-series of selma'o GOhA) represents the elliptical selbri.
    Lojban grammar does not allow the speaker to merely omit a
    selbri from a bridi, although any or all sumti may be freely
    omitted. Being vague about a relationship requires the use of
    ``co'e'' as a selbri place-holder:</p>
<pre>
<a id="e7d8" name="e7d8">7.8)</a>  mi troci le nu
        mi co'e le vorme
    I try the event-of
        my [doing-the-obvious-action] to-the door.
    I try the door.
</pre>

    <p>The English version means, and the Lojban version probably
    means, that I try to open the door, but the relationship of
    opening is not actually specified; the Lojbanic listener must
    guess it from context. Lojban, unlike English, makes it clear
    that there is an implicit action that is not being
    expressed.</p>

    <p>The form of ``co'e'' was chosen to resemble ``zo'e''; the
    cmavo ``do'e'' of selma'o BAI (see <a href="chapter9.html">Chapter
    9</a>) also belongs to the same group of cmavo.</p>

    <p>Note that ``do'i'', of the di'u-series, is also a kind of
    indefinite pro-sumti: it is indefinite in referent, but is
    restricted to referring only to an utterance.</p>

    <h3><a id="s8" name="s8">8. Reflexive and reciprocal pro-sumti: the vo'a-series</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   vo'a    KOhA    vo'a-series x1 of this bridi
    vo'e    KOhA    vo'a-series x2 of this bridi
    vo'i    KOhA    vo'a-series x3 of this bridi
    vo'o    KOhA    vo'a-series x4 of this bridi
    vo'u    KOhA    vo'a-series x5 of this bridi
    soi SOI         reciprocity
    se'u    SEhU            soi terminator
</pre>
    The cmavo of the vo'a-series are pro-sumti anaphora, like those
    of the ri-series, but have a specific function. These cmavo
    refer to the other places of the same bridi; the five of them
    represent up to five places. The same vo'a-series cmavo mean
    different things in different bridi. Some examples: 

    <p></p>
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  mi lumci vo'a
    I wash myself
</pre>
<pre>
<a id="e8d2" name="e8d2">8.2)</a>  mi klama le zarci vo'e
    I go to the store from itself
        [by some route unspecified].
</pre>
    To refer to places of neighboring bridi, constructions like
    ``le se go'i ku'' do the job: this refers to the 2nd place of
    the previous main bridi, as explained in <a href="#s6">Section
    6</a>. 

    <p>The cmavo of the vo'a-series are also used with ``soi'' (of
    selma'o SOI) to precisely express reciprocity, which in English
    is imprecisely expressed with a discursive phrase like ``vice
    versa'':</p>

    <p></p>
<pre>
<a id="e8d3" name="e8d3">8.3)</a>  mi prami do
        soi vo'a vo'e
    I love you
        [reciprocity] [x1 of this bridi]
        [x2 of this bridi].
    I love you and vice versa (swapping ``I'' and ``you'').
</pre>
    The significance of ``soi vo'a vo'e'' is that the bridi is
    still true even if the x1 (specified by ``vo'a'') and the x2
    (specified by ``vo'e'') places are interchanged. If only a
    single sumti follows ``soi'', then the sumti immediately
    preceding ``soi'' is understood to be one of those involved: 
<pre>
<a id="e8d4" name="e8d4">8.4)</a>  mi prami do soi vo'a
    I love you [reciprocity] [x1 of this bridi].
</pre>
    again involves the x1 and x2 places. 

    <p>Of course, other places can be involved, and other sumti may
    be used in place of vo'a-series cmavo, provided those other
    sumti can be reasonably understood as referring to the same
    things mentioned in the bridi proper. Here are several examples
    that mean the same thing:</p>
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  mi bajra ti ta soi vo'e
    mi bajra ti ta soi vo'e vo'i
    soi vo'e vo'i mi bajra ti ta
    I run to this from that and vice versa
        (to that from this).
</pre>
    The elidable terminator for ``soi'' is ``se'u'' (selma'o SEhU),
    which is normally needed only if there is just one sumti after
    the ``soi'', and the ``soi'' construction is not at the end of
    the bridi. Constructions using ``soi'' are free modifiers, and
    as such can go almost anywhere. Here is an example where
    ``se'u'' is required: 
<pre>
<a id="e8d6" name="e8d6">8.6)</a>  mi bajykla ti
        soi vo'i se'u ta
    I runningly-go to-this
        [reciprocity] [x3 of this bridi] from-that
    I run to this from that and vice versa.
</pre>

    <h3><a id="s9" name="s9">9. sumti and bridi questions: ``ma'' and ``mo''</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ma  KOhA            sumti question
    mo  GOhA            bridi question
</pre>
    Lojban questions are more fully explained in <a
    href="chapter19.html">Chapter 19</a>, but ``ma'' and ``mo'' are
    listed in this chapter for completeness. The cmavo ``ma'' asks
    for a sumti to make the bridi true: 
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  do klama ma
    You go to-what-destination?
    Where are you going?
</pre>
    The cmavo ``mo'', on the other hand, asks for a selbri which
    makes the question bridi true. If the answer is a full bridi,
    then the arguments of the answer override the arguments in the
    question, in the same manner as the go'i-series cmavo. A simple
    example is: 
<pre>
<a id="e9d2" name="e9d2">9.2)</a>  do mo
    What predicate is true as applied to you?
    How are you?
    What are you doing?
    What are you?
</pre>
    <a href="#e9d3">Example 9.3</a> is a truly pregnant question
    that will have several meanings depending on context. 

    <p>(One thing it probably does not mean is ``Who are you?'' in
    the sense ``What is your name/identity?'', which is better
    expressed by:</p>

    <p></p>
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  ma cmene do
    What sumti is-the-name-of you?
    What is your name?
</pre>
    or even 
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  doi ma
    O [what sumti?]
</pre>
    which uses the vocative ``doi'' to address someone, and
    simultaneously asks who the someone is.) 

    <p>A further example of ``mo'':</p>
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  lo mo prenu cu darxi do
        .i barda
    A [what selbri?] type-of person hit you?
        (Observative:) A big thing.
    Which person hit you?  The big one.
</pre>
    When ``ma'' or ``mo'' is repeated, multiple questions are being
    asked simultaneously: 

    <p></p>
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  ma djuno ma
    [what sumti] knows [what sumti]?
    Who knows what?
</pre>

    <h3><a id="s10" name="s10">10. Relativized pro-sumti: ``ke'a''</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ke'a    KOhA            relativized sumti
</pre>
    This pro-sumti is used in relative clauses (explained in <a
    href="chapter8.html">Chapter 8</a>) to indicate how the sumti
    being relativized fits within the clause. For example: 

    <p></p>
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    mi catlu lo mlatu
        poi [zo'e] zbasu
            ke'a
            lei slasi
    I see a cat such-that
        something-unspecified makes
            the-thing-being-relativized [the cat]
            from-some-mass-of plastic.
    I see a cat made of plastic.
</pre>
    If ``ke'a'' were omitted from <a href="#e10d1">Example
    10.1</a>, it might be confused with: 
<pre>
<a id="e10d2" name="e10d2">10.2)</a>    mi catlu lo mlatu poi [ke'a]
        zbasu lei slasi
    I see a cat such-that the-thing-being-relativized
        [the cat] makes a-mass-of plastic
    I see a cat that makes plastic.
</pre>
    The anaphora cmavo ``ri'' cannot be used in place of ``ke'a''
    in <a href="#e10d1">Example 10.1</a> and <a
    href="#e10d2">Example 10.2</a>, because the relativized sumti
    is not yet complete when the ``ke'a'' appears. 

    <p>Note that ``ke'a'' is used only with relative clauses, and
    not with other embedded bridi such as abstract descriptions. In
    the case of relative clauses within relative clauses, ``ke'a''
    may be subscripted to make the difference clear (see <a
    href="chapter8.html">Chapter 8</a>).</p>

    <h3><a id="s11" name="s11">11. Abstraction focus pro-sumti: ``ce'u''</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ce'u    KOhA            abstraction focus
</pre>
    The cmavo ``ce'u'' is used within abstraction bridi,
    particularly property abstractions introduced by the cmavo
    ``ka''. Abstractions, including the uses of ``ce'u'', are
    discussed in full in <a href="chapter11.html">Chapter 11</a>. 

    <p>In brief: Every property abstraction specifies a property of
    one of the sumti in it; that sumti place is filled by using
    ``ce'u''. This convention enables us to distinguish clearly
    between:</p>

    <p></p>
<pre>
<a id="e11d1" name="e11d1">11.1)</a>    le ka ce'u gleki
    the property-of (X being-happy)
    the property of being happy
    happiness
</pre>
    and 
<pre>
<a id="e11d2" name="e11d2">11.2)</a>    le ka gleki ce'u
    the property-of (being-happy about-X)
    the property of being that which
        someone is happy about

    
</pre>

    <h3><a id="s12" name="s12">12. Bound variable pro-sumti and pro-bridi: the da-series
    and the bu'a-series</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   da  KOhA    da-series   something-1
    de  KOhA    da-series   something-2
    di  KOhA    da-series   something-3
    bu'a    GOhA    bu'a-series some-predicate-1
    bu'e    GOhA    bu'a-series some-predicate-2
    bu'i    GOhA    bu'a-series some-predicate-3    
</pre>
    Bound variables belong to the predicate-logic part of Lojban,
    and are listed here for completeness only. Their semantics is
    explained in <a href="chapter16.html">Chapter 16</a>. It is worth
    mentioning that the Lojban translation of <a
    href="#e1d2">Example 1.2</a> is: 

    <p></p>
<pre>
<a id="e12d1" name="e12d1">12.1)</a>    la djan. cu lafti
        da poi grana ku'o
        gi'e desygau da
    John raised
        something-1 which is-a-stick
        and shake-did something-1
    John picked up a stick and shook it.
</pre>

    <h3><a id="s13" name="s13">13. Pro-sumti and pro-bridi cancelling</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   da'o    DAhO        cancel all pro-sumti/pro-bridi
</pre>
    How long does a pro-sumti or pro-bridi remain stable? In other
    words, once we know the referent of a pro-sumti or pro-bridi,
    how long can we be sure that future uses of the same cmavo have
    the same referent? The answer to this question depends on which
    series the cmavo belongs to. 

    <p>Personal pro-sumti are stable until there is a change of
    speaker or listener, possibly signaled by a vocative.
    Assignable pro-sumti and pro-bridi last indefinitely or until
    rebound with ``goi'' or ``cei''. Bound variable pro-sumti and
    pro-bridi also generally last until re-bound; details are
    available in <a href="chapter16.html">Chapter 16</a>.</p>

    <p>Utterance pro-sumti are stable only within the utterance in
    which they appear; similarly, reflexive pro-sumti are stable
    only within the bridi in which they appear; and ``ke'a'' is
    stable only within its relative clause. Anaphoric pro-sumti and
    pro-bridi are stable only within narrow limits depending on the
    rules for the particular cmavo.</p>

    <p>Demonstrative pro-sumti, indefinite pro-sumti and pro-bridi,
    and sumti and bridi questions potentially change referents
    every time they are used.</p>

    <p>However, there are ways to cancel all pro-sumti and
    pro-bridi, so that none of them have known referents. (Some,
    such as ``mi'', will acquire the same referent as soon as they
    are used again after the cancellation.) The simplest way to
    cancel everything is with the cmavo ``da'o'' of selma'o DAhO,
    which is used solely for this purpose; it may appear anywhere,
    and has no effect on the grammar of texts containing it. One
    use of ``da'o'' is when entering a conversation, to indicate
    that one's pro-sumti assignments have nothing to do with any
    assignments already made by other participants in the
    conversation.</p>

    <p>In addition, the cmavo ``ni'o'' and ``no'i'' of selma'o
    NIhO, which are used primarily to indicate shifts in topic, may
    also have the effect of canceling pro-sumti and pro-bridi
    assignments, or of reinstating ones formerly in effect. More
    explanations of NIhO can be found in <a
    href="chapter19.html">Chapter 19</a>.</p>

    <h3><a id="s14" name="s14">14. The identity predicate: du</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   du  GOhA            identity
</pre>
    The cmavo ``du'' has the place structure: 

    <dl>
      <dt></dt>

      <dd>x1 is identical with x2, x3, ...</dd>
    </dl>
    and appears in selma'o GOhA for reasons of convenience: it is
    not a pro-bridi. ``du'' serves as mathematical ``='', and
    outside mathematical contexts is used for defining or
    identifying. Mathematical examples may be found in <a
    href="chapter18.html">Chapter 18</a>. 

    <p>The main difference between</p>
<pre>
<a id="e14d1" name="e14d1">14.1)</a>    ko'a du le nanmu
    it-1 is-identical-to the man
</pre>
    and 
<pre>
<a id="e14d2" name="e14d2">14.2)</a>    ko'a mintu le nanmu
    it-1 is-the-same-as the man
</pre>
    is this defining nature. <a href="#e14d1">Example 14.1</a>
    presumes that the speaker is responding to a request for
    information about what ``ko'a'' refers to, or that the speaker
    in some way feels the need to define ``ko'a'' for later
    reference. A bridi with ``du'' is an identity sentence,
    somewhat metalinguistically saying that all attached sumti are
    representations for the same referent. There may be any number
    of sumti associated with ``du'', and all are said to be
    identical. 

    <p><a href="#e14d2">Example 14.2</a>, however, predicates; it
    is used to make a claim about the identity of ``ko'a'', which
    presumably has been defined previously.</p>

    <p>Note: ``du'' historically is derived from ``dunli'', but
    ``dunli'' has a third place which ``du'' lacks: the standard of
    equality.</p>

    <h3><a id="s15" name="s15">15. lujvo based on pro-sumti</h3>

    <p>There exist rafsi allocated to a few cmavo of selma'o KOhA,
    but they are rarely used. (See <a href="#s16">Section 16</a>
    for a complete list.) The obvious way to use them is as
    internal sumti, filling in an appropriate place of the gismu or
    lujvo to which they are attached; as such, they usually stand
    as the first rafsi in their lujvo.</p>

    <p>Thus ``donta'a'', meaning ``you-talk'', would be interpreted
    as ``tavla be do'', and would have the place structure</p>
<pre>
<a id="e15d1" name="e15d1">15.1)</a>    t1 talks to you about subject t3 in language t4
</pre>
    since t2 (the addressee) is already known to be ``do''. 

    <p>On the other hand, the lujvo ``donma'o'', literally
    ``you-cmavo'', which means ``a second person personal
    pronoun'', would be interpreted as ``cmavo be zo do'', and have
    the place structure:</p>
<pre>
<a id="e15d2" name="e15d2">15.2)</a>    c1 is a second person pronoun in language c4
</pre>
    since both the c2 place (the grammatical class) and the c3
    place (the meaning) are obvious from the context ``do''. 

    <p>An anticipated use of rafsi for cmavo in the ``fo'a'' series
    is to express terjvo which can't be expressed in a convenient
    rafsi form, because they are too long to express, or are
    formally inconvenient (fu'ivla, cmene, and so forth.) An
    example would be:</p>
<pre>
<a id="e15d3" name="e15d3">15.3)</a>    fo'a goi le kulnrsu,omi .i lo fo'arselsanga
    x6 stands for Finnish-culture.  An x6-song
</pre>
    Finally, lujvo involving ``zi'o'' are also possible, and are
    fully discussed in <a href="chapter12.html">Chapter 12</a>. In
    brief, the convention is to use the rafsi for ``zi'o'' as a
    prefix immediately followed by the rafsi for the number of the
    place to be deleted. Thus, if we consider a beverage (something
    drunk without considering who, if anyone, drinks it) as a ``se
    pinxe be zi'o'', the lujvo corresponding to this is
    ``zilrelselpinxe'' (deleting the second place of ``se pinxe'').
    Deleting the x1 place in this fashion would move all remaining
    places up by one. This would mean that ``zilpavypinxe'' has the
    same place structure as ``zilrelselpinxe'', and ``lo
    zilpavypinxe'', like ``lo zilrelselpinxe'', refers to a
    beverage, and not to a non-existent drinker. 

    <p>The pro-bridi ``co'e'', ``du'', and ``bu'a'' also have
    rafsi, which can be used just as if they were gismu. The
    resulting lujvo have (except for ``du''-based lujvo) highly
    context-dependent meanings.</p>

    <h3><a id="s16" name="s16">16. KOhA cmavo by series</h3>

    <p></p>

    <dl>
      <dt></dt>

      <dd>mi-series: mi I (rafsi: ``mib'') do you (rafsi: ``don''
      and ``doi'') mi'o you and I mi'a I and others, we but not you
      ma'a you and I and others do'o you and others ko
      you-imperative</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>ti-series: ti this here; something nearby (rafsi:
      ``tif'') ta that there; something distant (rafsi: ``taz'') tu
      that yonder; something far distant (rafsi: ``tuf'')</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>di'u-series: di'u the previous utterance de'u an earlier
      utterance da'u a much earlier utterance di'e the next
      utterance de'e a later utterance da'e a much later utterance
      dei this very utterance do'i some utterance</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>ko'a-series: ko'a it-1; 1st assignable pro-sumti ko'e
      it-2; 2nd assignable pro-sumti ko'i it-3; 3rd assignable
      pro-sumti ko'o it-4; 4th assignable pro-sumti ko'u it-5; 5th
      assignable pro-sumti fo'a it-6; 6th assignable pro-sumti
      (rafsi: ``fo'a'') fo'e it-7; 7th assignable pro-sumti (rafsi:
      ``fo'e'') fo'i it-8; 8th assignable pro-sumti (rafsi:
      ``fo'i'') fo'o it-9; 9th assignable pro-sumti fo'u it-10;
      10th assignable pro-sumti</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>ri-series: ri (repeats the last sumti) ra (repeats a
      previous sumti) ru (repeats a long-ago sumti)</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>zo'e-series: zo'e the obvious value zu'i the typical
      value zi'o the nonexistent value (rafsi: ``zil'')</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>vo'a-series: vo'a x1 of this bridi vo'e x2 of this bridi
      vo'i x3 of this bridi vo'o x4 of this bridi vo'u x5 of this
      bridi</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>da-series: da something-1 (rafsi: ``dav''/``dza'') de
      something-2 di something-3</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>others: ke'a relativized sumti ma sumti question ce'u
      abstraction focus</dd>
    </dl>

    <h3><a id="s17" name="s17">17. GOhA and other pro-bridi by series</h3>

    <p></p>

    <dl>
      <dt></dt>

      <dd>broda-series (not GOhA): broda is-1; 1st assignable
      pro-bridi brode is-2; 2nd assignable pro-bridi brodi is-3;
      3rd assignable pro-bridi brodo is-4; 4th assignable pro-bridi
      brodu is-5; 5th assignable pro-bridi</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>go'i-series: go'i (repeats the last bridi) go'a (repeats
      a previous bridi) go'u (repeats a long-ago bridi) go'e
      (repeats the last-but-one bridi) go'o (repeats a future
      bridi) nei (repeats the current bridi) no'a (repeats the next
      outer bridi)</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>bu'a-series: bu'a some-predicate-1 (rafsi: ``bul'') bu'e
      some-predicate-2 bu'i some-predicate-3</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>others: co'e has the obvious relationship (rafsi:
      ``com''/``co'e'') mo bridi question du identity: x1 is
      identical to x2, x3 ... (rafsi: ``dub''/``du'o'')</dd>
    </dl>

    <h3><a id="s18" name="s18">17. Other cmavo discussed in this chapter</h3>

    <p></p>
<pre>
   goi GOI pro-sumti assignment (ko'a-series)
    cei CEI pro-bridi assignment (broda-series)
    ra'o    RAhO    pro-sumti/pro-bridi update
    soi SOI reciprocity
    se'u    SEhU    soi terminator
    da'o    DAhO    cancel all pro-sumti/pro-bridi
</pre>

    <hr />
    
    <p>Última modificación: Mon Jun 27 23:11:04 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
