
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//SV" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="sv" lang="sv">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 9</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter9.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 9<br />
      To Boston Via The Road Go I, With An Excursion Into The Land
      Of Modals</h2>

      <!--
      <h6>$Revision: 4.0 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. Introductory</h3>

    <p>The basic type of Lojban sentence is the bridi: a claim by
    the speaker that certain objects are related in a certain way.
    The objects are expressed by Lojban grammatical forms called
    ``sumti''; the relationship is expressed by the Lojban
    grammatical form called a ``selbri''.</p>

    <p>The sumti are not randomly associated with the selbri, but
    according to a systematic pattern known as the ``place
    structure'' of the selbri. This chapter describes the various
    ways in which the place structure of Lojban bridi is expressed
    and by which it can be manipulated. The place structure of a
    selbri is a sequence of empty slots into which the sumti
    associated with that selbri are placed. The sumti are said to
    occupy the places of a selbri.</p>

    <p>For our present purposes, every selbri is assumed to have a
    well-known place structure. If the selbri is a brivla, the
    place structure can be looked up in a dictionary (or, if the
    brivla is a lujvo not in any dictionary, inferred from the
    principles of lujvo construction as explained in <a
    href="chapter12.html">Chapter 12</a>); if the selbri is a tanru,
    the place structure is the same as that of the final component
    in the tanru.</p>

    <p>The stock example of a place structure is that of the gismu
    ``klama'':</p>

    <dl>
      <dt></dt>

      <dd>x1 comes/goes to destination x2 from origin x3 via route
      x4 employing means of transport x5.</dd>
    </dl>

    <p>The ``x1 ... x5'' indicates that ``klama'' is a five-place
    predicate, and show the natural order (as assigned by the
    language engineers) of those places: agent, destination,
    origin, route, means.</p>

    <p>The place structures of brivla are not absolutely stable
    aspects of the language. The work done so far has attempted to
    establish a basic place structure on which all users can, at
    first, agree. In the light of actual experience with the
    individual selbri of the language, there will inevitably be
    some degree of change to the brivla place structures.</p>

    <h3><a id="s2" name="s2">2. Standard bridi form: ``cu''</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   cu  CU  prefixed selbri separator
</pre>
    The most usual way of constructing a bridi from a selbri such
    as ``klama'' and an appropriate number of sumti is to place the
    sumti intended for the x1 place before the selbri, and all the
    other sumti in order after the selbri, thus: 

    <p></p>
<pre>
<a id="e2d1"
name="e2d1">2.1)</a>  mi cu klama la bastn. la .atlantas.
        le dargu le karce
    I go to-Boston from-Atlanta
        via-the road using-the car.
</pre>

    <p>Here the sumti are assigned to the places as follows:</p>
<pre>
   x1  agent       mi
    x2  destination la bastn.
    x3  origin      la .atlantas.
    x4  route       le dargu
    x5  means       le karce
</pre>
    (Note: Many of the examples in the rest of this chapter will
    turn out to have the same meaning as <a href="#e2d1">Example
    2.1</a>; this fact will not be reiterated.) 

    <p>This ordering, with the x1 place before the selbri and all
    other places in natural order after the selbri, is called
    ``standard bridi form'', and is found in the bulk of Lojban
    bridi, whether used in main sentences or in subordinate
    clauses. However, many other forms are possible, such as:</p>
<pre>
<a id="e2d2"
name="e2d2">2.2)</a>  mi la bastn. la .atlantas. le dargu
        le karce cu klama
    I, to-Boston from-Atlanta via-the road
        using-the car, go.
</pre>
    Here the selbri is at the end; all the sumti are placed before
    it. However, the same order is maintained. 

    <p>Similarly, we may split up the sumti, putting some before
    the selbri and others after it:</p>
<pre>
<a id="e2d3"
name="e2d3">2.3)</a>  mi la bastn. cu klama la .atlantas. le dargu le karce
    I to-Boston go from-Atlanta via-the road using-the car.
</pre>
    All of the variant forms in this section and following sections
    can be used to place emphasis on the part or parts which have
    been moved out of their standard places. Thus, <a
    href="#e2d2">Example 2.2</a> places emphasis on the selbri
    (because it is at the end); <a href="#e2d3">Example 2.3</a>
    emphasizes ``la bastn.'', because it has been moved before the
    selbri. Moving more than one component may dilute this
    emphasis. It is permitted, but no stylistic significance has
    yet been established for drastic reordering. 

    <p>In all these examples, the cmavo ``cu'' (belonging to
    selma'o CU) is used to separate the selbri from any preceding
    sumti. It is never absolutely necessary to use ``cu''. However,
    providing it helps the reader or listener to locate the selbri
    quickly, and may make it possible to place a complex sumti just
    before the selbri, allowing the speaker to omit elidable
    terminators, possibly a whole stream of them, that would
    otherwise be necessary.</p>

    <p>The general rule, then, is that the selbri may occur
    anywhere in the bridi as long as the sumti maintain their
    order. The only exception (and it is an important one) is that
    if the selbri appears first, the x1 sumti is taken to have been
    omitted:</p>
<pre>
<a id="e2d4"
name="e2d4">2.4)</a>  klama la bastn. la .atlantas. le dargu le karce
    A-goer to-Boston from-Atlanta via-the road using-the car.
    Goes to-Boston from-Atlanta via-the road using-the car.
    Look: a goer to Boston from Atlanta via the road
        using the car!
</pre>
    Here the x1 place is empty: the listener must guess from
    context who is going to Boston. In <a href="#e2d4">Example
    2.4</a>, ``klama'' is glossed ``a goer'' rather than ``go''
    because ``Go'' at the beginning of an English sentence would
    suggest a command: ``Go to Boston!''. <a href="#e2d4">Example
    2.4</a> is not a command, simply a normal statement with the x1
    place unspecified, causing the emphasis to fall on the selbri
    ``klama''. Such a bridi, with empty x1, is called an
    ``observative'', because it usually calls on the listener to
    observe something in the environment which would belong in the
    x1 place. The third translation above shows this observative
    nature. Sometimes it is the relationship itself which the
    listener is asked to observe. 

    <p>(There is a way to both provide a sumti for the x1 place and
    put the selbri first in the bridi: see <a href="#e3d7">Example
    3.7</a>.)</p>

    <p>Suppose the speaker desires to omit a place other than the
    x1 place? (Presumably it is obvious or, for one reason or
    another, not worth saying.) Places at the end may simply be
    dropped:</p>

    <p></p>
<pre>
<a id="e2d5" name="e2d5">2.5)</a>  mi klama la bastn. la .atlantas.
    I go to-Boston from-Atlanta (via an unspecified route,
    using an unspecified means).
</pre>
    <a href="#e2d5">Example 2.5</a> has empty x4 and x5 places: the
    speaker does not specify the route or the means of transport.
    However, simple omission will not work for a place when the
    places around it are to be specified: in 
<pre>
<a id="e2d6"
name="e2d6">2.6)</a>  mi klama la bastn. la .atlantas. le karce
    I go to-Boston from-Atlanta via-the car.
</pre>
    ``le karce'' occupies the x4 place, and therefore <a
    href="#e2d6">Example 2.6</a> means: 

    <dl>
      <dt></dt>

      <dd>I go to Boston from Atlanta, using the car as a
      route.</dd>
    </dl>

    <p>This is nonsense, since a car cannot be a route. What the
    speaker presumably meant is expressed by:</p>
<pre>
<a id="e2d7" name="e2d7">2.7)</a>  mi klama la bastn. la .atlantas.
        zo'e le karce
    I go to-Boston from-Atlanta
        via-something-unspecified using-the car.
</pre>
    Here the sumti cmavo ``zo'e'' is used to explicitly fill the x4
    place; ``zo'e'' means ``the unspecified thing'' and has the
    same meaning as leaving the place empty: the listener must
    infer the correct meaning from context. 

    <h3><a id="s3" name="s3">3. Tagging places: FA</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   fa  FA  tags x1 place
    fe  FA  tags x2 place
    fi  FA  tags x3 place
    fo  FA  tags x4 place
    fu  FA  tags x5 place
    fi'a    FA  place structure question
</pre>
    In sentences like <a href="#e2d1">Example 2.1</a>, it is easy
    to get lost and forget which sumti falls in which place,
    especially if the sumti are more complicated than simple names
    or descriptions. The place structure tags of selma'o FA may be
    used to help clarify place structures. The five cmavo ``fa'',
    ``fe'', ``fi'', ``fo'', and ``fu'' may be inserted just before
    the sumti in the x1 to x5 places respectively: 
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  fa mi cu klama fe la bastn.
        fi la .atlantas. fo le dargu fu le karce
    x1= I go x2= Boston
        x3= Atlanta x4= the road x5= the car.
    I go to Boston from Atlanta via the road using the car.
</pre>
    In <a href="#e3d1">Example 3.1</a>, the tag ``fu'' before ``le
    karce'' clarifies that ``le karce'' occupies the x5 place of
    ``klama''. The use of ``fu'' tells us nothing about the purpose
    or meaning of the x5 place; it simply says that ``le karce''
    occupies it. 

    <p>In <a href="#e3d1">Example 3.1</a>, the tags are overkill;
    they serve only to make <a href="#e2d1">Example 2.1</a> even
    longer than it is. Here is a better illustration of the use of
    FA tags for clarification:</p>
<pre>
<a id="e3d2"
name="e3d2">3.2)</a>  fa mi klama fe le zdani be mi be'o poi nurma vau
        fi la nu,IORK.
    x1= I go x2= (the house of me) which is-rural
        x3= New York.
</pre>

    <p>In <a href="#e3d2">Example 3.2</a>, the place structure of
    ``klama'' is as follows:</p>
<pre>
   x1  agent       mi
    x2  destination le zdani be mi be'o poi nurma vau
    x3  origin      la nu,IORK.
    x4  route       (empty)
    x5  means       (empty)
</pre>
    The ``fi'' tag serves to remind the hearer that what follows is
    in the x3 place of ``klama''; after listening to the complex
    sumti occupying the x2 place, it's easy to get lost. 

    <p>Of course, once the sumti have been tagged, the order in
    which they are specified no longer carries the burden of
    distinguishing the places. Therefore, it is perfectly all right
    to scramble them into any order desired, and to move the selbri
    to anywhere in the bridi, even the beginning:</p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  klama fa mi fi la .atlantas.
        fu le karce fe la bastn. fo le dargu
    go x1= I x3= Atlanta
        x5= the car x2= Boston x4= the road.
    Go I from Atlanta using the car to Boston via the road.
</pre>
    Note that no ``cu'' is permitted before the selbri in <a
    href="#e3d3">Example 3.3</a>, because ``cu'' separates the
    selbri from any preceding sumti, and <a href="#e3d3">Example
    3.3</a> has no such sumti. 
<pre>
<a id="e3d4"
name="e3d4">3.4)</a>  fu le karce fo le dargu fi la .atlantas.
        fe la bastn. cu klama fa mi
    x5= the car x4= the road x3= Atlanta
        x2= Boston go x1=I
    Using the car, via the road, from Atlanta to Boston
        go I.
</pre>
    <a href="#e3d4">Example 3.4</a> exhibits the reverse of the
    standard bridi form seen in <a href="#e2d1">Examples 2.1</a>
    and <a href="#e3d1">3.1</a>, but still means exactly the same
    thing. If the FA tags were left out, however, producing: 
<pre>
<a id="e3d5" name="e3d5">3.5)</a>  le karce le dargu la .atlantas.
        la bastn. cu klama mi
    The car to-the road from-Atlanta
        via-Boston goes using-me.
    The car goes to the road from Atlanta, with Boston
        as the route, using me as a means
        of transport.
</pre>
    the meaning would be wholly changed, and in fact nonsensical. 

    <p>Tagging places with FA cmavo makes it easy not only to
    reorder the places but also to omit undesirable ones, without
    any need for ``zo'e'' or special rules about the x1 place:</p>
<pre>
<a id="e3d6"
name="e3d6">3.6)</a>  klama fi la .atlantas. fe la bastn. fu le karce
    A-goer x3= Atlanta x2= Boston x5 = the car.
    A goer from Atlanta to Boston using the car.
</pre>

    <p>Here the x1 and x4 places are empty, and so no sumti are
    tagged with ``fa'' or ``fo''; in addition, the x2 and x3 places
    appear in reverse order.</p>

    <p>What if some sumti have FA tags and others do not? The rule
    is that after a FA-tagged sumti, any sumti following it occupy
    the places numerically succeeding it, subject to the proviso
    that an already-filled place is skipped:</p>
<pre>
<a id="e3d7"
name="e3d7">3.7)</a>  klama fa mi la bastn. la .atlantas.
        le dargu le karce
    Go x1= I x2= Boston x3= Atlanta
        x4= the road x5= the car.
    Go I to Boston from Atlanta via the road
        using the car.
</pre>

    <p>In <a href="#e3d7">Example 3.7</a>, the ``fa'' causes ``mi''
    to occupy the x1 place, and then the following untagged sumti
    occupy in order the x2 through x5 places. This is the mechanism
    by which Lojban allows placing the selbri first while
    specifying a sumti for the x1 place.</p>

    <p>Here is a more complex (and more confusing) example:</p>
<pre>
<a id="e3d8"
name="e3d8">3.8)</a>  mi klama fi la .atlantas. le dargu
        fe la bastn. le karce
    I go x3= Atlanta the road
        x2= Boston the car.
    I go from Atlanta via the road to Boston using the car.
</pre>

    <p>In <a href="#e3d8">Example 3.8</a>, ``mi'' occupies the x1
    place because it is the first sumti in the sentence (and is
    before the selbri). The second sumti, ``la .atlantas.'',
    occupies the x3 place by virtue of the tag ``fi'', and ``le
    dargu'' occupies the x4 place as a result of following ``la
    .atlantas.''. Finally, ``la bastn.'' occupies the x2 place
    because of its tag ``fe'', and ``le karce'' skips over the
    already-occupied x3 and x4 places to land in the x5 place.</p>

    <p>Such a convoluted use of tags should probably be avoided
    except when trying for a literal translation of some English
    (or other natural-language) sentence; the rules stated here are
    merely given so that some standard interpretation is
    possible.</p>

    <p>It is grammatically permitted to tag more than one sumti
    with the same FA cmavo. The effect is that of making more than
    one claim:</p>

    <p></p>
<pre>
<a id="e3d9" name="e3d9">3.9)</a>  [fa] la rik. fa la djein. klama
        [fe] le skina fe le zdani fe le zarci
    [x1=] Rick x1= Jane goes-to
        x2= the movie x2= the house x2= the office
</pre>
    may be taken to say that both Rick and Jane go to the movie,
    the house, and the office, merging six claims into one. More
    likely, however, it will simply confuse the listener. There are
    better ways, involving logical connectives (explained in <a
    href="chapter14.html">Chapter 14</a>), to say such things in
    Lojban. In fact, putting more than one sumti into a place is
    odd enough that it can only be done by explicit FA usage: this
    is the motivation for the proviso above, that already-occupied
    places are skipped. In this way, no sumti can be forced into a
    place already occupied unless it has an explicit FA cmavo
    tagging it. 

    <p>The cmavo ``fi'a'' also belongs to selma'o FA, and allows
    Lojban users to ask questions about place structures. A bridi
    containing ``fi'a'' is a question, asking the listener to
    supply the appropriate other member of FA which will make the
    bridi a true statement:</p>

    <p></p>
<pre>
<a id="e3d10"
name="e3d10">3.10)</a>    fi'a do dunda [fe] le vi rozgu
    [what place]? you give x2= the nearby rose
    In what way are you involved in the giving of this rose?
    Are you the giver or the receiver of this rose?
</pre>

    <p>In <a href="#e3d10">Example 3.10</a>, the speaker uses the
    selbri ``dunda'', whose place structure is:</p>

    <dl>
      <dt></dt>

      <dd>x1 gives x2 to x3</dd>
    </dl>
    The tagged sumti ``fi'a do'' indicates that the speaker wishes
    to know whether the sumti ``do'' falls in the x1 or the x3
    place (the x2 place is already occupied by ``le rozgu''). The
    listener can reply with a sentence consisting solely of a FA
    cmavo: ``fa'' if the listener is the giver, ``fi'' if he/she is
    the receiver. 

    <p>I have inserted the tag ``fe'' in brackets into <a
    href="#e3d10">Example 3.10</a>, but it is actually not
    necessary, because ``fi'a'' does not count as a numeric tag;
    therefore, ``le vi rozgu'' would necessarily be in the x2 place
    even if no tag were present, because it immediately follows the
    selbri.</p>

    <p>There is also another member of FA, namely ``fai'', which is
    discussed in <a href="#s12">Section 12</a>.</p>

    <h3><a id="s4" name="s4">4. Conversion: SE</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   se  SE  2nd place conversion
    te  SE  3rd place conversion
    ve  SE  4th place conversion
    xe  SE  5th place conversion
</pre>
    So far we have seen ways to move sumti around within a bridi,
    but the actual place structure of the selbri has always
    remained untouched. The conversion cmavo of selma'o SE are
    incorporated within the selbri itself, and produce a new selbri
    (called a converted selbri) with a different place structure.
    In particular, after the application of any SE cmavo, the
    number and purposes of the places remain the same, but two of
    them have been exchanged, the x1 place and another. Which place
    has been exchanged with x1 depends on the cmavo chosen. Thus,
    for example, when ``se'' is used, the x1 place is swapped with
    the x2 place. 

    <p>Note that the cmavo of SE begin with consecutive consonants
    in alphabetical order. There is no ``1st place conversion''
    cmavo, because exchanging the x1 place with itself is a
    pointless maneuver.</p>

    <p>Here are the place structures of ``se klama'':</p>

    <dl>
      <dt></dt>

      <dd>x1 is the destination of x2's going from x3 via x4 using
      x5</dd>
    </dl>
    and ``te klama'': 

    <dl>
      <dt></dt>

      <dd>x1 is the origin and x2 the destination of x3 going via
      x4 using x5</dd>
    </dl>
    and ``ve klama'': 

    <dl>
      <dt></dt>

      <dd>x1 is the route to x2 from x3 used by x4 going via
      x5</dd>
    </dl>
    and ``xe klama'': 

    <dl>
      <dt></dt>

      <dd>x1 is the means in going to x2 from x3 via x4 employed by
      x5</dd>
    </dl>
    Note that the place structure numbers in each case continue to
    be listed in the usual order, x1 to x5. 

    <p>Consider the following pair of examples:</p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  la bastn. cu se klama mi
    Boston is-the-destination of-me.
    Boston is my destination.
    Boston is gone to by me.

<a id="e4d2" name="e4d2">4.2)</a>   fe la bastn. cu klama fa mi
    x2 = Boston go x1=I.
    To Boston go I.
</pre>
    <a href="#e4d1">Example 4.1</a> and <a href="#e4d2">Example
    4.2</a> mean the same thing, in the sense that there is a
    relationship of going with the speaker as the agent and Boston
    as the destination (and with unspecified origin, route, and
    means). Structurally, however, they are quite different. <a
    href="#e4d1">Example 4.1</a> has ``la bastn.'' in the x1 place
    and ``mi'' in the x2 place of the selbri ``se klama'', and uses
    standard bridi order; <a href="#e4d2">Example 4.2</a> has
    ``mi'' in the x1 place and ``la bastn.'' in the x2 place of the
    selbri ``klama'', and uses a non-standard order. 

    <p>The most important use of conversion is in the construction
    of descriptions. A description is a sumti which begins with a
    cmavo of selma'o LA or LE, called the descriptor, and contains
    (in the simplest case) a selbri. We have already seen the
    descriptions ``le dargu'' and ``le karce''. To this we could
    add:</p>

    <p></p>
<pre>
<a id="e4d3" name="e4d3">4.3)</a>  le klama
    the go-er, the one who goes
</pre>
    In every case, the description is about something which fits
    into the x1 place of the selbri. In order to get a description
    of a destination (that is, something fitting the x2 place of
    ``klama''), we must convert the selbri to ``se klama'', whose
    x1 place is a destination. The result is 

    <p></p>
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  le se klama
    the destination gone to by someone
</pre>

    <p>Likewise, we can create three more converted
    descriptions:</p>
<pre>
<a id="e4d5" name="e4d5">4.5)</a>  le te klama
    the origin of someone's going

<a id="e4d6" name="e4d6">4.6)</a>   le ve klama
    the route of someone's going

<a id="e4d7" name="e4d7">4.7)</a>   le xe klama
    the means by which someone goes
</pre>
    <a href="#e4d6">Example 4.6</a> does not mean ``the route''
    plain and simple: that is ``le pluta'', using a different
    selbri. It means a route that is used by someone for an act of
    ``klama''; that is, a journey with origin and destination. A
    ``road'' on Mars, on which no one has traveled or is ever
    likely to, may be called ``le pluta'', but it cannot be ``le ve
    klama'', since there exists no one for whom it is ``le ve klama
    be fo da'' (the route taken in an actual journey by someone
    [da]). 

    <p>When converting selbri that are more complex than a single
    brivla, it is important to realize that the scope of a SE cmavo
    is only the following brivla (or equivalent unit). In order to
    convert an entire tanru, it is necessary to enclose the tanru
    in ``ke ... ke'e'' brackets:</p>

    <p></p>
<pre>
<a id="e4d8" name="e4d8">4.8)</a>  mi se ke blanu zdani [ke'e] ti
    I [2nd conversion] blue house this-thing
</pre>

    <p>The place structure of ``blanu zdani'' (blue house) is the
    same as that of ``zdani'', by the rule given in <a
    href="#s1">Section 1</a>. The place structure of ``zdani''
    is:</p>

    <dl>
      <dt></dt>

      <dd>x1 is a house/nest/lair/den for inhabitant x2</dd>
    </dl>

    <p>The place structure of ``se ke blanu zdani [ke'e]'' is
    therefore:</p>

    <dl>
      <dt></dt>

      <dd>x1 is the inhabitant of the blue house (etc.) x2</dd>
    </dl>

    <p>Consequently, <a href="#e4d8">Example 4.8</a> means:</p>

    <dl>
      <dt></dt>

      <dd>I am the inhabitant of the blue house which is this
      thing.</dd>
    </dl>

    <p>Conversion applied to only part of a tanru has subtler
    effects which are explained in <a href="chapter5.html">Chapter
    5</a>.</p>

    <p>It is grammatical to convert a selbri more than once with
    SE; later (inner) conversions are applied before earlier
    (outer) ones. For example, the place structure of ``se te
    klama'' is achieved by exchanging the x1 and x2 place of ``te
    klama'', producing:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>x1 is the destination and x2 is the origin of x3 going
      via x4 using x5</dd>
    </dl>

    <p>On the other hand, ``te se klama'' has a place structure
    derived from swapping the x1 and x3 places of ``se klama'':</p>

    <dl>
      <dt></dt>

      <dd>x1 is the origin of x2's going to x3 via x4 using x5</dd>
    </dl>
    which is quite different. However, multiple conversions like
    this are never necessary. Arbitrary scrambling of places can be
    achieved more easily and far more intelligibly with FA tags,
    and only a single conversion is ever needed in a description. 

    <p>(Although no one has made any real use of it, it is perhaps
    worth noting that compound conversions of the form ``setese'',
    where the first and third cmavo are the same, effectively swap
    the two given places while leaving the others, including x1,
    alone: ``setese'' (or equivalently ``tesete'') swap the x2 and
    x3 places, whereas ``texete'' (or ``xetexe'') swap the x3 and
    x5 places.)</p>

    <h3><a id="s5" name="s5">5. Modal places: FIhO, FEhU</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   fi'o    FIhO    modal place prefix
    fe'u    FEhU    modal terminator
</pre>

    <p>Sometimes the place structures engineered into Lojban are
    inadequate to meet the needs of actual speech. Consider the
    gismu ``viska'', whose place structure is:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>x1 sees x2 under conditions x3</dd>
    </dl>

    <p>Seeing is a threefold relationship, involving an agent (le
    viska), an object of sight (le se viska), and an environment
    that makes seeing possible (le te viska). Seeing is done with
    one or more eyes, of course; in general, the eyes belong to the
    entity in the x1 place.</p>

    <p>Suppose, however, that you are blind in one eye and are
    talking to someone who doesn't know that. You might want to
    say, ``I see you with the left eye.'' There is no place in the
    place structure of ``viska'' such as ``with eye x4'' or the
    like. Lojban allows you to solve the problem by adding a new
    place, changing the relationship:</p>
<pre>
<a id="e5d1"
name="e5d1">5.1)</a>  mi viska do fi'o kanla [fe'u] le zunle
    I see you [modal] eye: the left-thing
    I see you with the left eye.
</pre>
    The three-place relation ``viska'' has now acquired a fourth
    place specifying the eye used for seeing. The combination of
    the cmavo ``fi'o'' (of selma'o FIhO) followed by a selbri, in
    this case the gismu ``kanla'', forms a tag which is prefixed to
    the sumti filling the new place, namely ``le zunle''. The
    semantics of ``fi'o kanla le zunle'' is that ``le zunle'' fills
    the x1 place of ``kanla'', whose place structure is 

    <dl>
      <dt></dt>

      <dd>x1 is an/the eye of body x2</dd>
    </dl>
    Thus ``le zunle'' is an eye. The x2 place of ``kanla'' is
    unspecified and must be inferred from the context. It is
    important to remember that even though ``le zunle'' is placed
    following ``fi'o kanla'', semantically it belongs in the x1
    place of ``kanla''. The selbri may be terminated with ``fe'u''
    (of selma'o FEhU), an elidable terminator which is rarely
    required unless a non-logical connective follows the tag
    (omitting ``fe'u'' in that case would make the connective
    affect the selbri). 

    <p>The term for such an added place is a ``modal place'', as
    distinguished from the regular numbered places. (This use of
    the word ``modal'' is specific to the Loglan Project, and does
    not agree with the standard uses in either logic or
    linguistics, but is now too entrenched to change easily.) The
    ``fi'o'' construction marking a modal place is called a ``modal
    tag'', and the sumti which follows it a ``modal sumti''; the
    purely Lojban terms ``sumti tcita'' and ``seltcita sumti'',
    respectively, are also commonly used. Modal sumti may be placed
    anywhere within the bridi, in any order; they have no effect
    whatever on the rules for assigning unmarked bridi to numbered
    places, and they may not be marked with FA cmavo.</p>

    <p>Consider <a href="#e5d1">Example 5.1</a> again. Another way
    to view the situation is to consider the speaker's left eye as
    a tool, a tool for seeing. The relevant selbri then becomes
    ``pilno'', whose place structure is</p>

    <dl>
      <dt></dt>

      <dd>x1 uses x2 as a tool for purpose x3</dd>
    </dl>
    and we can rewrite <a href="#e5d1">Example 5.1</a> as 
<pre>
<a id="e5d2"
name="e5d2">5.2)</a>  mi viska do fi'o se pilno le zunle kanla
    I see you [modal] [conversion] use: the left eye
    I see you using my left eye.
</pre>

    <p>Here the selbri belonging to the modal is ``se pilno''. The
    conversion of ``pilno'' is necessary in order to get the
    ``tool'' place into x1, since only x1 can be the modal sumti.
    The ``tool user'' place is the x2 of ``se pilno'' (because it
    is the x1 of ``pilno'') and remains unspecified. The tag ``fi'o
    pilno'' would mean ``with tool user'', leaving the tool
    unspecified.</p>

    <h3><a id="s6" name="s6">6. Modal tags: BAI</h3>

    <p>There are certain selbri which seem particularly useful in
    constructing modal tags. In particular, ``pilno'' is one of
    them. The place structure of ``pilno'' is:</p>

    <dl>
      <dt></dt>

      <dd>x1 uses tool x2</dd>
    </dl>
    and almost any selbri which represents an action may need to
    specify a tool. Having to say ``fi'o se pilno'' frequently
    would make many Lojban sentences unnecessarily verbose and
    clunky, so an abbreviation is provided in the language design:
    the compound cmavo ``sepi'o''. 

    <p>Here ``se'' is used before a cmavo, namely ``pi'o'', rather
    than before a brivla. The meaning of this cmavo, which belongs
    to selma'o BAI, is exactly the same as that of ``fi'o pilno
    fe'u''. Since what we want is a tag based on ``se pilno''
    rather than ``pilno'' --- the tool, not the tool user --- the
    grammar allows a BAI cmavo to be converted using a SE cmavo. <a
    href="#e5d2">Example 5.2</a> may therefore be rewritten as:</p>
<pre>
<a id="e6d1"
name="e6d1">6.1)</a>  mi viska do sepi'o le zunle kanla
    I see you with-tool: the left eye
    I see you using my left eye.
</pre>

    <p>The compound cmavo ``sepi'o'' is much shorter than ``fi'o se
    pilno [fe'u]'' and can be thought of as a single word meaning
    ``with-tool''. The modal tag ``pi'o'', with no ``se'',
    similarly means ``with-tool-user'', probably a less useful
    concept. Nevertheless, the parallelism with the place structure
    of ``pilno'' makes the additional syllable worthwhile.</p>

    <p>Some BAI cmavo make sense with as well as without a SE
    cmavo; for example, ``ka'a'', the BAI corresponding to the
    gismu ``klama'', has five usable forms corresponding to the
    five places of ``klama'' respectively:</p>
<pre>
   ka'a        with-goer
    seka'a      with-destination
    teka'a      with-origin
    veka'a      with-route
    xeka'a      with-means-of-transport
</pre>

    <p>Any of these tags may be used to provide modal places for
    bridi, as in the following examples:</p>

    <p></p>
<pre>
<a id="e6d2"
name="e6d2">6.2)</a>  la .eivn. cu vecnu loi flira cinta ka'a mi
    Avon sells a-mass-of face paint with-goer me.
    I am a traveling cosmetics salesperson for Avon.
</pre>
    (<a href="#e6d2">Example 6.2</a> may seem a bit strained, but
    it illustrates the way in which an existing selbri, ``vecnu''
    in this case, may have a place added to it which might
    otherwise seem utterly unrelated.) 
<pre>
<a id="e6d3" name="e6d3">6.3)</a>  mi cadzu seka'a la bratfyd.
    I walk with-destination Bradford.
    I am walking to Bradford.

<a id="e6d4" name="e6d4">6.4)</a>   bloti teka'a la nu,IORK.
    [Observative:] is-a-boat with-origin New York
    A boat from New York!

<a id="e6d5" name="e6d5">6.5)</a>   do bajra veka'a lo djine
    You run with-route a circle.
    You are running in circles.

<a id="e6d6" name="e6d6">6.6)</a>   mi citka xeka'a le vinji
    I eat with-means-of-transport the airplane.
    I eat in the airplane.
</pre>
    There are sixty-odd cmavo of selma'o BAI, based on selected
    gismu that seemed useful in a variety of settings. The list is
    somewhat biased toward English, because many of the cmavo were
    selected on the basis of corresponding English prepositions and
    preposition compounds such as ``with'', ``without'', and ``by
    means of''. The BAI cmavo, however, are far more precise than
    English prepositions, because their meanings are fixed by the
    place structures of the corresponding gismu. 

    <p>All BAI cmavo have the form CV'V or CVV. Most of them are
    CV'V, where the C is the first consonant of the corresponding
    gismu and the two Vs are the two vowels of the gismu. The table
    in <a href="#s16">Section 16</a> shows the exceptions.</p>

    <p>There is one additional BAI cmavo that is not derived from a
    gismu: ``do'e''. This cmavo is used when an extra place is
    needed, but it seems useful to be vague about the semantic
    implications of the extra place:</p>
<pre>
<a id="e6d7"
name="e6d7">6.7)</a>  lo nanmu be do'e le berti cu klama le tcadu
    Some man [related to] the north came to-the city.
    A man of the north came to the city.
</pre>
    Here ``le berti'' is provided as a modal place of the selbri
    ``nanmu'', but its exact significance is vague, and is
    paralleled in the colloquial translation by the vague English
    preposition ``of''. <a href="#e6d7">Example 6.7</a> also
    illustrates a modal place bound into a selbri with ``be''. This
    construction is useful when the selbri of a description
    requires a modal place; this and other uses of ``be'' are more
    fully explained in <a href="chapter5.html">Chapter 5</a>. 

    <h3><a id="s7" name="s7">7. Modal sentence connection: the causals</h3>

    <p>The following cmavo are discussed in this section:</p>

    <p></p>
<pre>
   ri'a    BAI rinka modal: physical cause
    ki'u    BAI krinu modal: justification
    mu'i    BAI mukti modal: motivation
    ni'i    BAI nibli modal: logical entailment
</pre>

    <p>This section has two purposes. On the one hand, it explains
    the grammatical construct called ``modal sentence connection''.
    On the other, it exemplifies some of the more useful BAI cmavo:
    the causals. (There are other BAI cmavo which have causal
    implications: ``ja'e'' means ``with result'', and so ``seja'e''
    means ``with cause of unspecified nature''; likewise, ``gau''
    means ``with agent'' and ``tezu'e'' means ``with purpose''.
    These other modal cmavo will not be further discussed here, as
    my purpose is to explain modal sentence connection rather than
    Lojbanic views of causation.)</p>

    <p>There are four causal gismu in Lojban, distinguishing
    different versions of the relationships lumped in English as
    ``causal'':</p>

    <dl>
      <dt></dt>

      <dd>rinka: event x1 physically causes event x2 krinu: event
      x1 is the justification for event x2 mukti: event x1 is the
      (human) motive for event x2 nibli: event x1 logically entails
      event x2</dd>
    </dl>
    Each of these gismu has a related modal: ``ri'a'', ``ki'u'',
    ``mu'i'', and ``ni'i'' respectively. Using these gismu and
    these modals, we can create various causal sentences with
    different implications: 

    <p></p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  le spati cu banro
        ri'a le nu
            do djacu dunda fi le spati
    the plant grows
        with-physical-cause the event-of
            you water give to the plant.
    The plant grows because you water it.

<a id="e7d2"
name="e7d2">7.2)</a>   la djan. cpacu le pamoi se jinga
        ki'u le nu la djan. jinga
    John gets the first prize
        with-justification the event-of John wins.
    John got the first prize because he won.

<a id="e7d3" name="e7d3">7.3)</a>   mi lebna le cukta
        mu'i le nu mi viska le cukta
    I took the book
        with-motivation the event-of I saw the book.
    I took the book because I saw it.
</pre>
<pre>
<a id="e7d4" name="e7d4">7.4)</a>  la sokrates. morsi binxo
        ni'i le nu la sokrates. remna
    Socrates dead-became
        with-logical-justification Socrates is-human.
    Socrates died because Socrates is human.
</pre>
    In <a href="#e7d1">Examples 7.1</a> through <a
    href="#e7d4">7.4</a>, the same English word ``because'' is used
    to translate all four modals, but the types of cause being
    expressed are quite different. Let us now focus on <a
    href="#e7d1">Example 7.1</a>, and explore some variations on
    it. 

    <p>As written, <a href="#e7d1">Example 7.1</a> claims that the
    plant grows, but only refers to the event of watering it in an
    abstraction bridi (abstractions are explained in <a
    href="chapter11.html">Chapter 11</a>) without actually making a
    claim. If I express <a href="#e7d1">Example 7.1</a>, I have
    said that the plant in fact grows, but I have not said that you
    actually water it, merely that there is a causal relationship
    between watering and growing. This is semantically
    asymmetrical. Suppose I wanted to claim that the plant was
    being watered, and only mention its growth as ancillary
    information? Then we could reverse the main bridi and the
    abstraction bridi, saying:</p>
<pre>
<a id="e7d5" name="e7d5">7.5)</a>  do djacu dunda fi le spati
        seri'a le nu ri banro
    You water-give to the plant
        with-physical-effect it grows.
    You water the plant; therefore, it grows.
</pre>
    with the ``ri'a'' changed to ``seri'a''. In addition, there are
    also symmetrical forms: 
<pre>
<a id="e7d6"
name="e7d6">7.6)</a>  le nu do djacu dunda fi le spati cu rinka
        le nu le spati cu banro
    The event-of (you water-give to the plant) causes
        the event-of (the plant grows).
    Your watering the plant causes its growth.
    If you water the plant, then it grows.
</pre>
    does not claim either event, but asserts only the causal
    relationship between them. So in <a href="#e7d6">Example
    7.6</a>, I am not saying that the plant grows nor that you have
    in fact watered it. The second colloquial translation shows a
    form of ``if-then'' in English quite distinct from the logical
    connective ``if-then'' explained in <a
    href="chapter14.html">Chapter 14</a>. 

    <p>Suppose we wish to claim both events as well as their causal
    relationship? We can use one of two methods:</p>

    <p></p>
<pre>
<a id="e7d7"
name="e7d7">7.7)</a>  le spati cu banro .iri'abo do djacu dunda fi le spati
    The plant grows.  Because you water-give to the plant.
    The plant grows because you water it.

<a id="e7d8" name="e7d8">7.8)</a>   do djacu dunda fi le spati
        .iseri'abo le spati cu banro
    You water-give to the plant.
        Therefore it grows.
    You water the plant; therefore, it grows.
</pre>

    <p>The compound cmavo ``.iri'abo'' and ``.iseri'abo'' serve to
    connect two bridi, as the initial ``.i'' indicates. The final
    ``bo'' is necessary to prevent the modal from ``taking over''
    the following sumti. If the ``bo'' were omitted from <a
    href="#e7d7">Example 7.7</a> we would have:</p>
<pre>
<a id="e7d9" name="e7d9">7.9)</a>  le spati cu banro
        .i ri'a do djacu dunda
            fi le spati
    The plant grows.
        Because of you, [something] water-gives
            to the plant.
    The plant grows.  Because of you, water is given
        to the plant.
</pre>

    <p>Because ``ri'a do'' is a modal sumti in <a
    href="#e7d9">Example 7.9</a>, there is no longer an explicit
    sumti in the x1 place of ``djacu dunda'', and the translation
    must be changed.</p>

    <p>The effect of sentences like <a href="#e7d7">Example 7.7</a>
    and <a href="#e7d8">Example 7.8</a> is that the modal, ``ri'a''
    in this example, no longer modifies an explicit sumti. Instead,
    the sumti is implicit, the event given by a full bridi.
    Furthermore, there is a second implication: that the first
    bridi fills the x2 place of the gismu ``rinka''; it specifies
    an event which is the effect. I am therefore claiming three
    things: that the plant grows, that you have watered it, and
    that there is a cause-and-effect relationship between the
    two.</p>

    <p>In principle, any modal tag can appear in a sentence
    connective of the type exemplified by <a href="#e7d7">Example
    7.7</a> and <a href="#e7d8">Example 7.8</a>. However, it makes
    little sense to use any modals which do not expect events or
    other abstractions to fill the places of the corresponding
    gismu. The sentence connective ``.ibaubo'' is perfectly
    grammatical, but it is hard to imagine any two sentences which
    could be connected by an ``in-language'' modal. This is because
    a sentence describes an event, and an event can be a cause or
    an effect, but not a language.</p>

    <h3><a id="s8" name="s8">8. Other modal connections</h3>

    <p>Like many Lojban grammatical constructions, sentence modal
    connection has both forethought and afterthought forms. (See <a
    href="chapter14.html">Chapter 14</a> for a more detailed
    discussion of Lojban connectives.) <a href="#s7">Section 7</a>
    exemplifies only afterthought modal connection, illustrated
    here by:</p>

    <p></p>
<pre>
<a id="e8d1"
name="e8d1">8.1)</a>  mi jgari lei djacu .iri'abo mi jgari le kabri
    I grasp the-mass-of water
        with-physical-cause I grasp the cup.
    Causing the mass of water to be grasped by me,
        I grasped the cup.
    I grasp the water because I grasp the cup.
</pre>
    An afterthought connection is one that is signaled only by a
    cmavo (or compound cmavo, in this case) between the two
    constructs being connected. Forethought connection uses a
    signal both before the first construct and between the two: the
    use of ``both'' and ``and'' in the first half of this sentence
    represents a forethought connection (though not a modal one). 

    <p>To make forethought modal sentence connections in Lojban,
    place the modal plus ``gi'' before the first bridi, and ``gi''
    between the two. No ``.i'' is used within the construct. The
    forethought equivalent of <a href="#e8d1">Example 8.1</a>
    is:</p>
<pre>
<a id="e8d2" name="e8d2">8.2)</a>  ri'agi mi jgari le kabri
        gi mi jgari lei djacu
    With-physical-cause I grasp the cup,
        I grasp the-mass-of water.
    Because I grasp the cup, I grasp the water.
</pre>
    Note that the cause, the x1 of ``rinka'' is now placed first.
    To keep the two bridi in the original order of <a
    href="#e8d1">Example 8.1</a>, we could say: 
<pre>
<a id="e8d3" name="e8d3">8.3)</a>  seri'agi mi jgari lei djacu
        gi mi jgari le kabri
    With-physical-effect I grasp the-mass-of water,
        I grasp the cup.
</pre>

    <p>In English, the sentence ``*Therefore I grasp the water, I
    grasp the cup'' is ungrammatical, because ``therefore'' is not
    grammatically equivalent to ``because''. In Lojban,
    ``seri'agi'' can be used just like ``ri'agi''.</p>

    <p>When the two bridi joined by a modal connection have one or
    more elements (selbri or sumti or both) in common, there are
    various condensed forms that can be used in place of full modal
    sentence connection with both bridi completely stated.</p>

    <p>When the bridi are the same except for a single sumti, as in
    Examples 8.1 through 8.3, then a sumti modal connection may be
    employed:</p>
<pre>
<a id="e8d4"
name="e8d4">8.4)</a>  mi jgari ri'agi le kabri gi lei djacu
    I grasp because the cup , the-mass-of water.
</pre>
    <a href="#e8d4">Example 8.4</a> means exactly the same as <a
    href="#e8d1">Examples 8.1</a> through <a
    href="#e8d3">8.3</a>, but there is no idiomatic English
    translation that will distinguish it from them. 

    <p>If the two connected bridi are different in more than one
    sumti, then a termset may be employed. Termsets are explained
    more fully in <a href="chapter14.html">Chapter 14</a>, but are
    essentially a mechanism for creating connections between
    multiple sumti simultaneously.</p>
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  mi dunda le cukta la djan.
        .imu'ibo la djan. dunda lei jdini mi
    I gave the book to John.
        Motivated-by John gave the-mass-of money to-me.
    I gave the book to John, because John gave money to me.
</pre>
    means the same as: 

    <p></p>
<pre>
<a id="e8d6" name="e8d6">8.6)</a>  nu'i mu'igi mi le cukta la djan.
        gi la djan. lei jdini mi nu'u dunda
    [start] because I, the book, John;
        John, the-mass-of money, me [end] gives.
</pre>

    <p>Here there are three sumti in each half of the termset,
    because the two bridi share only their selbri.</p>

    <p>There is no modal connection between selbri as such: bridi
    which differ only in the selbri can be modally connected using
    bridi-tail modal connection. The bridi-tail construct is more
    fully explained in <a href="chapter14.html">Chapter 14</a>, but
    essentially it consists of a selbri with optional sumti
    following it. <a href="#e7d3">Example 7.3</a> is suitable for
    bridi-tail connection, and could be shortened to:</p>
<pre>
<a id="e8d7"
name="e8d7">8.7)</a>  mi mu'igi viska le cukta gi lebna le cukta
    I, because saw the book, took the book.
</pre>

    <p>Again, no straightforward English translation exists. It is
    even possible to shorten <a href="#e8d7">Example 8.7</a>
    further to:</p>

    <p></p>
<pre>
<a id="e8d8"
name="e8d8">8.8)</a>  mi mu'igi viska gi lebna vau le cukta
    I because saw, therefore took, the book.
</pre>
    where ``le cukta'' is set off by the non-elidable ``vau'' and
    is made to belong to both bridi-tails --- see <a
    href="chapter14.html">Chapter 14</a> for more explanations. 

    <p>Since this is a chapter on rearranging sumti, it is worth
    pointing out that <a href="#e8d8">Example 8.8</a> can be
    further rearranged to:</p>
<pre>
<a id="e8d9"
name="e8d9">8.9)</a>  mi le cukta mu'igi viska gi lebna
    I, the book, because saw, therefore took
</pre>
    which doesn't require the extra ``vau''; all sumti before a
    conjunction of bridi-tails are shared. 

    <p>Finally, mathematical operands can be modally connected.</p>
<pre>
<a id="e8d10" name="e8d10">8.10)</a>    li ny. du li vo
        .ini'ibo li ny. du li re su'i re
    the number n = the-number 4.
        Entailed-by the-number n = the-number 2 + 2.
    n = 4 because n = 2 + 2.
</pre>
    can be reduced to: 
<pre>
<a id="e8d11" name="e8d11">8.11)</a>    li ny. du li
        ni'igi vei re su'i re [ve'o] gi vo
    the-number n = the-number
        because ( 2 + 2 ) therefore 4.
    n is 2 + 2, and is thus 4.
</pre>
    The cmavo ``vei'' and ``ve'o'' represent mathematical
    parentheses, and are required so that ``ni'igi'' affects more
    than just the immediately following operand, namely the first
    ``re''. (The right parenthesis, ``ve'o'', is an elidable
    terminator.) As usual, no English translation does <a
    href="#e8d11">Example 8.11</a> justice. 

    <p>Note: Due to restrictions on the Lojban parsing algorithm,
    it is not possible to form modal connectives using the
    ``fi'o''-plus-selbri form of modal. Only the predefined modals
    of selma'o BAI can be compounded as shown in <a
    href="#s7">Sections 7</a> and <a href="#s8">8</a>.</p>

    <h3><a id="s9" name="s9">9. Modal selbri</h3>

    <p>Consider the example:</p>

    <p></p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  mi tavla bau la lojban.
        bai tu'a la frank.
    I speak in-language Lojban
        with-compeller some-property-of Frank.
    I speak in Lojban, under compulsion by Frank.
</pre>
    <a href="#e9d1">Example 9.1</a> has two modal sumti, using the
    modals ``bau'' and ``bai''. Suppose we wanted to specify the
    language explicitly but be vague about who's doing the
    compelling. We can simplify <a href="#e9d1">Example 9.1</a> to:
    

    <p></p>
<pre>
<a id="e9d2"
name="e9d2">9.2)</a>  mi tavla bau la lojban. bai [ku].
    I speak in-language Lojban under-compulsion.
</pre>

    <p>In <a href="#e9d2">Example 9.2</a>, the elidable terminator
    ``ku'' has taken the place of the sumti which would normally
    follow ``bai''. Alternatively, we could specify the one who
    compels but keep the language vague:</p>
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  mi tavla bau [ku]
        bai tu'a la frank.
    I speak in-some-language
        under-compulsion-by some-property-of Frank.
</pre>

    <p>We are also free to move the modal-plus-``ku'' around the
    bridi:</p>
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  bau [ku] bai ku mi tavla
    In-some-language under-compulsion I speak.
</pre>
    An alternative to using ``ku'' is to place the modal cmavo
    right before the selbri, following the ``cu'' which often
    appears there. When a modal is present, the ``cu'' is almost
    never necessary. 
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  mi bai tavla bau la lojban.
    I compelledly speak in-language Lojban.
</pre>
    In this use, the modal is like a tanru modifier semantically,
    although grammatically it is quite distinct. <a
    href="#e9d5">Example 9.5</a> is very similar in meaning to: 
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  mi se bapli tavla bau la lojban.
    I compelledly-speak in-language Lojban.
</pre>

    <p>The ``se'' conversion is needed because ``bapli tavla''
    would be a compeller type of speaker rather than a compelled
    (by someone) type of speaker, which is what a ``bai tavla''
    is.</p>

    <p>If the modal preceding a selbri is constructed using
    ``fi'o'', then ``fe'u'' is required to prevent the main selbri
    and the modal selbri from colliding:</p>

    <p></p>
<pre>
<a id="e9d7" name="e9d7">9.7)</a>  mi fi'o kanla fe'u viska do
    I with-eye see you
    I see you with my eye(s).
</pre>
    There are two other uses of modals. A modal can
    be attached to a pair of bridi-tails that have already been
    connected by a logical, non-logical, or modal connection (see
    <a href="chapter14.html">Chapter 14</a> for more on logical and
    non-logical connections): 
<pre>
<a id="e9d8" name="e9d8">9.8)</a>  mi bai
        ke ge klama le zarci gi cadzu le bisli [ke'e]
    I under-compulsion
        ( both go to-the market and walk on-the ice )
    Under compulsion, I both go to the market
        and walk on the ice.
</pre>

    <p>Here the ``bai'' is spread over both ``klama le zarci'' and
    ``cadzu le bisli'', and the ``ge ... gi'' represents the
    logical connection ``both-and'' between the two.</p>

    <p> Similarly, a modal can be attached to multiple sentences that
    have been combined with ``tu'e'' and ``tu'u'', which are explained
    in more detail in <a href="chapter19.html">Chapter 19</a>:</p>
<pre>
<a id="e9d9" name="e9d9">9.9)</a>  bai tu'e mi klama le zarci
        .i mi cadzu le bisli [tu'u]
    Under-compulsion [start] I go to-the market.
        I walk on-the ice [end]
</pre>
    means the same thing as <a href="#e9d8">Example 9.8</a>. 

    <p>Note: Either BAI modals or ``fi'o''-plus-selbri modals may
    correctly be used in any of the constructions discussed in this
    section.</p>

    <h3><a id="s10" name="s10">10. Modal relative phrases; Comparison</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   pe  GOI restrictive relative phrase
    ne  GOI incidental relative phrase
    mau BAI zmadu modal
    me'a    BAI mleca modal
</pre>

    <p>Relative phrases and clauses are explained in much more
    detail in <a href="chapter8.html">Chapter 8</a>. However, there is
    a construction which combines a modal with a relative phrase
    which is relevant to this chapter. Consider the following
    examples of relative clauses:</p>

    <p></p>
<pre>
<a id="e10d1"
name="e10d1">10.1)</a>    la .apasionatas. poi se cusku la .artr. rubnstain.
        cu se nelci mi
    The Appassionata which is-expressed-by Artur Rubenstein
        is-liked-by me.

<a id="e10d2"
name="e10d2">10.2)</a> la .apasionatas. noi se finti la betovn.
        cu se nelci mi
    The Appassionata, which is-created-by Beethoven,
        is-liked-by me.
</pre>
    In <a href="#e10d1">Example 10.1</a>, ``la .apasionatas.''
    refers to a particular performance of the sonata, namely the
    one performed by Rubenstein. Therefore, the relative clause
    ``poi se cusku'' uses the cmavo ``poi'' (of selma'o NOI) to
    restrict the meaning of ``la .apasionatas'' to the performance
    in question. 

    <p>In <a href="#e10d2">Example 10.2</a>, however, ``la
    .apasionatas.'' refers to the sonata as a whole, and the
    information that it was composed by Beethoven is merely
    incidental. The cmavo ``noi'' (also of selma'o NOI) expresses
    the incidental nature of this relationship.</p>

    <p>The cmavo ``pe'' and ``ne'' (of selma'o GOI) are roughly
    equivalent to ``poi'' and ``noi'' respectively, but are
    followed by sumti rather than full bridi. We can abbreviate <a
    href="#e10d1">Example 10.1</a> and <a href="#e10d2">Example
    10.2</a> to:</p>
<pre>
<a id="e10d3"
name="e10d3">10.3)</a>    la .apasionatas pe la .artr. rubnstain. se nelci mi
    The Appassionata of Artur Rubenstein is-liked-by me.

<a id="e10d4"
name="e10d4">10.4)</a> la .apasionatas ne la betovn. se nelci mi
    The Appassionata, which is of Beethoven, is-liked-by me.
</pre>
    Here the precise selbri of the relative clauses is lost: all we
    can tell is that the Appassionata is connected in some way with
    Rubenstein (in <a href="#e10d3">Example 10.3</a>) and Beethoven
    (in <a href="#e10d4">Example 10.4</a>), and that the
    relationships are respectively restrictive and incidental. 

    <p>It happens that both ``cusku'' and ``finti'' have BAI cmavo,
    namely ``cu'u'' and ``fi'e''. We can recast <a
    href="#e10d3">Example 10.3</a> and <a href="#e10d4">Example
    10.4</a> as:</p>
<pre>
<a id="e10d5"
name="e10d5">10.5)</a>    la .apasionatas pe cu'u la .artr. rubnstain.
        cu se nelci mi
    The Appassionata expressed-by Artur Rubenstein
        is-liked-by me.

<a id="e10d6"
name="e10d6">10.6)</a> la .apasionatas ne fi'e la betovn.
        cu se nelci mi
    The Appassionata, invented-by Beethoven,
        is-liked-by me.
</pre>
    <a href="#e10d5">Example 10.5</a> and <a href="#e10d6">Example
    10.6</a> have the full semantic content of <a
    href="#e10d1">Example 10.1</a> and <a href="#e10d2">Example
    10.2</a> respectively. 

    <p>Modal relative phrases are often used with the BAI cmavo
    ``mau'' and ``me'a'', which are based on the comparative gismu
    ``zmadu'' (more than) and ``mleca'' (less than) respectively.
    The place structures are:</p>
<pre>
   zmadu   x1 is more than x2 in property/quantity x3
            by amount x4
    mleca   x1 is less than x2 in property/quantity x3
            by amount x4
</pre>

    <p>Here are some examples:</p>

    <p></p>
<pre>
<a id="e10d7"
name="e10d7">10.7)</a>    la frank. nelci la betis. ne semau la meiris.
    Frank likes Betty, which-is more-than Mary.
    Frank likes Betty more than (he likes) Mary.
</pre>
    <a href="#e10d7">Example 10.7</a> requires that Frank likes
    Betty, but adds the information that his liking for Betty
    exceeds his liking for Mary. The modal appears in the form
    ``semau'' because the x2 place of ``zmadu'' is the basis for
    comparison: in this case, Frank's liking for Mary. 
<pre>
<a id="e10d8"
name="e10d8">10.8)</a>    la frank. nelci la meiris. ne seme'a la betis.
    Frank likes Mary, which-is less-than Betty.
    Frank likes Mary less than (he likes) Betty.
</pre>
    Here we are told that Frank likes Mary less than he likes
    Betty; the information about the comparison is the same. It
    would be possible to rephrase <a href="#e10d7">Example 10.7</a>
    using ``me'a'' rather than ``semau'', and <a
    href="#e10d8">Example 10.8</a> using ``mau'' rather than
    ``seme'a'', but such usage would be unnecessarily confusing.
    Like many BAI cmavo, ``mau'' and ``me'a'' are more useful when
    converted with ``se''. 

    <p>If the ``ne'' were omitted in <a href="#e10d7">Example
    10.7</a> and <a href="#e10d8">Example 10.8</a>, the modal sumti
    (``la meiris.'' and ``la betis.'' respectively) would become
    attached to the bridi as a whole, producing a very different
    translation. <a href="#e10d8">Example 10.8</a> would
    become:</p>
<pre>
<a id="e10d9"
name="e10d9">10.9)</a>    la frank. nelci la meiris. seme'a la betis.
    Frank likes Mary is-less-than Betty.
    Frank's liking Mary is less than Betty.
</pre>
    which compares a liking with a person, and is therefore
    nonsense. 

    <p>Pure comparison, which states only the comparative
    information but says nothing about whether Frank actually likes
    either Mary or Betty (he may like neither, but dislike Betty
    less), would be expressed differently, as:</p>
<pre>
<a id="e10d10"
name="e10d10">10.10)</a>    le ni la frank. nelci la betis.
        cu zmadu le ni la frank. nelci la meiris.
    The quantity-of Frank's liking Betty
        is-more-than the quantity-of Frank's liking Mary.
</pre>
    The mechanisms explained in this section are appropriate to
    many modals other than ``semau'' and ``seme'a''. Some other
    modals that are often associated with relative phrases are:
    ``seba'i'' (``instead of''), ``ci'u'' (``on scale''), ``de'i''
    (``dated''), ``du'i'' (``as much as''). Some BAI tags can be
    used equally well in relative phrases or attached to bridi;
    others seem useful only attached to bridi. But it is also
    possible that the usefulness of particular BAI modals is an
    English-speaker bias, and that speakers of other languages may
    find other BAIs useful in divergent ways. 

    <p>Note: The uses of modals discussed in this section are
    applicable both to BAI modals and to ``fi'o''-plus-selbri
    modals.</p>

    <h3><a id="s11" name="s11">11. Mixed modal connection</h3>

    <p>It is possible to mix logical connection (explained in <a
    href="chapter14.html">Chapter 14</a>) with modal connection, in a
    way that simultaneously asserts the logical connection and the
    modal relationship. Consider the sentences:</p>
<pre>
<a id="e11d1"
name="e11d1">11.1)</a>    mi nelci do .ije mi nelci la djein.
    I like you.  And I like Jane
</pre>
    which is a logical connection, and 
<pre>
<a id="e11d2"
name="e11d2">11.2)</a>    mi nelci do .iki'ubo mi nelci la djein.
    I like you.  Justified-by I like Jane.
</pre>
    The meanings of <a href="#e11d1">Example 11.1</a> and <a
    href="#e11d2">Example 11.2</a> can be simultaneously expressed
    by combining the two compound cmavo, thus: 
<pre>
<a id="e11d3"
name="e11d3">11.3)</a>    mi nelci do .ijeki'ubo mi nelci la djein.
    I like you.  And justified-by I like Jane.
</pre>
    Here the two sentences ``mi nelci do'' and ``mi nelci la
    djein.'' are simultaneously asserted, their logical connection
    is asserted, and their causal relationship is asserted. The
    logical connective ``je'' comes before the modal ``ki'u'' in
    all such mixed connections. 

    <p>Since ``mi nelci do'' and ``mi nelci la djein.'' differ only
    in the final sumti, we can transform <a href="#e11d3">Example
    11.3</a> into a mixed sumti connection:</p>

    <p></p>
<pre>
<a id="e11d4"
name="e11d4">11.4)</a>    mi nelci do .eki'ubo la djein.
    I like you and/because Jane.
</pre>
    Note that this connection is an afterthought one. Mixed
    connectives are always afterthought; forethought connectives
    must be either logical or modal. 

    <p>There are numerous other afterthought logical and
    non-logical connectives that can have modal information planted
    within them. For example, a bridi-tail connected version of <a
    href="#e11d4">Example 11.4</a> would be:</p>
<pre>
<a id="e11d5"
name="e11d5">11.5)</a>    mi nelci do gi'eki'ubo nelci la djein.
    I like you and/because like Jane.
</pre>

    <p>The following three complex examples all mean the same
    thing.</p>

    <p></p>
<pre>
<a id="e11d6" name="e11d6">11.6)</a>    mi bevri le dakli
        .ijeseri'abo tu'e mi bevri le gerku
        .ijadu'ibo mi bevri le mlatu [tu'u]
    I carry the sack.
        And [effect] (I carry the dog
        And/or [equal] I carry the cat. )
    I carry the sack.
        As a result I carry the dog
        or I carry the cat, equally.

<a id="e11d7" name="e11d7">11.7)</a> mi bevri le dakli
        gi'eseri'ake bevri le gerku
        gi'adu'ibo bevri le mlatu [ke'e]
    I carry the sack
        and [effect] (carry the dog
        and/or [equal] carry the cat ).
    I carry the sack
        and as a result carry the dog or carry the cat equally.

<a id="e11d8" name="e11d8">11.8)</a> mi bevri le dakli
        .eseri'ake le gerku
            .adu'ibo le mlatu [ke'e]
    I carry the sack
        and [effect] (the cat
            and/or [equal] the dog ).
    I carry the sack, and as a result the cat
        or the dog equally.
</pre>
    In <a href="#e11d6">Example 11.6</a>, the ``tu'e ... tu'u''
    brackets are the equivalent of the ``ke ... ke'e'' brackets in
    <a href="#e11d7">Example 11.7</a> and <a href="#e11d8">Example
    11.8</a>, because ``ke ... ke'e'' cannot extend across more
    than one sentence. It would also be possible to change the
    ``.ijeseri'abo'' to ``.ije seri'a'', which would show that the
    ``tu'e ... tu'u'' portion was an effect, but would not pin down
    the ``mi bevri le dakli'' portion as the cause. It is legal for
    a modal (or a tense; see <a href="chapter10.html">Chapter 10</a>)
    to modify the whole of a ``tu'e ... tu'u'' construct. 

    <p>Note: The uses of modals discussed in this section are
    applicable both to BAI modals and to ``fi'o''-plus-selbri
    modals.</p>

    <h3><a id="s12" name="s12">12. Modal conversion: JAI</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   jai JAI modal conversion
    fai FA  modal place structure tag
</pre>
    So far, conversion of numbered bridi places with SE and the
    addition of modal places with BAI have been two entirely
    separate operations. However, it is possible to convert a
    selbri in such a way that, rather than exchanging two numbered
    places, a modal place is made into a numbered place. For
    example, 
<pre>
<a id="e12d1" name="e12d1">12.1)</a>    mi cusku bau la lojban.
    I express [something] in-language Lojban.
</pre>
    has an explicit x1 place occupied by ``mi'' and an explicit
    ``bau'' place occupied by ``la lojban.'' To exchange these two,
    we use a modal conversion operator consisting of ``jai'' (of
    selma'o JAI) followed by the modal cmavo. Thus, the modal
    conversion of <a href="#e12d1">Example 12.1</a> is: 
<pre>
<a id="e12d2"
name="e12d2">12.2)</a>    la lojban. jai bau cusku fai mi
    Lojban is-the-language-of-expression used-by me.
</pre>
    In <a href="#e12d2">Example 12.2</a>, the modal place ``la
    lojban.'' has become the x1 place of the new selbri ``jai bau
    cusku''. What has happened to the old x1 place? There is no
    numbered place for it to move to, so it moves to a special
    ``unnumbered place'' marked by the tag ``fai'' of selma'o FA. 

    <p>Note: For the purposes of place numbering, ``fai'' behaves
    like ``fi'a''; it does not affect the numbering of the other
    places around it.</p>

    <p>Like SE conversions, JAI conversions are especially
    convenient in descriptions. We may refer to ``the language of
    an expression'' as ``le jai bau cusku'', for example.</p>

    <p>In addition, it is grammatical to use ``jai'' without a
    following modal. This usage is not related to modals, but is
    explained here for completeness. The effect of ``jai'' by
    itself is to send the x1 place, which should be an abstraction,
    into the ``fai'' position, and to raise one of the sumti from
    the abstract sub-bridi into the x1 place of the main bridi.
    This feature is discussed in more detail in <a
    href="chapter11.html">Chapter 11</a>. The following two examples
    mean the same thing:</p>
<pre>
<a id="e12d3" name="e12d3">12.3)</a>    le nu mi lebna le cukta
        cu se krinu le nu mi viska le cukta
    The event-of I take the book
        is-justified-by the event-of I see the book.
    My taking the book is justified by my seeing it.

<a id="e12d4"
name="e12d4">12.4)</a> mi jai se krinu le nu mi viska le cukta kei
        [fai le nu mi lebna le cukta]
    I am-justified by the event-of I see the book
        [namely, the event-of I take the book]
    I am justified in taking the book by seeing the book.
</pre>
    <a href="#e12d4">Example 12.4</a>, with the bracketed part
    omitted, allows us to say that ``I am justified'' whereas in
    fact it is my action that is justified. This construction is
    vague, but useful in representing natural-language methods of
    expression. 

    <p>Note: The uses of modals discussed in this section are
    applicable both to BAI modals and to ``fi'o''-plus-selbri
    modals.</p>

    <h3><a id="s13" name="s13">13. Modal negation</h3>

    <p>Negation is explained in detail in <a
    href="chapter15.html">Chapter 15</a>. There are two forms of
    negation in Lojban: contradictory and scalar negation.
    Contradictory negation expresses what is false, whereas scalar
    negation says that some alternative to what has been stated is
    true. A simple example is the difference between ``John didn't
    go to Paris'' (contradictory negation) and ``John went to
    (somewhere) other than Paris'' (scalar negation).</p>

    <p>Contradictory negation involving BAI cmavo is performed by
    appending ``-nai'' (of selma'o NAI) to the BAI. A common use of
    modals with ``-nai'' is to deny a causal relationship:</p>
<pre>
<a id="e13d1"
name="e13d1">13.1)</a>    mi nelci do mu'inai le nu do nelci mi
    I like you, but not because you like me.
</pre>
    <a href="#e13d1">Example 13.1</a> denies that the relationship
    between my liking you (which is asserted) and your liking me
    (which is not asserted) is one of motivation. Nothing is said
    about whether you like me or not, merely that that hypothetical
    liking is not the motivation for my liking you. 

    <p>Scalar negation is achieved by prefixing ``na'e'' (of
    selma'o NAhE), or any of the other cmavo of NAhE, to the BAI
    cmavo.</p>

    <p></p>
<pre>
<a id="e13d2"
name="e13d2">13.2)</a>    le spati cu banro na'emu'i le nu
        do djacu dunda fi le spati
    The plant grows other-than-motivated-by the event-of
        you water-give to the plant.
</pre>
    <a href="#e13d2">Example 13.2</a> says that the relationship
    between the plant's growth and your watering it is not one of
    motivation: the plant is not motivated to grow, as plants are
    not something which can have motivation as a rule. Implicitly,
    some other relationship between watering and growth exists, but
    <a href="#e13d2">Example 13.2</a> doesn't say what it is
    (presumably ``ri'a''). 

    <p>Note: Modals made with ``fi'o'' plus a selbri cannot be
    negated directly. The selbri can itself be negated either with
    contradictory or with scalar negation, however.</p>

    <h3><a id="s14" name="s14">14. Sticky modals</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   ki  KI  stickiness flag
</pre>
    Like tenses, modals can be made persistent from the bridi in
    which they appear to all following bridi. The effect of this
    ``stickiness'' is to make the modal, along with its following
    sumti, act as if it appeared in every successive bridi.
    Stickiness is put into effect by following the modal (but not
    any following sumti) with the cmavo ``ki'' of selma'o KI. For
    example, 
<pre>
<a id="e14d1" name="e14d1">14.1)</a>    mi tavla bau la lojban.
        bai ki tu'a la frank.
    .ibabo mi tavla bau la gliban.
    I speak in-language Lojban
        compelled-by some-property-of Frank.
    Afterward, I speak in-language English.
</pre>
    means the same as: 
<pre>
<a id="e14d2" name="e14d2">14.2)</a>    mi tavla bau la lojban.
        bai tu'a la frank.
    .ibabo mi tavla bau la gliban.
        bai tu'a la frank.
    I speak in-language Lojban
        compelled-by some-property-of Frank.
    Afterward, I speak in-language English
        compelled-by some-property-of Frank.
</pre>

    <p>In <a href="#e14d1">Example 14.1</a>, ``bai'' is made
    sticky, and so Frank's compelling is made applicable to every
    following bridi. ``bau'' is not sticky, and so the language may
    vary from bridi to bridi, and if not specified in a particular
    bridi, no assumption can safely be made about its value.</p>

    <p>To cancel stickiness, use the form ``BAI ki ku'', which
    stops any modal value for the specified BAI from being passed
    to the next bridi. To cancel stickiness for all modals
    simultaneously, and also for any sticky tenses that exist
    (``ki'' is used for both modals and tenses), use ``ki'' by
    itself, either before the selbri or (in the form ``ki ku'')
    anywhere in the bridi:</p>
<pre>
<a id="e14d3" name="e14d3">14.3)</a>    mi ki tavla
    I speak (no implication about language or compulsion).
</pre>
    Note: Modals made with ``fi'o''-plus-selbri cannot be made
    sticky. This is an unfortunate, but unavoidable, restriction. 

    <h3><a id="s15" name="s15">15. Logical and non-logical connection of modals</h3>

    <p>Logical and non-logical connectives are explained in detail
    in <a href="chapter14.html">Chapter 14</a>. For the purposes of
    this chapter, it suffices to point out that a logical (or
    non-logical) connection between two bridi which differ only in
    a modal can be reduced to a single bridi with a connective
    between the modals. As a result, <a href="#e15d1">Example
    15.1</a> and <a href="#e15d2">Example 15.2</a> mean the same
    thing:</p>
<pre>
<a id="e15d1"
name="e15d1">15.1)</a>    la frank. bajra seka'a le zdani
        .ije la frank. bajra teka'a le zdani
    Frank runs with-destination the house.
        And Frank runs with-origin the house.
    Frank runs to the house, and Frank runs from the house.
</pre>
<pre>
<a id="e15d2"
name="e15d2">15.2)</a>    la frank. bajra seka'a je teka'a le zdani
    Frank runs with-destination and with-origin the house.
    Frank runs to and from the house.
</pre>
    Neither example implies whether a single act, or two acts, of
    running is referred to. To compel the sentence to refer to a
    single act of running, you can use the form: 
<pre>
<a id="e15d3"
name="e15d3">15.3)</a>    la frank. bajra seka'a le zdani
        ce'e teka'a le zdani
    Frank runs with-destination the house
        [joined-to] with-origin the-house.
</pre>

    <p>The cmavo ``ce'e'' creates a termset containing two terms
    (termsets are explained in <a href="chapter14.html">Chapter 14</a>
    and <a href="chapter16.html">Chapter 16</a>). When a termset
    contains more than one modal tag derived from a single BAI, the
    convention is that the two tags are derived from a common
    event.</p>

    <h3><a id="s16" name="s16">16. CV'V cmavo of selma'o BAI with irregular forms</h3>

    <p>There are 65 cmavo of selma'o BAI, of which all but one
    (``do'e'', discussed in <a href="#s6">Section 6</a>), are
    derived directly from selected gismu. Of these 64 cmavo, 36 are
    entirely regular and have the form CV'V, where C is the first
    consonant of the corresponding gismu, and the Vs are the two
    vowels of the gismu. The remaining BAI cmavo, which are
    irregular in one way or another, are listed in the table below.
    The table is divided into sub-tables according to the nature of
    the exception; some cmavo appear in more than one sub-table,
    and are so noted.</p>

    <p></p>
<pre>
   cmavo   gismu       comments

    Monosyllables of the form CVV:

    bai bapli
    bau bangu
    cau claxu
    fau fasnu
    gau gasnu
    kai ckaji   uses 2nd consonant of gismu
    mau zmadu   uses 2nd consonant of gismu
    koi korbi
    rai traji   uses 2nd consonant of gismu
    sau sarcu
    tai tamsmi  based on lujvo, not gismu
    zau zanru

    Second consonant of the gismu as the C:
        (the gismu is always of the form CCVCV)
    
    ga'a    zgana
    kai ckaji   has CVV form (monosyllable)
    ki'i    ckini
    la'u    klani   has irregular 2nd V
    le'a    klesi   has irregular 2nd V
    mau zmadu   has CVV form (monosyllable)
    me'e    cmene
    ra'a    srana
    ra'i    krasi
    rai traji   has CVV form (monosyllable)
    ti'i    stidi
    tu'i    stuzi

    Irregular 2nd V:

    fi'e    finti
    la'u    klani   uses 2nd consonant of gismu
    le'a    klesi   uses 2nd consonant of gismu
    ma'e    marji
    mu'u    mupli
    ti'u    tcika
    va'o    vanbi

    Special cases:

    ri'i    lifri   uses 3rd consonant of gismu
    tai tamsmi  based on lujvo, not gismu
    va'u    xamgu   CV'V cmavo can't begin with ``x''
</pre>

    <h3><a id="s17" name="s17">17. Complete table of BAI cmavo with rough English
    equivalents</h3>

    <p>The following table shows all the cmavo belonging to selma'o
    BAI, and has five columns. The first column is the cmavo
    itself; the second column is the gismu linked to it. The third
    column gives an English phrase which indicates the meaning of
    the cmavo; and the fourth column indicates its meaning when
    preceded by ``se''.</p>

    <p>For those cmavo with meaningful ``te'', ``ve'', and even
    ``xe'' conversions (depending on the number of places of the
    underlying gismu), the meanings of these are shown on one or
    two extra rows following the primary row for that cmavo.</p>

    <p>It should be emphasized that the place structures of the
    gismu control the meanings of the BAI cmavo. The English
    phrases shown here are only suggestive, and are often too broad
    or too narrow to correctly specify what the acceptable range of
    uses for the modal tag are.</p>
<pre>
   ba'i    basti   replaced by instead of
    bai bapli   compelled by    compelling
    bau bangu   in language in language of
    be'i    benji   sent by     transmitting
            te=sent to  ve=with transmit origin
            xe=transmitted via
    ca'i    catni   by authority of with authority over
    cau claxu   lacked by   without
    ci'e    ciste   in system   with system function
            te=of system components
    ci'o    cinmo   felt by     feeling emotion
    ci'u    ckilu   on the scale    on scale measuring
    cu'u    cusku   as said by  expressing
            te=as told to   ve=expressed in medium
    de'i    detri   dated       on the same date as
    di'o    diklo   at the locus of at specific locus
    do'e    -----   vaguely related to
    du'i    dunli   as much as  equal to
    du'o    djuno   according to    knowing facts
            te=knowing about
                    ve=under epistemology
    fa'e    fatne   reverse of  in reversal of
    fau fasnu   in the event of
    fi'e    finti   created by  creating work
            te=created for purpose
    ga'a    zgana   to observer observing
            te=observed by means
                    ve=observed under cond.
    gau gasnu   with agent  as agent in doing
    ja'e    jalge   resulting in    results because of
    ja'i    javni   by rule     by rule prescribing
    ji'e    jimte   up to limit as a limit of
    ji'o    jitro   under direction controlling
    ji'u    jicmu   based on    supporting
    ka'a    klama   gone to by  with destination
            te=with origin  ve=via route
            xe=by transport mode
    ka'i    krati   represented by  on behalf of
    kai ckaji   characterizing  with property
    ki'i    ckini   as relation of  related to
            te=with relation
    ki'u    krinu   justified by    with justified result
    koi korbi   bounded by  as boundary of
            te=bordering
    ku'u    kulnu   in culture  in culture of
    la'u    klani   as quantity of  in quantity
    le'a    klesi   in category as category of
            te=defined by quality
    li'e    lidne   led by      leading
    ma'e    marji   of material made from material
            te=in material form of
    ma'i    manri   in ref. frame   as a standard for
    mau zmadu   exceeded by more than
    me'a    mleca   undercut by less than
    me'e    cmene   with name   as a name for
            te=as a name to
    mu'i    mukti   motivated by    motive therefore
    mu'u    mupli   exemplified by  as an example of
    ni'i    nibli   entailed by entails
    pa'a    panra   in addition to  similar to
            te=similar in pattern
                    ve=similar by standard
    pa'u    pagbu   with component  as a part of
    pi'o    pilno   used by     using tool
    po'i    porsi   in the sequence sequenced by rule
    pu'a    pluka   pleased by  in order to please
    pu'e    pruce   by process  processing from
            te=processing into
                    ve=passing through stages
    ra'a    srana   pertained to by concerning
    ra'i    krasi   from source as an origin of
    rai traji   with superl.    superlative in
            te=at extreme   ve=superlative among
    ri'a    rinka   caused by   causing
    ri'i    lifri   experienced by  experiencing
    sau sarcu   requiring   necessarily for
            te=necessarily under cond.
    si'u    sidju   aided by    assisting in
    ta'i    tadji   by method   as a method for
    tai tamsmi  as a form of    in form
            te=in form similar to
    ti'i    stidi   suggested by    suggesting
            te=suggested to
    ti'u    tcika   with time   at the time of
    tu'i    stuzi   with site   as location of
    va'o    vanbi   under cond. as conditions for
    va'u    xamgu   benefiting from with beneficiary
    zau zanru   approved by approving
    zu'e    zukte   with actor  with means to goal
            te=with goal
</pre>

    <p>The lujvo ``tamsmi'' on which ``tai'' is based is derived
    from the tanru ``tarmi simsa'' and has the place structure:</p>

    <dl>
      <dt></dt>

      <dd>x1 has form x2, similar in form to x3 in property/quality
      x4</dd>
    </dl>

    <p>This lujvo is employed because ``tarmi'' does not have a
    place structure useful for the modal's purpose.</p>

    <hr />
    
    <p>Senast modifierad: Mon Jun 27 23:13:11 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
